/*
  TESTSND.PRG
  Author..... D.B. McDonald  [ CIS 76334,3521 ]
  Update..... February 03, 1992

  Uses the database file, DBSOUND.DBF/DBT
  Will create the index file if missing.
                                        
  Requires Nantucket Tools II
*/

* -------------------------------------------------------------------------- *
*                             Definitions
* -------------------------------------------------------------------------- *
#define SND_FILE  "dbsound"
#define SND_NAME   1
#define SND_LENGTH 2
#define SND_CHKSUM 3
#define SND_TIMER  4
#define SND_DATA   5


* -------------------------------------------------------------------------- *
Procedure main( cSndName )
* -------------------------------------------------------------------------- *
   local cSnd

   //... Change bell parameters
   SetBell( 3000, 1 )

   if file( SND_FILE + '.dbf' ) .and. file( SND_FILE + '.dbt' )

      //... Must pass name of sound to program
      if cSndName # NIL 

         //... Open database
         use ( SND_FILE ) alias SOUND

         //... Open index file if found, or create a new file if not found
         if file( SND_FILE + '.ntx' )
            set index to ( SND_FILE )
         else
            ?? "Building index file for the sound database."
            index on Upper( FieldGet( SND_NAME ) ) ;
                  to ( SND_FILE )
         endif

         //... Find sound name
         if dbSeek( Upper( PadR( cSndName, 10 ) ) )

            //... Get sound data, and test for valid checksum
            cSnd := SubStr( SOUND->DATA, 1, SOUND->LENGTH )
            if CheckSum( cSnd ) == SOUND->CHKSUM

               //... play sound
               sound( cSnd, SOUND->TIMER )

            else
               //... CheckSum Failure
               ?? chr(7), ;
                  "CheckSum Failure for sound " + cSndName
            endif

         else
            //... record not found
            ?? chr(7), ;
               "Could not find " + Upper( cSndName )
         endif

      else
         //... Missing command line parameter
         ?? chr(7)
         ?? "SYNTAX: TestSnd <Name>"
          ? "                <Name> is the sound record name"
      endif

   else
      //... Missing database
      ?? chr(7), ;
         "Database file " + Upper( SND_FILE ) + " is missing"
   endif


   //... Reset bell to 880.3 Hz for 0.3 seconds
   setbell()

return


* --------------------------------------------------------------------------- *
* EOF: TESTSND.PRG				February 03, 1992 at 16:29:28
* --------------------------------------------------------------------------- *

