/*
  SND2DBF.PRG
  Author ... D.B. McDonald  [ CIS 76334,3521 ]
  Update ... February 03, 1992

  Create a database from Nantucket Tools II *.SND files that contains
  the contents of the SND files in MEMO fields.

  Requires Nantucket Tools II
*/

* --------------------------------------------------------------------------  *
*                             Definitions
* --------------------------------------------------------------------------  *
#define SND_NAME   1
#define SND_LENGTH 2
#define SND_CHKSUM 3
#define SND_TIMER  4
#define SND_DATA   5

#define SND_DIR    "*.snd"
#define SND_FILE   "dbsound"

#define SND_DBF    { ;
                       { "Name  ", "C", 10,0 }, ;
                       { "Length", "N", 06,0 }, ;
                       { "ChkSum", "N", 10,0 }, ;
                       { "Timer ", "L", 01,0 }, ; 
                       { "Data  ", "M", 10,0 }  ;
                    }


#define CLIPPER_TONE   .T.      && Clipper Tone() duration is in
                                && 1/18.2 seconds
#define STANDARD_TONE  .F.      && Standard Sound() timing is in
                                && 1/100 seconds


* --------------------------------------------------------------------------  *
Procedure main()
* --------------------------------------------------------------------------  *
   local fName, cSnd, i

   //... Get list of all Nantucket Tools II sound files
   local aDir := directory( SND_DIR )

   //... Create the sound database if it does not exist
   if ! file( SND_FILE + '.dbf' )
      dbcreate( SND_FILE, SND_DBF )
   endif

   //... Kill any existing index file
   if file( SND_FILE + '.ntx' )
      ferase( SND_FILE + '.ntx' )
   endif

   //.. add selected sound files to sound database
   use ( SND_FILE ) alias SOUND
   for i = 1 to len( aDir )

      //... Read sound file to string
      fName := aDir[i][1]
      Qout( "Appending " + PadR( fName, 12 ) )
      cSnd := FileStr( fName )     
      QQout( " String Length:", NumFix( len( cSnd ), 6 ) )

     //... Add sound data to database
     append blank              
     aeval( { ;
              SubStr( fName, 1, at( '.', fName ) - 1 ), ;
              Len( cSnd ), ;
              CheckSum( cSnd ), ;
              CLIPPER_TONE, ;
              cSnd ;
            }, { |x,n| fieldput( n, x ) } )
   next

   //... Close database 
   use

return

* -------------------------------------------------------------------------- *
FUNCTION NumFix( n, nLen, nDec )
* -------------------------------------------------------------------------- *
  //... Create an array of code blocks containing number to string conversion
  //... routines for all parameter count possibilities.
  local bCode := { {|| chr( 241 ) }, ;
                   {|| ltrim( str( abs( n ) ) ) }, ;
                   {|| str( abs( n ), nLen - iif( n < 0, 1, 0 ) ) }, ;
                   {|| str( abs( n ), nLen - iif( n < 0, 1, 0 ), nDec ) } ;
                 }

//... Execute the appropriate code block, replace all leading spaces with
//... zeroes, and add a "-" sign to negative numbers.
return iif( iif( n == NIL, 0, n ) < 0, '-', '' ) + ;
            ReplLeft( eval( bCode[ pcount() + 1 ] ), '0' )


* --------------------------------------------------------------------------- *
* EOF: SND2DBF.PRG				February 03, 1992 at 17:02:07
* --------------------------------------------------------------------------- *

