*-- Header ---------------------------------------------------------------
*    Program . SMINDEX.PRG
*    Date .... December 3, 1986
*    Author .. Bob Laszko, Data Management Systems
*    Desc .... System Maintenance (re)Index databases
*    Notice .. Copyright 1986, 1988, Data Management Systems. 
*              All Rights Reserved.
*-------------------------------------------------------------------------
*
*-- Updates --------------------------------------------------------------
*    12/18/88  Put .DBF, NTX, & index expressions into arrays for easier
*              maintenance. Included SCROLL() and DOTS.PRG for nicer
*              looking output.
*-------------------------------------------------------------------------

* Initialize memvars
T_NTX_EXPR = SPACE(0)         && NTX_EXPR[] for macro usage

* Arrays to handle indexing routine
DECLARE DBF_NAME[21]          && name of .DBF file
DECLARE NTX_NAME[21]          && name of .NTX file
DECLARE NTX_EXPR[21]          && index expression

* Assign arrays
X = 1                         && incrementing a memvar allows insertion of new 
                              &&  elements anywhere in the array
DBF_NAME[X] = "CADET"
NTX_NAME[X] = "CADET1"
NTX_EXPR[X] = "CDLNAME + CDFNAME + CDMNAME"
X = X + 1

DBF_NAME[X] = "CADET"
NTX_NAME[X] = "CADET2"
NTX_EXPR[X] = "CDSERIAL"
X = X + 1

DBF_NAME[X] = "FORADDR"
NTX_NAME[X] = "FORADDR"
NTX_EXPR[X] = "FASERIAL"
X = X + 1

DBF_NAME[X] = "OTHADDR"
NTX_NAME[X] = "OTHADDR1"
NTX_EXPR[X] = "OASERIAL + OAADDRSSEE"
X = X + 1

DBF_NAME[X] = "OTHADDR"
NTX_NAME[X] = "OTHADDR2"
NTX_EXPR[X] = "OASERIAL"
X = X + 1

DBF_NAME[X] = "OTHFADDR"
NTX_NAME[X] = "OTHFADDR"
NTX_EXPR[X] = "OFSERIAL + OFADDRSSEE"
X = X + 1

DBF_NAME[X] = "INSTRUCT"
NTX_NAME[X] = "INST1"
NTX_EXPR[X] = "INLNAME + INFNAME + INMNAME"
X = X + 1

DBF_NAME[X] = "INSTRUCT"
NTX_NAME[X] = "INST2"
NTX_EXPR[X] = "INCODE"
X = X + 1

DBF_NAME[X] = "CLASSTIT"
NTX_NAME[X] = "CT1"
NTX_EXPR[X] = "CTCODE"
X = X + 1

DBF_NAME[X] = "CLASSTIT"
NTX_NAME[X] = "CT2"
NTX_EXPR[X] = "CTTITLE"
X = X + 1

DBF_NAME[X] = "CLASSES"
NTX_NAME[X] = "CL1"
NTX_EXPR[X] = "CLCODE"
X = X + 1

DBF_NAME[X] = "CLASSES"
NTX_NAME[X] = "CL2"
NTX_EXPR[X] = "CLCTCODE + CLPERIOD + CLROOM + CLINCODE"
X = X + 1

DBF_NAME[X] = "CLASSES"
NTX_NAME[X] = "CL3"
NTX_EXPR[X] = "CLCTCODE"
X = X + 1

DBF_NAME[X] = "CLASSES"
NTX_NAME[X] = "CL4"
NTX_EXPR[X] = "CLINCODE + CLPERIOD"
X = X + 1

DBF_NAME[X] = "CLASSES"
NTX_NAME[X] = "CL5"
NTX_EXPR[X] = "CLPERIOD + CLCTCODE"
X = X + 1

DBF_NAME[X] = "SCHEDULE"
NTX_NAME[X] = "SD1"
NTX_EXPR[X] = "SDSERIAL + SDCLCODE"
X = X + 1

DBF_NAME[X] = "SCHEDULE"
NTX_NAME[X] = "SD2"
NTX_EXPR[X] = "SDSERIAL + SDCLCODE"
X = X + 1

DBF_NAME[X] = "SCHEDULE"
NTX_NAME[X] = "SD3"
NTX_EXPR[X] = "SDCLCODE + SDSERIAL"
X = X + 1

DBF_NAME[X] = "COUNTRY"
NTX_NAME[X] = "COUNTRY"
NTX_EXPR[X] = "CNCODE"
X = X + 1

DBF_NAME[X] = "RELATION"
NTX_NAME[X] = "RELATION"
NTX_EXPR[X] = "RLCODE"
X = X + 1

DBF_NAME[X] = "CLASSCAT"
NTX_NAME[X] = "CLASSCAT"
NTX_EXPR[X] = "CCCODE"
X = X + 1


* Setup screen
CLEAR
** If you use some type of screen border, put it in here

ROW = 5                            && starting row for display
FOR X = 1 TO LEN(DBF_NAME)
     IF ROW = 21                   && max lower row for display + 1
          SCROLL(05,15,20,49,1)    && scroll 1 line up
          ROW = ROW - 1            && avoids blank line in first scroll at line 20
     ENDIF

     * Display indexing progress
     @ ROW,15 SAY "Indexing"
     @ ROW,25 SAY DBF_NAME[X]
     @ ROW,35 SAY "to"
     @ ROW,39 SAY DOTS(NTX_NAME[X],16)

     T_NTX_EXPR = NTX_EXPR[X]
     USE (DBF_NAME[X])
     INDEX ON &T_NTX_EXPR. TO (NTX_NAME[X])

     @ ROW,56 SAY "Complete"

     ROW = ROW + 1
NEXT

RETURN


*--------------------------------------------------------------------------
*    EOF  SMINDEX.PRG
*--------------------------------------------------------------------------