/*
  ķ
                                                                         
   Program...: RECYCLE.PRG                                               
   Author....: Team SuccessWare                                          
   Notice....: Copyright 1994 - SuccessWare 90, Inc.                     
   Purpose...: Demonstrates using the SIx Driver's Database Event        
               Triggers to seamlessly add Record-Recycling to an app.    
                                                                         
   Compile...: CLIPPER recycle /w /n /dCDX  (for SIXCDX)                 
   Compile...: CLIPPER recycle /w /n /dNSX  (for SIXNSX)                 
                                                                         
         NOTE: Add /dDEMO to the compile line to make DEMO program.      
                                                                         
   Link......: BLINKER FI recycle,sixcdx @six2  (for SIXCDX)             
           or: BLINKER FI recycle,sixnsx @six2  (for SIXNSX)             
                                                                         
   NOTES:  The example requires a TEST.DBF file of any size, which must  
           be created with our DBCRE8.EXE utility.  For example, to      
           create a TEST.DBF file with 1000 records, you would type this 
           at the DOS command-line:                                      
                                                                         
               C:\> DBCRE8 1000                                          
                                                                         
           To seamlessly add record recycling into an existing SIx       
           Driver application, just link this RECYCLE.OBJ file into your 
           app AHEAD of the SIX2.LIB file.                               
                                                                         
  Ľ
*/

#ifdef CDX
  #include "SIXCDX.CH"
#else
  #include "SIXNSX.CH"
#endif

#include "dbStruct.ch"

#ifdef DEMO
FUNC Test()

  LOCAL nMaxRow := MaxRow(), cOldColor := SetColor( "bg+/n, b/w,,,bg/n" )

  CLS

  IF !file( "TEST.DBF" )
    Alert( "Missing TEST.DBF" )
    quit
  ENDIF

  Alert( "Once in the Browse screen, delete one or more records.;" +;
         "Then, scroll to the bottom of the browse to 'APPEND' a;" +;
         "new record.  But, notice that the record count doesn't;" +;
         "increase.  We've recycled a deleted record! A new rec-;" +;
         "ord won't actually be added to the database until  all;" +;
         "previously deleted records have been reused.          "  ,;
         NIL, "n/gr*" )

  USE test
  IF !Sx_SetTag( "LAST", "TEST" )
    ? "Creating LAST tag..."
    INDEX ON test->LAST TAG last
  ELSE
    SET TAG TO last
  ENDIF
  @ 0,28 SAY " Record Recycling Example " COLOR "b/w"
  @ nMaxRow, 3 SAY "<DEL> - Delete/Recall" COLOR "g+/n"
  @ nMaxRow,31 SAY "<ENTER> - Edit" COLOR "g+/n"
  @ nMaxRow,52 SAY "<Scroll to EOF to APPEND>" COLOR "g+/n"
  Browse( 1, 0, nMaxRow-1, MaxCol() )

  SetColor( cOldColor )
  CLS

Return( NIL )
#endif


//----------------------------------------------------------------------//
FUNC Sx_DefTrigger( nEvent, nArea, nFieldPos, xTrigVal )

LOCAL nTagOrd := 0, cIndex := "", nMaxRow := MaxRow()
LOCAL cScreen := SaveScreen( nMaxRow, 0, nMaxRow, 50 )

// Save current index order
nTagOrd := OrdNumber()

// Peel off base name of data table to use as structural index name
cIndex := Left( Sx_TableName(), at( ".", Sx_TableName())-1 )

DO CASE

  CASE nEvent == EVENT_APPEND
    // Look for "_DEL_" tag in structural index by trying to set it
    IF !Sx_SetTag( "_DEL_", cIndex )            // If _DEL_ tag not built
      @ nMaxRow, 0 SAY "  Initializing Record Recycling. Stand By...  " ;
                   COLOR "gr+*/n"               //  Display message and
      INDEX ON recno() TAG _del_ FOR Deleted()  //  Build it!
      OrdSetFocus( nTagOrd )                    // Restore previous order
      RestScreen( nMaxRow, 0, nMaxRow, 50, cScreen )  // Restore Screen
    ENDIF

    // If at least one record was previously deleted, reuse it!
    IF Sx_KeyCount( "_DEL_", cIndex ) > 0
      OrdSetFocus( "_DEL_", cIndex ) // Change to the "_DEL_" tag
      dbGoTop()                      // Go to the first deleted record
      dbRLock()                      // Lock this record
      BlankRec()                     // Blank out all of the fields
      dbRecall()                     // Undelete this record
      OrdSetFocus( nTagOrd )         // Restore original index order
      Return(.F.)                    // Return FALSE == Don't APPEND BLANK
    ENDIF

  CASE nEvent == EVENT_DELETE
    // No changes required here!

  CASE nEvent == EVENT_PACK
    // No need to PACK.  That's why we're recycling records!
    Return(.F.)

ENDCASE

Return( .T. )

//----------------------------------------------------------------------//
// This UDF simply blanks out all of the fields for the current record

FUNC BlankRec()

LOCAL nFld := 0, aStruct := dbStruct(), nFldCount := fCount()

FOR nFld := 1 TO nFldCount
  DO CASE

    // CHARACTER or MEMO field
    CASE aStruct[ nFld, DBS_TYPE ] == "C" .or. ;
         aStruct[ nFld, DBS_TYPE ] == "M"
      FieldPut( nFld, "" )

    // NUMERIC field
    CASE aStruct[ nFld, DBS_TYPE ] == "N"
      FieldPut( nFld, 0 )

    // DATE field
    CASE aStruct[ nFld, DBS_TYPE ] == "D"
      FieldPut( nFld, ctod( "" ))

    // LOGICAL field
    CASE aStruct[ nFld, DBS_TYPE ] == "L"
      FieldPut( nFld, .F. )

  ENDCASE

NEXT

Return( NIL )


