***********************************************************************
* SHOWRECS.PRG       (I always called it "PRINTALL.PRG" --- JRL)      *
***********************************************************************
*                                                                     *
* Written by J. Robert Lyons                                          *
* 307 E. Mason Ave.                                                   *
* Alexandria, VA 22301                                                *
*                                                                     *
* (703) 836-8260                                                      *
*                                                                     *
* Prints a formatted list of the contents of all fields               *
* for every record of the specified database.                         *
*                                                                     *
* Output is similar to the view of data in dBASE's EDIT               *
*                                                                     *
***********************************************************************
close databases
clear all
set talk off
set safety off
clear

* Prompt user to enter file name
store "        " to PRINTME
@ 01,15 to 07,64 double
MSG = " LIST THE CONTENTS OF A DBF FILE "
@ 01, (80-len(MSG))/2 say MSG
MSG = "Type the name of the file to be listed below"
@ 03, (80-len(MSG))/2 say MSG

* Show user list of available files
@ 08,00 say ""
dir *.dbf

* Accept user's file name
@ 05,36 get PRINTME picture "@!"
READ

* Quit if user enters blank
if len(trim(PRINTME)) = 0
   clear
   MSG = "No file name entered.  Quitting ..."
   @ 09,15 to 13,64 double
   @ 11,(80-len(MSG))/2 say MSG
   @ 23,0 say ""
   wait
   clear
   return
endif

* In case user adds extension to short file name, cut it off
if "." $ PRINTME
   store substr(PRINTME,1,AT(".",PRINTME)-1) to PRINTME
endif
store upper(ltrim(rtrim(PRINTME)))+".DBF" to PRINTME

set talk off

* Check to see if file entered exists
if .not. file("&PRINTME")
   clear
   @ 09,09 to 13,70 double
   MSG = "Unable to find file, " + PRINTME + ", in current directory!"
   @ 11,(80-len(MSG))/2 say MSG
   @ 23,0 say ""
   wait
   clear
   return
else
   * Go for it!
   clear
   select A
   use &PRINTME
   copy structure extended to TEMPSTRU
endif

* Where does the output go?
@ 11,22 say "Output to <S>creen or <P>rinter?"
OUTTO = "S"
@ 11,55 get OUTTO picture "!"
read
clear
if OUTTO = "P"
   set print on
endif

** Star out next 3 lines for more sophistocated users
** MSG = "Press <Enter> to begin.  Then use <Ctrl-S> to Stop and Start display ..."
** @ 11,04 say MSG
** wait ""
   @ 23,0 say ""

* Here's where the magic happens
select B
use TEMPSTRU

select A
do while .NOT. EOF()

  ? "Record #  :" + str(RECNO(),4)
  ? "================================================================="

  sele B
  goto top

  do while .NOT. EOF()
     ? FIELD_NAME + ":  "
     store FIELD_NAME to PRINTME
     sele A
     ?? &PRINTME
     sele B
     SKIP
  enddo

  ?
  ?
  sele A
  SKIP

enddo

* That's all folks
? "*** END OF FILE ***"

* Housekeeping
set print off
close databases
delete file TEMPSTRU.DBF
RETURN
