* COMPILE WITH - CLIPPER SHOWFIL /N/W
* Link with:
*   BLINKER FI SHOWFIL
*   RTLINK FI SHOWFIL
*   LINK /NOE /SE:512 SHOWFILE,,,CLIPPER+EXTEND
*
* From Auto Exec BBS (508) 833-0508
********************
#include "keys.ch"
#define pNULL ""   
#define pTRUE .T.
#define pFALSE .F.

#command REPEAT => WHILE .T.
#command UNTIL <exp> => IF <exp> ; EXIT ; END ; END
#translate Box(<t>, <l>, <b>, <r>, <s>) => ;
           DISPBOX( <t>, <l>, <b>, <r>, <s> )


FUNCTION ShowFIle( file)

   LOCAL screen1 := SAVESCREEN(0, 0, 24, 79 ), fhandle, ;
         pointer := 1, showo := TBROWSENEW(1,1,23,78), column, ;
         thekey, length, buffer
   
    buffer := INT( LEN( screen1 ) )
   fhandle := FOPEN( file )
    length := FLength( fhandle )

   showo:skipblock     := {|n| ArraySkip(n, @pointer, length)}
   showo:goTopBlock    := {|| pointer := 0}
   showo:goBottomBlock := {|| pointer := length }

   column := TBCOLUMNNEW( pNULL, {|| Freadline(fhandle, ;
                                          pointer)} )
   column:width := 78

   showo:addColumn( column )

   Box( 0, 0, 24, 79, REPLICATE( CHR(178), 8 ) + CHR(32) )
   DEVPOS( 1, 1 )
   DEVOUT( " " + file + " " )

   REPEAT

      IF IsStable( showo )

         IF showo:hittop
            pointer := 1
         ELSEIF showo:hitbottom
            pointer := length
         ENDIF

         thekey  := INKEY(0)

         DO CASE
         CASE ( thekey = pDOWN_ARROW )
            showo:down()

         CASE ( thekey = pUP_ARROW )
            showo:up()

         CASE ( thekey = pEND_KEY )
            showo:gobottom()

         CASE ( thekey = pPGUP )
            showo:pageUp()

         CASE ( thekey = pPGDN )
            showo:pageDown()

         CASE ( thekey = pHOME )
            showo:gotop()

         ENDCASE

      ENDIF

   UNTIL (LASTKEY() = pESC)

   FCLOSE( fhandle )
   RESTSCREEN( 0, 0, 24, 79, screen1 )
RETURN .T.
********************

*******************

STATIC FUNCTION IsStable( p )

   LOCAL thekey

   WHILE ( !p:stabilize() )
      thekey := INKEY()
      IF !EMPTY( thekey )
         EXIT
      ENDIF
   ENDDO

   RETURN( EMPTY( thekey ) .AND. p:stable )

********************

STATIC FUNCTION ArraySkip( n, pointer, length )

   LOCAL k

   k := IF( ABS(n) >= IF(n >= 0, length-pointer, pointer-1 ), ;
                      IF(n >= 0, length-pointer, 1-pointer), n )

   pointer += k

   RETURN( k )

********************

STATIC FUNCTION FLength( file )

   /* This function is designed to figure out the number
      of lines in a file based on CHR(13)+CHR(10)
      character combinations */

   LOCAL buffer, length := 4096, counter := 0, exit := pFALSE, ;
         begin, loc, pntr := 0

   FSEEK( file, 0 )
   WHILE !exit
      buffer := SPACE( length )
      exit   := ( FREAD(file, @buffer, length ) != length )
      begin  := 1

      WHILE pTRUE

         loc := AT( CHR(13)+CHR(10), SUBSTR(buffer, begin) )

         IF !EMPTY( loc )
            pntr++
            begin += loc+1
         ELSE
            EXIT
         ENDIF
      ENDDO
   ENDDO
   
   RETURN( ++pntr )

*******************

STATIC FUNCTION Freadline( file, line )

   LOCAL buffer, length := 4096, counter := 0, exit := pFALSE, ;
         begin, loc, pntr := 0, retval

   retval := SPACE( length )

   FSEEK( file, 0 )

   WHILE !exit
      buffer := SPACE( length )
      exit   := ( FREAD(file, @buffer, length ) != length )
      begin  := 1

      WHILE pTRUE

         loc := AT( CHR(13)+CHR(10), SUBSTR(buffer, begin) )

         IF !EMPTY( loc )
            IF ++pntr = line
               retval := SUBSTR(buffer, begin, loc-1)
               EXIT
            ENDIF
            begin += loc+1
         ELSE
            EXIT
         ENDIF

      ENDDO
   ENDDO

   RETURN( retval )

