*ͻ*
*   Module Name:   ShowErr.prg                                     *
*   Description:   Provides a TBrowse of the instance variables    *
*                  of the error object.                            *
*   Notes......:   COMPILE with the /n switch.                     *
*   Author.....:   Micheal Todd Charron                            *
*   Date.......:   May 20, 1991                                    *
*   History....:   Written as a way to teach myself the errorsys.  *
*                  Started out modifying the GetSys.prg.           *
*                  Realized it wasn't necessary.                   *
*                                                                  *
*   Copyright..:   (c) The people at Nantucket Canada, 1991        *
*ͼ*
#include "set.ch"

* * * *
*
*	Function ShowError()
*
//  The main function
FUNCTION ShowError( oErr )
	//  Set up the array for browsing. \\
	LOCAL aErrInstance := {;
		{ "args",          { || oErr:args }           },;
		{ "canDefault",    { || oErr:canDefault }     },;
		{ "canRetry",      { || oErr:canRetry }       },;
		{ "canSubstitute", { || oErr:canSubstitute }  },;
		{ "cargo",         { || oErr:cargo }          },;
		{ "description",   { || oErr:description }    },;
		{ "filename",      { || oErr:filename }       },;
		{ "genCode",       { || oErr:genCode }        },;
		{ "operation",     { || oErr:operation }      },;
		{ "osCode",        { || oErr:osCode }         },;
		{ "severity",      { || oErr:severity }       },;
		{ "subCode",       { || oErr:subCode }        },;
		{ "subSystem",     { || oErr:subSystem }      },;
		{ "tries",         { || oErr:tries }          };
			}
	//  Save the current screen  \\
	LOCAL cFullScrn := SAVESCREEN()
	//  Save the current device setting and set it to screen  \\
	LOCAL cSetDevice := SET( _SET_DEVICE, "SCREEN" )
	LOCAL lErrReturn
	LOCAL nArrPos := 1
	//  Save the current cursor setting and set it off  \\
	LOCAL nSetCursor := SET( _SET_CURSOR, 0 )
	//  Calculate the center row of the current screen  \\
	LOCAL nMidScreen := INT( MAXROW()/2 )
	//  Create the TBrowse object  \\
	LOCAL oBrowse := TBROWSENEW( nMidScreen - 8, 18, nMidScreen + 5, 60 )
	LOCAL oColumn

	//  Halts all screen writing  \\
	DISPBEGIN()

	//  Create a transparent shadow and window for the TBrowse  \\
	RESTSCREEN( nMidScreen - 8, 18, nMidScreen + 7, 63,;
	TRANSFORM( SAVESCREEN( nMidScreen - 8, 18, nMidScreen + 7, 63 ),;
	REPLICATE( 'X', 736 ) ) );;
	DISPBOX( nMidScreen - 9, 16, nMidScreen + 6, 61, 'ͻȺ ', 'w+/n' )

	//  Display a message in the bottom right corner of the TBrowse  \\
	//  window                                                       \\
	DEVPOS( nMidScreen + 6, 44 )
	DEVOUT( '[ Press Any Key ]', 'w+/n' )

	oBrowse:colorSpec := 'w/n, w+/n'

	//  Create the movement mechanism for the TBrowse  \\
	oBrowse:skipBlock := { | nMove | SkipArray( nMove, @nArrPos ) }

	//  Create the first column of the object's instance variables   \\
	//  names                                                        \\
	oColumn := TBCOLUMNNEW( '',;
		{ || PADR( aErrInstance[ nArrPos, 1 ], 15, '.' ) } )
	oBrowse:addColumn( oColumn )

	//  Create the second column of the values of the object's  \\
	//  instance variables                                      \\
	oColumn := TBCOLUMNNEW( '',;
		{ || InstanceVal( EVAL( aErrInstance[ nArrPos, 2 ] ) ) } )
	oColumn:width := 26
	//  Displays this column in the color in the second position of  \\
	//  the oBrowse:colorSpec instance variable                      \\
	oColumn:defColor := { 2, 2 }
	oBrowse:addColumn( oColumn )

	//  Turns the highlite bar off  \\
	oBrowse:autoLite := .F.

	//  Displays the TBrowse's values  \\
	DO WHILE ! oBrowse:stabilize()
	ENDDO

	//  Displays the pending screen writes  \\
	DISPEND()

	INKEY( 0 )

	//  Restore the original screen  \\
	RESTSCREEN( 0, 0, MAXROW(), MAXCOL(), cFullScrn )

	//  Restore the original device and cursor settings  \\
	SET( _SET_DEVICE, cSetDevice )
	SET( _SET_CURSOR, nSetCursor )

	//  Call ErrorSys() which will post Clipper 5.01's error  \\
	//  handling function as the current error handler        \\
	//  ErrorSys() must be called as the error handling  \\
	//  function is a STATIC function                    \\
	ErrorSys()

	//  Invoke Clipper 5.01's error handler, passing the error  \\
	//  object                                                  \\
	lErrReturn := EVAL( ERRORBLOCK(), oErr )
	//  Reset ShowError() as the current error handler  \\
	ERRORBLOCK( { | oErr | ShowError( oErr ) } )

//  Return the result from Clipper 5.01's error handling  \\
//  function to the system                                \\
RETURN lErrReturn



* * * *
*
*	Function SkipArray()
*
//  Control movement for the TBrowse  \\
STATIC FUNCTION SkipArray( nMove, nArrPos )

	IF nMove > 0
		IF ( nMove + nArrPos ) > 14
			nMove := 14 - nArrPos
		ENDIF
	ELSE
		IF ( nMove + nArrPos ) < 1
			nMove := 1 - nArrPos
		ENDIF
	ENDIF

	nArrPos += nMove

RETURN nMove



* * * *
*
*	Function InstanceVal()
*
//  Converts the passed value into a character representation  \\
//  for easier viewing                                         \\
STATIC FUNCTION InstanceVal( xVal )
	LOCAL cRetVal
	LOCAL nI

	//  If the passed value is an array, build a character  \\
	//  representation of a literal array                   \\
	IF VALTYPE( xVal ) == 'A'
		cRetVal := '{ ' + ValToChr( xVal[ 1 ] )
		FOR nI := 2 TO LEN( xVal )
			cRetVal += ', ' + ValToChr( xVal[ nI ] )
		NEXT nI
		cRetVal += ' }'
	ELSE
		//  Converts all values to character representaions  \\
		cRetVal := ValToChr( xVal )
	ENDIF
//  Returns the character representation of the value to  \\
//  the TBrowse                                           \\
RETURN cRetVal


* * * *
*
*	Function ValToChar()
*
//  Converts the value to it's character representation \\
STATIC FUNCTION ValToChr( xVal )
	LOCAL cRetVal

	DO CASE
	CASE xVal == Nil
		cRetVal := 'Nil'
	CASE VALTYPE( xVal ) == 'C'
		cRetVal := '"' + xVal + '"'
	CASE VALTYPE( xVal ) == 'B'
		cRetVal := '{ ||... }'
	CASE VALTYPE( xVal ) == 'D'
		cRetVal := DTOC( xVal )
	CASE VALTYPE( xVal ) == 'L'
		cRetVal := IF( xVal, '.T.', '.F.' )
	CASE VALTYPE( xVal ) == 'N'
		cRetVal := LTRIM( STR( xVal ) )
	ENDCASE
//  Returns the character representation  \\
RETURN cRetVal
