* MARKDEMO.prg
* Copyright (c) 1991 by Ian Thurston, Ph.D. - but (ab)use this as you will
* Demonstration of a CLIPPER UDF to pick up to 64K records in a DBEDIT() call

* To compile the demo
*       CLIPPER MAKEDEMO

* To link the demo
*       TLINK MAKEDEMO,,,CLIPPER.LIB EXTEND.LIB
*   or  PLINK86 FI MAKEDEMO LIB CLIPPER, EXTEND

* Calling Sequence:
* SHIRLEY( [<expN1>, <expN2>, <expN3>, <expN4> [, array1 ]])
*   expN1, expN2, expN3, expN4 are Top, Left, Bottom, Right of window
*   array1 is a valid list of database fields

* Assumes:
*   A non-empty database is active in the currently selected area;

* Returns:
*   .T. if one or more records are marked when ESC is pressed
*   .F. if no marks are marked when ESC is pressed
*   PUBLIC character string MARKS contains "*" character at all
*   ordinal locations corresponding to RECNO() of marked records

* Examples:
*	SHIRLEY()	uses default window size, all fields in database
*	SHIRLEY( t, b, l ,r) uses passed window size, all fields in database
*	SHIRLEY( t, b, l, r, namearray) uses passed window, fields in array


* Keys:
*   ENTER   marks unmarked records, or removes marks from marked ones,
*           then moves cursor down a row
*   ESC returns from SHIRLEY with

**** DEMO OF SHIRLEY() function ******************************************

SETCOLOR( IIF( ISCOLOR(), "W/B,B/W","W/N,N/W"))
CLEAR
@ 0,30 say "A Demo of SHIRLEY()"
IF !FILE("EXAMPLE.DBF")
    TEXT

    The file EXAMPLE.DBF is missing. Copy any old DBF file to EXAMPLE.DBF
    and start again.

    Sorry we were too cheap to include code to build the DBF here !
    ENDTEXT
    quit
ENDIF
USE EXAMPLE                         && any database will do
IF SHIRLEY()
    CLEAR
    ? "You picked:"
    set filter to SUBSTR( marks, RECNO(), 1) = "*"
    goto top
    dbedit(2,0,19,79)
ELSE
    CLEAR
    @ 10, 15 say "You didn't pick a thing. Does that mean you're picky ?"
ENDIF
@ 20,15 SAY "Thanks for trying 'SHIRLEY' (a.k.a. Little Miss Marker)"
QUIT
******************************************************************************

********
FUNCTION Shirley    && Copyright (c) 1991 by Ian Thurston
********
PARAMETERS t, l, b, r, fld_array
* t,l,b,r specify location of picklist
* fld_array specifies fields to include in picklist

PRIVATE a, s_shirley, w, wide, x,
PUBLIC marks    && this is used after pick

IF EMPTY(ALIAS())   && cain't do nuthin' with an empty database !
    WAIT "Better reread the manual, Bucky !!!"
    RETURN .F.
ENDIF

IF PCOUNT() < 4     && default window sizing
    t =  2
    l =  0
    b = 23
    r = 79
ENDIF

A=LASTREC()
IF A > 64000    && the string can't be T-O-O long !
    wait "Whoops, Shirley can't handle that many records !!!"
    return .F.
ENDIF
marks = REPLICATE(" ", a) && give me lots of space !
IF (b-t-3) > a
    b = t + a + 3
ENDIF
GOTO TOP

IF PCOUNT() = 5
    DECLARE shirlarray[ len( fld_array) + 1]
    ACOPY( fld_array, shirlarray, 1, len( fld_array), 2)
ELSE
    DECLARE shirlarray[ FCOUNT() + 1]   && default fields to browse
    FOR a = 1 TO FCOUNT()
        STORE FIELDNAME(a) TO shirlarray[ a+1]
    NEXT A
ENDIF
DECLARE shirlhead[ LEN(shirlarray)]
ACOPY(shirlarray, shirlhead)
STORE "SUBSTR(marks,RECNO(),1)" TO shirlarray[1]
STORE "" TO shirlhead[1]

STORE 0 TO wide     && check ... is the window too wide ?
FOR A = 1 TO LEN(shirlarray)
    x = shirlarray[a]
    DO CASE
        CASE TYPE("&X")="N"
            w =  LENNUM(&X)
        CASE TYPE("&X")="C"
            w = LEN(&X)
        CASE TYPE("&X")="D"
            w =8
        CASE TYPE("&X")="L"
            w =3
        OTHERWISE
            w = -2
    ENDCASE
    wide = wide + w + 2
    IF wide > r - l
        EXIT
    ENDIF
NEXT
IF wide < (r - l - 2)
    r = l + wide + 2
ENDIF

SAVE SCREEN TO s_shirley
@ t, l, b, r BOX "ͻȺ "

@ 24,10 SAY "[ENTER ]  mark/unmark a record   [] Scroll    [ESC] Quit"
KEYBOARD CHR(0)     && flush the buffer
INKEY()
DBEDIT( t+1, l+1 ,b-1, r-1, shirlarray, "s_func","",shirlhead)

RESTORE SCREEN FROM s_shirley
RELEASE a, s_shirley, shirlarray, shirlhead
RETURN AT("*",marks) > 0

********
FUNCTION s_func
********
* SHIRLEY()'S DBEDIT() UDF
PARAMETERS sf_status, sf_fldptr
IF SUBSTR(marks,RECNO(),1) = " "
    @ t, l + 2 SAY  ""        && no mark
ELSE
    SETCOLOR( "*" + SETCOLOR())         && flashy, eh
    @ t, l + 2 SAY  "< Marked >"
    SETCOLOR( STRTRAN(SETCOLOR(),"*"))  && calm the display down
ENDIF
DO CASE
    CASE sf_status < 4
        RETURN 1
    OTHERWISE
ENDCASE

DO CASE
    CASE LASTKEY() = 13 && mark the record
        marks = STUFF(marks, RECNO(), 1, IIF(SUBSTR(marks,RECNO(),1);
               = "*", " ", "*"))
        KEYBOARD CHR(24)    && save operator some work ... move down one
        RETURN 1
    CASE LASTKEY() = 27     && As Steve McQueen discovered during WWII...
        KEYBOARD CHR(0)     && ... the GREAT ESCAPE returns us home
        RETURN 0
    OTHERWISE
        KEYBOARD CHR(0)
        RETURN 1
ENDCASE
RETURN 0

* END FUNCTION s_func

* END FUNCTION shirley
