* Demo to test ShdwBox Function

* Make sure to include TIMEH.OBJ if you need to recompile and link

******************************************************
*      Main program to test the ShdwBox function.
******************************************************

priv  Mask
Mask = REPL("X"+CHR(8),79)                  &&  158 character mask

* ---  Check for color monitor
if ISCOLOR()
   Back_Color = 'gr+/b,gr+/b'    &&  Background color for fill characters
   Box_Color  = 'n/bg,n/bg'      &&  Box color
   Disp_Color = 'w+*/b,w+*/b'    &&  Display timing results
else
   Back_Color = 'w/n,w/n'
   Box_Color  = 'n/w,n/w'
   Disp_Color = 'w+/n,w+/n'
end

SETCOLOR(Back_Color)

* ---  Fill the first 23 lines with various characters
do FillScrn

wait"         Make a single large box with FOR/NEXT loop, press any key...  "
SETCOLOR(Box_Color)
starttimer()    &&  Public domain timing function from Steve Steiner (TIMEH.OBJ)
ForNxtShdw(1,1,20,76)
SETCOLOR(Disp_Color)
@ 23,10 say "     Elapsed time in hundreds of a second:"
??elaptime()    &&  Another P.D. timing function from Steve Steiner (TIMEH.OBJ)
SETCOLOR(Back_Color)
wait"               Large Box, with FOR/NEXT loop, press any key...         "
do FillScrn

wait"           Make a single large box with ShdwBox, press any key...      "
SETCOLOR(Box_Color)
starttimer()
ShdwBox(1,1,20,76)
SETCOLOR(Disp_Color)
@ 23,10 say "     Elapsed time in hundreds of a second:"
??elaptime()
SETCOLOR(Back_Color)
wait"                  Large Box, with ShdwBox, press any key...            "
do FillScrn

wait "        Make 20 small boxes with FOR/NEXT loop, press any key...      "
SETCOLOR(Box_Color)
starttimer()
Make20Boxes("ForNxtLoop")
SETCOLOR(Disp_Color)
@ 23,10 say "     Elapsed time in hundreds of a second:"
??elaptime()
SETCOLOR(Back_Color)
wait"             20 small boxes, with FOR/NEXT loop, press any key...      "
do FillScrn

wait "           Make 20 small boxes with ShdwBox, press any key...         "
SETCOLOR(Box_Color)
starttimer()
Make20Boxes("ShadowBox")
SETCOLOR(Disp_Color)
@ 23,10 say "     Elapsed time in hundreds of a second:"
??elaptime()
SETCOLOR(Back_Color)
wait"               20 small boxes, with ShdwBox, press any key...          "

clear
*       End of Main Program


*****************************************************************************
func ShdwBox
*****************************************************************************
PARAMETERS t,l,b,r
PRIVATE Shadow

* ---   Shade the area below the box
Shadow = SAVESCREEN(b+1,l+1,b+1,r+1)
Shadow = TRAN(Shadow,LEFT(Mask,LEN(Shadow)))
RESTSCREEN(b+1,l+1,b+1,r+1,Shadow)

* ---   Shade the area to the right of the box
Shadow = SAVESCREEN(t+1,r+1,b+1,r+2)
Shadow = TRAN(Shadow,LEFT(Mask,LEN(Shadow)))
RESTSCREEN(t+1,r+1,b+1,r+2,Shadow)

* ---  Do the box
@ t,l to b,r
@ t+1,l+1 clea to b-1,r-1
RETURN .t.


*****************************************************************************
func Make20Boxes
*****************************************************************************
para WhichRoutine
priv WR
WR = WhichRoutine
for i = 5 to 75 step 15
   for j = 0 to 21 step 6
      if WhichRoutine = "ForNxtLoop"
         ForNxtShdw(j,i,j+3,i+10)
      else
         ShdwBox(j,i,j+3,i+10)
      end
   next
next
RETURN .t.


*****************************************************************************
func ForNxtShdw
*****************************************************************************
para row1,col1,row2,col2

if PCOUNT() =4
   * ---   Save area at bottom of window
   WINDOW = SAVESCREEN(row2+1,col1+1,row2+1,col2+1)
   for x = 2 to LEN(WINDOW) step 2
       WINDOW = STUFF(WINDOW, x, 1, CHR(8))
   next
   RESTSCREEN(row2+1,col1+1,row2+1,col2+1,WINDOW)

   * ---   Save area at right of window
   WINDOW = SAVESCREEN(row1+1,col2+1,row2+1,col2+2)
   for x = 2 to LEN(WINDOW) step 2
       WINDOW = STUFF(WINDOW, x, 1, CHR(8))
   next
   RESTSCREEN(row1+1,col2+1,row2+1,col2+2,WINDOW)
end

* ---  Do the boxes
@ row1,col1 to row2,col2
@ row1+1,col1+1 clea to row2-1,col2-1
return(0)

*****************************************************************************
proc FillScrn
*****************************************************************************
* ---  Fill the first 23 lines with various characters
clea
@ 00,00 say REPL(REPL("abcdefghijklmnopqrstuvw",5),16)
@ 23,00
retu
