*----------------------------------------------------------------------------*
PROCEDURE box2    && generic box maker
*----------------------------------------------------------------------------*
   * SYNTAX:  DO box2 [WITH {4 box coordinates}|{string with box coordinates}
   *          [,color] [,lines] [,shadow] [,explode]
   * EXAMPLES:
   *   do box2 
   *   DO box2 WITH gp_mid
   *   DO box2 WITH gp_mid,2
   *   DO box2 WITH gp_low,2,'DOUBLE'
   *   DO box2 WITH 0,0,24,79,2,'SINGLE'
   *   DO box2 with 0,0,24,79,3,'SINGLE','SHADOW'
   *   DO box2 WITH 10,10,16,60,"w+/r",rect_3,.T.,.T.
*----------------------------------------------------------------------------*   
PRIVATE urow, lcol, brow, rcol, bcolor, lines, shadow, var1, var2, var3, var4
PRIVATE mcolor, mshadow, mbox, mcolor, lastcolor, explode
PARAMETERS  var1,;      && Numeric - upper row, or Character with coordinates
            var2,;      && Numeric - left side
            var3,;      && Numeric - left side
            var4,;      && Numeric - left side
            mcolor,;    && Numeric - color[] element or Character i.e.'w+/b'
            mbox,;      && Character - 'DOUBLE', 'SINGLE' or Box Characters
            mshadow,;   && Character - 'SHADOW', 'YES' or Logical variable
            mexplode    && Character - 'EXPLODE', 'YES', or LogicaL
            
   lastcolor = SETCOLOR()
   IF PCOUNT()=0        && If no parameters were passed default is single box
      var1=gp_mid       && in mid screen area with no color change & no shadow 
   ENDIF
   
   IF TYPE('var1') = 'C'   && if box coordinates are passed in a string
      urow = VAL(SUBSTR(var1,1,2))                    && compute them
      lcol = VAL(SUBSTR(var1,4,2))                    && and move other 
      brow = VAL(SUBSTR(var1,7,2))                    && parameters up 
      rcol = VAL(SUBSTR(var1,10,2))
      bcolor = IF(TYPE('var2')=='U',lastcolor,var2)   && default set color
      lines  = IF(TYPE('var3')=='U','SINGLE',var3)    && default single
      shadow1 = IF(TYPE('var4')=='U',.F.,var4)        && default no shadow
      explode1= IF(TYPE('mcolor')=='U',.F., mcolor)   && default no explode
   ELSE                    && otherwise check which parameters were passed
      urow = var1          && must have 4 good box coordinates
      lcol = var2
      brow = var3
      rcol = var4
      bcolor = IF(TYPE('mcolor')=='U',lastcolor,mcolor)
      lines  = IF(TYPE('mbox')=='U','SINGLE',mbox)
      shadow1 = IF(TYPE('mshadow')=='U',.F.,mshadow)
      explode1= IF(TYPE('mexplode')=='U',.F.,mexplode)
   ENDIF
   
   setcolor(bcolor)

   * now determine whether to make a shadow behind box
   IF TYPE('shadow1')=='C'    
      shadow=IF(shadow1='SHADOW'.OR.shadow1='YES',.T.,.F.)
   ELSEIF TYPE('shadow1')=='L'
      shadow=shadow1
   ELSE 
      shadow=.F.
   ENDIF

   * and whether to explode the box
   IF TYPE('explode1')=='C'
      explode=IF(explode1='EXPLODE'.OR.explode1='YES',.T.,.F.)
   ELSEIF TYPE('explode1')=='L'
      explode=explode1
   ELSE 
      explode=.F.
   ENDIF
   
   IF shadow      && if shadow make bigger box and call shadow function
      shadow_box(urow-1,lcol-2,brow+1,rcol+2)
   ELSE           && otherwise just blank the area behind the box
      scroll(urow, lcol, brow, rcol, 0)
   ENDIF

   * now determine type of box lines and draw it
   IF TYPE("lines") = "C"
      DO CASE
         CASE lines='SINGLE'
            @ urow, lcol TO brow, rcol
         CASE lines='DOUBLE'
            @ urow, lcol TO brow, rcol DOUBLE
         OTHERWISE
            @ urow, lcol, brow, rcol BOX lines
      ENDCASE
   ELSE
      IF lines == 2
         @ urow, lcol TO brow, rcol DOUBLE
      ELSE
         @ urow, lcol TO brow, rcol
      ENDIF
   ENDIF
   
   SETCOLOR(lastcolor)
   
RETURN
*----------------------------------------------------------------------------*

*----------------------------------------------------------------------------*
FUNCTION shadow_box     && makes boxes floating and shadowed
                        && called from box2 with offset coordinates
*----------------------------------------------------------------------------*
PRIVATE pp1, pp2, pp3, pp4, scr1, c1, c2, sc, i, j
PARAMETERS  pp1,;       && Numeric ->top row of box-1
            pp2,;       && Numeric ->left column-2
            pp3,;       && Numeric ->bottom row+1
            pp4         && Numeric ->right column+2


scr1= savescreen(pp1+1, pp2+2, pp3+1, pp4+2)    && save background box
scr1 = dim(scr1)                                && dim colors in box

sc=setcolor()                             && save color setting
IF explode
   c1=int(((pp3-pp1)/2)+.5)               && get vertical center
   c2=int(((pp4-pp2)/2)+.5)               && get horizontal center
   IF INT(c2/2)<>c2/2                     && make horiz center even
      c2=c2+1
   ENDIF

   FOR j=0 to c1 step 2    && explode background and vertical
      set color to n/n     && black for background
      scroll(pp1+c1-j+1,pp2+2,pp3-c1+j+1,pp4+2,0) && explode
      setcolor(sc)         && correct color
      SCROLL(pp1+c1-j+1,pp2+c2,pp3-c1+j,pp4-c2,0) && explode vert in color
   NEXT
   
   restscreen(pp1+1, pp2+2, pp3+1, pp4+2, scr1)    && put dim background up
   
   FOR j=0 to c2 step 2    && explode horizontal in color
      SCROLL(pp1,pp2+c2-j,pp3,pp4-c2+j,0)
   NEXT
ELSE  && just put the shadow & box up
   restscreen(pp1+1, pp2+2, pp3+1, pp4+2, scr1)    && put dim background up
   SCROLL(pp1,pp2,pp3,pp4,0)                       && box on top
ENDIF && explode

return (.T.)
*----------------------------------------------------------------------------*

*----------------------------------------------------------------------------*
function box_msg     && shadow boxes a one line message
*----------------------------------------------------------------------------*
&& called from any program like this:
&&
&& box_msg(<message>[, row, column]) or
&&
&& <mvar> = <default>
&& box_msg(<message>[, row, column]) 
&& @ row, col()+1 GET <mvar>
&& READ
&&
&& If row or column are not specified they default to 12 (should be replaced
&& with a global constant)  This procedure draws the box around the message
&& and puts the message in the box at the passed or default row & column
*----------------------------------------------------------------------------*
PRIVATE tr, lc, message, trow, lcol, sc, shad
PARAMETERS message, trow, lcol, shad
   sc=setcolor()
   len_msg=LEN(message)+3
   tr=IF(TYPE('trow')=='U',12,trow)
   lc=IF(TYPE('lcol')=='U',12,lcol)
   shadow=IF(TYPE('shad')=='U', .F., shad)
   IF shadow
      DO box2 WITH tr-1, lc-1, tr+1, lc+len_msg, sc, 1, yes, yes
   ELSE
      DO box2 WITH tr-1, lc-1, tr+1, lc+len_msg
   ENDIF
   @ tr,lc SAY message
   
RETURN (.T.)
*----------------------------------------------------------------------------*
*-----------------------EOF() BOXER.PRG--------------------------------------*