*----------------------------------------------------------------------------*
*                             SHAD_BOX.PRG
*  Demonstrates use of box2 and box_msg functions
*  Draws various types of boxes, including exploding boxes
*  with a shadow behind them
*----------------------------------------------------------------------------*
PUBLIC scr1, scr2, len1, len2, sc, lastcolor, pic[5], cur_row[5], cur_col[5]
PUBLIC yes, no

* initialize  publics
yes= .T.
no = .NOT. yes

* draw a contrasting background for this demo

   SETCOLOR("W/B")
   CLEAR SCREEN
   
   FOR I=0 TO 24
      @ I,0 SAY REPLICATE(CHR(64+I),80)
   NEXT
   SETCOLOR("W+/B")
   
* demonstrate the box_msg function

* Used like box_msg(<expC> [, <expN1>, <expN2>])
* Where <expC>  is the message to display
*       <expN1> is the row where the message will be
*       <expN2> is the col where the message will start
* See BOXER.PRG for more info

   box_msg("Press <space> to change boxes, <Esc> to quit.",23,18)

* Demonstrate some shadow boxes
* See BOXER.PRG for more info

DO WHILE LASTKEY()<>27

   SAVE SCREEN TO pic[1]               && save the screen for show
   cur_row[1] = row()                  && save cursor position also
   cur_col[1] = col()
   
   DO box2 WITH 6,7,12,21,"w+/g",1,yes, yes
   SETCOLOR("W+/G")                     && color for this text
   @ 7,8 SAY "Box 1"                   && write some text in box
   INKEY(.5)                           && wait a bit

   SAVE SCREEN TO pic[2]               && save the screen for show
   cur_row[2] = row()                  && save cursor position also
   cur_col[2] = col()
   
   DO box2 WITH 13,28,17,70,'GR+*/GB',2,no
   SETCOLOR("GR+/GB")                     && color for this text
   @ 14,29 SAY "Box 2"                 && write some text in box
   INKEY(.5)                           && wait a bit
   
   SAVE SCREEN TO pic[3]               && sameo-sameo
   cur_row[3] = row()
   cur_col[3] = col()

   DO box2 WITH 4,18,9,50,'W+/GR',2,"SHADOW"
   SETCOLOR("W+/GR")
   @ 5,19 SAY "Box 3"
   INKEY(.5)         

   SAVE SCREEN TO pic[4]
   cur_row[4] = row()
   cur_col[4] = col()

   DO box2 WITH 8,44,14,63,'W+/R',2,'YES', yes
   SETCOLOR("W+/R")
   @ 9,45 SAY "Box 4"
   INKEY(.5)

   SAVE SCREEN TO pic[5]
   cur_row[5] = row()
   cur_col[5] = col()

   * Now demonstrate the heart of the box2 shadows - UDF dim()
   * If no color is passed, the default is 8 - gray/black

   fancy = SAVESCREEN(7,42,15,65)         && save box 4
   INKEY(1)                               && wait a sec

   FOR i = 21 TO 126 STEP 4               && run through nonblinking colors
      fancy1 = dim(fancy, i)              && change attribute
      RESTSCREEN(7, 42, 15, 65, fancy1)   && put box back up with new colors
      INKEY(8/i)                          && make changes faster as it goes
   NEXT

   INKEY(1)                               && let that sink in
   RESTSCREEN(7, 42, 15, 65, fancy)       && put original box back up
   
   FOR I=4 TO 1 STEP -1
      INKEY(I/4)
      RESTORE SCREEN FROM pic[I]
      @ cur_row[i], cur_col[i]  SAY ""
   NEXT
   INKEY(1)

ENDDO

RESTORE SCREEN FROM pic[5]             && get final screen back

RETURN
*----------------------------------------------------------------------------*
*----------------------------------------------------------------------------*