;Function...:dim1.ASM
;Syntax.....:<expC> = dim(<expC>, [<expN>])
;Note.......:changes attribute of savescreen data passed as a string <expC>
;            if no color attribute is passed, it uses 08H, grey/black
;
public   DIM               ; this public statement makes this
;                          ; routine accessible to the 'public'
;
EXTRN    __PARINFO:FAR     ; Clipper's parameter counter
extrn    __PARC:far        ; Clipper's character 'getter'
extrn    __PARNI:far       ; Clipper's integer 'getter'
extrn    __RETC:far        ; Clipper's character 'returner'
extrn    __parclen:far     ; string length
;
DGROUP  GROUP   datasg  ; Clipper's Data Segment

; the 'public' in the next statement combines the datasg
; to Clipper's DGROUP group

datasg  segment public  'DATA'

RETVAL   db       4000 dup(" ")     ; init with 4000 spaces (largest possible)
VAL1     dw       0                 ; init with 0
VAL2     dw       0                 ; init with 0
val3     db       8                 ; default attribute gray/black
VAL4     db       8                 ; default attribute gray/black
datasg  ends                        ; end of datasg (in DGROUP)
;
_prog    segment
         assume      cs:_prog,ds:DGROUP,es:DGROUP

DIM      proc     far               ; far process
         push     bp                ; preserve return address
         mov      bp,sp             ; move stack pointer
         push     ds
         push     es
         push     di
         push     si
         
         mov      ax,1              ; get first para
         push     ax                ; push AX
         call     __PARC            ; call Chara "getter"
         add      sp,2              ; restore stack manually to preserve AX
         mov      VAL1,ax           ; save OFFSET address 
         mov      VAL2,dx           ; save SEGMENT address 
         
         xor      ax,ax             ; find out how many parameters passed
         push     ax                ; set ax to zero and push
         call     __parinfo         ; call for info
         add      sp,2              ; returns number of params in ax
         cmp      ax,01             ; if ax=1, use default, else use 2nd parm
         jne      two_passed        ; get the second param
only_one:
         mov      al, val4          ; restore default value
         jmp      go_here           ; skip over second parse

two_passed:         
         mov      ax, 2             ; second parameter
         push     ax                ; prepare for function call
         call     __parni           ; get attribute, returned in AX
         add      sp,2              ; retore stack manually to preserve AX
go_here:
         mov      val3, al

         mov      ax, 1             ; first parameter
         push     ax                ; prepare for function call
         call     __parclen         ; get string length, returned in AX
         add      sp,2              ; retore stack manually to preserve AX
         sar      ax,1              ; shift right 1 (divide by 2)
         mov      cx,ax             ; 1/2 string length in cx
         
         cld                        ; clear direction flag (L-R)
         mov      di,offset DGROUP:RETVAL  ; get RETVAL's offset
                                           ; from DGROUP
         mov      ax,DGROUP         ; get DGROUP segment
         mov      es,ax             ; and place in ES

; in the next three statements, the order that it appears is
; important because the values of SI & AX must first be taken 
; from the DATASG extension before assigning the DGROUP segment
; address to DS

         mov      si,VAL1
         mov      ax,VAL2
         mov      ds,ax

A1:      mov      al,ds:[si]        ; move odd SI value to AL
A2:      mov      es:[di],al        ; save it 
         inc      di                ; increment DI
         inc      si                ; increment SI
;         mov      al,ds:[si]        ; move even SI value to AL (attribute)
         mov      al,es:[val3]      ; change to desired color
         mov      es:[di],al        ; save it 
         inc      di                ; increment DI
         inc      si                ; increment SI
         loop     A1                ; loop to A1:

C3:      xor      ax,ax             ; zero-out AX
         mov      es:[di],al        ; add null terminator to end
                                    ; of RETVAL

exit:
         pop      si
         pop      di
         pop      es                ; restore registers
         pop      ds                ; restore
         pop      bp                ; restore   

         mov      ax,DGROUP         ; get DGROUP address
         mov      ds,ax             ; assign to DS
         push     ds                ; push segment address
         mov      ax,offset DGROUP:RETVAL ; get RETVAL's offset
         push     ax                ; push offset address
         call     __RETC            ; Clipper's  character "returner"
         add      sp,4              ; fixup stack

         ret                     ; actual ret to caller
DIM      endp                    ; end of process

_prog    ends                    ; end of segment
         end                     ; end of program
