*******************************************************************************
** Shadow2.PRG
**
** Clipper front-end for Greg Martin-type boxes with half-shadows
** part 1
**
** (C) Copyright 1989, J. David Reynolds
*******************************************************************************

FUNCTION ShadowBox
PARAMETERS mUpperRow, mUpperCol, mLowerRow, mLowerCol, mShadow, mBorder, ;
           mSAYColor, mGETColor
PRIVATE mID, mOrigCoord, mColorList, mCursorPos, mCursorShape, mBorderType, ;
        mBorderChars, mShadowType, mFirstChar, mSaveBuffer
mUpperRow = MAX(00, mUpperRow)
mUpperCol = MAX(01, mUpperCol)
mLowerRow = MIN(23, mLowerRow)
mLowerCol = MIN(79, mLowerCol)
IF .NOT. (TYPE("MSHADOW") == "C")
  mShadow = "Half"
ENDIF
IF .NOT. (TYPE("MBORDER") == "C")
  mBorder = "Double"
ENDIF
IF .NOT. (TYPE("MSAYCOLOR") == "C")
  mSAYColor = "W/N"
ENDIF
IF .NOT. (TYPE("MGETCOLOR") == "C")
  mGETColor = "N/W"
ENDIF
mID          = "ID"
mOrigCoord   = STR(mUpperRow, 2, 0) + STR(mUpperCol, 2, 0) + ;
               STR(mLowerRow, 2, 0) + STR(mLowerCol, 2, 0)
mColorList   = LEFT(SETCOLOR() + SPACE(40), 40)
mCursorPos   = STR(ROW(), 2, 0) + STR(COL(), 2, 0)
mCursorShape = STR(_CursorGet(), 6, 0)
mSaveBuffer  = SAVESCREEN(mUpperRow, mUpperCol - 1, mLowerRow + 1, mLowerCol)
mShadowType  = LEFT(mShadow, 1)
DO CASE
  CASE mShadowType = "S"  && normal Shadow
    SET COLOR TO N/N
    SCROLL(mUpperRow + 1, mUpperCol - 1, mLowerRow + 1, mLowerCol - 1, 0)
  CASE mShadowType = "H"  && Half shadow
    _Shadow(mUpperRow + 1, mUpperCol - 1, mLowerRow + 1, mLowerCol - 1)
ENDCASE
PUBLIC mDeltaYCursor, mDeltaXCursor
mBorderType   = LEFT(mBorder, 1)
mBorderChars  = "        "
mDeltaYCursor = mUpperRow
mDeltaXCursor = mUpperCol
DO CASE
  CASE LEN(mBorder) = 8        && user-defined border
    mBorderType   = "U"
    mBorderChars  = mBorder
    mDeltaYCursor = mUpperRow + 1
    mDeltaXCursor = mUpperCol + 1
  CASE mBorderType = "S"  && Single border
    mBorderChars  = "Ŀ"
    mDeltaYCursor = mUpperRow + 1
    mDeltaXCursor = mUpperCol + 1
  CASE mBorderType = "D"  && Double border
    mBorderChars  = "ͻȺ"
    mDeltaYCursor = mUpperRow + 1
    mDeltaXCursor = mUpperCol + 1
ENDCASE
SET COLOR TO &mGETColor
@ mUpperRow, mUpperCol, mLowerRow, mLowerCol BOX mBorderChars
SET COLOR TO &mSAYColor, &mGETColor
SCROLL(mUpperRow + 1, mUpperCol + 1, mLowerRow - 1, mLowerCol - 1, 0)
@ mDeltaYCursor,mDeltaXCursor SAY ""
mFirstChar = STR(mDeltaYCursor, 2, 0) + STR(mDeltaXCursor, 2, 0)
RETURN(mID + mOrigCoord + mColorList + mCursorPos + mCursorShape + ;
       mBorderType + mBorderChars + mShadowType + mFirstChar + mSaveBuffer)


FUNCTION ShadowClose
PARAMETERS mSaveScreen
RESTSCREEN(VAL(SUBSTR(mSaveScreen, 3, 2)), ;
           VAL(SUBSTR(mSaveScreen, 5, 2)) - 1, ;
           VAL(SUBSTR(mSaveScreen, 7, 2)) + 1, ;
           VAL(SUBSTR(mSaveScreen, 9, 2)), ;
           SUBSTR(mSaveScreen, 75))
SETCOLOR(SUBSTR(mSaveScreen, 11, 40))
_CursorSet(VAL(LTRIM(SUBSTR(mSaveScreen, 55, 6))))
PUBLIC mDeltaYCursor, mDeltaXCursor
mDeltaYCursor = VAL(SUBSTR(mSaveScreen, 51, 2))
mDeltaXCursor = VAL(SUBSTR(mSaveScreen, 53, 2))
@ mDeltaYCursor,mDeltaXCursor SAY ""
RETURN(.T.)
