TITLE   Shadow.ASM - assembly functions for Greg Martin-type boxes with half-shadows
;       (C) Copyright 1989, J. David Reynolds
PAGE    ,132

INCLUDE EXTENDA.INC

CLpublic        <_Shadow, _SetAttr, _LoScreen, _HiScreen>
CLpublic        <_CursorGet, _CursorSet>

WORKFUNCS

;------------------------------------------------------------------------------
 SetAttr        PROC    NEAR
;------------------------------------------------------------------------------
; sets foreground attribute to AL (00H-0FH)
; AH     = mode (0 = leave background unchanged; 1 = change background too
;                2 = set intensity bit low;      3 = set intensity bit high
; AL     = attribute
; CH, CL = top row (0-24), col (0-79)
; DH, DL = bot row (0-24), col (0-79)
;------------------------------------------------------------------------------
                push    AX
                push    BX
                push    CX
                push    DX
                push    SI
                push    DI
                push    DS
                push    ES

; save parameters
                mov     CS:SA_Mode, AH
                mov     CS:SA_Attr, AL
                mov     CS:SA_TopCoord, CX
                mov     CS:SA_BotCoord, DX

; precalculate width, height
                mov     AH, 0
                mov     AL, DL
                sub     AL, CL
                inc     AX
                mov     CS:SA_Width, AX
                mov     AH, 0
                mov     AL, DH
                sub     AL, CH
                inc     AX
                mov     CS:SA_Height, AX

; get current video mode
                mov     AH, 15
                int     10H
                cmp     AL, 7
                je      SA_Mono
                mov     CS:SA_Screen, 0B800H
                jmp     SA_Cont1
SA_Mono:        mov     CS:SA_Screen, 0B000H
; CS:SA_Screen now holds the seg addr of the screen

SA_Cont1:
; find ofs of first char
                mov     AX, 0
                mov     CX, CS:SA_TopCoord      ; CH has row
                mov     CL, 0
                xchg    CH, CL
                cmp     CX, 0
                je      SA_Cont2
SA_AddLoop:     add     AX, 160
                loop    SA_AddLoop
SA_Cont2:       mov     CX, CS:SA_TopCoord      ; CL has col
                mov     CH, 0
                add     AX, CX
                add     AX, CX
                mov     CS:SA_FirstChar, AX
; AX now has ofs of first char

; set up pointers
                mov     SI, CS:SA_FirstChar
                mov     AX, CS:SA_Screen
                mov     DS, AX          ; DS:SI has addr of first line

; do the move
SA_Move:        inc     SI
                mov     CX, CS:SA_Width
                mov     AL, CS:SA_Attr
SA_Loop:        mov     BL, BYTE PTR DS:[SI]
                cmp     CS:SA_Mode, 00H
                je      SA_Mode0
                cmp     CS:SA_Mode, 01H
                je      SA_Mode1
                cmp     CS:SA_Mode, 02H
                je      SA_Mode2
                cmp     CS:SA_Mode, 03H
                je      SA_Mode3
SA_Mode0:       and     BL, 11110000B
                or      BL, AL
                jmp     SA_ModeDone
SA_Mode1:       mov     BL, AL
                jmp     SA_ModeDone
SA_Mode2:       and     BL, 11110111B
                jmp     SA_ModeDone
SA_Mode3:       or      BL, 00001000B
                jmp     SA_ModeDone
SA_ModeDone:    mov     BYTE PTR DS:[SI], BL
                inc     SI
                inc     SI
                loop    SA_Loop
                mov     AX, CS:SA_FirstChar
                add     AX, 160
                mov     CS:SA_FirstChar, AX
                mov     SI, AX
                dec     CS:SA_Height
                cmp     CS:SA_Height, 0
                ja      SA_Move
; done moving

                pop     ES
                pop     DS
                pop     DI
                pop     SI
                pop     DX
                pop     CX
                pop     BX
                pop     AX

                ret

SA_Mode         DB      ?
SA_Attr         DB      ?
SA_TopCoord     DW      ?
SA_BotCoord     DW      ?
SA_Width        DW      ?
SA_Height       DW      ?
SA_Screen       DW      ?
SA_FirstChar    DW      ?

SetAttr         ENDP


;------------------------------------------------------------------------------
 FillScreen     PROC    NEAR
;------------------------------------------------------------------------------
; writes char AL to area; leaves attributes unchanged
; AL     = char
; CH, CL = top row (0-24), col (0-79)
; DH, DL = bot row (0-24), col (0-79)
;------------------------------------------------------------------------------
                push    AX
                push    BX
                push    CX
                push    DX
                push    SI
                push    DI
                push    DS
                push    ES

; save parameters
                mov     CS:FS_Char, AL
                mov     CS:FS_TopCoord, CX
                mov     CS:FS_BotCoord, DX

; precalculate width, height
                mov     AH, 0
                mov     AL, DL
                sub     AL, CL
                inc     AX
                mov     CS:FS_Width, AX
                mov     AH, 0
                mov     AL, DH
                sub     AL, CH
                inc     AX
                mov     CS:FS_Height, AX

; get current video mode
                mov     AH, 15
                int     10H
                cmp     AL, 7
                je      FS_Mono
                mov     CS:FS_Screen, 0B800H
                jmp     FS_Cont1
FS_Mono:        mov     CS:FS_Screen, 0B000H
; CS:FS_Screen now holds the seg addr of the screen

FS_Cont1:
; find ofs of first char
                mov     AX, 0
                mov     CX, CS:FS_TopCoord      ; CH has row
                mov     CL, 0
                xchg    CH, CL
                cmp     CX, 0
                je      FS_Cont2
FS_AddLoop:     add     AX, 160
                loop    FS_AddLoop
FS_Cont2:       mov     CX, CS:FS_TopCoord      ; CL has col
                mov     CH, 0
                add     AX, CX
                add     AX, CX
                mov     CS:FS_FirstChar, AX
; AX now has ofs of first char

; set up pointers
                mov     SI, CS:FS_FirstChar
                mov     AX, CS:FS_Screen
                mov     DS, AX          ; DS:SI has addr of first line

; do the move
FS_Move:        mov     CX, CS:FS_Width
                mov     AL, CS:FS_Char
FS_Loop:        mov     BYTE PTR DS:[SI], AL
                inc     SI
                inc     SI
                loop    FS_Loop
                mov     AX, CS:FS_FirstChar
                add     AX, 160
                mov     CS:FS_FirstChar, AX
                mov     SI, AX
                dec     CS:FS_Height
                cmp     CS:FS_Height, 0
                ja      FS_Move
; done moving

                pop     ES
                pop     DS
                pop     DI
                pop     SI
                pop     DX
                pop     CX
                pop     BX
                pop     AX

                ret

FS_Char         DB      ?
FS_TopCoord     DW      ?
FS_BotCoord     DW      ?
FS_Width        DW      ?
FS_Height       DW      ?
FS_Screen       DW      ?
FS_FirstChar    DW      ?

FillScreen      ENDP

ENDWORK


;------------------------------------------------------------------------------
; _Shadow       Clipper FUNCTION
;------------------------------------------------------------------------------
CLfunc int _Shadow <int UpperRow, int UpperCol, int LowerRow, int LowerCol>
CLcode
                mov     AH, 00H                 ; leave background unchanged
                mov     AL, 00H                 ; black foreground
                mov     CX, UpperRow
                xchg    CL, CH
                add     CX, UpperCol
                mov     DX, LowerRow
                xchg    DL, DH
                add     DX, LowerCol
                call    SetAttr
                mov     AL, ''
                call    FillScreen
                mov     AX, 00h
                CLret   AX


;------------------------------------------------------------------------------
; _SetAttr      Clipper FUNCTION
;------------------------------------------------------------------------------
CLfunc int _SetAttr <int UpperRow, int UpperCol, int LowerRow, int LowerCol, int Attr>
CLcode
                mov     AX, Attr
                mov     AH, 01H                 ; change background too
                mov     CX, UpperRow
                xchg    CL, CH
                add     CX, UpperCol
                mov     DX, LowerRow
                xchg    DL, DH
                add     DX, LowerCol
                call    SetAttr
                mov     AX, 00h
                CLret   AX


;------------------------------------------------------------------------------
; _LoScreen     Clipper FUNCTION
;------------------------------------------------------------------------------
CLfunc int _LoScreen <int UpperRow, int UpperCol, int LowerRow, int LowerCol>
CLcode
                mov     AH, 02H                 ; set intensity bit to low
                mov     CX, UpperRow
                xchg    CL, CH
                add     CX, UpperCol
                mov     DX, LowerRow
                xchg    DL, DH
                add     DX, LowerCol
                call    SetAttr
                mov     AX, 00h
                CLret   AX


;------------------------------------------------------------------------------
; _HiScreen     Clipper FUNCTION
;------------------------------------------------------------------------------
CLfunc int _HiScreen <int UpperRow, int UpperCol, int LowerRow, int LowerCol>
CLcode
                mov     AH, 03H                 ; set intensity bit to high
                mov     CX, UpperRow
                xchg    CL, CH
                add     CX, UpperCol
                mov     DX, LowerRow
                xchg    DL, DH
                add     DX, LowerCol
                call    SetAttr
                mov     AX, 00h
                CLret   AX


;------------------------------------------------------------------------------
; _CursorGet    Clipper FUNCTION
;------------------------------------------------------------------------------
CLfunc int _CursorGet
CLcode
                mov     AH, 03H
                int     10H
                CLret   CX


;------------------------------------------------------------------------------
; _CursorSet    Clipper FUNCTION
;------------------------------------------------------------------------------
CLfunc int _CursorSet   <int CursorState>
CLcode
                mov     AH, 01H
                mov     CX, CursorState
                int     10H
                mov     AX, 00h
                CLret   AX

END

