/*ͻ
 ۺ Author        : Graham McKechnie                                         
 ۺ                                                                          
 ۺ Date          : 04-08-93                                                 
 ۺ                                                                          
 ۺ Program       : Shadow.c                                                 
 ۺ                                                                          
 ۺ Copyright     : 1993 by RCM Software (Australia)                         
 ͼ
 */

// Compiled with MSVC v8.0  cl /c /AL /FPa /Zl /Oalt /Gh /Gs /W3

#include "extend.api"
#include "vm.api"
#include "gt.api"


// eg Box( 2,2,10,40 )
// Shadow(2,2,10,40)

static void near ColorAttr( USHORT uiTop,
                            USHORT uiLeft,
                            USHORT uiBottom,
                            USHORT uiRight );



CLIPPER Shadow( ) {

   USHORT uiTop      = _parni(1);
   USHORT uiLeft     = _parni(2);
   USHORT uiBottom   = _parni(3);
   USHORT uiRight    = _parni(4);

   // No param checking - you deserve to blowup if you get these wrongs


   // Draw shadow on the right column
   ColorAttr( uiTop+1, uiRight+1, uiBottom+1, uiRight + 1 );

   // Draw shadow on the bottom
   ColorAttr( uiBottom+1, uiLeft+1, uiBottom+1, uiRight );

   _ret();

}



static void near ColorAttr ( USHORT uiTop,
                             USHORT uiLeft,
                             USHORT uiBottom,
                             USHORT uiRight )


{
   USHORT uiBufferSize;
   USHORT i;
   USHORT j;
   USHORT k;

   HANDLE hVM;

   BYTEP scrPtr;     // buffer to manipulate

   // Get the size of uiBuffer and alloc memory for scrPtr
   _gtRectSize( uiTop,  uiLeft, uiBottom,  uiRight , &uiBufferSize );

   if( !(hVM = _xvalloc( uiBufferSize, 0 )) )
       return;

   scrPtr = _xvlock(  hVM );

   // Save the row or the column
   _gtSave( uiTop,  uiLeft, uiBottom,  uiRight , scrPtr );

    // From top to bottom
    for ( j = uiTop; j <= uiBottom; ++j ){

       // Get the start of scrPtr
       i = ( (j - uiTop) * (uiRight - uiLeft + 1) * 2 ) + 1;

       // From left to right
       for ( k = uiLeft; k <= uiRight; ++k, i += 2 ){

          // If high intensity background and high intensity foreground
          if( scrPtr[i] & 0x0080  &&  scrPtr[i] &  0x0008 )

                  // Set both bits 3 and 7 off
              scrPtr[i] &= 0x0077;   // 119

          // If only high intensity background
          else if( scrPtr[i] & 128 )

              // Set bit 7 off
              scrPtr[i] &= 0x0070;    // 112

          // Normal shadow type
          else scrPtr[i] = 0x0008;

       }
    }

    // restore the row or the column
    _gtRest( uiTop,  uiLeft, uiBottom,  uiRight , scrPtr );

    // unlock and free the memory allocated to hVM
    _xvunlock( hVM );
    _xvfree( hVM );
    return;
}
