*****************************************************
*  testshad.prg
*  By    : Scott McIntosh
*  Placed in Public Domain, 1990
*	Date  : 08/19/90
*  Update: 09/31/90
*
*  Tests shadow function with and without optional
*  color parameters on both monochrome and color 
*  monitors

PRIVATE cFiller
cFiller = REPLICATE( "ABCD1234", 500 )


IF ISCOLOR()  && color detected

   * Test Screen 1 - shadow() without optional parameters

   * fill screen with text
   SETCOLOR( "W/B" )
   CLEAR SCREEN
   @ 0,0 SAY cFiller

   * draw box and add message
   SETCOLOR( "W/R" )
   @ 5,5 CLEAR TO 20,75
   @ 5,5 TO 20,75 DOUBLE
   @ 10,15 SAY "Default drop shadow colors"
   
   * make drop shadow an wait for keypress
   shadow( 5, 5, 20, 75 )    && No Attributes
   @ 12,15 SAY "Press any for next example"
   INKEY(0)
   CLEAR TYPEAHEAD
   
   * Test Screen 2 - with optional parameters
   
   SETCOLOR( "W/B" )
   CLEAR SCREEN
   @ 0,0 SAY cFiller

   SETCOLOR( "W/R" )
   @ 5,5 CLEAR TO 20,75
   @ 5,5 TO 20,75 DOUBLE
   @ 10,15 SAY "Lt. Green on Cyan shadow " +;
	            "(just to show it can be done)"
   
   shadow( 5, 5, 20, 75, 10, 3 )  && With attributes passed
   @ 12,15 SAY ""
   @ 12,15 SAY "Press any for next example"
   INKEY(0)
   CLEAR TYPEAHEAD

   * fill screen with text
   SETCOLOR( "W/B" )
   CLEAR SCREEN
   @ 0,0 SAY cFiller

   * draw box and add message
   SETCOLOR( "W/R" )
   @ 5,5 CLEAR TO 20,75
   @ 5,5 TO 20,75 DOUBLE
   @ 10,15 SAY "Press any key to start speed test..."
   INKEY(0)
   CLEAR TYPEAHEAD

   PRIVATE i, j, nStart, nEnd, nTime
	nStart = SECONDS()

	FOR i = 0 TO 7	              && For each background...
      FOR j = 0 TO 15			  && do each foreground
		  shadow( 5, 5, 20, 75, i, j )  
	   NEXT
	NEXT

	nEnd = SECONDS()
	nTime = nEnd - nStart

   @ 12,15 SAY "Done! Did 128 Shadows in " +;
	             LTRIM( STR( nTime ) ) + " Seconds!"
	@ 14,15 SAY "Press any key when done..."
   INKEY(0)
   CLEAR TYPEAHEAD

ELSE   && Monochrome

   * Test Screen 1 - shadow() without optional parameters

   SETCOLOR( "W+/N" )
   CLEAR SCREEN
   @ 0,0 SAY cFiller

   SETCOLOR( "N/W" )
   @ 5,5 CLEAR TO 20,75
   SETCOLOR( "W/N" )
   @ 5,5 TO 20,75 DOUBLE
   @ 10,15 SAY "Default Drop shadow colors"
   
   shadow( 5, 5, 20, 75 )    && No Attributes
   @ 12,15 SAY ""
   @ 12,15 SAY "Press any for next example"
   INKEY(0)
   CLEAR TYPEAHEAD
   
   
   * Test Screen 2 - with optional parameters
   
   SETCOLOR( "W/N" )
   CLEAR SCREEN
   @ 0,0 SAY cFiller

   SETCOLOR( "N/W" )
   @ 5,5 CLEAR TO 20,75
   SETCOLOR( "W/N" )
   @ 5,5 TO 20,75 DOUBLE
   @ 10,15 SAY "Black on Black Drop shadow colors"
   
   shadow( 5, 5, 20, 75, 0, 0 )  && With attributes passed
   @ 12,15 SAY ""
   @ 12,15 SAY "Press any key to quit..."
   INKEY(0)
   CLEAR TYPEAHEAD

ENDIF

RETURN

*----------- EOF: testshad.prg ---------------------------------------------*
