/****************************************************************************
*  DOSVIDEO.C                                                               *
*  8/19/89                                                                  *
*  Scott McIntosh                                                           *
*                                                                           *
*  get_video_zero()                                                         *
*  performs a interrupt 10h service 0Fh to detect                           *
*  video mode then sets a far pointer to the first                          *
*  byte of active video memory.                                             *
*  After call: AL contains the video mode                                   *
*              BH contains active page (if applicable)                      *
*                                                                           *
*  To avoid the nessesity of linking in the C library                       *
*  containing the interrupt function this code can be                       *
*  compiled to asm source (tcc -S) and assembled into                       *
*  an .obj                                                                  *
*                                                                           *
*  Compile - Turbo C: TCC -c -f- -G -ml -O -Z dosvideo.c                    *
*            MSC:     CL /AL /c /FPa /Gs /Oalt /Zl dosvideo.c               *
*                                                                           *
****************************************************************************/

#include <dos.h>

#ifndef __TURBOC__
#define MK_FP(seg,ofs) ((void far *) (((unsigned long)(seg) << 16) | (unsigned)(ofs)))
#endif

char far * get_video_zero()
{
   char far * v_zero;                                /* return pointer */

   _AH = 0x0F;                                   /* request service 0F */

   geninterrupt( 0x10 );

   if( _AL == 0x07 )             /* If monochrome */
      v_zero = MK_FP( 0xB000, 0 );

   else             /* color: must calculate correct page (BH x 1000h) */
   {
      v_zero = MK_FP( 0xB800,  _BH * 0x1000 );
   }
   return( v_zero );
}

/*---------------------------- EOF: DOSVIDEO.C ----------------------------*/
