/****************************************************************************
*  SHADOW.C         Clipper UDF for realistic drop shadows                  *
*                                                                           *
*  By.....: Scott McIntosh                                                  *
*  Placed in Public Domain 1989                                             *
*                                                                           *
*  Date...: 08/19/1989                                                      *   
*  Revised: 08/31/1990                                                      *
*  Version: 1.2                                                             *
*                                                                           *
*  Special thanks to Leonard Zerman.  Without whos help this function       *
*           would never have been written.                                  *
*                                                                           *
*  Syntax:                                                                  *
*  SHADOW( <expN1>, <expN2>, <expN3>, <expN4>, [<expN5>], [<expN6>] )       *
*                                                                           *
*  Where: N1 through N4 are t,b,l,r coordinates of the Box to               *
*             be shadowed and N5/N6 is foreground/background values         *
*                                                                           *
*  Color parameter values:                                                  *
*          Black        =  0    Foreground/Background                       *       *
*          Blue         =  1    Foreground/Background                       *
*          Green        =  2    Foreground/Background                       *
*          Cyan         =  3    Foreground/Background                       *
*          Red          =  4    Foreground/Background                       *
*          Magenta      =  5    Foreground/Background                       *
*          Brown        =  6    Foreground/Background                       *
*          Lt. Gray     =  7    Foreground/Background                       *
*          Dk. Gray     =  8    Foreground Only                             *
*          Lt. Blue     =  9    Foreground Only                             *
*          Lt. Green    = 10    Foreground Only                             *
*          Lt. Cyan     = 11    Foreground Only                             *
*          Lt. Red      = 12    Foreground Only                             *
*          Lt. Magenta  = 13    Foreground Only                             *
*          Yellow       = 14    Foreground Only                             *
*          White        = 15    Foreground Only                             *
*                                                                           *
*  May support Dbase style color pairs (ie: "+W/N") in a later              *
*      version.                                                             *
*                                                                           *
*  Example:  @ 10,10 CLEAR TO 20,20                                         *
*            @ 10,10 TO 20,20 DOUBLE                                        *
*            SHADOW( 10, 10, 20, 20 )                                       *
*              - or -                                                       *
*            SHADOW( 10, 10, 20, 20, 7, 8 )  && Lt. Gray / Dk. Gray         *
*                                                                           *
*  Returns: Nothing                                                         *
*                                                                           *
*  char far * get_video_zero()                                              *
*     is an external assembly routine (see explination in dosvideo.c)       *
*     that sets a far pointer to the correct start of video memory based    *
*     on the video mode (and active video page if applicable).  This        *
*     function is supplied in DOSVIDEO.OBJ which must be linked with the    *
*     application.  This saves making a call to the C function int86()      *
*     which would require linking the C library containing int(86) with     *
*     the Clipper application.                                              *
*                                                                           *
*  Compile - Turbo C: TCC -c -f- -G -ml -O -Z shadow.c                      *
*            MSC:     CL /AL /c /FPa /Gs /Oalt /Zl shadow.c                 *
*                                                                           *
****************************************************************************/     

#define IS_CLIPPER                    /* Remove if not used as Clipper UDF */

#include <stdio.h>
#include <dos.h>

#ifdef IS_CLIPPER
#include "nandef.h"
#include "extend.h"
#endif

void set_scr_attr( int top, int left, int bottom, int right, int fg, int bg );
extern char far * get_video_zero();

#ifdef IS_CLIPPER
CLIPPER SHADOW()
{
   if( ( PCOUNT == 6 && ISNUM(1) && ISNUM(2) && ISNUM(3) &&
                        ISNUM(4) && ISNUM(5) && ISNUM(6) )
    || ( PCOUNT == 4 && ISNUM(1) && ISNUM(2) && ISNUM(3) && ISNUM(4) ) )
   {
      int t, b, l, r;                       /* Coordinates of box */
      char f_gnd, b_gnd;                    /* Foreground/Background */

      f_gnd = 8;                            /* Gray default */
      b_gnd = 0;                            /* Black default */

      if( PCOUNT == 6 )
      {
         if( ( _parni(5) > 0 ) && ( _parni(5) < 16 ) ) /* check foreground */
            f_gnd = _parni(5);

         if( ( _parni(6) > 0 ) && ( _parni(6) < 8 ) )  /* check background */
            b_gnd = _parni(6);
      }

      t = _parni(1);
      l = _parni(2);
      b = _parni(3);
      r = _parni(4);

      /* Check for valid coordinates */
      if( t>=0 || t<=24 || b>=0 || b<=24 || l>=0 || l<=79 || r>=0 || r<=79 )
      {
         if( t<b && r>l )      /* Check for valid coordinate relationships */                      
         {
            /* Shadow on right side of box */

            set_scr_attr( t+1, r+1,  b , r+2, f_gnd, b_gnd );

            /* Shadow on bottom of box */
            set_scr_attr( b+1, l+2, b+1, r+2, f_gnd, b_gnd );
         }
      }
   }
   _ret();
}
#endif


/*-----------------------------------------------------------------------*/
void set_scr_attr( int top, int left, int bottom, int right, int fg, int bg )
{
   char far * video_zero;                   /* Video 0,0 Reference */
   char far * ptr;                          /* Pointer to attribute byte */
   char color;                              /* Foreground/Background Pair */
   int row;                                 /* Current screen row */
   int col;                                 /* Current screen col */
                                                     
   video_zero = get_video_zero();
   if( video_zero )
   {
      color = ( bg << 4 ) | fg;               /* Set attribute byte value */
      if( right-left >= bottom-top )          /* Determine greatest Aspect */
      {
         for( row = top; row <= bottom; row++ )    /* Horiz aspect greater */
         {
            col = left;                        /* Reset col to left border */
            ptr = (video_zero + 1) + (row * 160) + (left * 2);

            for( ; col <= right; col++ )
            {
               *ptr = color;                /* Set attribute */
               ptr++;
               ptr++;                       /* Next attribute byte */
               /* Note: Incrementes pointer twice instead of pointer += 2
                  for speed. */  
            }
         }
      }
      else
      {
         for( col = left; col <= right; col++ ) /* Vert aspect greater */
         {
            row = top;                      /* Reset row to top */
            ptr = (video_zero + 1) + (row * 160) + (col * 2);

            for( ; row <= bottom; row++ )
            {
               *ptr = color;
               ptr += 160;
            }
         }
      }
   }
   return;
}


/*---------- EOF: SHADOW.C ------------------------------------------------*/
  
  
