 ***
* Copywright 1988 Enterprise Systems, All Rights reserved.
*
*
* SFyesn01:     System Function -- yesno("Question?")
*
* Author:       Sean Smith 02-20-88.
*
* Called by:    Anyone.
*
* Returns:      (Logical) answer to question
***
Function yesno

Parameter yn_msg,opt_row

Private max_width,num_lines,top_line,first_col,old_color,wdw_data
Private bot_line,last_col,line,yn_ans,fkeys,act_width

if type('opt_fkeys') = 'C'
   fkeys = opt_fkeys
else
   fkeys = "Y-Yes  N-No"
endif

*** Figure out a nice size for window

Do Case
   Case len(yn_msg) < 54
      max_width = max(len(yn_msg),len(fkeys))
      num_lines = 7

   Case mlcount(yn_msg,44) < 4
      max_width = 44
      num_lines = mlcount(yn_msg,44) + 6

   Case mlcount(yn_msg,54) < 6
      max_width = 54
      num_lines = mlcount(yn_msg,54) + 6

   Otherwise
      max_width = 64
      num_lines = mlcount(yn_msg,64) + 6
Endcase

*** For multi line deals make size that of the biggest

act_width = max_width
If num_lines > 7
   act_width = 0
   For line = 1 To num_lines - 6
      If act_width < Len(Trim(MemoLine(yn_msg,max_width,line)))
         act_width = Len(Trim(MemoLine(yn_msg,max_width,line)))
      Endif
   Next line
Endif

top_line   = int( (25-num_lines) / 2 )          && Coor of top line
if type('opt_row') = 'N'
   top_line = opt_row
endif

bot_line   = top_line + num_lines - 1
first_col  = int( (74-act_width) / 2 )          && Leftmost Column
last_col   = first_col + act_width + 5

wdw_data   = SaveScreen(top_line, first_col, bot_line+1, last_col+2)
old_color  = SetColor()

SetColor('N')
@ top_line+1, first_col+2 Clear To bot_line+1, last_col+2
SetColor(c0prom_n)                                      && Clear inner box
@ top_line+1, first_col+1 Clear To bot_line-1, last_col-1
SetColor(c0prom_b)                                      && Draw border
@ top_line, first_col, bot_line, last_col Box "͸Գ"
@ bot_line-2,first_col Say '' + Replicate('',act_width+4) + ''
SetColor(c0prom_h)                                      && Bottom parts
@ bot_line-1,first_col + 3 + (act_width-len(fkeys))/2 say fkeys

SetColor(c0prom_n)
For line = 1 To num_lines - 6
   @ top_line+1+line,first_col+3 Say Left(MemoLine(yn_msg,max_width,line),act_width)
Next line

yn_ans = inkey()

Do While Type("yn_ans") = "N"
   Do Case
      Case yn_ans = 28 .and. 'F1' $ fkeys
         helpkey('YESNO',0,'SYS')
         yn_ans = 0

      Case Upper(Chr(yn_ans)) = "Y"
         yn_ans = .t.

      Case Upper(Chr(yn_ans)) = "N" .or. yn_ans = 27
         yn_ans = .f.

      Otherwise
         yn_ans = inkey(60)
   Endcase
Enddo

RestScreen(top_line, first_col, bot_line+1, last_col+2, wdw_data)
SetColor(old_color)
Return(yn_ans)