*********************************************************************
*  Function: SetVMode
*  Writer: Kraig Krist/TCBS
*          PO Box 711
*          Annandale, VA 22003-0711
*  Date: September 23, 1993
*  Description: Set Video Mode and/or return Current Video Mode.
*********************************************************************
*
*   ***** Function Specifications *****
*
*   Passed In: 1. Row and Column to set
*                 Example: cOldMode := SetVMode(25,80)
*
*              2. Value returned by previous call to SetVMode (restore
*                 previous mode).
*                 Example: SetVMode(cOldMode)
*
*              3. Nothing (just wants current mode setting).
*                 Example: cCurMode := SetVMode()
*
*   Returns:  Appropriate action based on input value.
*
*
*********************************************************************
*
*   NOTE: If testing if Video Adapter is not necessary, remove line
*         cMonType := MonType().  Also remove (or comment out) If
*         tests using cMonType.
*
*********************************************************************
*             ---- Modification Log ----
*
*  When:
*   Why:
*
*********************************************************************
FUNCTION SetVMode(xRow,xCol)
*********************************************************************
*    Declare Variables
*********************************************************************
  Local cReturn, nRow, nCol, cMonType
*********************************************************************
*    Initialize Variables
*********************************************************************
  nRow := 0
  nCol := 0
  cMonType := MonType()
  cReturn := AllTrim(Str(MaxRow()+1)) + ',' + AllTrim(Str(MaxCol()+1))
  If Empty(xRow) .and. Empty (xCol)
*********************************************************************
*   User just wants current setting
*********************************************************************
***  Next Sentence
  Elseif Empty(xCol)
*********************************************************************
*  Resetting Mode to value returned by previous call to SetVMode
*********************************************************************
    nRow := Val(Substr(xRow,1,(At(',',xRow)-1)))
    nCol := Val(Substr(xRow,(At(',',xRow)+1)))
    SetMode(nRow,nCol)
  Else
*********************************************************************
*  Set Mode to passed value.  Begin by converting passed values to
* acceptable values.
*********************************************************************
    If xRow <= 35
      nRow := 25
    ElseIf xRow <= 45
      If cMonType == 'EGA' .or. cMonType == 'VGA'
        nRow := 43
      Else
        nRow := 25
      EndIf
    Else
      If cMonType ==  'VGA'
        nRow := 50
      Else
        nRow := 25
      EndIf
    EndIf
    If xCol <= 50
      nCol := 40
    Else
      nCol := 80
    EndIf
    SetMode(nRow,nCol)
  EndIf
Return (cReturn)
