/* demo.prg : demo for set4017.asm

	 Clipper callable function to manipulate the DOS BIOS segment, ie turn the
	 keyboard lights on or off.

	 Written Chris Murray, CIS:10043,2247

   Free for all to use at will but comments are always nice.

*/

#include "Set4017.ch"

Function Main()

	// save previous settings
	Local lOldCaps   := Set4017( CAPS_LOCK   )
	Local lOldNum    := Set4017( NUM_LOCK    )
	Local lOldScroll := Set4017( SCROLL_LOCK )
	Local nCounter

	Cls

	@ 03 , 10 Say "Set4017 - a function to manipulate the DOS BIOS data segment"
	@ 05 , 10 Say "Written by Chris Murray CIS:100043,2247"
	@ 10 , 10 Say "Watch the Lights !"

	// flash all three lights on and off ten times
	For nCounter := 1 To 10
		// turn all the lights on
		Set4017( SCROLL_LOCK , ON )
		Set4017( NUM_LOCK    , ON )
		Set4017( CAPS_LOCK   , ON )

		Inkey(.3)

		// turn all the lights off
		Set4017( SCROLL_LOCK , OFF )
		Set4017( NUM_LOCK    , OFF )
		Set4017( CAPS_LOCK   , OFF )
		Inkey(.3)
	Next

	@ 10 , 10 Say "Press escape to exit."

	Do While Inkey() != 27
		@ 12 , 10 Say "Caps   Lock : " + IsOnOff( Set4017( CAPS_LOCK   ) )
		@ 13 , 10 Say "Num    Lock : " + IsOnOff( Set4017( NUM_LOCK    ) )
		@ 14 , 10 Say "Scroll Lock : " + IsOnOff( Set4017( SCROLL_LOCK ) )
	Enddo

	// restore previous settings
	Set4017( CAPS_LOCK   , lOldCaps   )
	Set4017( NUM_LOCK    , lOldNum    )
	Set4017( SCROLL_LOCK , lOldScroll )

Return( NIL )

Function IsOnOff( lValue )
Return Iif( lValue , "On " , "Off" )
