; Set4017.asm : Written by Chris Murray CIS:100043,2247, June 1994.
;
; Clipper callable Get/Set function to manipulate the DOS BIOS data segment 40h
; offset 17h, which is the keyboard status 1.
;
; This program was written in responce to a CA-Clipper Forum message on
; Compuserve.
;
; Freeware, for all to use at will but comments are always nice to here.
;
; I admit that I actually like programming in assembly, and would be happy to
; have a go at any other sugestions.
;
; Program Flow.
; -------------
; 1. Check param 1 is numeric
; 2. Check param 1 is => 0
; 3. Check param 2 is =< 7
; 4. Save current setting
; 5. Check there is a param 2
; 6. Check param 2 is logical
; 7. Calculate bit mask
; 7. apply bit mask
; 8. Return previous setting Clipper
; 8. Return to Clipper
;

PUBLIC Set4017

EXTRN __parinfo:FAR           ; param info
EXTRN __parni  :FAR           ; retrieve numeric integer to clipper
EXTRN __retl   :FAR           ; return logical to clipper
EXTRN __parl   :FAR           ; retrieve a logical from clipper

BIOS      equ 0040h           ; BIOS data segment
KEYB      equ 0017h           ; Keyb status 1 offset
NUM_TYPE  equ 2               ; num type value returned by parinfo
LOG_TYPE  equ 4		      ; logical type value returned by parinfo
TRUE      equ 1		      ; true constant

DGROUP GROUP   data

data   SEGMENT PUBLIC  'DATA'

  RetValue	DW 0				; Storage
  KeybBit	DB 0				; Storage

data   ENDS

code   SEGMENT 'CODE'
ASSUME cs:code, ds:dgroup

Set4017   PROC     FAR

	push	ds			; save registers affected
	push    es
	push    si
	push    di

	mov	RetValue, 0		; store 0 to retvalue

	mov	ax, 1			; get the type of param 1
	push	ax
	call	__parinfo		; result returned in AX
	add	sp, 2

	cmp	ax, NUM_TYPE		; is it a numeric
	jne	Finish			; if not jump to end

	mov	ax, 1			; get param 1 as a integer
	push	ax
	call	__parni			; result returned in AX
	add	sp, 2

	cmp	ax, 0			; compare result with 0
	jl	Finish			; jump to end if less than 0

	cmp	ax, 7			; compare result with 7
	jg	Finish			; jump to end if larger than 7

	mov	KeybBit, al		; copy param 1 to storage

	mov	cl, al			; copy param 1 to cx
	inc	cl			; add 1 to param 1

	mov	ax, BIOS		; load ax with BIOS segment
	mov	es, ax			; copy to es, cannot load es directly
	mov	bl, byte ptr es:KEYB	; copy one byte to bl

	shr	bl, cl			; shift to the right cl times

	jnc	NotSetOn		; CF will now contain the requested bit
					; if 0 jump to the end

	mov	RetValue, 1		; stor 1 to return value

NotSetOn:

	mov	ax, 2			; check param 2 is logical
	push	ax
	call	__parinfo		; param info returned in ax
	add	sp, 2

	cmp	ax, LOG_TYPE		; check param 2 is logical
	jne	Finish			; if not jump to end

	mov	ax, 2			; get value of param 2
	push	ax			; as a logical
	call	__parl			; result returned in ax
	add	sp, 2			; TRUE -> 1 or FALSE -> 0

	mov	cl, KeybBit		; copy param 1 to cl

	cmp	al, TRUE		; if param 2 is TRUE
	je	TurnOn			; jump to TurnOn

TurnOff:
	mov	al, 11111110b		; load initial bit mask
	rol	al, cl			; rotate left param 1 times
	and	byte ptr es:KEYB, al	; swith bit off
	jmp	Finish

TurnOn:
	mov	al, 00000001b		; load initial bit mask
	rol	al, cl			; rotate left param 1 times
	or	byte ptr es:KEYB, al	; swith bit on

Finish:

	mov	ax, RetValue		; load ax with previous value

	push	ax			; return value as logical
	call	__retl			; result retuened in AX
	add	sp, 2			; TRUE -> 1 or FALSE -> 0

	pop     di			; Restore registers
	pop     si
	pop     es
	pop     ds

	ret				; return to clipper
Set4017	ENDP

code	ENDS				; End of code segment
END
