/* SENDFAX.PRG An example of how to call wrtecf51()

   The heart of this process is wrtecf51() so read the following
   or be lost!

   WRTECF51() depends upon two arrays and an optional filename for
              the Task Control File.

   SYNTAX wrtecf51(<aArray1>, <aArray2>, <[fFileName]>)

   The first array has 8 elements and these elements break down
   as follows: 

      aArray1[1] = <Character> string containing the name of the
                   receiver of the fax. Max len 32

      aArray1[2] = <Character> string containing the phone number
                   of the receiving fax machine Max len 47

      aArray1[3] = <Character> string containing the name of the
                   sender. Max len 32

      aArray1[4] = <Date> date to send fax.

      aArray1[5] = <Character> string in the form "HH:MM:SS" to send fax.

      aArray1[6] = <Numeric> 0 or 1 (0=200x200 dpi or 1=100x100 dpi)

      aArray1[7] = <Character> string containing the path and filename
                   of a .PCX logo file. Max len 80. Maximum size of the
                   .PCX file is 1728 x 800 pels

      aArray1[8] = <Numeric> type number that specifies the number of files
                   to send. Max number 32766

   The second array is 2 dimensional and breaks down as follows:

      aArray2[n,1] = <Character> file type "0", "1" or "2"
                     "0"=ASCII, "1"=PCX, "2"=DCX

      aArray2[n,2] = <Character> if file type is ASCII this represents
                     80 or 132 columns. "0"=80 cols, "1"=132 cols

      aArray2[n,3] = <Character> string containing the path and filename
                     of the file to send. Simply aadd as many sets of 
                     elements as you have files to send

      fFileName = Optional filename for the Task Control File.
                  If not specified "submit.ecf" will be used
                  It is deleted as soon as the TCF is submitted.

      RETURNS = A positive Hex event handle if successful; otherwise,
                a negitive error code.

To try out this stuff make sure the Connection Coprocessor board is
installed and working properly. The Resident Manager "CONNECT.SYS" and
"CCAM.EXE" must be running as outlined in the board docs.

There is almost no error trapping and having a copy of the CAS specification
is highly recommended.

COMPILE SYNTAX: Clipper sendfax /w/n/a

LINK SYNTAX: Rtlink fi sendfax lib sendfax

*/

FUNCTION send
   LOCAL sSendTo, sPhoneNumStr, sFrom, sTimeStr, dDate, nResolution
   LOCAL sLogoPathFile, nNumFiles, c1FileType, c1FileWidth, s1PathFile
   LOCAL c2FileType, c2FileWidth, s2PathFile, c3FileType, c3FileWidth
   LOCAL s3PathFile, GetList, aECF, aFTR, lAnswer, fEcfFileName
   LOCAL RetVal

   sSendTo       := SPACE(20)
   sPhoneNumStr  := SPACE(14)
   sFrom         := SPACE(20)
   sTimeStr      := TIME() //"00:00:00"
   dDate         := DATE()
   nResolution   := 0
   sLogoPathFile := SPACE(35)
   nNumFiles     := 1
   c1FileType    := "0"
   c1FileWidth   := "0"
   s1PathFile    := SPACE(35)
   c2FileType    := "0"
   c2FileWidth   := "0"
   s2PathFile    := SPACE(35)
   c3FileType    := "0"
   c3FileWidth   := "0"
   s3PathFile    := SPACE(35)
   GetList       := {}
   lAnswer       := .F.
   aECF          := {}
   aFTR          := {}
   fEcfFileName  := "submitfx.ecf"

   CLS
   DO WHILE .T.
      @ 1,11 SAY "SEND FAXES VIA CLIPPER 5.0 AND INTEL CONNECTION COPROCESSOR"
      @ 2, 0 SAY ""
      @ 3, 4 SAY "Name of person or company receiving fax.:"
      @ 4, 4 SAY "Phone number of receiving fax machine...:"
      @ 5, 4 SAY "Name of person or company sending fax...:"
      @ 6, 4 SAY "Date to send............................:"
      @ 7, 4 SAY "Time of day to send.....................:"
      @ 8, 4 SAY "Transmit resolution (0=200, 1=100 dpi)..:"
      @ 9, 4 SAY "Path and filename of logo file..........:"
      @10, 4 SAY "Number of files to send (maximum of 3)..:"
      @11, 0 SAY ""
      @12, 4 SAY "File number 1:"
      @13, 9 SAY "Type (0=TEXT, 1=PCX, 2=DCX)....................:"
      @14, 9 SAY "Width, only for Type=0 (0=80 cols, 1=132 cols).:"
      @15, 9 SAY "Path and filename.:"
      @16, 4 SAY "File number 2:"
      @17, 9 SAY "Type (0=TEXT, 1=PCX, 2=DCX)....................:"
      @18, 9 SAY "Width, only for Type=0 (0=80 cols, 1=132 cols).:"
      @19, 9 SAY "Path and filename.:"
      @20, 4 SAY "File number 3:"
      @21, 9 SAY "Type (0=TEXT, 1=PCX, 2=DCX)....................:"
      @22, 9 SAY "Width, only for Type=0 (0=80 cols, 1=132 cols).:"
      @23, 9 SAY "Path and filename.:"

      @ 3,46 GET sSendTo         PICTURE [@!]
      @ 4,46 GET sPhoneNumStr
      @ 5,46 GET sFrom           PICTURE [@!]
      @ 6,46 GET dDate           PICTURE "@D"
      @ 7,46 GET sTimeStr        PICTURE [##:##:##]
      @ 8,46 GET nResolution     PICTURE [#] RANGE 0, 1
      @ 9,46 GET sLogoPathFile   PICTURE [@!]
      @10,46 GET nNumFiles       PICTURE [#] RANGE 1, 3
      @13,58 GET c1FileType      PICTURE [#]
      @14,58 GET c1FileWidth     PICTURE [#]
      @15,29 GET s1PathFile      PICTURE [@!]
      @17,58 GET c2FileType      PICTURE [#]
      @18,58 GET c2FileWidth     PICTURE [#]
      @19,29 GET s2PathFile      PICTURE [@!]
      @21,58 GET c3FileType      PICTURE [#]
      @22,58 GET c3FileWidth     PICTURE [#]
      @23,29 GET s3PathFile      PICTURE [@!]
      READ
      IF LASTKEY() == 27
         CLS
         EXIT
      ENDIF
      @ 24,0 SAY "Is this correct? (Y/N):" GET lAnswer PICTURE "Y"
      READ
      IF ! lAnswer
         @ 24, 0
         LOOP
      ENDIF

      AADD(aECF, TRIM(sSendTo))                  // aECF[1]
      AADD(aECF, TRIM(sPhoneNumStr))             // aECF[2]
      AADD(aECF, TRIM(sFrom))                    // aECF[3]
      AADD(aECF, dDate)                          // aECF[4]
      AADD(aECF, sTimeStr)                       // aECF[5]
      AADD(aECF, nResolution)                    // aECF[6]
      AADD(aECF, TRIM(sLogoPathFile))            // aECF[7]
      AADD(aECF, nNumFiles)                      // aECF[8]

      IF FILE(TRIM(s1PathFile))                  // aFtr[1,1], [1,2], [1,3]
         AADD(aFTR, { c1FileType , c1FileWidth, TRIM(s1PathFile) })
      ENDIF
      IF FILE(TRIM(s2PathFile))                  // aFTR[2,1], [2,2], [2,3]
         AADD(aFTR, { c2FileType , c2FileWidth, TRIM(s2PathFile) })
      ENDIF
      IF FILE(TRIM(s3PathFile))                  // aFTR[3,1], [3,2], [3,3]
         AADD(aFTR, { c3FileType , c3FileWidth, TRIM(s3PathFile) })
      ENDIF
      RetVal := wrtecf51(aECF, aFTR, fEcfFileName)

*===>  Insert a nice little box here that says that if the RetVal is
*      greater than 0 all is OK. For testing just uncomment these next
*      2 lines. See below for details. Convert the decimal Clipper 
*      return value to Hex (TR.LIB has nice Hex() function *it's free*)

*      ? retval
*      wait

      EXIT
   ENDDO
RETURN .T.

/*

SOME OF THESE ARE NOT APPLICABLE BUT FYI

     0002 Bad scanline count
     0003 Page sent with errors, could not resend
     0004 Received data lost
     0005 Invalid or missing logo file
     0006 File name does not match NSF header
     0007 File size does not match NSF header
     0101 Invalid function number
     0105 Access denied
     0106 Invalid handle
     0200 Multiplex handler failed
     0201 Unknown command (invalid function number)
     0202 Event not found (invlaid event handle)
     0203 Attempted to Find Next before Find First
     0204 No more events
     0207 Invalid Queue type (bad Queue number)
     0208 Bad Control file
     0209 Communication board is busy
     020A Invalid command parameter
     020B Can not uninstall Resident Manager
     020C File already exists
     0280 Invalid task type (not a Send or Poll event
     0281 Bad phone number
     0282 Bad PCX file header
     0283 Unexpected End of File
     0284 Unexpected disconnect
     0285 Exceeded maximum dialing retries
     0286 No files were specified for send event
     0287 Communication board timeout
     0288 Received more than 1023 pages of data
     0289 Manual connect posted too long ago
     028A Hardware command set error
     028B Bad nonstandard NSF header file
     0302 File not found
     0303 Path not found
     0401 Remote unit not Group 3 compatible
     0402 Remote unit didn't send its capabilities
     0403 Remote unit requested disconnect
     0404 Remote unit isn't a Connection Coprocessor
     0405 Exceeded retrain or fax resend limit
     0406 Line noise or the local and remote unit don't agree on a bit rate
     0407 Remote unit disconnected after receiving data
     0408 No response from remote unit after sending data
     040A Capabilities of remote unit aren't compatible
     040C Invalid response from remote unit after sending data
     0410 Phone line dead or remote unit disconnected
     0414 Invalid command from remote after receiving data 
     041E Tried to receive from incompatible hardware
     045B Unexpected end of file while receiving
     045C Received data overflowed input buffer
     045D Remote hardware unexpectedly stopped sending data
     045E Remote hardware didn't send any data
     0462 Remote hardware took too long to send fax scan line
     0463 Can't get through to remote unit
     0464 User canceled event
*/
