*************************************************************************
*
*  SEDIT is nothing more than a piece of code I quickly chopped out of 
*  one of my applications in response to a person's request for an 
*  example of how to simulate dBASE's EDIT command. The original version
*  of this routine was done by F. Ho of Nantucket and was called SIMEDIT.
*  Since first downloading that piece of code I have done much to improve
*  it for my own use. Many of those improvements have been taken out of this
*  example since they relied heavily on third party libraries. The original
*  version used 'SET FORMAT TO' which just had to go. They way this one works
*  is as follows.
*  
*  Give each different editing screen a number and call SEDIT with that 
*  number, the name of the first GET and the name of the last get.
*  
*  (I'm sure there's a way to make SEDIT automatically figure out these last
*  two parms, but I haven't bothered with it yet)
*  
*  Usage:
*  
*  DO sedit WITH <format number>, <first_get>, <last_get>   
*  
*  
*  
*     Example calling program:
*  
*     ****************************************************************
*     
*     Files are already open
*    
*     * Initialize the variables here so all of SEDIT's sub procedures
*     * can access them
*    
*     var_1 = ""
*     var_2 = ""
*     var_3 = ""
*     var_4 = ""
*  
*     DO sedit WITH 1, "var_1", "var_4"
*  
********************************************************************
*  
*  At the end of this file are four procedures; edit_says, edit_lvars,
*  edit_gets, and edit_repl
*  
*  Each of these has a DO CASE structure on the variable format_num.
*  You must put the specific code for each different screen (format number)
*  in each of these procedures.
*  
*  *****************************************************************
*  
*  
*  Provided by:
*  Steven C. Davies, CIS# 72517,777, (201)575-7052, 12-16-89
*  
*  Disclaimer:
*  This is an example of a routine and is not intended to work as is.
*  Anyone wishing to make use of this will have to do a certain amount
*  of additional programming. S. Davies assumes no responsability for
*  the suitability of this code for any purpose whatsoever.
*  
*********************************************************************
  
  
FUNCTION sedit

PARAMETERS format_num,first_get,last_get

PRIVATE answer, edit_scr

IF Pcount() < 3
   RETURN
ENDIF

DO edit_says WITH format_num
SET DELETED Off

SET Key 248 TO set_keys

DO WHILE editing
   DO set_keys
   deleting = DELETED()
   DO edit_lvars WITH format_num
   DO edit_gets WITH format_num
   
   READ
   
   DO WHILE LASTKEY() = 27
         
         edit_scr = Savescreen(5,4,11,36)
         box(6,5,10,35)
         @ 7,6 CLEAR TO 9,34
         @ 8,11 SAY "Abort edit ? (y/n) " GET answer PICTURE "Y"
         READ
         IF UPPER(answer) == "Y"
            editing = .F.
            EXIT
         ENDIF

         Restscreen(5,4,11,36,edit_scr)
         
         DO edit_gets WITH format_num
         READ
   ENDDO
   
ENDDO


SET Key 248 TO
DO unset_keys
SET DELETED ON

RETURN(0)



PROCEDURE ukey
*-----
* UP key
*-----
PARAMETERS proc_name,proc_line,read_var

IF UPPER(TRIM(read_var)) == UPPER(TRIM(first_get))
   *-----
   * if current GET is same as first field then
   * save this record and go to previous one
   *-----
   SET Key 23 TO
   KEYBOARD CHR(23)
   DO edit_repl WITH format_num
   SKIP -1
   IF BOF()
      ?? CHR(&)
   ENDIF
ELSE
   *-----
   * otherwise, disable UP-arrow's pre-assigned procedure,
   * go up - chr(5), then invoke procedure that
   * reassigns procedure      *-----
   SET Key 5 TO
   KEYBOARD CHR(5) + CHR(31)
ENDIF
RETURN


PROCEDURE dkey
*-----
* DOWN key
*-----
PARAMETERS proc_name,proc_line,read_var

IF UPPER(TRIM(read_var)) == UPPER(TRIM(last_get))
   *-----
   * if current GET is same as last field or 1st field then
   * save this record and go to next one
   *-----
   SET Key 23 TO
   KEYBOARD CHR(23)
   DO edit_repl WITH format_num
   old_recno = RECNO()              
   SKIP
   IF EOF()
      GO old_recno
      ?? chr(&)
   ENDIF
ELSE
   *-----
   * otherwise, turn off assigned procedure,
   * go down - chr(24), then invoke procedure that
   * reassigns procedure
   *-----
   SET Key 24 TO
   KEYBOARD CHR(24) + CHR(31)
ENDIF
RETURN


PROCEDURE enkey
*-----
* ENTER key
*-----
PARAMETERS proc_name,proc_line,read_var

IF UPPER(TRIM(read_var)) == UPPER(TRIM(last_get))
   *-----
   * if current GET is same as last field or 1st field then
   * save this record and go to next one
   *-----
   SET Key 23 TO
   KEYBOARD CHR(23)
   DO edit_repl WITH format_num
   old_recno = RECNO()
   SKIP
   
   IF EOF()
      GO old_recno
      DO unset_keys
      editing = .F.
   ENDIF
ELSE
   *-----
   * otherwise, turn off assigned procedure,
   * enter - chr(13), then invoke procedure that
   * reassigns procedure
   *-----
   SET Key 13 TO
   KEYBOARD CHR(13) + CHR(31)
ENDIF
RETURN


*!*********************************************************************
*!
*!      Procedure: PUKEY
*!
*!      Called by: SET_KEYS       (procedure in pbEDIT.PRG)
*!
*!          Calls: EDIT_REPL      (procedure in pbEDIT.PRG)
*!
*!*********************************************************************
PROCEDURE pukey
*-----
* PAGE-UP key
*-----
PARAMETERS proc_name,proc_line,read_var
*-----
* save current record and
* go to previous one
*-----
SET Key 23 TO
KEYBOARD CHR(23)
DO edit_repl WITH format_num

SKIP -1
IF BOF()
   ?? CHR(7)
ENDIF
RETURN


PROCEDURE pdkey
*-----
* PAGE-DOWN key
*-----
PARAMETERS proc_name,proc_line,read_var
*-----
* save current record and
* go to next one
*-----

SET Key 23 TO
KEYBOARD CHR(23)
DO edit_repl WITH format_num,deleting

old_recno = RECNO()
SKIP
IF EOF()
   GO old_recno
   ?? CHR(7)
ENDIF
RETURN


PROCEDURE ct_end_key
*-----
* ^END or ^W keys
*-----
PARAMETERS proc_name,proc_line,read_var
DO unset_keys
KEYBOARD CHR(23)
DO edit_repl WITH format_num,deleting

editing = .F.
RETURN


PROCEDURE delkey
*----------------------------
* DELETE RECORD KEY - ALT-F10
*----------------------------
PARAMETERS aa,bb,cc
PRIVATE old_color

IF deleting
   deleting = .F.
   @ 0,60 SAY SPACE(5)

ELSE
   deleting = .T.
   @ 0,60 SAY "<DEL>"
ENDIF

RETURN


PROCEDURE intmode
*-----
* CONTROL-MINUS key
* - this procedure reassigns procedures to their
*   respective keys
*   (inter-mode ("dummy-key"))
*-----
PARAMETERS proc_name,proc_line,read_var
SET Key 5 TO ukey
SET Key 24 TO dkey
SET Key 13 TO enkey
SET Key 23 TO ct_end_key

RETURN


PROCEDURE set_keys
*-----------------
*
*-----------------

SET Key 5 TO ukey
SET Key 3 TO pdkey
SET Key 13 TO enkey
SET Key 18 TO pukey
SET Key 24 TO dkey
SET Key 31 TO intmode
SET Key 23 TO ct_end_key
SET Key 278 TO delkey

RETURN


PROCEDURE unset_keys
*-------------------
*
*-------------------
SET Key 5 TO
SET Key 3 TO
SET Key 13 TO
SET Key 18 TO
SET Key 24 TO
SET Key 31 TO
SET Key 23 TO
SET Key 278 TO

RETURN



PROCEDURE edit_says
   *-----------------------------------
   * Constant text in edit screen
   * proc. edit_gets contains SAYS
   * which may change.
   *-----------------------------------

   PARAMETER f_number

   DO CASE
      CASE f_number = 1

      ********************************************************
      *
      * Display your first screen here.
      * 
      * Only text that doesn't change from record 
      * to record should be displayed here.
      *
      ********************************************************

   DO CASE
      CASE f_number = 2

      ********************************************************
      *
      * Display your second screen here.
      * 
      ********************************************************

      * Etc....................



   ENDCASE

RETURN



PROCEDURE edit_lvars
*----------------------------------------
* Load vars with fields.
* These vars must first be initialized
* in proc calling edit in order for all lower
* procs to access them
*----------------------------------------
PARAMETER f_number

DO CASE
CASE f_number = 1

    var_1 = field_1
    var_2 = field_2
    * Etc...........


CASE f_number = 2
   
    * Etc...........


ENDCASE


RETURN



PROCEDURE edit_gets
*------------------------------------------------
* This procedure contains GETS for each
* editing format and also contains SAYS
* which are not constant. ie: from database fields 
* in related areas or fields you don't want the
* user to modify
*-------------------------------------------------

PARAMETER f_number

DO CASE

   CASE f_number = 1

      @ 10,1 GET var_1
      @ 10,3 GET var_2

      * Etc ..........


   CASE f_number = 2

      * Etc ..........


ENDCASE

RETURN



PROCEDURE edit_repl
*-----------------------------------
*
*-----------------------------------

PARAMETER f_number,del_stat

IF del_stat
   DELETE
ELSE
   RECALL
ENDIF

DO CASE
CASE f_number = 1
   
   REPLACE field_1 WITH var_1
   REPLACE field_2 WITH var_2

   * Etc .............


CASE f_number = 2
   
   * Etc .............


ENDCASE


RETURN



*  7
*  7
*  7
*  7
*  7
*  7
*  7
*  7
*  7
   7
