#Include "DVSet.Ch"
#Include "Error.ch"
#include  "M_INKEY.CH"
#include  "dvs.ch"
#INCLUDE "dvbrowse.CH"


// Below Is Function To Setup The Error System
//***********************
FUNCTION  ErrorSys(BmainFunc,Bntx)   //Clipper Automaticlly Executes On StartUp
//************************
// Load Error Block
// Clipper Calls This Block Upon An Error
// Install Custom ErrorBlock
// bMainFunc=Code Block For Controling Function;.
// bNtx = Code Block For Index Recovery.
ERRORBLOCK({|errobj|deferror(ErrObj,bMainFunc,bNtx)})
    // Pop up Browse of Sets
SETKEY(K_ALT_M,{|| saveEnviron(.t.)})

// if no bMainFunc Just Return
// and let program flow continue
IF EMPTY(BMAINFUNC);RETURN(NIL);ENDIF


DO WHILE .T.                    // Begin Sequence Area If Code Block Sent

   BEGIN SEQUENCE
         EVAL(Bmainfunc)
   RECOVER
        // if you wish you could place more custom code here to recover from
        // assorted errors at your discretion
        LOOP

   END  SEQUENCE

ENDDO

RETURN(NIL)





#XTRANSLATE  E_Choice     =>         Cargo\[1]
#XTRANSLATE  E_Environ    =>         Cargo\[2]
#XTRANSLATE  E_Color      =>         Cargo\[3]
#xtranslate  E_InfoBox    =>         Cargo\[4]
#XTRANSLATE  E_Video      =>         Cargo\[5]
#XTRANSLATE  E_Prompts    =>         Cargo\[6]
#XTRANSLATE  E_bMainFunc  =>         Cargo\[7]
#XTRANSLATE  E_bntx       =>         Cargo\[8]
#xTRANSLATE  E_Info       =>         Cargo\[9]
#XTRANSLATE  E_Stack      =>         Cargo\[10]
// print

//************************************
STATIC FUNCTION DefError(errobj,BmainFunc,bntx)
//*************************************
LOCAL  x


errobj:cargo:=array(10)

Errobj:E_Environ:=SaveEnviron()

IF ErrObj:E_Environ[_SET_ISCOLOR]
     Errobj:E_color:="15/9,0/7,0,0,14/9"
     Errobj:E_InfoBox:="0/4,4/7+,0,0,7+/4"
     Errobj:E_Prompts:="0/11,0/7,0,0,4/11"

Elseif ! Errobj:E_Environ[_SET_ISCOLOR]
   Errobj:E_Color:="15/0,0/15,0,0,7/0"
   Errobj:E_InfoBox:="7/0,0/7,0,0,15/0"
   Errobj:E_Prompts:="7/0,0/7,0,0,15/0"
EnDif

Errobj:E_bMainFunc:=bMainFunc
Errobj:E_bNtx      :=bNtx
// Load Information on Error
ErrObj:E_Info:={;
              Oserror(Errobj:oscode),;
              ErrObj:Description,;
              IF(Empty(errobj:Operation),"No Operation",;
                   Errobj:operation),;
              if(Empty(Errobj:filename),;
                   "No Filename",Upper(Errobj:Filename)),;
              "System Error Type  SEVERITY  Code Os Code  "+;
                  "Sub Code  Sub System",;
              PADC(S_NTRIM(ErrObj:GENCODE),13," ")+" "+;
                  PADR(IF(ErrObj:SEVERITY==ES_WARNING,"Warning",;
                  IF(ErrObj:SEVERITY==ES_ERROR,"Error  ",;
                  IF(ErrObj:SEVERITY==ES_CATASTROPHIC,"Catastrophic"," "))),18," ")+;
                  PADC(S_NTRIM(ErrObj:SEVERITY),4," ")+" "+;
                  PADC(S_NTRIM(ErrObj:OSCODE),10," ")+" "+;
                  PADC(S_NTRIM(ErrObj:SUBCODE),9," ")+" "+;
                  PADC(ErrObj:SUBSYSTEM,11," ")}

// Load The Call Stack
Errobj:E_Stack:=GetStack()
	DO CASE


	   CASE ErrObj:GenCode==EG_PRINT
          SetBlink(Errobj:E_Environ[_SET_BLINK])
					ErrObj:E_Video:=SaveVideo(8,10,22,70)

					SET(_SET_PRINTER,.F.)
					SET(_SET_CONSOLE,.T.)
          SET(_SET_DEVICE,"SCREEN")
          SET(_SET_PRINTFILE)
					SET(_SET_MESSAGE,16)
					SET(_SET_MCENTER,.T.)
		      errobj:description:="Printer OFF Line or Not Connected"
	      	errobj:FILENAME:="Print Routed to - "+;
					IF(Empty(ErrObj:E_Environ[_SET_PRINTFILE]),"LPT1",;
					         ErrObj:E_Environ[_SET_PRINTFILE])


		       laser(2)
           Boxit(8,10,16,70,8,Errobj:E_InfoBox,2,"7/0")
           Setpos(8,23);Devout("!!!!!!!!  PRINTER ERRROR  !!!!!!!!",Revclr(Errobj:E_InfoBox))
					 // Display Error
           Setpos(10,12);Devout("Description ",Errobj:E_InfoBox);
            ;Setpos(Row(),Col()+1);Devout(Errobj:Description,ClrSep(Errobj:E_InfoBox,5))
           SetPos(Row()+1,12);Devout("Print To ",Errobj:E_InfoBox);
            ;Setpos(Row(),Col()+1);Devout(Errobj:Filename,ClrSep(Errobj:E_InfoBox,5))
           Setpos(Row()+1,11);Devout(Replicate("",59),Errobj:E_InfoBox)

           @ 14,12 Say "Description " Color Errobj:E_InfoBox

					 Errobj:E_Choice:=2
           @ 14,12 Prompt "   Quit    " pcolor Errobj:E_Prompts Message " Exit to MS DOS " Mcolor revclr(Errobj:E_InfoBox);
                   Shadow Scolor Errobj:E_InfoBox
           @ 14,32 Prompt "   Retry   " pcolor Errobj:E_Prompts Message " Retry, Continue Printing " Mcolor Revclr(Errobj:E_InfoBox) ;
                   Shadow Scolor Errobj:E_InfoBox
           @ 14,52 Prompt " Main Menu " pcolor Errobj:E_Prompts Message " Return To Main Menu " Mcolor Revclr(Errobj:E_InfoBox) ;
                   Shadow Scolor Errobj:E_InfoBox

					 Menu To Errobj:E_Choice
					 if Empty(Errobj:E_Choice) .OR. Errobj:E_Choice==2

                   RestVideo(ErrObj:E_Video)
					         SET(_SET_PRINTER,Errobj:E_Environ[_SET_PRINTER])
									 SET(_SET_CONSOLE,Errobj:E_Environ[_SET_CONSOLE])
									 SET(_SET_DEVICE,Errobj:E_Environ[_SET_DEVICE])
                   RETURN(.T.)

           Elseif Empty(Errobj:E_Choice) .or. Errobj:E_Choice==1
                   GiveUp(.f.)
           ELSEIF Errobj:E_Choice==3

                 if Valtype(Errobj:E_bMainFunc)=="B"
                      Break
                 Else
                       GiveUp(.f.)
                 ENDIF
           Endif
	   CASE ErrObj:Gencode==EG_ZERODIV
        RestEnviron(ErrObj:E_Environ)
	      Return(0)    // DIVIDE bY 0 Results In 0 so We Return


	   Case Valtype(Errobj:E_bntx)=="B" .and. ErrObj:Gencode==EG_OPEN ;
		  .and. ErrObj:subcode==1003 .or. Errobj:Subcode==1006  ;
                   .or. (errobj:gencode==EG_CORRUPTION .AND.;
                        ErrObj:subcode==1012)
		      laser(2)
		      Errobj:Candefault:=.t.
          Errobj:Operation:="Index File Error Re-Indexing Please Wait "
		      Errobj:description:="Open Error (Index File/Corruption)"
					Boxit(8,10,16,70,8,Errobj:E_Color,2,"7/0")
          @ 10,15 Say Errobj:Operation   Color Errobj:E_Color
          @ 12,15 Say Errobj:Description Color Errobj:E_Color
          @ 14,15 Say "Datafile - "+Alias()+" Index File "+Upper(errObj:Filename) Color Errobj:E_Color
					inkey(1)
		      Eval(Errobj:E_BNtx)


		      BREAK


          CASE ErrObj:Gencode==EG_OPEN .AND. ;
                ErrObj:OsCode==32       .AND. ; // Shareing violation
                ErrObj:Candefault==.t.          // open Error Who Knows
                 NETERR(.T.)
                 RestEnviron(Errobj:E_Environ)
		             RETURN(.F.)   // Return .f. To Try To Recover At Line
			       // Error Occured



           CASE ErrObj:Gencode==EG_APPENDLOCK .AND. ;
                ErrObj:CanDefault==.t.
        	// for lock error during APPEND BLANK, set NETERR()
                // and subsystem default
               NETERR(.T.)
               RestEnviron(Errobj:E_Environ)
		   RETURN(.F.)


	OTHERWISE
        Setblink(.t.)
        ErrObj:E_Video:=SaveVideo(0,0,maxrow(),MaxCol())
        Scroll()
        ERRORBOX(1,1,24,77,Errobj)
        SET(_SET_MESSAGE,24)
        @ 22,5 Prompt " Operating System " pcolor Errobj:E_Prompts ;
                      Message " Exit To MS-DOS " MColor Errobj:E_Color ;
                      Offpos 2 OffClr ClrSep(Errobj:E_Prompts,5) ;
                      Shadow Scolor Errobj:E_color
        @ 22,32 Prompt "  Print Error   " pcolor Errobj:E_Prompts ;
                      Message " Print this Error Window " MColor Errobj:E_Color ;
                      Offpos 3 OffClr ClrSep(Errobj:E_Prompts,5);
                      Shadow Scolor Errobj:E_color
        @ 22,57 Prompt "   Main Menu    " pcolor Errobj:E_Prompts ;
                      Message " Return To the Main Menu " MColor Errobj:E_Color ;
                      Offpos 4 OffClr ClrSep(Errobj:E_Prompts,5);
                      Shadow Scolor Errobj:E_color



         Menu to Errobj:E_Choice

        If Empty(Errobj:E_Choice) .or. ErrObj:E_Choice==1
           Giveup(.t.)
        ElseIf  ErrObj:E_Choice==2
		      SendToPrinter(Errobj)
          SetBlink(ErrObj:E_Environ[_SET_BLINK])
		      BREAK

        Elseif Errobj:E_Choice==3

          if ValType(Errobj:E_bMainFunc)=="B"
                 SetBlink(Errobj:E_Environ[_SET_BLINK])
                 Restvideo(Errobj:E_Video)

                 Break
          Else
                 Giveup(.t.)
         endif

      Endif
ENDCASE

return(NIL)

//***********************************
STATIC FUNCTION ERRORBOX(ntop,nleft,nbottom,nright,errobj)
//***********************************
Local aErrinfo,aCallStk,nrow

BOXIT(nTop,nLeft,nBottom,nRight,1,Errobj:E_Color,0,"7/0")

boxit(nTop+1,nleft+2,nBottom-14,nRight-2,2,Errobj:E_InFoBox,2,"7/0")
 @ 13,6 say " Func/Proc   Line       Func/Proc   Line      "+;
            "   Func/Proc   Line     " COLOR ClrSep(Errobj:E_Color,5)
  @ 13,6 say "Func/Proc   Line        Func/Proc   Line      "+;
  "   Func/Proc   Line     " COLOR ClrSep(Errobj:E_Color,5)
   // Box 2
  nRow:=7
  @ nrow,4 Say Replicate("",((nRight-2)-(nLeft+2))) COLOR Errobj:E_InFoBox
  @ nRow,3 SAY "" COLOR Errobj:E_InFoBox
  @ nRow,75 SAY"" COLOR Errobj:E_InFoBox
  @ nRow,18 SAY "" COLOR Errobj:E_InFoBox
  @ nRow,41 SAY "" COLOR Errobj:E_InFoBox
   @ nRow,52 SAY "" COLOR Errobj:E_InFoBox
  @ nRow,62 SAY "" COLOR Errobj:E_InFoBox
  nRow+=3
  @ nRow,18 SAY "" COLOR Errobj:E_InFoBox
  @ nRow,41 SAY "" COLOR Errobj:E_InFoBox
  @ nRow,52 SAY "" COLOR Errobj:E_InFoBox
  @ nRow,62 SAY "" COLOR Errobj:E_InFoBox

  nRow:=3

         @ nRow,5  Say  "Oper. System -" Color Errobj:E_InFoBox
         @ nRow,Col()+1 Say Errobj:E_info[1] Color clrSep(Errobj:E_InFoBox,5)
         @ nRow+1,5 Say "Description  -" Color Errobj:E_InFoBox
         @ nRow+1,Col()+1  SAY Errobj:E_Info[2] COLOR ClrSep(Errobj:E_InFoBox,5)
         @ nRow+2,5 Say "Operation    -" Color Errobj:E_InFoBox
         @ nRow+2,Col()+1  SAY Errobj:E_Info[3] COLOR ClrSep(Errobj:E_InFoBox,5)
         @ nrow+3,5 Say "Filename     -" Color Errobj:E_InFoBox
         @ nRow+3,Col()+1  SAY Errobj:E_Info[4] COLOR ClrSep(Errobj:E_InFoBox,5)
         @ nRow+5,5  SAY Errobj:E_Info[5] COLOR Errobj:E_InFoBox

         @ nRow+6,5 say Errobj:E_Info[6] COLOR ClrSep(Errobj:E_InFoBox,5)
         @ nRow+6,18 Say "" Color Errobj:E_InFoBox
         @ nRow+6,41 Say "" Color Errobj:E_InFoBox
         @ nRow+6,52 Say "" Color Errobj:E_InFoBox
         @ nRow+6,62 Say "" Color Errobj:E_InFoBox
         SayStack(Errobj,13)
    Laser(2)


RETURN(nil)
//***************************
STATIC FUNCTION GIVEUP(lErrScreen)
//****************************
local ErrScreen
Setblink(.t.)
SetMode(80,25)

  ErrScreen:=savescreen(1,1,21,77)

  Setcolor("7/0,7/0,0,0,7/0")
  cls
	ErrorLevel(1)
	dbunlockall()
	dbcloseall()
  Setpos(maxrow(),0)
  if lErrScreen
     RestScreen(1,1,21,77,ErrScreen)
	Endif

	Quit

RETURN(NIL)



//****************************
STATIC FUNCTION SENDTOPRINTER(ErrObj)
//****************************
LOCAL I:=1
Msgbox(10,18,12,43,4,Errobj:E_Color,2,"W/N","......Printing.....",.F.,.F.,1)

DVPRINT("ON")

 ? REPLICATE("_",75)
 ? "                       System Error Response Report "
 ? REPLICATE("_",75)

 Print13
 print13 "Oper. System -> "+Errobj:E_info[1]
 Print13 "Description  -> "+Errobj:E_info[2]
 Print13 "Operation    -> "+Errobj:E_info[3]
 Print13 "Filename     -> "+Errobj:E_info[4]
 Print13 Errobj:E_info[5]
 Print13 Errobj:E_info[6]
 Print13

        Print13 REPLICATE("_",75)

        Print13  "   Func/Proc   Line        Func/Proc   Line     "+;
                    "   Func/Proc   Line     "
        Print13 REPLICATE("_",75)

        FOR I=1 TO 7
          Print13 Errobj:E_Stack[I]+"     |"+Errobj:E_Stack[I+7]+"     |"+Errobj:E_Stack[I+14]
        NEXT

       Print13 REPLICATE("_",75)
       Print13
       Print13
       Print13
       Print13
       Print13
       Print13
       print13 "Name_______________________Office________________________Serial #_________"
       Print13
       print13
       Print13 "Remarks___________________________________________________________________"
       print13
       Print13 "__________________________________________________________________________"
       Print13
       Print13 "__________________________________________________________________________"
       Print13
       Print13 "__________________________________________________________________________"
       Print13 CHR(12)
dvprint("off")
RETURN(NIL)
//*******************************
STATIC FUNCTION GetStack()
//*********************************
local x:=1,thearray[21]
for x:=3 to 23
       thearray[x-2]:=padr(S_NTRIM(x-1),3," ")+;
                        padr(procname(x),12," ")+;
                        Padr(S_NTRIM(procline(x)),4," ")

NEXT
RETURN(THEARRAY)
//********************************
Static FUNCTION SayStack(ErrObj,nRow)
//********************************
LOCAL X
  For X:=1 TO 7
     @ nrow+x,3 say Errobj:E_Stack[x]+"     "+Errobj:E_Stack[x+7]+"     "+;
      Errobj:E_Stack[x+14] COLOR (Errobj:E_Color)
  Next

return(NIL)




