/*
Ŀ
                   getsys.prg - Clipper Get System Get System ;             
                   Dave L. Palmer.  D.V.S Business System.                  
                   Sacramento, CA     (916)-852-9567                        
                                                                            
     **************       ADDITIONS TO GETSYS.PRG *******************       
        1. Full Mouse Support                                               
           Mouse Commands Located in Mouse.prg.                             
                                                                            
        2. Message Support Like @ Prompt, Menuto                            
           Sample                                                           
            @ [row],[col] Say/Get [color] [pic] [color] [when] [valid] ;    
              [message] [mcolor]                                            
                                                                            
        3. Incremental Date With -+ keys                                    
        4. Check Individual Get To For Updated                              
        5. Pop Up Menu/Browse Clause is Popup <array>                       
        6. Pop Up Menu/Browse Database                                      
        7. Memoediting in Get                                               
        8. All The above are Actually Part of Each Get Object Cargo         
           which I made it an array                                         
     ReadKill( [<lKill>] )       --> lKill                                  
     ReadUpdated( [<lUpdated>] ) --> lUpdated                               
     ReadFormat( [<bFormat>] )   --> bFormat                                
       Returns NIL if no format                                             
                                                                            
                                                                            
       NOTE: compile with L/M/N/W                                           
                                                                            

*/

#INCLUDE "DVBROWSE.CH"
#INCLUDE "SETCURS.CH"
#INCLUDE "M_INKEY.CH"
#INCLUDE "GETEXIT.CH"
#INCLUDE "dVS.CH"
#define K_UNDO          K_CTRL_U


//
// State variables for active READ
//
STATIC sbFormat
STATIC slUpdated := .F.
STATIC slKillRead
STATIC slBumpTop
STATIC slBumpBot
STATIC snLastExitState
STATIC snLastPos
STATIC soActiveGet
STATIC scReadProcName
STATIC snReadProcLine
STATIC MemoMaxlines
static MemoKey


//
// Format of array used to preserve state variables
//
#define GSV_KILLREAD       1
#define GSV_BUMPTOP        2
#define GSV_BUMPBOT        3
#define GSV_LASTEXIT       4
#define GSV_LASTPOS        5
#define GSV_ACTIVEGET      6
#define GSV_READVAR        7
#define GSV_READPROCNAME   8
#define GSV_READPROCLINE   9

#define GSV_COUNT          9

//#DEFINE GE_MOUSELIST             CARGO[1] // array of mouse pos
        // 1=mouserow,mousecol beginning get ,mouserow,mousecol end of get
//#DEFINE GE_MESSAGELIST           CARGO[2] // array message info
        // 1=message to display, 2 color of message
//#DEFINE GE_POPLIST               CARGO[3] // array of popup list
        // 1=array to browse, 2 color of browse
//#DEFINE GE_POPDBF                CARGO[5]
//#DEFINE GE_MEMO                  CARGO[4] // Memoediting in get object
#DEFINE GE_MEMO1                 CARGO[4,1]   // Screen Cooridnates
#DEFINE GE_MEMO2                 CARGO[4,2]
#DEFINE GE_MEMO3                 CARGO[4,3]
#DEFINE GE_MEMO4                 CARGO[4,4]


//#DEFINE GE_GETCHANGED            CARGO[10] // HAS GET CHANGE (INDIVIDUAL)





//***************************************
FUNCTION ReadModal( GetList, nPos )
//***************************************
local oget,;
      asavGetSysVars,;
      Oldcursor,;
      x,;
      msgCol,;
      msgrow,;
      msgscreen

		nPos       :=  if(nPos==NIL,1,nPos)
		x          :=  0

    OldCursor  :=  SetCursor(SC_NORMAL)
		msgrow     :=  Set(_SET_MESSAGE)
    msgscreen  :=  savescreen(Set(_SET_MESSAGE),0,SET(_SET_MESSAGE),MAXCOL())

   IF ( VALTYPE( sbFormat ) == "B" )
      EVAL( sbFormat )
   ENDIF
	 // Get Rid of all S87 Stuff
   // Preserve state variables
   aSavGetSysVars := ClearGetSysVars()

   // Set these for use in SET KEYs
   scReadProcName := PROCNAME( 1 )
   snReadProcLine := PROCLINE( 1 )

   // Set initial GET to be read
   IF !( VALTYPE( nPos ) == "N" .AND. nPos > 0 )
      nPos := Settle( Getlist, 0 )
   ENDIF

   WHILE !( nPos == 0 )
		 // This Code is for My Getsys to Work With Any Program
		 if Valtype(Getlist[nPos]:cargo)!="A"
							GetList[nPos]:Cargo:=Array(10)
		 endif
      // Get next GET from list and post it as the active GET
      PostActiveGet( oGet := GetList[ nPos ] )

		// read the GET
		IF ( ValType( oget:reader ) == "B" )
			// I Added (nPos,Getlist) Because I Have Know Idea What i Will Do When
			// I need A custom Reader So I Want Current Get its Pos And the Whole
			// List, Theirfore I Pretty Much Can do AnyThing I Want To !
			              Eval( oget:reader, oget,npos,getlist) 		// use custom reader block
										Restscreen(msgrow,0,msgrow,Maxcol(),msgscreen)
		ELSE

                    npos := Getreader( oget,GetList,npos,msgscreen)     // use standard reader
                       // EXITING READMODOL REST ORIGINAL MESSAGE LINE
                       // BEFORE ENTERING GET SYSTEM
                       restscreen(msgrow,0,msgrow,maxcol(),msgscreen)

   ENDIF

      // Move to next GET based on exit condition
      nPos := Settle( GetList, nPos )

   ENDDO


   // Restore state variables
   RestoreGetSysVars( aSavGetSysVars )


   SETCURSOR(OldCursor)

   RETURN ( slUpdated )

//******************
//GetReader
//******************

//***********************************
//Function GetReader( oGet )
Function Getreader( oget,GetList,npos,msgscreen)
//*************************************************
local m,nKey
   // Read the GET if the WHEN condition is satisfied
   IF ( GetPreValidate( oGet ) )

      // Display a message if there is one

      if oGet:GE_MESSAGELIST!=NIL  // Standard Gets No Message clause
																			// Cargo[2] Will Be Empty
                  GetSayMessage(oGet)
      Endif

      // activate the GET for reading
          MOUSEOFF(); oget:SetFocus()


      WHILE ( oGet:exitState == GE_NOEXIT )

         // Check for initial typeout (no editable positions)
         IF ( oGet:typeOut )
            oGet:exitState := GE_ENTER
         ENDIF

         // Apply keystrokes until exit
			while ( oGet:exitState == GE_NOEXIT )

               			nKey := mInKey(0)
                    MOUSEWAIT(K_MOUSE_2)
										MOUSEWAIT(K_MOUSE_1)
                    MOUSEOFF()
	       			if nkey==K_MOUSE_1 .AND. ;
                 (M:=ASCAN(getlist,{|ELE|;
                 mregion(ele:cargo[1,1],ele:cargo[1,2],;
                 ele:cargo[1,3],ele:cargo[1,4])}))>0 .AND. m<>nPos

							      oGet:exitState := GE_DOWN
							       npos :=m
										 if npos>0
											  getList[nPos]:exitState := GE_NOEXIT
										 endif
												exit

							Endif
							if nkey>0 .OR. nkey==K_MOUSE_2
								Mouseoff()
				       GetApplyKey( oGet, nKey)
						 ENDIF

			enddo

											 IF ! EMPTY(oGet:GE_POPDBF)
															IF (!GetPopDBF(oGet))
																oGet:ExitState:= GE_NOEXIT
															ENDIF
											 ENDIF
			 // disallow exit if the VALID condition is not satisfied
			if ( !GetPostValidate(oGet) )

				oGet:exitState := GE_NOEXIT
			end
                        // Lets See if We Used POPUP CLAUSE Get Command

                       if ! Empty(oGet:GE_POPLIST)
                          IF (!Getpopup(oGet))
                                oGet:exitState := GE_NOEXIT
									        ENDIF
                       ENDIF
		 	 /*								 IF ! EMPTY(oGet:GE_POPDBF)
															IF (!GetPopDBF(oGet))
																oGet:ExitState:= GE_NOEXIT
															ENDIF
											 ENDIF
				 */
		end

		// de-activate the oGet

                 oGet:KillFocus()

	end

RETURN(nPos)



/***
*
*  GetApplyKey()
*
*  Apply a single MINKEY() keystroke to a GET
*
*  NOTE: GET must have focus.
*
*/
//********************************
FUNCTION GetApplyKey(oGet, key)
//********************************
LOCAL cKey,bKeyBlock
           MOUSEOFF()

           oGet:GE_GETCHANGED:=oGet:changed
	// check for SET KEY first
      /*if ( (bKeyBlock := SetKey(key)) <> NIL )
	        	GetDoSetKey(bKeyBlock, oGet)
		        return(NIL)
           // NOTE
       End  */


DO CASE
         CASE  oGet:type == "D" .and. chr(key)$"+="

            oGet:buffer:=IF(oGet:buffer=="  /  /  ";
                        .or. oGet:buffer=="99/99/99";
                        .or. oGet:buffer=="00/00/00",dtoc(DATE()),oGet:buffer)
            oGet:buffer := TRANSFORM( oGet:unTransform() + 1, oGet:picture )
            oGet:changed := .T.
            oGet:Display()
         CASE oGet:type == "D" .and. chr(key)=="-"
            oGet:buffer:=IF(oGet:buffer=="  /  /  ";
                        .or. oGet:buffer=="99/99/99",dtoc(DATE()),oGet:buffer)
            oGet:buffer := TRANSFORM( oGet:unTransform() - 1, oGet:picture )
            oGet:changed := .T.
            oGet:Display()
	CASE ( key == K_ESC  .AND.  Set(_SET_ESCAPE)) .OR. Key==K_MOUSE_2
		  oGet:undo()
			oGet:exitState := GE_ESCAPE
	CASE ( key == K_UP )
		oGet:exitState := GE_UP

	CASE ( key == K_SH_TAB )
		oGet:exitState := GE_UP

	CASE ( key == K_DOWN )
		oGet:exitState := GE_DOWN

	CASE ( key == K_TAB )
		oGet:exitState := GE_DOWN

	CASE ( key == K_ENTER )
		oGet:exitState := GE_ENTER


	CASE ( key == K_PGUP )
		oGet:exitState := GE_WRITE

	CASE ( key == K_PGDN )
		oGet:exitState := GE_WRITE

	CASE ( key == K_CTRL_HOME )
		oGet:exitState := GE_TOP


#ifdef CTRL_END_SPECIAL

	// both ^W and ^End go to the last oGet
	CASE (key == K_CTRL_END)
		oGet:exitState := GE_BOTTOM

#else

	// both ^W and ^End terminate the READ (the default)
	CASE (key == K_CTRL_W)
		oGet:exitState := GE_WRITE

#endif


	case (key == K_INS)
		Set( _SET_INSERT, !Set(_SET_INSERT) )
                IF(Set(_SET_INSERT),;
                   SETCURSOR(SC_SPECIAL1),;
                   SETCURSOR(SC_NORMAL))


	CASE (key == K_UNDO)
		oGet:Undo()

	case (key == K_HOME)
		 oGet:Home()

	case (key == K_END)
		 oGet:End()

	case (key == K_RIGHT)
		oGet:Right()

	case (key == K_LEFT)
		oGet:Left()

	case (key == K_CTRL_RIGHT)
		oGet:WordRight()

	case (key == K_CTRL_LEFT)
		oGet:WordLeft()
	case (key == K_BS)
		oGet:BackSpace()

	case (key == K_DEL)
		oGet:Delete()

	case (key == K_CTRL_T)
		oGet:DelWordRight()

	case (key == K_CTRL_Y)
	      oGet:DelEnd()

	case (key == K_CTRL_BS)
		oGet:DelWordLeft()

	otherwise

	 //	if (key >= 32 .and. key <= 255)

			cKey := Chr(key)

			if (oGet:type == "N" .and. (cKey == "." .or. cKey == ","))
				oGet:ToDecPos()

			else
				if ( Set(_SET_INSERT) )
					oGet:Insert(cKey)
				else
					 oGet:Overstrike(cKey)
				end

				if (oGet:typeOut .and. !Set(_SET_CONFIRM) )
					if ( Set(_SET_BELL) )
						?? Chr(7)
					end

					oGet:exitState := GE_ENTER
				end

			end

	 //	end // let any Thing go in get

	endcase

return(NIL)


//***************************
FUNCTION GetPreValidate(oGet)
//***************************

local saveUpdated
local lwhen := .t.
	if ( oGet:preBlock <> NIL )

		saveUpdated := slUpdated

		lwhen := Eval(oGet:preBlock, oGet)

                MouseOff(); oGet:Display()


		slUpdated := saveUpdated

	end


	if ( slKillread )
		lwhen := .f.
		oGet:exitState := GE_ESCAPE		// provokes ReadModal() exit

	elseif ( !lwhen )
		oGet:exitState := GE_WHEN		// indicates failure
	else    // original Else clause
		oGet:exitState := GE_NOEXIT		// prepares for editing
	end

return (lwhen)


/***
*	oGetPostValidate()
*	Test exit condition (VALID clause) for a oGet.
*
*	NOTE: bad dates are rejected in such a way as to preserve edit buffer.
*/
//*****************************
FUNCTION GetPostValidate(oGet)
//****************************
local saveUpdated,;
      changed, valid := .t.,;
      Oldcursor:=SetCursor()
			MouseOff()

	if ( oGet:exitState == GE_ESCAPE )
            return (.t.)					// NOTE
	end

	if ( oGet:BadDate() )

		laser(3)
		Msgbox(3,5,5,45,5,setcolor(),1,"7/0",;
                    "- Invalid Date - ",1,.t.)

                 oGet:Home()
		Setcursor(oldcursor)
		return (.f.)					// NOTE
	end


	// if editing occurred, assign the new value to the variable
	if ( oGet:changed )
            	oGet:Assign()
	        slUpdated := .t.
	end


	// reform edit buffer, set cursor to home position, redisplay
          oGet:Reset()

	// check VALID condition if specified
	if ( oGet:postBlock <> NIL )

		saveUpdated := slUpdated

		// S87 compat.
                SetPos( oGet:row, oGet:col + Len(oGet:buffer) )

		valid := Eval(oGet:postBlock, oGet)

		// reset compat. pos
		SetPos( oGet:row, oGet:col )

	        MouseOff(); oGet:UpdateBuffer()

		slUpdated := saveUpdated

		if ( slKillread )
			oGet:exitState := GE_ESCAPE	// provokes ReadModal() exit
			valid := .t.
		end

	end

RETURN(valid)



/***
*
*  GetDoSetKey()
*
*  Process SET KEY during editing
*
*/
PROCEDURE GetDoSetKey( keyBlock, oGet )

   LOCAL lSavUpdated

   // If editing has occurred, assign variable
   IF ( oGet:changed )
      oGet:assign()
      slUpdated := .T.
   ENDIF

   lSavUpdated := slUpdated

   EVAL( keyBlock, scReadProcName, snReadProcLine, ReadVar() )


   oGet:updateBuffer()

   slUpdated := lSavUpdated

   IF ( slKillRead )
      oGet:exitState := GE_ESCAPE      // provokes ReadModal() exit
   ENDIF

   RETURN





/***
*              READ services
*/



/***
*
*  Settle()
*
*  Returns new position in array of Get objects, based on:
*     - current position
*     - exitState of Get object at current position
*
*  NOTES: return value of 0 indicates termination of READ
*         exitState of old Get is transferred to new Get
*
*/
STATIC FUNCTION Settle( GetList, nPos )

   LOCAL nExitState

   IF ( nPos == 0 )
      nExitState := GE_DOWN
   ELSE
      nExitState := GetList[ nPos ]:exitState
   ENDIF

   IF ( nExitState == GE_ESCAPE .or. nExitState == GE_WRITE )
      RETURN ( 0 )               // NOTE
   ENDIF

   IF !( nExitState == GE_WHEN )
      // Reset state info
      snLastPos := nPos
      slBumpTop := .F.
      slBumpBot := .F.
   ELSE
      // Re-use last exitState, do not disturb state info
      nExitState := snLastExitState
   ENDIF

   //
   // Move
   //
   DO CASE
   CASE ( nExitState == GE_UP )
      nPos--

   CASE ( nExitState == GE_DOWN )
      nPos++

   CASE ( nExitState == GE_TOP )
      nPos       := 1
      slBumpTop  := .T.
      nExitState := GE_DOWN

   CASE ( nExitState == GE_BOTTOM )
      nPos       := LEN( GetList )
      slBumpBot  := .T.
      nExitState := GE_UP

   CASE ( nExitState == GE_ENTER )
      nPos++

   ENDCASE

   //
   // Bounce
   //
   IF ( nPos == 0 )                       // Bumped top
      IF ( !ReadExit() .and. !slBumpBot )
         slBumpTop  := .T.
         nPos       := snLastPos
         nExitState := GE_DOWN
      ENDIF

   ELSEIF ( nPos == len( GetList ) + 1 )  // Bumped bottom
      IF ( !ReadExit() .and. !( nExitState == GE_ENTER ) .and. !slBumpTop )
         slBumpBot  := .T.
         nPos       := snLastPos
         nExitState := GE_UP
      ELSE
         nPos := 0
      ENDIF
   ENDIF

   // Record exit state
   snLastExitState := nExitState

   IF !( nPos == 0 )
      GetList[ nPos ]:exitState := nExitState
   ENDIF

   RETURN ( nPos )



/***
*
*  PostActiveGet()
*
*  Post active GET for ReadVar(), GetActive()
*
*/
STATIC PROCEDURE PostActiveGet( oGet )

   GetActive( oGet )
   ReadVar( GetReadVar( oGet ) )



   RETURN



/***
*
*  ClearGetSysVars()
*
*  Save and clear READ state variables. Return array of saved values
*
*  NOTE: 'Updated' status is cleared but not saved (S'87 compatibility)
*/
STATIC FUNCTION ClearGetSysVars()

   LOCAL aSavSysVars[ GSV_COUNT ]

   // Save current sys vars
   aSavSysVars[ GSV_KILLREAD ]     := slKillRead
   aSavSysVars[ GSV_BUMPTOP ]      := slBumpTop
   aSavSysVars[ GSV_BUMPBOT ]      := slBumpBot
   aSavSysVars[ GSV_LASTEXIT ]     := snLastExitState
   aSavSysVars[ GSV_LASTPOS ]      := snLastPos
   aSavSysVars[ GSV_ACTIVEGET ]    := GetActive( NIL )
   aSavSysVars[ GSV_READVAR ]      := ReadVar( "" )
   aSavSysVars[ GSV_READPROCNAME ] := scReadProcName
   aSavSysVars[ GSV_READPROCLINE ] := snReadProcLine

   // Re-init old ones
   slKillRead      := .F.
   slBumpTop       := .F.
   slBumpBot       := .F.
   snLastExitState := 0
   snLastPos       := 0
   scReadProcName  := ""
   snReadProcLine  := 0
   slUpdated       := .F.

   RETURN ( aSavSysVars )



/***
*
*  RestoreGetSysVars()
*
*  Restore READ state variables from array of saved values
*
*  NOTE: 'Updated' status is not restored (S'87 compatibility)
*
*/
STATIC PROCEDURE RestoreGetSysVars( aSavSysVars )

   slKillRead      := aSavSysVars[ GSV_KILLREAD ]
   slBumpTop       := aSavSysVars[ GSV_BUMPTOP ]
   slBumpBot       := aSavSysVars[ GSV_BUMPBOT ]
   snLastExitState := aSavSysVars[ GSV_LASTEXIT ]
   snLastPos       := aSavSysVars[ GSV_LASTPOS ]

   GetActive( aSavSysVars[ GSV_ACTIVEGET ] )

   ReadVar( aSavSysVars[ GSV_READVAR ] )

   scReadProcName  := aSavSysVars[ GSV_READPROCNAME ]
   snReadProcLine  := aSavSysVars[ GSV_READPROCLINE ]

   RETURN



/***
*
*  GetReadVar()
*
*  Set READVAR() value from a GET
*
*/
STATIC FUNCTION GetReadVar( oGet )

   LOCAL cName := UPPER( oGet:name )
   LOCAL i

   // The following code includes subscripts in the name returned by
   // this FUNCTIONtion, if the get variable is an array element
   //
   // Subscripts are retrieved from the oGet:subscript instance variable
   //
   // NOTE: Incompatible with Summer 87
   //
   IF !( oGet:subscript == NIL )
      FOR i := 1 TO LEN( oGet:subscript )
         cName += "[" + LTRIM( STR( oGet:subscript[i] ) ) + "]"
      NEXT
   END

   RETURN ( cName )





/***
*              System Services
*/



/***
*
*  __SetFormat()
*
*  SET FORMAT service
*
*/
PROCEDURE __SetFormat( b )
   sbFormat := IF( VALTYPE( b ) == "B", b, NIL )
   RETURN



/***
*
*  __KillRead()
*
*  CLEAR GETS service
*
*/
PROCEDURE __KillRead()
   slKillRead := .T.
   RETURN



/***
*
*  GetActive()
*
*  Retrieves currently active GET object
*/
FUNCTION GetActive( g )

   LOCAL oldActive := soActiveGet

   IF ( PCOUNT() > 0 )
      soActiveGet := g
   ENDIF

   RETURN ( oldActive )



/***
*
*  Updated()
*
*/
FUNCTION Updated()
   RETURN slUpdated



/***
*
*  ReadExit()
*
*/
FUNCTION ReadExit( lNew )
   RETURN ( SET( _SET_EXIT, lNew ) )



//***********************************
FUNCTION ReadInsert( lNew )
//***********************************
   RETURN ( SET( _SET_INSERT, lNew ) )

/***
*
*  DateMsg()
*
*/
//***************************
STATIC FUNCTION DateMsg()
//***************************
			MsgBox(3,5,5,30,7,setcolor(),2,"7/0","...Invalid Date....",.t.)


RETURN(NIL)


//******************************************
FUNCTION RangeCheck( oGet, junk, lo, hi )
//******************************************

   LOCAL cMsg, nRow, nCol
   LOCAL xValue

   IF ( !oGet:changed )
      RETURN ( .T. )          // NOTE
   ENDIF

   xValue := oGet:varGet()

   IF ( xValue >= lo .and. xValue <= hi )
      RETURN ( .T. )          // NOTE
   ENDIF



      cMsg := "Range: " + LTRIM( TRANSFORM( lo, "" ) ) + ;
            " - " + LTRIM( TRANSFORM( hi, "" ) )

			MsgBox(3,5,5,5+Len(cmsg),7,setcolor(),2,"7/0",cmsg,.t.)


   RETURN ( .F. )



/***
*
*  ReadKill()
*
*/
FUNCTION ReadKill( lKill )

   LOCAL lSavKill := slKillRead

   IF ( PCOUNT() > 0 )
      slKillRead := lKill
   ENDIF

   RETURN ( lSavKill )



/***
*
*  ReadUpdated()
*
*/
FUNCTION ReadUpdated( lUpdated )

   LOCAL lSavUpdated := slUpdated

   IF ( PCOUNT() > 0 )
      slUpdated := lUpdated
   ENDIF

   RETURN ( lSavUpdated )



/***
*
*  ReadFormat()
*
*/
FUNCTION ReadFormat( b )

   LOCAL bSavFormat := sbFormat

   IF ( PCOUNT() > 0 )
      sbFormat := b
   ENDIF

   RETURN ( bSavFormat )

//* Get system Enhancements
//***************************************
function GetSayMessage(oGet)
//****************************************
Local nOldrow,nOldCol,nOldcsr,nMsgCol,nMsgRow
nOldrow:=Row();nOldcol:=Col()
nOldCsr:=SetCursor(SC_NONE)
nMsgRow:=Set(_SET_MESSAGE)
nMsgCol:=IF(!SET(_SET_MCENTER),0,(((MAXCOL()+1)/2)-(LEN(oGet:GE_MESSAGELIST[1])/2)))
MouseOff()
      //RestScreen(nMsgRow,0,nMsgRow,maxcol(),msgscreen)
      SETPOS(nMsgrow,nMsgCol)
      DevOut(" "+oGet:GE_MESSAGELIST[1]+" ",oGet:GE_MESSAGELIST[2])
      SETCURSOR(nOldCsr)
      SetPos(nOldrow,nOldcol)

Return(NIL)


//****************************
Function GetPopUp(oGet)
//******************************
local lretvar:=.t.,nMchoice,nTrow,nLcol,nBrow,nRcol,;
     nWidth,colinfo,atype,nFreeze:=1,nHeight:=5,nelements
MouseOff()
if valtype(oGet:GE_POPLIST[1][1])=="A"
    IF  (lretvar:=(Ascan(oGet:GE_POPLIST[1],{|ele|;
         Upper(oGet:buffer)==;
			   padr(Substr(UPPER(ALLTRIM(ele[1])),1,Len(oGet:buffer)),Len(oGet:buffer)," ")}) !=0))
         Return(lRetvar)

    endif



         nHeight+=len(oGet:GE_POPLIST[1])
         nWidth:= if((nWidth:=aTotlen(oGet:GE_POPLIST[1][1]))<15,16,nWidth)
				 NFreeze:=Len(oGet:GE_POPLIST[1][1])

				 Nwidth+=nfreeze
else
   IF (lretvar:=(Ascan(oGet:GE_POPLIST[1],{|ele|;
      Upper(oGet:buffer)==;
			padr(Substr(UPPER(ALLTRIM(ele)),1,Len(oGet:buffer)),Len(oGet:buffer)," ")}) !=0))
      Return(Lretvar)

   endif
				 nHeight+=len(oGet:GE_POPLIST[1])

         nWidth:= if((nWidth:=Amaxlen(oGet:GE_POPLIST[1][1]))<15,16,nWidth)+2
         oGet:GE_POPLIST[1][1]:=padr(oGet:GE_POPLIST[1][1],nwidth," ")
				 NFREEZE:=1


endif


				 //Ntrow:=IF(oGet:row<maxrow()/2,(oGet:row+1),(oGet:row-1))
				 Ntrow:=3 //IF(oGet:row<maxrow()/2,(oGet:row+1),(oGet:row-1))

				 nBrow:=IF(ntrow+nHeight<maxrow()-2,ntrow+nheight,maxrow()-2)
				 nLcol:=if(oGet:col<(Maxcol()/2) .AND. nWidth < (Maxcol()/2),;
									Maxcol()/2,5)

		     nRcol:=(if((nLcol+nwidth)>=maxcol(),(maxcol()-2),(nlcol+nwidth)))

				 Browse nmchoice from ntrow,nlcol,nbrow,nrcol array oGet:GE_POPLIST[1] ;
												Box 6 bcolor oGet:GE_POPLIST[2] Freeze (NFreeze) ;
												title "Selections"

         if empty(nMchoice)
               lRetvar:=.f.
               slUpdated:=.f.
         else
				 	  IF valtype(oGet:GE_POPLIST[1][1])=="C"
               oGet:buffer:=(padr(alltrim(oGet:GE_POPLIST[1][nMchoice]),;
                           len(oGet:buffer)," "))
            else
               oGet:buffer:=(padr(alltrim(oGet:GE_POPLIST[1][nMchoice][1]),;
                           len(oGet:buffer)," "))
            endif
							 MouseOff()
               oGet:ASSIGN()
               oGet:display()
               oGet:killfocus()

               slUpdated:=.t.
               lRetvar:=.t.
         endif
				 // PopDisp OPTION OF COMMAND. if We Want More on Screen
							 IF Valtype(oGet:GE_POPLIST[3])=="B"
									 Eval(oGet:GE_POPLIST[3])
							 ENDIF


return(lRetvar)



//****************************************
FUNCTION GetPopDbf(oGet)
//*****************************************
local mchoice,nwidth,aStru,nLcol,nBrow,nRcol,autopop:=.f.,x,;
			Records,retvar:=.t.,ntrow

#DEFINE _alias            1 // Alias work area
#DEFINE _putfield         2 // field to stuff oGet:buffer
#DEFINE _afieldlist       3 // ARRAY OF C FIELDNAMES
#DEFINE _color            4 // browse color
#DEFINE _title            5 // BOX TITLE
#DEFINE _columnlist       6 // ARRAY C COLUMN HEADINGS
#DEFINE _auto             7 // IF .T. AUTO LOOKUP ELSE LOOKFOR ?
#DEFINE _delok            8 // if .T. let browse delete records
#Define _nrow             9 // Row to Disp browse
#DEFINE _ncol             10 // Col To Start Browse
#DEFINE _popseek          11 // logical to seek database
#DEFINE _bpopdisp          12 // Post Disp block
#define _fieldname        1 // Field name in Stru Array
#Define _fieldlen         3 // Field Length in Stru Array
oGet:GE_POPDBF[_alias]:=;
	TRIM(Upper(IF(Empty(oGet:GE_POPDBF[_alias]),ALIAS(),oGet:GE_POPDBF[_alias])))
oGet:GE_POPDBF[_putfield]:=;
	IF(EMPTY(oGet:GE_POPDBF[_putfield]),1,oGet:GE_POPDBF[_putfield])
oGet:GE_POPDBF[_afieldlist]:=;
	IF(EMPTY(oGet:GE_POPDBF[_afieldlist]),(oGet:GE_POPDBF[_afieldlist])->(SCATTER("L","F",.F.)),;
											oGet:GE_POPDBF[_afieldlist])
oGet:GE_POPDBF[_color]:=;
	IF(empty(oGet:GE_POPDBF[_color]),SETCOLOR(),oGet:GE_POPDBF[_color])
oGet:GE_POPDBF[_title]:=;
	IF(Empty(oGet:GE_POPDBF[_title]),"Selections",oGet:GE_POPDBF[_title])

// Starting top Row, Left col
Records:=(oGet:GE_POPDBF[_alias])->(Reccount())
Ntrow:=IF(oGet:GE_POPDBF[_nrow]==NIL,5,oGet:GE_POPDBF[_nrow])
Nlcol:=IF(oGet:GE_POPDBF[_ncol]==NIL,10,oGet:GE_POPDBF[_ncol])
nBrow:=IF((ntrow+records)+3>=(Maxrow()-6),;
								 (Maxrow()-5),(Ntrow+records)+5)

aStru:=(oGet:GE_POPDBF[_alias])->(DBSTRUCT())
// fIND OUT hOW wHIDE ALL THE FIELDS DATA IS AND ADD TOTAL ELEMENTS TO NWIDTH
// THEN FIND OUT IF MAXCOL() HAS BEEN EXCEEDED
nwidth:=len(oGet:GE_POPDBF[_afieldlist])
				 For X:=1 to len(oGet:GE_POPDBF[_afieldlist])

								 nwidth+=;
								 	astru[ascan(Astru,;
									{|ele|ele[_fieldname]==;
						      trim(UPPER(oGet:GE_POPDBF[_afieldlist][x]))}),_fieldlen]

				 next

nwidth:=if((nwidth+10)>=(Maxcol()-1),Maxcol()-2,(nwidth+10))

IF ! oGet:GE_POPDBF[_popseek]
     IF (! oGet:GE_POPDBF[_auto]) .AND. (at("?",oGet:buffer)>0)
		   Autopop:=.t.
		   retvar:=.f.
     ELSEIF oGet:GE_POPDBF[_auto]
		   autopop:=.t.
		   Retvar:=.t.
     endif


else // Use POPSEEK Clause


	 (oGet:GE_POPDBF[_alias])->(dbgotop())

	 IF (oGet:GE_POPDBF[_alias])->(DBSEEK(UPPER(oGet:BUFFER),.T.))==.t.



			RetVar:=.t.
			autopop:=.f.

			if valtype(oGet:GE_POPDBF[_bpopdisp])=="B"

				Eval(oGet:GE_POPDBF[_bpopdisp])
			endif
	 else

	 	  autopop:=.t.
			retvar:=.f.
	 Endif
	 (oGet:GE_POPDBF[_alias])->(dbgotop())
ENDIF

IF autopop
IF (oGet:GE_POPDBF[_alias])->(reccount())==0
		 Laser(3)
		 Msgbox(3,5,5,55,7,oGet:GE_POPDBF[_color],2,Clrsep(oGet:GE_POPDBF[_color],2),;
			"There are No Recods Present [Press Any Key]",.t.,.t.)
		 Return(.t.)
ENDIF
MCHOICE:=;
 	(oGet:GE_POPDBF[_alias])->(Mdbfview(nTrow,nLcol,nBrow,nLcol+NWIDTH,;
	                oGet:GE_POPDBF[_afieldlist],;
									oGet:GE_POPDBF[_columnlist],;
	                oGet:GE_POPDBF[_title], 7,;
	                oGet:GE_POPDBF[_color],,,,1,;
									oGet:GE_POPDBF[_delok],.f.,,.F.,,.F.))

IF eMPTY(MCHOICE)
		slUpdated:=.f.


Else



	        		 MouseOff()
							 oGet:Buffer:=PADR(eval(oGet:GE_POPDBF[_putfield]),LEN(oGet:buffer)," ")
               oGet:ASSIGN()
							 oGet:display()


							 if valtype(oGet:GE_POPDBF[_bpopdisp])=="B"
									Eval(oGet:GE_POPDBF[_bpopdisp])
							 endif
 							 slUpdated:=.t.
							 retvar:=.t.


Endif
ENDIF // autopop


RETURN(retvar)
#DEFINE  _mTop               oGet:GE_MEMO[1]
#DEFINE  _mLeft              oGet:GE_MEMO[2]
#DEFINE  _mBottom            oGet:GE_MEMO[3]
#DEFINE  _mRight             oGet:GE_MEMO[4]
#DEFINE  _mColor             oGet:GE_MEMO[5]
#DEFINE  _mStrip             oGet:GE_MEMO[6]
#DEFINE  _mKey               oGet:GE_MEMO[7]
#DEFINE  _mMaxlines          oGet:GE_MEMO[8]
#DEFINE  _mMessage           oGet:GE_MESSAGELIST[1]
#DEFINE  _mMcolor            oGet:GE_MESSAGELIST[2]

//*************************************
function getmemo(oGet,Getlist,Pos)
//*************************************
local oldcolor,thevar,newtrow,newbrow
oldcolor:=Setcolor(clrsep(oGet:cargo[4,5],2))
Thevar:=oGet:Varget()
// Check MemoKey Claus Initialize static Memoediting Save Key in oGet
MemoMaxlines:=if(_mMaxlines==NIL,500,_mMaxlines+1)

MemoKey:=If(_mKey!=NIL,_mKey,K_ALT_ENTER)

			// Say A Message if Their is one
      if _mMessage!=NIL
			          GetSayMessage(oGet)
      Endif
SetCursor(SC_NORMAL)
INSERTKEY()
        Thevar:=memoedit(thevar,_mTop,_mLeft,_mBottom,_mRight,.t.,"getkeys()")
Clear typeahead
if lastkey()==K_CTRL_W
		 oGet:varput(thevar)
		 oGet:EXITSTATE:=GE_ENTER
		 slUpdated:=.T.
ELSE
      oGet:EXITSTATE:=GE_ESCAPE
      slUpdated:=.F.
Endif

Setcolor(ClrSep(oGet:cargo[4,5],5))

// Redisplay Unselect oGet color
Memoedit(oGet:varget(),_mTop,_mLeft,_mBottom,_mRight,.f.,.f.)
Setcolor(oldcolor)
IF _mStrip // Strip 141,13,10 Characters
			 Thevar:=(Strtran(thevar,(chr(141)+Chr(10)),""))
			 Thevar:=(Strtran(thevar,(Chr(13)+chr(10)),""))
			 oGet:varput(thevar)
ENDIF
Return(NIL)
//*****************************
Function MEMODISP(oGet)
//********************************
local oldclr,newtrow,newbrow
IF _mBottom>=maxrow()
	 Newbrow:=oGet:Row
	 newtrow:=oGet:Row-(_mBottom-_mTop)
MouseOff()

	  _mTop:=newtrow
	  _mBottom:=newbrow
Endif

 _mColor:=if(Empty(_mColor),Setcolor(),_mColor)
 oldclr:=Setcolor(clrsep(_mColor,5))

 memoedit(oGet:varget(),_mTop,_mLeft,_mBottom,_mRight,.f.,.f.)
Setcolor(oldclr)
Return(NIL)


//*********************************
Function Getkeys(mode,line,col)
//**********************************
local key:=Lastkey()

			 INSERTKEY()
			IF MODE==3
				 RETURN(0)
			ENDIF

      if KEY==memokey .OR. line>=MemoMaxlines
		           KEYBOARD CHR(K_CTRL_W)
			ENDIF
RETURN(0)
//********************************
Function GetReDraw(GetList,Array,nPos)
//********************************
Local X,Start,Ending
Start  :=If(Empty(nPos),1,nPos)
Ending :=If(Empty(nPos),Len(Getlist),nPos)
    for X:= Start To Ending
        if EMPTY(Getlist[x]:GE_MEMO)
               GetList[x]:Display()
        Else
               MemoEdit(Getlist[x]:Varget(),;
               GetList[x]:GE_MEMO1,GetList[x]:GE_MEMO2,;
               Getlist[x]:GE_MEMO3,GetList[x]:GE_MEMO4,.F.,.F.)
        Endif

   Next
Return(GetList)



//***********************************
Function GetReLoad(Getlist,newgets,nPos)
//************************************
Local X,Start,Ending,oldclr,tmpvar
Start  :=If(Empty(nPos),1,nPos)
Ending :=If(Empty(nPos),Len(Getlist),nPos)

    for x:= Start To Ending
			   if valtype(getlist[x]:subscript)=="A"
									 Getlist[x]:varput(newgets[getlist[x]:subscript[1]])
				 Endif
        if VALTYPE(Getlist[x]:GE_MEMO)!="A"
               GetList[x]:Display()
				else
							 Oldclr:=Setcolor(clrsep(Getlist[x]:Cargo[4,5],5))
						   MemoEdit(Getlist[x]:Varget(),;
               GetList[x]:GE_MEMO1,GetList[x]:GE_MEMO2,;
               Getlist[x]:GE_MEMO3,GetList[x]:GE_MEMO4,.F.,.F.)
							 SetColor(oldclr)
        Endif
    Next
Return(GetList)


