page,132
title SCROLLA  *** Scroll Display Adapter Horiz or Vert
comment * ===============================================================

05-06-86
Thomas E. Link  Original Submission to IBMSIG

MODIFIED FOR CLIPPER BY RE MCCORD  10-21-86
        This is a procedure for display scrolling.
        It will support any BIOS supported adapter for
        vertical scrolling, and text modes for horizontal scrolling.
        Found in public domain and all alterations remain in the
        public domain 10-21-86

USAGE IS AS FOLLOWS:

BASIC Compiler:

        10 call scroll(dir%,car%,ulr%,ulc%,lrr%,lrc%,att%)

PASCAL     declare as:
       procedure scroll(dir,car,ulr,ulc,lrr,lrc,att: integer);extern;
           use as:
       scroll(1,2,0,0,24,79,7);
       This example will scroll right the entire screen two characters
       with fill attribute 7 (white on black).

LATTICE C
          use as:
       scroll(2,3,0,0,4,4,0x78);
       This example will scroll right the upper left 5x5 characters of
       the screen 3 characters with fill attribute hex 78(grey on white).

CLIPPER
              use as:
        CALL  ASCROLL WITH DIR,CAR,ATT,ULR,ULC,LRR,LRC
        THIS MUST BE PASSED AS CHARACTORS
        ie> CHR(nn)
        Order= direction up/down 6,7  left right 1,2
        Attributes are decimal eqivalents of Hex attribute
        01234567ABCDEF
        ||           | 
        | Blue.......|
        Black        High White
        e.g. Hex 1F = decimal 31 call with chr(31)
             Blue background,High white foreground
  
  The three equates below allow custom tailoring before assembling.
  Place a `;' before the statement and it becomes a comment (not defined)
  This allows usage with various languages and display adapters.

  BASIC creates code compatible with compiled or interpretive BASIC.
  Otherwise code will be for IBM PASCAL.

  BLOAD will build a header onto the code to allow the .BIN file to be
  directly BLOADed by BASIC.

  FLASH determines whether there will be a flash of the color display
  during a scroll. If not true, you get snow on an IBM color display.

  LATTICE will create an object code file compatible with the Lattice
  C Compiler small molule, else code will be for IBM PASCAL.

======================================================================= *


; The equates as listed below create a BASIC BLOAD file.
; BASIC    equ  1        ; Use with any version BASIC  else PASCAL
; BLOAD    equ  1        ; Makes the .BIN file directly BASIC BLOADable  
CLIPPER    EQU  1        ; ASM FOR CLIPPER ;*************************
 FLASH    equ  1        ; Leaving this equate makes scroll flash like IBM
;LATTICE  equ  1        ; Creates code compatible with LATTICE small mod.

bios_data       segment at 40H  ; This is where the IBM PC stores various
org     49H                             ; operating parameters for the
        crt_mode        db      ?       ; display (0040:0049H).
        crt_cols        dw      ?
        crt_len         dw      ?
        crt_start       dw      ?
        cursor_posn     dw      8 dup(?)
        cursor_mode     dw      ?
        active_page     db      ?
        addr_6845       dw      ?
        crt_mode_set    db      ?
bios_data       ends

IFDEF LATTICE                   ; This is the entry status of the stack
  stackin struc                 ; with LATTICE C small module
        pushed_bp       dw      ?      
        ret_addr        dw      ?
        dir             dw      ?
        car             dw      ?
        ulr             dw      ?
        ulc             dw      ?
        lrr             dw      ?
        lrc             dw      ?
        att             dw      ?
  stackin ends

ENDIF
IFDEF BASIC

  stackin struc                ; This is the entry status with PASCAL
        pushed_bp       dw      ?       ; or BASIC
        ret_addr        dd      ?
        att             dw      ?
        lrc             dw      ?
        lrr             dw      ?
        ulc             dw      ?
        ulr             dw      ?
        car             dw      ?
        dir             dw      ?
  stackin ends

ENDIF

DATA    SEGMENT PUBLIC 'DATA'   ; define a dummy data segment
DATA    ENDS
DGROUP  GROUP   DATA

IFDEF LATTICE

    ret_len equ 0
    PGROUP      GROUP   PROG
    SCROLLS     segment public 'PROG'
    assume      cs:PGROUP,ds:bios_data
                public  SCROLL,SCROLL_,_SCROLL
    SCROLL_:
    _SCROLL:
    SCROLL      proc    near

ENDIF 
IFDEF  BASIC   ; PASCAL-BASIC VERSION

    ret_len equ type stackin - 6
    SCROLLS     segment 'CODE'
ifdef   BLOAD
        db      0FDH            ; indicate BLOAD file
        dw      0               ; segment - BASIC uses default
        dw      0               ; offset - spec in BLOAD
        dw      scrollend-scroll; length of routine
endif
    assume      cs:SCROLLS,ds:bios_data
                public  SCROLL
    SCROLL      proc    far

ENDIF
 IFDEF   CLIPPER
  RET_LEN  EQU   0
         SCROLLS  SEGMENT PUBLIC 'CODE'
        PUBLIC ASCROLL
 ASCROLL    PROC    FAR        ;SAVE DS
         ASSUME CS:SCROLLS
        PUSH    DS
        CALL   SCROLL
        POP     DS      ;RESET DS
        RET
ASCROLL ENDP

         SCROLL  PROC   NEAR
         ASSUME DS:BIOS_DATA
 ENDIF

;........................................................................
        push    bp
        mov     bp,sp

ifdef   BASIC
        mov     si,[bp].dir             ; Get parms off stack
        mov     ah,[si]
        mov     si,[bp].car
        mov     al,[si]
        mov     si,[bp].att
        mov     bh,[si]
        mov     si,[bp].ulr
        mov     ch,[si]
        mov     si,[bp].ulc
        mov     cl,[si]
        mov     si,[bp].lrr
        mov     dh,[si]
        mov     si,[bp].lrc
        mov     dl,[si]
ENDIF
IFDEF  LATTICE
        mov     ah,byte ptr[bp].dir     ; Get parms off stack
        mov     al,byte ptr[bp].car
        mov     bh,byte ptr[bp].att
        mov     ch,byte ptr[bp].ulr
        mov     cl,byte ptr[bp].ulc
        mov     dh,byte ptr[bp].lrr
        mov     dl,byte ptr[bp].lrc
endif         
IFDEF  CLIPPER
       
                                        ;GET PARMS OFF STACK
        MOV     AX,BP
        ADD     AX,04H
        MOV     BP,AX
        LES     SI,SS:[BP+6]
        MOV     AH,BYTE PTR ES:[SI]       ;DIR
        LES     SI,SS:[BP+10]
        MOV     AL,BYTE PTR ES:[SI]       ;CAR
        LES     SI,SS:[BP+14]
        MOV     BH,BYTE PTR ES:[SI]       ;ATT
        LES     SI,SS:[BP+18]
        MOV     CH,BYTE PTR ES:[SI]       ;ULR
        LES     SI,SS:[BP+22]
        MOV     CL,BYTE PTR ES:[SI]       ;ULC
        LES     SI,SS:[BP+26]
        MOV     DH,BYTE PTR ES:[SI]       ;LRR
        LES     SI,SS:[BP+30]
        MOV     DL,BYTE PTR ES:[SI]       ;LRC
ENDIF
        cmp     ah,6            ; If direction is 6(up) or 7 (down)
        je      use_BIOS        ;    then use BIOS
        cmp     ah,7         
        jne     use_toms
use_BIOS:
        int     10h
nop_exit:
        pop     bp
        ret     ret_len
use_toms:
        cmp     ah,1            ; If direction is 1 (left)
        je      ut1
        cmp     ah,2            ;  or 2 (right)
        jne     nop_exit
ut1:
        push    ds              ; continue ...
        push    es
        push    ax
        mov     ax,bios_data    ; We need to find out video mode.
        mov     ds,ax           ; Stored in BIOS_DATA
        mov     ax,0B800h       ; Get segment address of color-graphics
        cmp     crt_mode,4      ; Jump if color card text modes.
        jb      color_kill
        mov     ax,0B000h       ; Segment for mono card.
        cmp     crt_mode,7      ; Is this MONO mode ?
        je      set_seg         ; Yes - continue with mono segment set.
        jmp     scroll_return   ; We are in a graphics mode - exit.
        cli
color_kill:
IFDEF   FLASH                   ; If flash is ok then .....
        push    ax
        push    dx
        mov     dx,3DAh         ; Put status port into DX.
ck1:
        in      al,dx           ; Test for vertical retrace
        test    al,8
        jz      ck1             ; Loop until OK
        mov     al,25h          ; Value to kill color display.
        mov     dx,03D8h
        out     dx,al           ; Output to color mode port.
        pop     dx
        pop     ax
ENDIF

set_seg:
        mov     es,ax
        pop     ax
        cmp     ah,1
        je      scroll_left
        jmp     scroll_right
;.........................
scroll_left     proc    near
        cld                     ; Insure incrementing
        mov     bl,al           ; AL has number of columns to scroll.
                                ; Save it in BL
                                ; (BH has attribute).
        mov     ax,cx           ; CX contains the upper left corner.
        call    scroll_position ; Do setup for scroll.
        add     si,ax           ; From address
        mov     ah,dh           ; # of rows in block.
row_loop:       ;---------------- Move loop
        call    m_row           ; Move one row.
        add     si,bp
        add     di,bp           ; Point to next line in block,
        dec     ah              ;       decrement the number of rows
        jnz     row_loop        ;       and loop if not finished.
        jmp     scroll_return   ; Exit this procedure.
scroll_left     endp

;------------------
scroll_position proc    near
        push    bx              ; Save BX.
        mov     bx,ax
        mov     al,ah           ; Move number of rows to AL.
        mul     byte ptr crt_cols ; Multiply by number of bytes to a row.
        xor     bh,bh
        add     ax,bx           ; Add in column value.
        sal     ax,1            ; x 2 for attribute bytes.
        add     ax,crt_start    ; Offset of active page.
        pop     bx              ; Restore BX
        mov     di,ax           ; Address to move TO.
        mov     si,ax           ; Address to move FROM.
        sub     dx,cx           ; DX = #rows,#cols in block
        inc     dh              ; Increment to include row
        inc     dl              ;                      and column zero.
        xor     ch,ch
        xor     ah,ah           ; Clear out CH and AH.
        mov     bp,crt_cols     ; Get number of columns in display.
        add     bp,bp           ; Times 2 for attribute byte.
        mov     al,bl           ; Get column count.
        shl     al,1            ; Times 2 for attribute byte.
        push    es              ; Get ES into DS.
        pop     ds
        ret
scroll_position endp

;------------------
m_row   proc    near            ; Move one row
        push    ax
        push    si              ; Save registers.
        push    di
        mov     cl,dl           ; # of columns in block in CL.
        sub     cl,bl           ; # of columns to be moved.
        rep     movsw           ; move
        mov     cl,bl           ; get # of columns to clear in cl.
        mov     ah,bh           ; Get attribute into AH.
        mov     al,' '          ; and a space character into AL.
        rep     stosw           ; Store it.
        pop     di
        pop     si              ; restore registers ...
        pop     ax
        ret                     ; ... and return.
m_row   endp

;------------------
scroll_right    proc    near
        std                     ; Set direction flag to decrement.
        mov     bl,al           ; Move line count into BL.
                                ; BH has fill attribute.
        mov     ax,dx           ; Move lower right corner into AX.
        call    scroll_position ; Get regen location.
        sub     si,ax           ; Si is pointer to FROM location.
        mov     ah,dh           ; Get total # of rows.
r_loop:
        call    m_row           ; Move one row.
        sub     si,bp           ; Set pointers to point at next row.
        sub     di,bp
        dec     ah              ; Decrement rows left to move.
        jnz     r_loop          ; Loop if not finished.
scroll_right    endp

;----------------------------

scroll_return:
        cld                     ; Restore direction flag.
        sti                     ; Restore interrupt flag.
IFDEF   FLASH                   ; If flash is ok
        mov     ax,bios_data
        mov     ds,ax
        cmp     crt_mode,7      ; Is this the mono mode ?
        je      not_color       ; Yes - skip video reset
        mov     al,crt_mode_set ; Get stored mode
        mov     dx,03d8h
        out     dx,al           ; Output to color card mode port.
not_color:
ENDIF
        pop     es
        pop     ds
        pop     bp
        ret     ret_len          ; return.
SCROLL  endp
scrollend       equ     $
SCROLLS ends
end

