*.............................................................................
*
*   Program Name: RPTOSCRN.PRG      Copyright: EDON Corporation
*   Date Created: 11/27/90           Language: Clipper S'87
*   Time Created: 12:09:27             Author: Ed Phillips
*           Desc: Routines for "Report to Screen" capability
*.............................................................................


*----------------------------
*         Author: Ed Phillips
*   Date Created: 11/27/90
*   Time Created: 07:22:59
*----------------------------
FUNCTION MakScrnDBF
   PARAMETERS line_len
   PRIVATE work[1], ret_val, workfile

   IF Type('line_len') != 'N'
      line_len = 178
   ENDIF                                         && IF Type('line_len') != 'N'

   work[1] = 'RPT_LINE  C'+Str(line_len,3,0)
   workfile = Timetofile("dbf")

   CreateDBF(workfile, work)
   ret_val = Subs(workfile,1,At('.',workfile)-1)
RETURN (ret_val)


*----------------------------
*         Author: Ed Phillips
*   Date Created: 11/27/90
*   Time Created: 09:50:59
*----------------------------
FUNCTION RptToDBF
   PARAMETERS filename
   PRIVATE work

   work = filename+'.prn'
   SELECT 0
   USE (filename) EXCLUSIVE
   APPEND FROM (work) SDF
   GO TOP

RETURN(Reccount())


*----------------------------
*         Author: Ed Phillips
*   Date Created: 11/27/90
*   Time Created: 09:59:51
*----------------------------
FUNCTION CleanRPT
   PARAMETERS filename

   IF File(filename+'.dbf')
      ERASE &filename..dbf
   ENDIF                                         && IF File(filename+'.dbf')

   IF File(filename+'.prn')
      ERASE &filename..prn
   ENDIF                                         && IF File(filename+'.prn')

   IF File(filename+'.ntx')
      ERASE &filename..ntx
   ENDIF

RETURN(.T.)


*----------------------------
*         Author: Ed Phillips
*   Date Created: 11/27/90
*   Time Created: 10:02:47
*----------------------------
FUNCTION Brpt
   PARAMETERS t, l, b, r, line_len, filename, _color

   IF Type("line_len") != "N"
      line_len = 178
   ENDIF                                            && IF Type("line_len") != "N"

   IF Type("_color") = "U"
      _color = c_pop
   ENDIF                                            && IF Type("_color") = "U"

   nrows = b - t - 1
   ncols = r - l - 1
   top = t + 1
   bot = b - 1
   lt = l + 1
   rt = r - 1
   offset = 1
   num_in_buf = 0
   line_num = 0
   more_to_read = .t.
   next_char = 1
   block_num = 1
   last_line = Reccount()
   last_scrn = .f.
   vhelp = Chr(24)+Chr(25)+Chr(27)+Chr(26)+'<PgUp> <PgDn> <Home> <End> <Alt-G>, <Esc> when done'

   oldcolor = Setcolor(_color)
   Scroll(t-1,l,b,r,0)
   @ t,l TO b,r

   BEGIN SEQUENCE
      GO TOP
      line_num = Recno()
      DispView()
      DO WHILE .T.
         @ t-1,l SAY "Line: "+Str(line_num,4,0)+Space(2)+If(last_line > 0, Str(last_line,4),'')+Space(4)+"Offset: "+Str(offset,3)
         last_scrn = If(line_num+nrows > Reccount(), .t., .f.)
         keystroke = Inkey(0)

         DO CASE
            CASE keystroke = esc
               BREAK
            CASE keystroke = AltG
               Setcolor(c_field)
               @ 24,0 CLEAR
               lnum = Recno()
               @ 24,20 SAY 'GoTo Line Number:' GET lnum VALID ValRecNo(M->lnum)
               READ
               GO lnum
               line_num = lnum
               Setcolor(_color)
               DispView()
            CASE keystroke = end_key
               EndKey()
            CASE keystroke = home
               HomeKey()
            CASE keystroke = rtarrow                && pan right
               offset = offset + 9
               IF offset >= line_len - 9
                  offset = offset - 9
                  Alert()
               ELSE
                  DispView()
               ENDIF                                && IF offset >= line_len
            CASE keystroke = ltarrow                && pan left
               offset = offset - 9
               IF offset <= -8
                  offset = 1
                  Alert()
               ELSE
                  DispView()
               ENDIF                                && IF offset < 1
            CASE keystroke = dnarrow
               DownArrow()
            CASE keystroke = pgdn
               PageDown()
            CASE keystroke = uparrow
               IF line_num > 1
                  Scroll(top,lt,bot,rt,-1)
                  SKIP -1
                  line_num = Recno()
                  @ top,lt SAY Subs(Rpt_line,offset,ncols)
               ELSE
                  Alert()
               ENDIF                             && IF next_char <= num_in_buf .OR. more_to_read
            CASE keystroke = pgup
               PageUp()
         ENDCASE                                    && DO CASE
      ENDDO                                         && DO WHILE .T.
   END                                              && BEGIN SEQUENCE
   USE
RETURN(.T.)

*----------------------------
*         Author: Ed Phillips
*   Date Created: 11/27/90
*   Time Created: 10:52:28
*----------------------------
FUNCTION DispView
   PRIVATE i, oldrec, output

   output = 'SCREEN'
   oldrec = Recno()
   Scroll(top,lt,bot,rt,0)                       && clear window
   @ top,lt SAY Subs(rpt_line,offset,ncols)
   SKIP
   FOR i = 2 TO nrows
      @ Row()+1,lt SAY Subs(rpt_line,offset,ncols)
      SKIP
      IF Eof()
         last_scrn = .t.
         EXIT
      ENDIF                                      && IF Eof()
   NEXT                                          && FOR i = 1 TO nrows
   Sayhelp(vhelp)
   GO oldrec
RETURN(.T.)

*----------------------------
*         Author: Ed Phillips
*   Date Created: 11/27/90
*   Time Created: 10:56:27
*----------------------------
FUNCTION EndKey
   PRIVATE oldrec
   oldrec = Recno()
   GO BOTTOM
   SKIP -(nrows-1)
   IF oldrec != Recno()
      line_num = Recno()
      DispView()
   ELSE
      Alert()
   ENDIF                                         && IF oldrec != Recno()
RETURN(.T.)

*----------------------------
*         Author: Ed Phillips
*   Date Created: 11/27/90
*   Time Created: 10:59:55
*----------------------------
FUNCTION HomeKey
   IF line_num > 1
      GO TOP
      line_num = Recno()
      DispView()
   ELSE
      Alert()
   ENDIF                                         && IF line_num > 1
RETURN(.T.)

*----------------------------
*         Author: Ed Phillips
*   Date Created: 11/27/90
*   Time Created: 11:04:03
*----------------------------
FUNCTION DownArrow
   IF ! last_scrn
      Scroll(top,lt,bot,rt,1)
      line_num = line_num + 1
      SKIP nrows
      @ bot,lt SAY Subs(Rpt_line,offset,ncols)
      GO line_num
   ELSE
      Alert()
   ENDIF                                         && IF ! last_scrn
RETURN(.T.)

*----------------------------
*         Author: Ed Phillips
*   Date Created: 11/27/90
*   Time Created: 11:08:20
*----------------------------
FUNCTION PageDown
   IF ! last_scrn
      SKIP nrows-1
      line_num = Recno()
      DispView()
      GO line_num
   ELSE
      Alert()
   ENDIF                                         && IF ! last_scrn
RETURN(.T.)

*----------------------------
*         Author: Ed Phillips
*   Date Created: 11/27/90
*   Time Created: 11:12:09
*----------------------------
FUNCTION PageUp
   IF line_num > 1
      SKIP -(nrows - 1)
      line_num = Recno()
      DispView()
   ELSE
      Alert()
   ENDIF                                         && IF line_num > 1
RETURN(.T.)

*----------------------------
*         Author: Ed Phillips
*   Date Created: 11/27/90
*   Time Created: 11:53:39
*----------------------------
FUNCTION ValRecNo
   PARAMETERS recno
   PRIVATE ret_val

   ret_val = .t.
   IF M->recno < 1 .OR. M->recno > Reccount()
      Sayerr( 'Range is 1 to '+Ltrim(Str(Reccount(),7,0)) )
      ret_val = .f.
   ENDIF                                         && IF M->recno < 1 .OR. M->recno > Reccount()
RETURN (ret_val)
* EOF: RPTOSCRN.PRG
