***************************************************************
* Program Name: ordmenu.prg
* Author: Skip Tatum
*-----------------------------------------------------------------------------
* Created: 3/25/1991
* main =
* Called From:
* --- Data Base Files ---   ----- Index Files -----   ----- Other Files ----
*
*
*
*.............................................................................
* Revision: 1.0 Last Revised: 7/11/1989 at 13:59
* Description: Browse of a database which may be indexed, filtered, or have
*              set deleted on.
*.............................................................................
*---------------------------- ALL RIGHTS RESERVED ----------------------------
FUNCTION orderm
   PARAMETERS ary, t, l, b, r

   PRIVATE num_disp_rows, floor, ceiling, hl, width, order_on
   PRIVATE msg, cur_disp_rows, prom1, resp1, recno, eoa, boa, disp_row

   msg = Chr(24) + Chr(25) +  '   PgDn   PgUp   Home / ^Home   End / ^End;   Select - Enter '

   *------------------
   * Define keystrokes
   *------------------
   esc = 27
   enter = 13
   uparrow = 5
   dnarrow = 24
   pgup = 18
   pgdn = 3
   home = 1
   end_key = 6
   ctrl_home = 29
   ctrl_end = 23
   order_on = .F.

   boa = 1
   eoa = LEN(ary)
   ceiling = 1
   disp_row = 1

   c_lista = '+W/N'
   c_field = '+W/BG'
   c_arrow = '+W/G'

   SET CURSOR OFF
   Setcolor(c_lista)
   @ t, l TO b, r
   @ 24,40-LEN(msg)/2 SAY msg
   num_disp_rows = b - t - 1
   width = r - l - 1
   hl = 1
   floor = fill_box(ary, t, l, b, r)

   IF ceiling != eoa
      Setcolor(c_arrow)
      @ b, l SAY Chr(25)
      Setcolor(c_lista)
   ENDIF

   *-------------------------
   * Highlight active element
   *-------------------------
   Setcolor(c_field)

   @ t + disp_row, l + 1 SAY Lib_pad(ary[hl], width)

   Setcolor(c_lista)

   key = Inkey(0)
   DO WHILE key != esc .AND. key != enter

      DO CASE
         CASE key = uparrow                      && up one
            IF hl # ceiling
               hl = hl - 1
               disp_row = disp_row - 1
            ELSE
               IF ceiling != boa
                  hl = hl - 1
                  ceiling = ceiling -1
                  floor = floor - 1

                  Scroll(t + 1, l + 1, b - 1, r - 1, -1)
               ENDIF
            ENDIF

            IF order_on
               temp = ary[hl+1]
               ary[hl+1] = ary[hl]
               ary[hl] = temp
            ENDIF

            @ t + (disp_row+1), l + 1 SAY Lib_pad(ary[hl+1], width)

         CASE key = dnarrow                      && down one
            IF hl # floor
               hl = hl + 1
               disp_row = disp_row + 1
            ELSE
               IF floor != eoa
                  hl = hl + 1
                  ceiling = ceiling + 1
                  floor = floor + 1

                  Scroll(t + 1, l + 1, b - 1, r - 1, 1)
               ENDIF
            ENDIF

            IF order_on
               temp = ary[hl-1]
               ary[hl-1] = ary[hl]
               ary[hl] = temp
            ENDIF

            @ t + (disp_row-1), l + 1 SAY Lib_pad(ary[hl-1], width)

         CASE key = pgup                         && previous screen
               IF order_on
                  temp = ary[hl]
                  ADEL(ary,hl)
               ENDIF

               IF (ceiling - num_disp_rows) < 1
                  ceiling = boa
                  floor = boa + num_disp_rows - 1
                  hl = ceiling + disp_row - 1
               ELSE
                  hl = hl - num_disp_rows
                  ceiling = ceiling - num_disp_rows
                  floor = floor - num_disp_rows
               ENDIF

               IF order_on
                  AINS(ary,hl)
                  ary[hl] = temp
               ENDIF

               fill_box(ary, t, l, b, r)

         CASE key = pgdn                         && next screen
            IF order_on
               temp = ary[hl]
               ADEL(ary,hl)
            ENDIF

            IF (floor + num_disp_rows) > eoa
               ceiling = eoa - num_disp_rows + 1
               floor = eoa
               hl = ceiling + disp_row - 1
            ELSE
               hl = hl + num_disp_rows
               ceiling = ceiling + num_disp_rows
               floor = floor + num_disp_rows
            ENDIF

            IF order_on
               AINS(ary,hl)
               ary[hl] = temp
            ENDIF

            fill_box(ary, t, l, b, r)

         CASE key = home                         && top of screen
            IF order_on
               temp = ary[hl]
               ary[hl] = ary[ceiling]
               ary[ceiling] = temp
            ENDIF

            @ t + disp_row, l + 1  SAY  LIB_PAD(ary[hl],width)

            hl = ceiling
            disp_row = 1

         CASE key = end_key                      && bottom of screen
            IF order_on
               temp = ary[hl]
               ary[hl] = ary[floor]
               ary[floor] = temp
            ENDIF

            @ t + disp_row, l + 1  SAY  LIB_PAD(ary[hl],width)

            hl = floor
            disp_row = num_disp_rows

         CASE key = ctrl_home                    && go to boa
            IF order_on
               temp = ary[hl]
               ary[hl] = ary[boa]
               ary[boa] = temp
            ENDIF

            hl = boa
            ceiling = boa
            disp_row = 1

            floor = fill_box(ary, t, l, b, r)

         CASE key = ctrl_end                     && go to eoa
            IF order_on
               temp = ary[hl]
               ary[hl] = ary[eoa]
               ary[eoa] = temp
            ENDIF

            hl = eoa
            ceiling = eoa - num_disp_rows +1
            floor = eoa
            disp_row = num_disp_rows

            fill_box(ary, t, l, b, r)

          CASE key = -4                            && F5 - mode switch
             order_on = !order_on
             c_field = IIF(order_on,'+W/G','+W/BG')

      ENDCASE

      *-------------------------
      * Highlight active element
      *-------------------------
      Setcolor(c_field)
      @ t + disp_row, l + 1 SAY Lib_pad(ary[hl], width)
      Setcolor(c_lista)

      IF ceiling != boa
         Setcolor(c_arrow)
         @ t, l SAY Chr(24)
         Setcolor(c_lista)
      ELSE
         @ t, l SAY Chr(218)
      ENDIF
      IF floor != eoa
         Setcolor(c_arrow)
         @ b, l SAY Chr(25)
         Setcolor(c_lista)
      ELSE
         @ b, l SAY Chr(192)
      ENDIF

      key = Inkey(0)

   ENDDO

   SET CURSOR ON
RETURN (.T.)


FUNCTION Fill_box
   PARAMETERS expr, t, l, b, r

   PRIV num_disp, num_rows, i, width, ele

   num_rows = b - t - 1
   width = r - l - 1
   ele = ceiling

   num_disp = 0
   DO WHILE num_disp < LEN(expr) .AND. num_disp < num_rows
      @ t + num_disp + 1, l + 1 SAY Lib_pad(expr[ele], width)
      num_disp = num_disp + 1
      ele = ele + 1
   ENDDO

   FOR i = num_disp + 1 TO num_rows
      @ t + i, l + 1 SAY Space(width)
   NEXT

RETURN (num_disp)


FUNCTION Lib_pad
   PARAMETERS str, width

   IF Len(str) > width
      str = Subs(str, 1, width)
   ELSE
      str = str + Space(width - Len(str))
   ENDIF
RETURN (str + Space(width - Len(str)))
* EOF: Browze.prg
