*.............................................................................
*
*   Program Name: MEM_PROC.PRG      Copyright: EDON Corporation
*   Date Created: 02/25/91           Language: Clipper S'87
*   Time Created: 13:12:00             Author: Ed Phillips
*           Desc:
*.............................................................................

*----------------------------
*         Author: Ed Phillips
*   Date Created: 03/31/91
*   Put cursor at r,c
*----------------------------
FUNCTION Gotoxy
   PARAMETERS r,c

   @ r,c SAY ''
RETURN(.T.)


PROCEDURE DrawScreen
   PARAMETERS attribs

   IF ! Empty(fname)
      buffer1 = Memoread(fname)
      fname = Space(20)
   ENDIF

   IF attribs
      Restscreen(1,0,24,79,buffer1)
   ELSE
      lines = Mlcount(buffer1,80)
      lc = 1
      @ 1,0 CLEAR 
      FOR i = 1 TO lines
         p_line = Memoline(buffer1,80,i)
         @ lc,0 SAY p_line
         lc = lc + 1
      NEXT
   ENDIF                                         

RETURN 

*----------------------------
*         Author: Ed Phillips
*   Date Created: 02/22/91
*----------------------------
PROCEDURE MakeScreen
   PRIVATE temp[8]

   temp[1] = 'Scrn_name C0010'
   temp[2] = 'Screen    C4000'
   temp[3] = 'St        N0002'
   temp[4] = 'Sl        N0002'
   temp[5] = 'Sb        N0002'
   temp[6] = 'Sr        N0002'
   temp[7] = 'Shadow    L0001'
   temp[8] = 'Explode   N0001'

   CreateDBF('Screen',temp)
RETURN

*----------------------------
*         Author: Ed Phillips
*   Date Created: 02/25/91
*----------------------------
PROCEDURE MakeGets
   PRIVATE temp[12]

   temp[1] = 'Scrn_name C0010'
   temp[2] = 'G_row     N0002'
   temp[3] = 'G_col     N0002'
   temp[4] = 'G_pic     C0030'
   temp[5] = 'G_var     C0013'
   temp[6] = 'G_valid   C0030'
   temp[7] = 'G_color   C0020'
   temp[8] = 'G_when    C0030'
   temp[9] = 'Say_exp   C0040'
   temp[10] = 'Say_pict  C0030'
   temp[11] = 'Say_color C0020'
   temp[12] = 'Gs_flag   C0001'

   CreateDBF('ScrnGets',temp)
RETURN

*----------------------------
*         Author: Ed Phillips
*   Date Created: 12/10/91
*----------------------------
PROCEDURE MakeMenu
   PRIVATE temp[7]

   temp[1] = 'Scrn_name C0010'
   temp[2] = 'M_row     N0002'
   temp[3] = 'M_col     N0002'
   temp[4] = 'M_func    C0040'
   temp[5] = 'M_prompt  C0070'
   temp[6] = 'M_msg     C0070'
   temp[7] = 'M_cargo   C0070'

   CreateDBF('ScrnMenu',temp)
RETURN

*----------------------------
*         Author: Ed Phillips
*   Date Created: 12/12/91
*----------------------------
PROCEDURE MakeRpts
   PRIVATE temp[9]

   temp[1] = 'Scrn_name C0010'
   temp[2] = 'Rptname   C0008'
   temp[3] = 'Phdr      C0010'
   temp[4] = 'Detproc   C0010'
   temp[5] = 'Maincond  C0070'
   temp[6] = 'Detcond   C0070'
   temp[7] = 'Ftrproc   C0010'
   temp[8] = 'Rpt_wid   N0003'
   temp[9] = 'Lm        N0002'

   CreateDBF('ScrnRpts',temp)
RETURN

*----------------------------
*         Author: Ed Phillips
*   Date Created: 02/22/91
*   Strip attribute bytes from a Screen Memvar
*----------------------------
FUNCTION SaveWinTxt
   PARAMETERS t,l,b,r
   PRIVATE temp, ret_val, charcnt, i, j

   temp = Savescreen(t,l,b,r)
   charcnt = (r - l + 1) * (b - t + 1)
   ret_val = ' '
   j = 1
   FOR i = 1 TO charcnt
      ret_val = ret_val + Subs(temp,j,1)
      j = j + 2
   NEXT                                          

RETURN( Subs(ret_val,2) )

*----------------------------
*         Author: Ed Phillips
*   Date Created: 02/22/91
*   Display a Screen Memvar
*----------------------------
FUNCTION SayWinTxt
   PARAMETERS t,l,b,r,string
   PRIVATE width,num_ln, i, j

   width = r - l + 1
   num_ln = Len(string)/width
   t = t - 1
   j = 1
   FOR i = 1 TO num_ln
       @ t+i,l SAY Subs(string,j,width)
       j = j + width
   NEXT                                          

RETURN(.T.)

*----------------------------
*         Author: Ed Phillips
*   Date Created: 02/22/91
*----------------------------
PROCEDURE SwapChk
   PRIVATE temp

   IF left > right
      temp = right
      right = left
      left = temp
   ENDIF                                         
   IF top > bottom
      temp = bottom
      bottom = top
      top = temp
   ENDIF                                         
RETURN

*----------------------------
*         Author: Ed Phillips
*   Date Created: 02/25/91
*----------------------------
FUNCTION RestGets
   PRIVATE oldcolor, r, c

   IF showgm
      oldcolor = Setcolor()
      SELECT ScrnGets
      SEEK Scr_file->Scrn_name
   
      DO WHILE Scrn_name = Scr_file->Scrn_name .AND. ! Eof()
         @ G_row, G_col SAY ''
         r = G_row
         c = G_col
         DO ScrnAttrib
         @ G_row, G_col SAY gchar
         SKIP
      ENDDO                                         
      SELECT Scr_file
      Setcolor(oldcolor)
   ENDIF

RETURN(.T.)

*----------------------------
*         Author: Ed Phillips
*   Date Created: 12/10/91
*----------------------------
FUNCTION RestMenu
   PRIVATE oldcolor, r, c

   IF showgm
      oldcolor = Setcolor()
      SELECT ScrnMenu
      SEEK Scr_file->Scrn_name
   
      DO WHILE Scrn_name = Scr_file->Scrn_name .AND. ! Eof()
         @ M_row, M_col SAY ''
         r = M_row
         c = M_col
         DO ScrnAttrib
         @ M_row, M_col SAY mchar
         SKIP
      ENDDO                                         
      SELECT Scr_file
      Setcolor(oldcolor)
   ENDIF
RETURN(.T.)

*----------------------------
*         Author: Ed Phillips
*   Date Created: 02/28/91
*   Is the current screen a sub-screen?
*----------------------------
FUNCTION IsSub
   IF (Sb - St = 23) .AND. (Sr - Sl = 79)
      RETURN .f.
   ELSE
      RETURN .t.
   ENDIF
*----------------------------
* EOF: MEM_PROC.PRG
