*.............................................................................
*
*   Program Name: MEMSCRN.PRG       Copyright: EDON Corporation
*   Date Created: 02/22/91           Language: Clipper S'87 S'87
*   Time Created: 10:57:25             Author: Ed Phillips
*    Description: Read TXT file that contains screen, set screen colors, 
*                 save screen to memvar, save screen to MEM file
*.............................................................................

PARAMETERS par1

SET CURSOR ON

* Requires a DBF with the following structure:
*     Scrn_num    N     3
*     Scrn_name   C    10
*     Screen      C  4000

c_statln1 = 'N/W,W+/G'
c_default = 'W/N'

DO Mempubs
palette = .f.
gchar = Chr(228)    && "get" character
mchar = Chr(234)    && "menu" character
struvar = Space(30)                              && DBF file spec

IF ! File('Screen.dbf')
   DO MakeScreen
ENDIF                                            && IF ! File('Screen.dbf') [line: 25]

IF ! File('ScrnGets.dbf')
   DO MakeGets
ENDIF                                            && IF ! File('ScrnGets.dbf') [line: 29]

IF ! File('ScrnMenu.dbf')
   MakeMenu()                                    && see MEM_PROC.PRG
ENDIF

IF ! File('ScrnRpts.dbf')
   MakeRpts()
ENDIF

IF File('Scrnpal.mem')
   RESTORE FROM Scrnpal ADDITIVE                 && restore color palette
ENDIF                                            && IF File('Scrnpal.mem') [line: 33]

USE Screen ALIAS Scr_file

Automem('PUB')
IF ! File('Screen.ntx')
   INDEX ON Scrn_name TO Screen
ELSE                                             && IF ! File('Screen.ntx') [line: 40]
   SET INDEX TO Screen
ENDIF                                            && IF ! File('Screen.ntx') [line: 40]

SELECT 0
USE ScrnGets
IF ! File('ScrnGets.ntx') .OR. ! File('Sgets.ntx')
   INDEX ON Scrn_name TO Sgets
   INDEX ON Scrn_name+Str(G_row,2)+Str(G_col,2) TO ScrnGets
ELSE                                             && IF ! File('ScrnGets.ntx') .OR. ! File('Sgets.ntx') [line: 48]
   SET INDEX TO Sgets,ScrnGets
ENDIF                                            && IF ! File('ScrnGets.ntx') .OR. ! File('Sgets.ntx') [line: 48]
Automem('PUB')
Automem('INIT')

SELECT 0
USE ScrnMenu
Automem('PUB')

IF ! File('ScrnMenu.ntx')
   INDEX ON Scrn_name+Str(M_row,2)+Str(M_col,2) TO ScrnMenu
ELSE
   SET INDEX TO ScrnMenu
ENDIF

SELECT 0
USE ScrnRpts
Automem('PUB')

IF ! File('ScrnRpts.ntx')
   INDEX ON Scrn_name TO ScrnRpts
ELSE
   SET INDEX TO ScrnRpts
ENDIF

SELECT Scr_file
IF Type('par1') != 'U'
   SEEK Upper(par1)
   IF ! Found() .AND. Lastrec() > 0
      GO TOP
   ENDIF                                         && IF ! Found() .AND. Lastrec() > 0 [line: 59]
ENDIF                                            && IF Type('par1') != 'U' [line: 57]


memfile = Scrn_name
memscrn = Screen
undoscrn = Screen
buffer1 = Screen


fname = Space(20)
memvar = Space(10)
single = .t.                                     && default to single line box
showgm = .f.                   && default to hide gets/menu char

Setcolor(c_statln1)
@ 0,0 CLEAR TO 0,79

Setcolor(c_default)
Scroll(1,0,24,79,0)
Restscreen(St,Sl,Sb,Sr,memscrn)
RestGets()
RestMenu()

@ 1,0 SAY ''
r = Row()
c = Col()
st = 1                                           && save screen top
sl = 0                                           && save screen left
sb = 24                                          && save screen bottom
sr = 79                                          && save screen right

sct = 1                                          && scrap coords
scl = 0
scb = 24
scr = 79
scrap = ' '

memrow = 6
memcol = 7
changed = .f.

SetCancel(.f.)                                   && disable Alt-C
is_scrap = .f.                                   && is scrap active?

DO WHILE .T.
   choice = ' '
   memfile = Scrn_name

   @ r,c SAY ''

   DO StatLine
   key = Inkey(0)
   IF key < 32
      DO CtrlKey
      LOOP
   ELSEIF key >= 271                             && DO CtrlKey [line: 112]
      buffer1 = Savescreen(1,0,24,79)
      DO AltKey
      undoscrn = buffer1
      LOOP
   ELSE                                          && DO CtrlKey [line: 112]
      buffer1 = Savescreen(1,0,24,79)
      choice = Chr(key)
   ENDIF                                         && DO CtrlKey [line: 112]

   DO CASE
      CASE choice $ 'Aa'                         && colors
         DO Memcolor

      CASE choice $ 'Bb'
         DO MakeBOX
         undoscrn = buffer1

      CASE choice $ 'Cc'                         && copy block
         DO CopyBlock
         undoscrn = buffer1

      CASE choice $ 'Dd'                         && delete
         IF Deleted()
            RECALL
         ELSE                                    && IF Deleted() [line: 137]
            del = ' '
            oldcolor = Setcolor(c_field)
            @ 0,0 SAY 'DELETE '+scrn_name+'?' GET del PICT '!'
            READ
            IF del = 'Y'
               DELETE
            ENDIF                                && IF del = 'Y' [line: 144]
            Setcolor(oldcolor)
         ENDIF                                   && IF Deleted() [line: 137]

      CASE choice $ 'Ee'                         && erase block
         DO EraseBlock
         undoscrn = buffer1

      CASE choice $ 'Ff'                         && find (browze) screen
         DO Memfind

      CASE choice $ 'Gg'                         && GET processing
         IF Empty(Scrn_name)
            memfile = Scrn_name
            oldcolor = Setcolor(c_field)
            @ 0,10 SAY 'ENTER Screen NAME: ' GET memfile PICT '@K!'
            READ
         ENDIF                                   && IF Empty(Scrn_name) [line: 158]
         DO MemGets

      CASE choice $ 'Hh'                         && horizontal line
         DO Make_Hline
         undoscrn = buffer1

      CASE choice $ 'Ii'                         && import from file
         DO Memimp

      CASE choice $ 'Ll'                         && load

*--------------
* List function
* Commented out
*--------------
*         recno = Recno()
*         GO TOP
*         dev = Space(1)
*         @ 24,0 CLEAR
*         @ 24,10 SAY '<P>rinter, <S>creen, <F>ile' GET dev PICT '!'
*         READ
*         IF ! Empty(dev)
*            DO CASE
*               CASE dev = 'P'
*                  LIST Scrn_name,St,Sl,Sb,Sr TO PRINT
*                  EJECT
*               CASE dev = 'S'
*                  CLEAR
*                  speed = .2
*                  LIST Interupt(Scrn_name),St,Sl,Sb,Sr
*                  Inkey(0)
*               CASE dev = 'F'
*                  fname = Space(20)
*                  @ 24,0 CLEAR
*                  @ 24,10 SAY 'ENTER FILE NAME:' GET fname
*                  READ
*                  SET PRINTER TO (fname)
*                  LIST Scrn_name,St,Sl,Sb,Sr TO PRINT
*                  SET PRINTER TO
*                  fname = Space(20)
*            ENDCASE
*         ENDIF
*         GO recno
*         Restscreen(1,0,24,79,buffer1)

      CASE choice $ 'Mm'                         && move block
         DO MoveBlock
         undoscrn = buffer1

      CASE choice $ 'Nn'                         && Pick a NONASCII char
         savrow = r
         savcol = c
         savchr = Nonascii(memrow,memcol)
         IF ! Empty(savchr)
            @ savrow,savcol SAY savchr
         ENDIF                                   && IF ! Empty(savchr) [line: 217]
         undoscrn = buffer1

      CASE choice $ 'Pp'                         && paint block
         DO Paint
         undoscrn = buffer1

      CASE choice $ 'Rr'                         && repeat char a number of times
         oldcolor = Setcolor(c_field)
         rchar = ' '
         rcount = 0
         @ 0,10 SAY 'Repeat Char: ' GET rchar
         @ 0,25 SAY 'Repeat Count: ' GET rcount PICT '99'
         READ
         IF ! Empty(rcount)
            Setcolor(oldcolor)
            @ r,c SAY Replicate(rchar,rcount)
            undoscrn = buffer1
         ENDIF                                   && IF ! Empty(rcount) [line: 236]
         Setcolor(oldcolor)

      CASE choice $ 'Ss'                         && save
         DO SaveScrn WITH 1,0,24,79,buffer1
         changed = .f.

      CASE choice $ 'Tt'                         && text mode
         DO MemText
         undoscrn = buffer1

      CASE choice $ 'Uu'                         && Undo
         Restscreen(1,0,24,79,undoscrn)

      CASE choice $ 'Vv'                         && Vertical line
         DO Make_Vline
         undoscrn = buffer1

      CASE choice $ 'Ww'                         && walk about mode
         DO WalkAbout
         undoscrn = buffer1

      CASE choice $ 'Xx'                         && EXIT POINT
         IF changed
            DO AskToSave
         ENDIF                                   && IF changed [line: 263]

         EXIT

      CASE choice $ 'Zz'
         IF changed
            DO AskToSave
         ENDIF                                   && IF changed [line: 270]

         GO BOTTOM
         SKIP
         Scroll(1,0,24,79,0)
         memscrn = Savescreen(1,0,24,79)
         st = 1
         sl = 0
         sb = 24
         sr = 79
         Restscreen(M->st,M->sl,M->sb,M->sr,memscrn)

      OTHERWISE
         Alert()
   ENDCASE                                       &&  [line: 283]
ENDDO                                            &&  [line: 273]
SET DELETED OFF

SELECT Scr_file
LOCATE FOR Deleted()
IF Found()
   DO WHILE ! Eof()
      SELECT ScrnGets
      SEEK Scr_file->Scrn_name
      IF Found()
         DO WHILE Scrn_name == Scr_file->Scrn_name .AND. ! Eof()
            DELETE
            SKIP
         ENDDO                                   && DO WHILE Scrn_name == Scr_file->Scrn_name .AND. ! Eof() [line: 297]
      ENDIF                                      && IF Found() [line: 296]
      SELECT Scr_file
      CONTINUE
   ENDDO                                         && DO WHILE ! Eof() [line: 293]
   PACK

   DO WHILE ! Eof()
      SELECT ScrnMenu
      SEEK Scr_file->Scrn_name
      IF Found()
         DO WHILE Scrn_name == Scr_file->Scrn_name .AND. ! Eof()
            DELETE
            SKIP
         ENDDO                                   && DO WHILE Scrn_name == Scr_file->Scrn_name .AND. ! Eof() [line: 297]
      ENDIF                                      && IF Found() [line: 296]
      SELECT Scr_file
      CONTINUE
   ENDDO                                         && DO WHILE ! Eof() [line: 293]
   PACK
ENDIF                                            && IF Found() [line: 292]

SELECT ScrnGets
LOCATE FOR Deleted()
IF Found()
   DELETE ALL FOR Empty(Scrn_name)
   PACK
ENDIF                                            && IF Found() [line: 310]

SELECT ScrnMenu
LOCATE FOR Deleted()
IF Found()
   DELETE ALL FOR Empty(Scrn_name)
   PACK
ENDIF

CLOSE DATA   
RETURN

*----------------------------
*         Author: Ed Phillips
*   Date Created: 02/22/91
*   Time Created: 07:44:36
*----------------------------
PROCEDURE StatLine
   PARAMETERS cMsg
   PRIVATE oldcolor, r, c
   oldcolor = Setcolor(c_statln1)

   r = Row()
   c = Col()
*          1         2         3         4         5         6         7
*01234567890123456789012345678901234567890123456789012345678901234567890123456789
*                              ccccccccccc S  ccccccc   -    nn,nn
   @ 0,0 CLEAR TO 0,79

   IF Type('cMsg') = 'C'
      @ 0,0 SAY cMsg
   ENDIF

   IF single
      @ 0,55 SAY Chr(218)
   ELSE                                          && IF single [line: 332]
      @ 0,55 SAY Chr(201)
   ENDIF                                         && IF single [line: 332]
   @ 0,60 SAY Strzero(r,2)+','+Strzero(c,2)
   @ 0,30 SAY ' '+Scrn_name
   IF Deleted()
      @ 0,30 SAY '*'
   ENDIF                                         && IF Deleted() [line: 339]
   IF IsSub()
      @ 0,42 SAY 'S'
   ELSE                                          && IF IsSub() [line: 342]
      @ 0,42 SAY ' '
   ENDIF                                         && IF IsSub() [line: 342]

   SELECT Scrngets
   SEEK Scr_file->Scrn_name
   IF Found()
      @ 0,75 SAY 'G'
   ENDIF

   SELECT ScrnMenu
   SEEK Scr_file->Scrn_name
   IF Found()
      @ 0,76 SAY 'M'
   ENDIF

   SELECT ScrnRpts
   SEEK Scr_file->Scrn_name
   IF Found()
      @ 0,77 SAY 'R'
   ENDIF

   SELECT Scr_file
   Setcolor(oldcolor)
   @ 0,45 SAY ' Color '
   @ r,c SAY ''
RETURN

*----------------------------
*         Author: Ed Phillips
*   Date Created: 02/24/91
*----------------------------
PROCEDURE SaveScrn
   PARAMETERS sst,ssl,ssb,ssr,buffname
   PRIVATE oldcolor, oldname, nRec

   SELECT Scr_file
   oldcolor = Setcolor(c_field)
   @ 0,0 CLEAR TO 0,39
   IF Empty(Scrn_name)
      memfile = Scrn_name
   ENDIF                                         && IF Empty(Scrn_name) [line: 364]
   oldname = memfile
   nRec = Recno()

   @ 0,0 SAY 'ENTER Screen NAME:' GET memfile PICT '@K!'
   READ

   IF ! Empty(memfile) .AND. Lastkey() != esc
      mde = 'EDIT'
      explode = Explode
      ok = .t.

      SEEK memfile
      IF ! Found()
         mde = 'ADD'
         explode = 9
         APPEND BLANK
      ELSE                                       && IF ! Found() [line: 378]
         @ 0,0 CLEAR TO 0,39
         Alert()
         @ 0,0 SAY 'SCREEN already exists, Replace it? (Y/N)' GET ok PICT 'Y'
         READ
      ENDIF                                      && IF ! Found() [line: 378]
      IF ok
         buffname = Strtran(buffname,gchar,' ')
         REPL Scrn_name WITH memfile, Screen WITH buffname, St WITH sst,;
         Sl WITH ssl, Sb WITH ssb, Sr WITH ssr, Explode WITH M->explode

         *----------------------------
         * Update GETS if name changed
         *----------------------------
         IF oldname != memfile .AND. !Empty(oldname)
            SELECT Scrngets
            SEEK oldname
            IF Found()
               IF mde = 'EDIT'
                  SET ORDER TO 0
                  GO TOP
                  REPLACE ALL Scrn_name WITH memfile FOR Scrn_name == oldname
                  SET ORDER TO 1
               ELSE                              && IF mde = 'EDIT' [line: 399]
                  DO WHILE Scrn_name == oldname .AND. ! Eof()
                     re = Recno()
                     Automem('STUP')
                     scrn_name = memfile
                     APPEND BLANK
                     Automem('REPL')
                     GO re
                     SKIP
                  ENDDO                          && DO WHILE Scrn_name == oldname .AND. ! Eof() [line: 405]
               ENDIF                             && IF mde = 'EDIT' [line: 399]
            ENDIF                                && IF Found() [line: 398]
            SELECT Scr_file
         ENDIF                                   && IF oldname != memfile .AND. !Empty(oldname) [line: 395]
      ELSE
         memfile = oldname
         GO nRec
      ENDIF                                      &&  [line: 391]
   ENDIF
   Setcolor(oldcolor)
RETURN

*----------------------------
*         Author: Ed Phillips
*   Date Created: 02/28/91
*   Time Created: 10:01:53
*----------------------------
PROCEDURE AskToSave
   PRIVATE oldcolor, keep

   oldcolor = Setcolor(c_field)
   keep = .t.
   Alert()
   @ 0,0 CLEAR TO 0,39
   @ 0,0 SAY 'Screen not saved.  Save?' GET keep PICT 'Y'
   READ
   IF keep
      DO SaveScrn WITH M->st,M->sl,M->sb,M->sr,buffer1
   ENDIF                                         && IF keep [line: 437]
   changed = .f.
   SetColor(oldcolor)
RETURN
* EOF: MEMSCRN.PRG
