*----------------------------------------------------------------------------
*
*   Program Name: MEMGORD.PRG       Copyright: EDON Corporation                                         
*   Date Created: 03/12/91           Language: Clipper S'87                                             
*   Time Created: 16:22:32             Author: Ed Phillips                               
*    Description: Memscrn Reorder GETS function
*----------------------------------------------------------------------------

PRIVATE grec, oldcolor, oldscrn

oldscrn = Savescreen(1,0,24,79)
oldcolor = Setcolor()
SELECT Scrngets
SEEK Scr_file->Scrn_name
IF ! Found()
   Alert()
ELSE
   gcount = 0
   grec = Recno()
   DO WHILE Scrn_name == Scr_file->Scrn_name .AND. ! Eof()
      gcount = gcount + 1
      SKIP
   ENDDO                                         && DO WHILE Scrn_name == Scr_file->Scrn_name .AND. ! Eof()
   GO grec
   IF gcount <= 1
      Alert()
   ELSE

      *-------------------
      * Build the Get_List
      *-------------------
      PRIVATE get_list[gcount]
      SET ORDER TO 0
      LOCATE FOR Scrn_name == Scr_file->Scrn_name

*----------------------------------------------------------------------------------
*          1         2         3         4         5         6         7         8         9         0         1         2         3         4         5         6         7         8         9         0         1         2         3
* 12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789
* g_var         r  c  g_pic                          g_valid                        g_color              g_when                         say_exp                                  say_pict                       say_color            gs_flag
* ccccccccccccc nn nn cccccccccccccccccccccccccccccc cccccccccccccccccccccccccccccc cccccccccccccccccccc cccccccccccccccccccccccccccccc cccccccccccccccccccccccccccccccccccccccc cccccccccccccccccccccccccccccc cccccccccccccccccccc c
*------------------------------------------------------------------------------------

      FOR i = 1 TO gcount
         get_list[i] = G_var+' '+Str(g_row,2,0)+' '+Str(g_col,2,0)+' '+g_pic+' '+g_valid+' '+g_color+' '+g_when+' '+say_exp+' '+say_pict+' '+say_color+' '+gs_flag
         CONTINUE
      NEXT                                       && FOR i = 1 TO gcount

      mtitle = '    GET List    '
      Setcolor(c_error)
      @ 02,32 SAY mtitle
      Setcolor(c_pop)
      Orderm(get_list,3,32,22,47,13)

      LOCATE FOR Scrn_name == Scr_file->Scrn_name

      FOR i = 1 TO gcount
         g_var = Subs(get_list[i],1,13)
         g_row = Val(Subs(get_list[i],15,2))
         g_col = Val(Subs(get_list[i],18,2))
         g_pic = Subs(get_list[i],21,30)
         g_valid = Subs(get_list[i],52,30)
         g_color = Subs(get_list[i],83,20)
         g_when = Subs(get_list[i],104,30)
         say_exp = Subs(get_list[i],135,40)
         say_pict = Subs(get_list[i],176,30)
         say_color = Subs(get_list[i],207,20)
         gs_flag = Subs(get_list[i],228,1)

         REPL G_var WITH M->g_var, G_row WITH M->g_row, G_col WITH M->g_col,;
            G_pic WITH M->g_pic, G_valid WITH M->g_valid, G_color WITH M->g_color
         REPL G_when WITH M->g_when, Say_exp WITH M->say_exp, Say_pict WITH M->say_pict,;
            Say_color WITH M->say_color, Gs_flag WITH M->gs_flag

         CONTINUE
      NEXT                                       && FOR i = 1 TO gcount
      SET ORDER TO 1
   ENDIF                                         && IF gcount <= 1
ENDIF                                            && IF ! Found()
SELECT Scr_file
Setcolor(oldcolor)
Restscreen(1,0,24,79,oldscrn)
RestGets()
Gotoxy(r,c)
RETURN

* Author: Skip Tatum
* Modified by Ed Phillips for use with Memscrn system
FUNCTION orderm
   PARAMETERS ary, t, l, b, r, width

   PRIVATE num_disp_rows, floor, ceiling, hl, width, order_on, c_work
   PRIVATE msg, cur_disp_rows, prom1, resp1, recno, eoa, boa, disp_row

   msg = Chr(24) + Chr(25) +  '   PgDn   PgUp   Home / ^Home   End / ^End;   Select - <F5>'

   *------------------
   * Define keystrokes
   *------------------
   order_on = .F.

   boa = 1
   eoa = LEN(ary)
   ceiling = 1
   disp_row = 1

   c_arrow = '+W/G'

   SET CURSOR OFF
   Setcolor(c_lista)
   Scroll(t,l,b,r,0)
   @ t, l TO b, r
   Sayhelp(msg)
   num_disp_rows = b - t - 1
*   width = 13                                    && r - l - 1
   hl = 1
   floor = afill_box(ary, t, l, b, r)

   IF eoa > num_disp_rows
      Setcolor(c_arrow)
      @ b, l SAY Chr(25)
      Setcolor(c_lista)
   ENDIF

   *-------------------------
   * Highlight active element
   *-------------------------
   c_work = c_field
   Setcolor(c_work)

   @ t + disp_row, l + 1 SAY Lib_pad(ary[hl], width)

   Setcolor(c_lista)

   key = Inkey(0)
   DO WHILE key != esc .AND. key != enter

      DO CASE
         CASE key = uparrow                      && up one
            IF hl # ceiling
               hl = hl - 1
               disp_row = disp_row - 1
            ELSE
               IF ceiling != boa
                  hl = hl - 1
                  ceiling = ceiling -1
                  floor = floor - 1

                  Scroll(t + 1, l + 1, b - 1, r - 1, -1)
               ENDIF
            ENDIF

            IF order_on
               temp = ary[hl+1]
               ary[hl+1] = ary[hl]
               ary[hl] = temp
            ENDIF

            @ t + (disp_row+1), l + 1 SAY Lib_pad(ary[hl+1], width)

         CASE key = dnarrow                      && down one
            IF hl # floor
               hl = hl + 1
               disp_row = disp_row + 1
            ELSE
               IF floor != eoa
                  hl = hl + 1
                  ceiling = ceiling + 1
                  floor = floor + 1

                  Scroll(t + 1, l + 1, b - 1, r - 1, 1)
               ENDIF
            ENDIF

            IF order_on
               temp = ary[hl-1]
               ary[hl-1] = ary[hl]
               ary[hl] = temp
            ENDIF

            @ t + (disp_row-1), l + 1 SAY Lib_pad(ary[hl-1], width)

         CASE key = pgup                         && previous screen
            IF order_on
               temp = ary[hl]
               ADEL(ary,hl)
            ENDIF

            IF (ceiling - num_disp_rows) < 1
               ceiling = boa
               floor = Min(eoa,boa + num_disp_rows - 1)
               hl = ceiling + disp_row - 1
            ELSE
               hl = Max(1,hl - num_disp_rows)
               ceiling = Max(1,ceiling - num_disp_rows)
               floor = If(floor - num_disp_rows < 1, eoa, floor-num_disp_rows)
            ENDIF

            IF order_on
               AINS(ary,hl)
               ary[hl] = temp
            ENDIF

            afill_box(ary, t, l, b, r)

         CASE key = pgdn                         && next screen
            IF order_on
               temp = ary[hl]
               ADEL(ary,hl)
            ENDIF

            IF (floor + num_disp_rows) > eoa
               ceiling = Max(1,eoa - num_disp_rows + 1)
               floor = eoa
               hl = ceiling + disp_row - 1
            ELSE
               hl = hl + num_disp_rows
               ceiling = ceiling + num_disp_rows
               floor = floor + num_disp_rows
            ENDIF

            IF order_on
               AINS(ary,hl)
               ary[hl] = temp
            ENDIF

            afill_box(ary, t, l, b, r)

         CASE key = home                         && top of screen
            IF order_on
               temp = ary[hl]
               ary[hl] = ary[ceiling]
               ary[ceiling] = temp
            ENDIF

            @ t + disp_row, l + 1  SAY  LIB_PAD(ary[hl],width)

            hl = ceiling
            disp_row = 1

         CASE key = end_key                      && bottom of screen
            IF order_on
               temp = ary[hl]
               ary[hl] = ary[floor]
               ary[floor] = temp
            ENDIF

            @ t + disp_row, l + 1  SAY  LIB_PAD(ary[hl],width)

            hl = floor
            disp_row = Min(eoa,num_disp_rows)

         CASE key = ctrl_home                    && go to boa
            IF order_on
               temp = ary[hl]
               ary[hl] = ary[boa]
               ary[boa] = temp
            ENDIF

            hl = boa
            ceiling = boa
            disp_row = 1

            floor = afill_box(ary, t, l, b, r)

         CASE key = ctrl_end                     && go to eoa
            IF order_on
               temp = ary[hl]
               ary[hl] = ary[eoa]
               ary[eoa] = temp
            ENDIF

            hl = eoa
            ceiling = eoa - num_disp_rows +1
            floor = eoa
            disp_row = num_disp_rows

            afill_box(ary, t, l, b, r)

         CASE key = -4                           && F5 - mode switch
            order_on = !order_on
            c_work = IIF(order_on,c_pop,c_field)

      ENDCASE

      *-------------------------
      * Highlight active element
      *-------------------------
      Setcolor(c_work)
      @ t + disp_row, l + 1 SAY Lib_pad(ary[hl], width)
      Setcolor(c_lista)

      IF ceiling != boa
         Setcolor(c_arrow)
         @ t, l SAY Chr(24)
         Setcolor(c_lista)
      ELSE
         @ t, l SAY Chr(218)
      ENDIF
      IF eoa > floor
         Setcolor(c_arrow)
         @ b, l SAY Chr(25)
         Setcolor(c_lista)
      ELSE
         @ b, l SAY Chr(192)
      ENDIF

      key = Inkey(0)

   ENDDO

   SET CURSOR ON
RETURN (.T.)


FUNCTION afill_box
   PARAMETERS expr, t, l, b, r

   PRIV num_disp, num_rows, i, ele

   num_rows = b - t - 1
   ele = ceiling

   num_disp = 0
   DO WHILE num_disp < LEN(expr) .AND. num_disp < num_rows
      @ t + num_disp + 1, l + 1 SAY Lib_pad(expr[ele], width)
      num_disp = num_disp + 1
      ele = ele + 1
   ENDDO

   FOR i = num_disp + 1 TO num_rows
      @ t + i, l + 1 SAY Space(width)
   NEXT

RETURN (num_disp)


FUNCTION Lib_pad
   PARAMETERS str, width

   IF Len(str) > width
      str = Subs(str, 1, width)
   ELSE
      str = str + Space(width - Len(str))
   ENDIF
RETURN (str + Space(width - Len(str)))

* EOF: Memgord.prg
