* Program : Help.prg
* Author  : EDON CORPORATION
* Date    : 9/9/88
* Notes   : Routine to display help text
*
*   Syntax:         set key 28 to HELP
*
*
*   Databases Used:
*        Name      Contents
*        ----      --------
*        HELP      Un-compiled help displays

PARA proc, line, memvar
PRIV save_sel, save_rec, help_sc, t, oldcolor, r, c, nlc, nrc
PRIV ntr, nbr, n_text, corner, edit_sc, mvex

PUBLIC disp_name, box_st

IF UPPER(proc) = "HELP"
   RETURN
ENDIF
SAVE SCREEN TO help_sc
r = ROW()
c = COL()
oldcolor = SETCOLOR(h_color)
IF UPPER(proc) = "MEMOEDIT"
   @  1,0 SAY "ͻ"
   @  2,0 SAY "                This is a free format text entry data field.                  "
   @  3,0 SAY "                The following editing commands are available.                 "
   @  4,0 SAY "͹"
   @  5,0 SAY "     KEY             PRIMARY FUNCTION               CONTROL FUNCTION        "
   @  6,0 SAY "Ķ"
   @  7,0 SAY "   Up Arrow    Move up one line                            -                "
   @  8,0 SAY "  Down Arrow   Move down one line                          -                "
   @  9,0 SAY "  Left Arrow   Move left one character        Move left one word            "
   @ 10,0 SAY " Right Arrow   Move right one character       Move right one word           "
   @ 11,0 SAY "    HOME       Beginning of current line      Beginning of field            "
   @ 12,0 SAY "     END       End of current line            End of field                  "
   @ 13,0 SAY "    PgUp       Next edit window up            Beginning of current window   "
   @ 14,0 SAY "    PgDn       Next edit window down          End of current window         "
   @ 15,0 SAY "     ESC       Abort edit without changes                  -                "
   @ 16,0 SAY "     ^B                      -                Reformat field in window      "
   @ 17,0 SAY "     ^T                      -                Delete word right             "
   @ 18,0 SAY "     ^Y                      -                Delete current line           "
   @ 19,0 SAY "     ^W                      -                Finish edit and save changes  "
   @ 20,0 SAY "ͼ"
   @ 21,0 SAY "Press any key to continue...                                                    "
   t = INKEY(0)
   SETCOLOR(oldcolor)
   @ r,c SAY ""
   RESTORE SCREEN FROM help_sc
   RELE save_sel, save_rec, help_sc, t, oldcolor, r, c
   RELE ntr, nbr, nlc, nrc, n_text, corner, edit_sc, mvex
   RETURN
ENDIF
save_sel = ALIAS()
save_rec = RECNO()
DO N_select WITH "HELP"
IF ALIAS() != "HELP"
   SELE 0
   IF NET_USE("HELP",.F.,5)
      SET INDEX TO Help
   ENDIF

ENDIF
SEEK TRIM(UPPER(disp_name))+TRIM(UPPER(proc))+TRIM(UPPER(memvar))
IF ! FOUND()
   IF FIL_LOCK(3)
      APPE BLAN
      REPL Menu_nam WITH UPPER(disp_name)
      REPL Proc_nam WITH UPPER(proc)
      REPL Vari_nam WITH UPPER(memvar)
      IF r >=17
         REPL Htr WITH r-6
         REPL Hbr WITH r-2
      ELSE
         REPL Htr WITH r+1
         REPL Hbr WITH r+5
      ENDIF
      nlc = c - 9
      nrc = c + 9
      DO WHILE nlc < 1
         nlc = nlc + 1
         nrc = nrc + 1
      ENDDO
      DO WHILE nrc > 78
         nlc = nlc - 1
         nrc = nrc - 1
      ENDDO
      REPL Hlc WITH nlc
      REPL Hrc WITH nrc
      REPL Help_txt WITH " No Additional  "+chr(13)+chr(10)+;
                       " Help Available "+chr(13)+chr(10)
      UNLOCK
   ELSE
      SETCOLOR(oldcolor)
      IF ! EMPTY(save_sel)
         DO N_select WITH save_sel
         GOTO save_rec
      ENDIF
      @ r,c SAY ""
      RESTORE SCREEN FROM help_sc
      RELE save_sel, save_rec, help_sc, t, oldcolor, r, c
      RELE ntr, nbr, nlc, nrc, n_text, corner, edit_sc, mvex
      RETURN
   ENDIF
ENDIF
@ Htr, Hlc CLEAR to Hbr+1, Hrc
@ Htr, Hlc, Hbr, Hrc BOX box_st
memoedit(HELP_TXT,HTR+1,HLC+1,HBR-1,HRC-1,.F.,"helpnob")
@ HBR+1, HLC+1 SAY "Press any key"+space(HRC-HLC-13)
t = INKEY(0)
IF t = -34   && <ALT><F5>
   IF REC_LOCK(5)
      ntr = HTR
      nbr = HBR
      nlc = HLC
      nrc = HRC
      n_text = HELP_TXT
      mvex = .F.
      RESTORE SCREEN FROM help_sc
      @ 23,0 CLEAR TO 24,79
      msg = "Edit(E), Quit(Q), Abort(ESC)"
      @ 23,CENTR(msg,0) SAY msg
      msg = "Select Corner(Home,End,PgUp,PgDn), Position(Arrows), Toggle Move/Expand(M)"
      @ 24,CENTR(msg,0) SAY msg
      SAVE SCREEN to edit_sc
      corner = 1 && (1) Top Left (2) Top Right (3) Bottom Left (4) Bottom Right
      DO WHILE .T.
         RESTORE SCREEN FROM edit_sc
         @ ntr, nlc CLEAR to nbr+1, nrc
         @ ntr, nlc to nbr, nrc double
         memoedit(n_text,ntr+1,nlc+1,nbr-1,nrc-1,.F.,"helpnob")
         @ nbr+1, nlc+1 SAY "Press any key"+space(nrc-nlc-14)
         DO CASE
            CASE corner = 1
               @ ntr,nlc SAY "*"
            CASE corner = 2
               @ ntr,nrc SAY "*"
            CASE corner = 3
               @ nbr,nlc SAY "*"
            CASE corner = 4
               @ nbr,nrc SAY "*"
         ENDCASE
         IF mvex
            @ 0,70 SAY "<EXPAND>"
         ENDIF
         t = INKEY(0)
         DO CASE
            CASE (t = 27)               && (ESC) Abort
               UNLOCK
               EXIT
            CASE (t = 113) .or. (t = 81)      && (Q or q) Quit
               REPL Htr WITH ntr
               REPL Hbr WITH nbr
               REPL Hlc WITH nlc
               REPL Hrc WITH nrc
               REPL Help_txt WITH n_text
               UNLOCK
               EXIT
            CASE (t = 1)               && Home
               corner = 1
            CASE (t = 18)               && PgUp
               corner = 2
            CASE (t = 6)               && End
               corner = 3
            CASE (t = 3)               && PgDn
               corner = 4
            CASE (t = 5)               && up arrow
               IF mvex
                  IF (corner = 1) .or. (corner = 2)
                     ntr = ntr - 1
                     IF ntr < 1
                        ntr = 1
                     ENDIF
                  ELSE
                     nbr = nbr - 1
                     IF nbr < (ntr + 2)
                        nbr = nbr + 1
                     ENDIF
                  ENDIF
               ELSE
                  ntr = ntr - 1
                  nbr = nbr - 1
                  IF ntr < 1
                     ntr = 1
                     nbr = nbr + 1
                  ENDIF
               ENDIF
            CASE (t = 24)               && down arrow
               IF mvex
                  IF (corner = 1) .or. (corner = 2)
                     ntr = ntr + 1
                     IF ntr > (nbr - 2)
                        ntr = ntr - 1
                     ENDIF
                  ELSE
                     nbr = nbr + 1
                     IF nbr > 23
                        nbr = 23
                     ENDIF
                  ENDIF
               ELSE
                  ntr = ntr + 1
                  nbr = nbr + 1
                  IF nbr > 23
                     nbr = 23
                     ntr = ntr - 1
                  ENDIF
               ENDIF
            CASE (t = 19)               && left arrow
               IF mvex
                  IF (corner = 1) .or. (corner = 3)
                     nlc = nlc - 1
                     IF nlc < 1
                        nlc = 0
                     ENDIF
                  ELSE
                     nrc = nrc  - 1
                     IF nrc < (nlc + 14)
                        nrc = nrc + 1
                     ENDIF
                  ENDIF
               ELSE
                  nlc = nlc - 1
                  nrc = nrc - 1
                  IF nlc < 1
                     nlc = 0
                     nrc = nrc + 1
                  ENDIF
               ENDIF
            CASE (t = 4)               && right arrow
               IF mvex
                  IF (corner = 1) .or. (corner = 3)
                     nlc = nlc + 1
                     IF nlc > (nrc - 14)
                        nlc = nlc - 1
                     ENDIF
                  ELSE
                     nrc = nrc + 1
                     IF nrc > 79
                        nrc = 79
                     ENDIF
                  ENDIF
               ELSE
                  nlc = nlc + 1
                  nrc = nrc + 1
                  IF nrc > 79
                     nrc = 79
                     nlc = nlc - 1
                  ENDIF
               ENDIF
            CASE (t = 101) .or. (t = 69)   && (E or e) Edit
               n_text = memoedit(n_text,ntr+1,nlc+1,nbr-1,nrc-1,.T.)
            CASE (t = 109) .or. (t = 77)   && (M or m) Toggle Move/Expand
               IF mvex
                  mvex = .F.
               ELSE
                  mvex = .T.
               ENDIF
         ENDCASE
      ENDDO
   ELSE
      @ 24,0 CLEAR TO 24,79
      msg = "Record is in Use, Press any Key to Continue..."
      @ 24,CENTR(msg,0) SAY msg
      INKEY(0)
   ENDIF
ENDIF
SETCOLOR(oldcolor)
IF ! empty(save_sel)
   DO N_select WITH save_sel
   GOTO save_rec
ENDIF
@ r,c SAY ""
RESTORE SCREEN FROM help_sc
RELE save_sel, save_rec, help_sc, t, oldcolor, r, c, nlc, nrc
RELE ntr, nbr, nlc, nrc, n_text, corner, edit_sc, mvex
RETURN

FUNC Helpnob
PARA mode,line,colu
*
IF mode = 3
   KEYBOARD CHR(23)
ENDIF
RETURN 0
