*----------------------------------------------------------------------------
*
*   Program Name: MEMIMP.PRG        Copyright: EDON Corporation
*   Date Created: 03/06/91           Language: Clipper S'87
*   Time Created: 21:25:27             Author: Ed Phillips
*    Description: File Import function
*----------------------------------------------------------------------------

PRIVATE pcount, oldcolor, inrec
pcount = 4
PRIVATE prompts[pcount],msgs[pcount]             && DEFINE PRIVATE VARIABLES

*---------------------------------
* Build array to hold menu choices
*---------------------------------

prompts[1] = '1. Text File       '
prompts[2] = '2. Screen Data Base'
prompts[3] = '3. MEM File        '
prompts[4] = '0. Quit            '

msgs[1] = 'Import from DOS text file, with or without screen attributes'
msgs[2] = 'Import Screen and Gets from another EDON Screen Data Base'
msgs[3] = "Import from a Clipper S'87 MEM file"
msgs[4] = 'Return to session'

item = 1
redraw = .T.
oldcolor = Setcolor(c_default)
CLEAR

*-------------
* Display menu
*-------------
DO Bmenu WITH item, redraw, 5, 39, pcount, "Import Menu", prompts, msgs

DO CASE
   CASE item = 1                                 && text file
      inrec = Recno()
      fname = Space(20)
      Setcolor(c_field)
      attribs = .f.
      Shadow(3,17,8,63)
      Scroll(3,17,8,63,0)
      @ 3,17 TO 8,63
      @ 3,31 SAY ' Text File Import '
      @ 5,19 SAY 'Enter Text File Name:' GET fname PICT '@K!'
      @ 6,19 SAY 'Does Text File Include Screen Attributes?' GET attribs PICT 'Y'
      READ
      IF ! Empty(fname)
         fname = Trim(fname)
         fname= If('.' $ fname, fname, fname + '.txt')
         IF File(fname)
*            changed = .t.

            DO DrawScreen WITH attribs
            buffer1 = Savescreen(1,0,24,79)
            GO BOTTOM
            SKIP
            DO SaveScrn WITH M->st,M->sl,M->sb,M->sr,buffer1
         ELSE
            Sayerr('File &fname. not found')
            Restscreen(1,0,24,79,buffer1)
            GO inrec
         ENDIF
      ELSE
         Restscreen(1,0,24,79,buffer1)
         GO inrec
      ENDIF

   CASE item = 2                                 && another screen dbf
      fname = Space(20)
      getname = Space(20)
      Setcolor(c_field)
      Shadow(3,17,8,63)
      Scroll(3,17,8,63,0)
      @ 3,17 TO 8,63
      @ 3,31 SAY ' Screen DBF Import '
      @ 5,19 SAY 'Enter DBF  File Name:' GET fname PICT '@K!'
      @ 6,19 SAY 'Enter GET File Name:' GET getname PICT '@K!'
      READ
      IF ! Empty(fname) .AND. !('SCREEN.DBF' $ fname)
         fname = Trim(fname)
         fname= If('.' $ fname, fname, fname + '.dbf')
         getname = Trim(getname)
         getname= If('.' $ getname, getname, getname + '.dbf')
         IF File(fname)
            fname = Subs(fname,1,At('.',fname)-1)
            getname = Subs(getname,1,At('.',getname)-1)
            SELECT 0
            USE (getname) INDEX (getname) ALIAS Work1

            SELECT 0
            USE (fname) INDEX (fname) ALIAS Work

            SELECT Scr_file
            srec = Recno()
            SELECT Scrngets
            grec = Recno()

            SELECT Work
            DO WHILE .T.
               DO Memfind
               SELECT Work
               IF Lastkey() = esc
                  EXIT
               ELSE

                  *------------------------------
                  * Import selected Screen record
                  *------------------------------
                  Automem('STUP')
                  SELECT Scr_file
                  SEEK M->scrn_name
                  IF ! Found()
                     APPEND BLANK
*                     changed = .t.
                     Automem('REPL')

                     *--------------------
                     * Import the GETS too
                     *--------------------
                     SELECT Work1
                     SEEK Work->Scrn_name
                     DO WHILE Scrn_name == Work->Scrn_name .AND. ! Eof()
                        Automem('STUP')
                        SELECT Scrngets
                        APPEND BLANK
                        Automem('REPL')
                        SELECT Work1
                        SKIP
                     ENDDO                       && DO WHILE Scrn_name == Work->Scrn_name .AND. ! Eof()

                  ELSE
                     Sayerr('Selected Screen Name Already Exists in Target File')
                  ENDIF                          && IF ! Found()

                  SELECT Work
               ENDIF                             && IF Lastkey = esc
            ENDDO                                && DO WHILE .T.
            SELECT Work
            USE
            SELECT Work1
            USE
            SELECT Scrngets
            GO grec
            SELECT Scr_file
            GO srec
            Restscreen(St,Sl,Sb,Sr,Screen)
         ENDIF                                   && IF File(fname)
      ELSE
         Restscreen(1,0,24,79,buffer1)
      ENDIF                                      && IF ! Empty(fname)

   CASE item = 3                                 && a MEM file
      fname = Space(20)
      varname = Space(10)
      Setcolor(c_field)
      Shadow(3,17,8,63)
      Scroll(3,17,8,63,0)
      @ 3,17 TO 8,63
      @ 3,31 SAY ' MEM  File Import '
      @ 5,19 SAY 'Enter MEM  File Name:' GET fname PICT '@K!'
      @ 6,19 SAY 'Enter MemVar Name:' GET varname PICT '@!'
      READ
      IF ! Empty(fname)
         fname = Trim(fname)
         fname= If('.' $ fname, fname, fname + '.mem')
         IF File(fname)
            RESTORE FROM (fname) ADDITIVE
            IF ! Empty(varname)
               changed = .t.
               RestScreen(1,0,24,79,&varname.)
            ENDIF                                && IF ! Empty(varname)
         ENDIF                                   && IF File(fname)
      ELSE
         Restscreen(1,0,24,79,buffer1)
      ENDIF                                      && IF ! Empty(fname)
   OTHERWISE
      Restscreen(1,0,24,79,buffer1)
ENDCASE

Setcolor(oldcolor)
RETURN                                           && RETURN TO CALLING PROGRAM
* EOF: MEMIMP.PRG
