*----------------------------------------------------------------------------
*
*   Program Name: MEMCOLOR.PRG      Copyright: EDON Corporation
*   Date Created: 02/24/91           Language: Clipper S'87
*   Time Created: 10:08:59             Author: Ed Phillips
*    Description: Based on Greg Lief's Colors.prg from Compass for Clipper S'87
*                 Selects color from a color table.
*----------------------------------------------------------------------------


PARAM curr_color
PRIVATE oldrow, oldcol, oldcolor, mrow, mcol, palettetop, winbuff
PRIVATE colorstrng, mfore, mback, keypress

palettetop = 7                                  && top row for palette - change this to suit your needs

** save environment
oldrow = ROW()
oldcol = COL()
oldcolor = SETCOLOR()
winbuff = SAVESCREEN(palettetop, 16, palettetop + 8, 63)

** this string will be used in converting color numbers in the
** range of 0-127 to dBASE color strings (e.g. "W/N" etc)
colorstrng = 'N  B  G  BG R  BR GR W  N+ B+ G+ BG+R+ BR+GR+W+ '

** set start-up color to current color if no parameter passed
curr_color = IF(PCOUNT() = 0, SETCOLOR(), UPPER(curr_color))


******* parse this string to determine foreground and background colors
*
** first determine how many characters are in the foreground color
** by locating the first slash in the string
mslash = AT('/', curr_color)
*
** background color will lie between the slash and the first comma,
mcomma = AT(',', curr_color)
** but we also must allow for color parameters passed without a comma
mcomma = IF(mcomma = 0, LEN(curr_color) + 1, mcomma)
*
** break out the foreground and background colors
mfore = SUBSTR(curr_color, 1, mslash - 1)
mback = SUBSTR(curr_color, mslash + 1, mcomma - mslash - 1)
*
** convert the string to a number
curr_color = INT(AT(mfore, colorstrng)/3) + INT(AT(mback, colorstrng)/3)*16
*
********

** draw the color palette
IF TYPE('palette') = 'C'
   RESTSCREEN(palettetop, 16, palettetop + 8, 63, palette)
ELSE
   FOR mcol = 0 TO 15
      FOR mrow = 0 TO 7
         colorno = mrow*16 + mcol
         SETCOLOR(color_n2s(colorno))
         @ palettetop + mrow, 16 + mcol*3 SAY CHR(32)+CHR(4)+CHR(32)
      NEXT
   NEXT

   SETCOLOR('GR+/N')
   @ palettetop + 8,16 CLEAR TO palettetop + 8,63
   @ palettetop + 8,16 SAY CHR(24)+CHR(25)+CHR(27)+CHR(26)+' to move'
   @ palettetop + 8,33 SAY 'Enter to select'
   @ palettetop + 8,53 SAY 'Esc to exit'

   palette=SAVESCREEN(palettetop, 16, palettetop + 8, 63)
   SAVE TO Scrnpal ALL LIKE palette
ENDIF

** determine starting row and column within palette
mrow = palettetop + INT(curr_color/16)
mcol = 17 + curr_color % 16 * 3

** commence main keypress loop
DO WHILE .T.

   ** draw blinking diamond to mark current color and get keypress
   SETCOLOR('*' + color_n2s(curr_color))
   @ mrow,mcol SAY CHR(4)
   INKEY(0)
   keypress = LASTKEY()

   ** clear blinking diamond
   SETCOLOR(color_n2s(curr_color))
   @ mrow,mcol SAY CHR(4)

   ** process keystroke
   DO CASE
         ** user pressed an arrow key (24=down, 5=up, 4=left, 19=right)
      CASE (keypress = 24 .AND. mrow < palettetop+7) .OR. ;
         (keypress = 5  .AND. mrow > palettetop) .OR.  ;
         (keypress = 4  .AND. mcol < 62) .OR. ;
         (keypress = 19 .AND. mcol > 17)
         ** adjust row position for up or down arrows
         mrow = mrow + IF(keypress = 24, 1, IF(keypress = 5, -1, 0))
         ** adjust column position for left or right arrows
         mcol = mcol + IF(keypress = 4, 3, IF(keypress = 19, -3, 0))
         ** change color number accordingly
         curr_color = curr_color + IF(keypress=24, 16, ;
         IF(keypress = 5, -16, IF(keypress = 4, 1, -1)))
         ** user pressed Enter or Esc - time to move along
      CASE keypress = 13 .OR. keypress = 27
         EXIT
         ** user pressed something else
      OTHERWISE
         Alert()
   ENDCASE
ENDDO

** restore environment
@ oldrow, oldcol SAY ''
IF Lastkey() != 27
   Setcolor(Color_n2s(curr_color))
ELSE
   Setcolor(oldcolor)
ENDIF                                            && IF Lastkey() != 27

RESTSCREEN(palettetop, 16, palettetop + 8, 63, winbuff)

RETURN
* EOF: Memcolor.prg

