*.............................................................................
*
*   Program Name: MEMSTRU.PRG       Copyright: EDON Corporation
*   Date Created: 04/30/91           Language: Clipper S'87
*   Time Created: 08:01:15             Author: Ed Phillips
*           Desc: Display a Database Structure
*.............................................................................

PRIVATE oldcolor, savscrn, oldarea

struvar = If(Len(struvar) < 30, Gaspad(struvar,30), struvar)

ex_flg = .f.
savscrn = Savescreen(1,0,24,79)
oldcolor = Setcolor(c_statln1)
oldarea = Select()

Shadow(5,17,13,64)
Scroll(5,17,13,64,0)
Setcolor(c_error)
@ 5,17 SAY Replicate(Chr(176),48)
@ 5,30 SAY ' List DBF Structure '
@ 13,17 SAY Replicate(Chr(176),48)
Setcolor(c_statln1)
SET KEY -2 TO DbfileList

@ 07,23 SAY "Enter DBF file name: (path optional)"
@ 11,21 SAY 'Press <F3> for a list, <Esc> to Cancel'
Setcolor(c_fielda)
@ 09,26 GET struvar PICT '@K!'
READ
SET KEY -2 TO

IF Empty(struvar) .OR. Lastkey() = esc
   ex_flg = .t.
ELSEIF ! File(struvar)
   ex_flg = .t.
   Sayerr('File not found')
ENDIF                                            && IF Empty(struvar) .OR. Lastkey() = esc

IF ! ex_flg
   SELECT 0
   USE (struvar)
   COPY STRU EXTENDED TO MemJunk
   USE MemJunk

   bhelp_msg = Chr(24)+Chr(25)+', <Esc> = Done'
   btit1 = 'Structure: '+Trim(struvar)
   Shadow(3,18,22,63)
   Setcolor(c_error)
   Scroll(3,18,5,63,0)
   @ 3,Centr(btit1) SAY btit1
   @ 5,19 SAY 'Field No.   Field Name   Type   Width   Dec'
   expr = "Space(3)+Str(Recno(),3,0)+Space(6)+Field_name+Space(4)+Field_type+Space(6)+FieldSize()"
   Setcolor(c_statln1)
   Browze_dbf(expr,6,18,22,63)
   USE
ENDIF                                            && IF ! ex_flg

IF File('MemJunk.dbf')
   ERASE MemJunk.dbf
ENDIF                                            && IF File('MemJunk.dbf')

Setcolor(oldcolor)
Restscreen(1,0,24,79,savscrn)
SELECT (oldarea)
RETURN

*----------------------------
*         Author: Ed Phillips
*   Date Created: 04/30/91
*----------------------------
FUNCTION FieldSize
   PRIVATE ret_val

   ret_val = Str(Field_len,4,0)+Space(3)+Str(Field_dec,3,0)
   IF Field_type = 'C'
      IF Field_dec > 0
         ret_val = Str(Field_dec * 256 + Field_len,4,0)+Space(5)+'0'
      ENDIF                                      && IF Field_dec > 0
   ENDIF                                         && IF Field_type = 'C'
RETURN(ret_val)

*----------------------------
*         Author: Ed Phillips
*   Date Created: 04/30/91
*----------------------------
PROCEDURE DbfileList
   PRIVATE dbf_files[Adir('*.dbf')], oldcolor, dwin

   Adir('*.dbf',dbf_files)
   sel = PickList("dbf_files", " File List",15,3,1)
   IF sel > 0
      struvar = dbf_files[sel]
   ENDIF                                         && IF sel > 0

RETURN
* EOF: MEMSTRU.PRG
