*----------------------------------------------------------------------------
*
*   Program Name: MEMCENTR.PRG      Copyright: EDON Corporation                                         
*   Date Created: 02/25/91           Language: Clipper S'87                                             
*   Time Created: 20:59:57             Author: Ed Phillips                               
*    Description: Center Text function for memscrn.prg
*----------------------------------------------------------------------------

PROCEDURE CenterText
   PRIVATE right, left, last, first, linebuff, block, i, j, temp, col, str_len

   right = 80
   left = 1
   first = 1
   last = 1
   linebuff = Savescreen(r,0,r,79)
   j = 1
   FOR i = 1 TO 80
      temp = Bin2w(Subs(linebuff,j,1))
      IF temp > 127
         left = j/2
      ELSEIF temp > 32
         first = j/2
         EXIT
      ENDIF                                      && IF temp > 127

      j = j + 2
   NEXT                                          && FOR i = 1 TO 160

   j = 159
   FOR i = 80 TO 1 STEP -1
      temp = Bin2w(Subs(linebuff,j,1))
      IF temp > 127
         right = j/2
      ELSEIF temp > 32
         last = j/2
         EXIT
      ENDIF                                      && IF temp > 127
      j = j - 2
   NEXT                                          && FOR i = 80 TO 1 STEP -1

   IF last > first
      right = right - 0.5
      left = left - 0.5

      str_len = last - first + 1
      block = Savescreen(r,first,r,last)
      
      col = If((right-left) % 2 = 0, Int((right - left)/2) - Int((str_len/2)), Int((right - left + 1)/2) - Int((str_len/2)))

      @ r,first CLEAR TO r,last
      Restscreen(r,col+left,r,col+left+str_len-1,block)
      c = col + left
      Gotoxy(r,c)
      changed = .t.
   ENDIF                                         && IF last > first

RETURN
* EOF: Memcentr.prg
