*.............................................................................
*
*   Program Name: SHADOW.PRG        Copyright: Public Domain
*   Date Created: 12/09/91           Language: Clipper 5.0
*   Time Created: 09:19:31             Author: Ed Phillips
*           Desc: Draw a shadow at coordinates
*.............................................................................

*----------------------------
*         Author: Ed Phillips
*   Date Created: 12/09/91
*----------------------------
FUNCTION Shadow(t,l,b,r)
   LOCAL prvscr, h, w
   h := b - t
   w := r - l
  
   *---------------
   * bottom shading
   *---------------
   prvscr := Savescreen(t+h+1,l+2,b+1,r+2)
   IF Len(prvscr) > 2048
      prvscr := Transform(Subs(prvscr,1,2048),Repl('X'+Chr(8),1000))+;
      Transform(Subs(prvscr,2049),Repl('X'+Chr(8),1000))
   ELSE
      prvscr := Transform(prvscr,Repl('X'+Chr(8),Len(prvscr)/2))
   ENDIF
   Restscreen(t+h+1,l+2,b+1,r+2,prvscr)

   *-------------------
   * right edge shading
   *-------------------
   prvscr := Savescreen(t+1,l+w+1,b+1,l+w+2)
   IF Len(prvscr) > 2048
      prvscr := Transform(Subs(prvscr,1,2048),Repl('X'+Chr(8),1000))+;
      Transform(Subs(prvscr,2049),Repl('X'+Chr(8),1000))
   ELSE
      prvscr := Transform(prvscr,Repl('X'+Chr(8),Len(prvscr)/2))
   ENDIF
   Restscreen(t+1,l+w+1,b+1,l+w+2,prvscr)
RETURN (NIL)
* EOF: SHADOW.PRG
