*----------------------------------------------------------------------------
*
*   Program Name: PUSHWIN.PRG       Copyright: Public Domain
*   Date Created: 08/13/92           Language: Clipper 5.0
*   Time Created: 13:13:38             Author: Ed Phillips
*    Description: PUSH and POP a full or sub-screen from SCREEN.DBF
*----------------------------------------------------------------------------

STATIC sScreen

*----------------------------
*         Author: Ed Phillips
*   Date Created: 08/13/92
*----------------------------
FUNCTION PushWin(sname)
   FIELD St, Sr, Sb, Sl, Shadow IN Screen
   MEMVAR screen                                 && alias of screen dbf, usually "SCREEN"
   LOCAL oldarea := Select(), oldcolor, t, l, b, r

   IF Select(screen) = 0
      M->ex_flg := .f.
      USE (screen) INDEX (screen) ALIAS Screen SHARED NEW
      IF Neterr()
         M->ex_flg := .t.
      ENDIF                                      && IF Neterr()
   ENDIF

   IF ! M->ex_flg
      SELECT Screen
      SEEK Upper(sname)
      IF Found()
         t := St
         l := Sl
         b := Sb
         r := Sr
         IF Shadow
            r += 2
            b++
         ENDIF
         sScreen := Savescreen(t, l, b, r)
      ENDIF
   ENDIF

   SELECT (oldarea)
RETURN (nil)

*----------------------------
*         Author: Ed Phillips
*   Date Created: 08/13/92
*----------------------------
FUNCTION PopWin(sname)
   FIELD St, Sr, Sb, Sl, Shadow IN Screen
   LOCAL oldarea := Select(), t, l, b, r

   SELECT Screen
   SEEK Upper(sname)
   IF Found()
      t := St
      l := Sl
      b := Sb
      r := Sr
      IF Shadow
         r += 2
         b++
      ENDIF
      Restscreen(t, l, b, r, sScreen)
   ENDIF

   SELECT (oldarea)
RETURN(nil)
* EOF: Pushwin.prg
