*.............................................................................
*
*   Program Name: POPSCRN.PRG       Copyright: Public Domain
*   Date Created: 02/27/91           Language: Clipper 5.0
*   Time Created: 08:13:03             Author: Ed Phillips
*           Desc: Restore a Screen from the Screens Data Base
*.............................................................................

FUNCTION PopScreen(sname)
   MEMVAR screen
   LOCAL oldarea := Select(), oldcolor

   IF Select(screen) = 0
      M->ex_flg := .f.
      USE (screen) INDEX (screen) ALIAS Screen SHARED NEW
      IF Neterr()
         M->ex_flg := .t.
      ENDIF                                      && IF Neterr()
   ENDIF

   IF ! M->ex_flg
      SELECT Screen
      SEEK Upper(sname)
      IF Found()

         *------------------------------------------------------------
         * Explode = 0 - use top-left char of screen as "explode" char
         *         = 1 - use single box as "explode" char
         *         = 2 - use double box as "explode" char
         *------------------------------------------------------------
         IF Screen->Explode < 3
            oldcolor = Setcolor()
            DO ScrnAttrib                        && get attrib of top-left char of screen
            BoomBox(Screen->St,Screen->Sl,Screen->Sb,Screen->Sr,Screen->Explode)
            Setcolor(oldcolor)
         ENDIF                                      && IF ! Empty(Explode)

         Restscreen(Screen->St,Screen->Sl,Screen->Sb,Screen->Sr,Screen->Screen)

         IF Screen->Shadow
            Shadow(Screen->St,Screen->Sl,Screen->Sb,Screen->Sr)
         ENDIF                                      && IF Shadow

      ELSE
         Sayerr('Screen ' + sname + ' not found')
      ENDIF                                         && IF Found()
   ENDIF                                         && IF ! M->ex_flg
   SELECT (oldarea)
RETURN (NIL)

*-------------------------------------------------
* Determine attribute at top left of screen record
*-------------------------------------------------
PROCEDURE ScrnAttrib

   Setcolor(Color_n2s(Bin2w(Subs(Screen->Screen,2,1)+Chr(0))))
RETURN

FUNCTION Color_n2s( nColorNo )
   LOCAL cColorStrng

   cColorStrng = 'N  B  G  BG R  BR GR W  N+ B+ G+ BG+R+ BR+GR+W+ '

RETURN (Trim(Subs(cColorStrng, (nColorNo % 16) * 3 + 1, 3)) + '/' + ;
        Trim(Subs(cColorStrng, Int(nColorNo / 16) * 3 + 1, 3)))

* EOF: POPSCRN.PRG
