*----------------------------------------------------------------------------
*
*   Program Name: GET_SAY.PRG       Copyright: Public Domain
*   Date Created: 11/13/92           Language: Clipper
*   Time Created: 15:28:50             Author: Ed Phillips
*    Description: Sample GET/SAY reader for SCREEN system
*----------------------------------------------------------------------------

*----------------------------
*         Author: Ed Phillips
*   Date Created: 03/19/91
*   Invoke GETs from SCRNGETS.DBF for 
*     specified screen
*----------------------------
FUNCTION Gets(scrname)
   MEMVAR getlist

   LOCAL oldarea := Select(), ret_val := .t., oldexit, oldcolor := Setcolor(),;
      oldcurs := Setcursor(), checkval, tmp, lLoop := .f.

   PRIVATE gtop := 0, gbottom := 0, work, when, var, val

   oldexit := Readexit(.t.)

   IF Select('Scrngets') == 0
      USE Scrngets INDEX Sgets NEW
   ENDIF

   SELECT Scrngets
   scrname := Upper(scrname)
   SEEK scrname

   IF !Found()
      RETURN (.f.)
   ENDIF                                         && IF !Found()

   DO WHILE scrname = Trim(FIELD->Scrn_name) .AND. ! Eof()
      IF FIELD->GS_flag $ 'BG'
         gtop := If(gtop == 0, Recno(), gtop)

         var := Trim(Right(FIELD->G_var,10))

         *-----------------------
         * Issue one GET as a SAY
         *-----------------------
         IF ! Empty(FIELD->G_when)
            when := Trim(FIELD->G_when)
            IF ! &when.
               SKIP
               LOOP
            ENDIF                                   && IF ! &when.
         ENDIF                                      && IF ! Empty(M->when)

         tmp := If(Empty(Field->G_color), M->c_get, Trim(FIELD->G_color))

         IF Empty(FIELD->G_pic)
            @ FIELD->G_row, FIELD->G_col SAY Eval(MemVarBlock(var)) COLOR tmp
         ELSE
            @ FIELD->G_row, FIELD->G_col SAY Eval(MemVarBlock(var)) PICT Trim(FIELD->G_pic) COLOR tmp
         ENDIF
         gbottom := Recno()
      ENDIF                                      && IF FIELD->GS_flag $ 'BG'

      SKIP
   ENDDO

   GO gtop
   SET KEY K_CTRL_END TO CtrlEnd
   SET KEY K_CTRL_HOME TO CtrlHome

   DO WHILE scrname = Trim(FIELD->Scrn_name) .AND. ! Eof()
      var := Trim(FIELD->G_var)
      val := Trim(FIELD->G_valid)
      checkval := .f.

      BEGIN SEQUENCE
         *--------------
         * Issue one GET
         *--------------
         IF Field->Gs_flag $ 'BG'
            IF ! Empty(FIELD->G_when)
               when = Trim(FIELD->G_when)
               IF ! &when.
                  lLoop := .t.
                  BREAK
               ENDIF                                   && IF ! &when.
            ENDIF                                      && IF ! Empty(M->when)

            tmp := If(Empty(Field->G_color), M->c_get, Trim(FIELD->G_color))

            IF Empty(FIELD->G_pic)
               @ FIELD->G_row, FIELD->G_col GET &var. COLOR tmp
            ELSE
               @ FIELD->G_row, FIELD->G_col GET &var. PICT Trim(FIELD->G_pic) COLOR tmp
            ENDIF

            Setcursor(SC_NORMAL)
            READ
            checkval := .t.
            Setcursor(SC_NONE)
         ELSE
            lLoop := .t.
         ENDIF
      END

      IF lLoop
         lLoop := .f.
         SKIP
         LOOP
      ENDIF

      IF !Empty(val) .AND. checkval
         IF ! &val.                              && validation failed
            LOOP
         ENDIF                                      && IF ! &val.
      ENDIF                                         && IF !Empty(val)

      DO CASE
         CASE Lastkey() = K_DOWN
            NextGet(scrname)
         CASE Lastkey() = K_UP
            PrevGet(scrname)
         CASE Lastkey() = K_PGDN
            EXIT
         CASE Lastkey() = K_ESC
            ret_val = .f.
            EXIT
         OTHERWISE
            DO WHILE .T.
               SKIP
               IF scrname != Trim(FIELD->Scrn_name) .OR. Bof()
                  EXIT
               ELSEIF FIELD->Gs_flag $ 'BG'
                  EXIT
               ELSEIF Eof()
                  GO gtop
                  EXIT
               ENDIF                             && IF scrname != Trim(Scrn_name) .OR. Bof()
            ENDDO                                && DO WHILE .T.
      ENDCASE                                       && DO CASE

   ENDDO
   SELECT (oldarea)
   Readexit(oldexit)
   Setcursor(oldcurs)

   SET KEY K_CTRL_END TO
   SET KEY K_CTRL_HOME TO
RETURN (ret_val)

*----------------------------
*         Author: Ed Phillips
*   Date Created: 03/19/91
*----------------------------
FUNCTION PrevGet(scrname)
   DO WHILE .t.
      SKIP -1
      IF scrname != Trim(FIELD->Scrn_name) .OR. Bof()
         GO M->gbottom
         EXIT
      ELSEIF FIELD->Gs_flag $ 'BG'
         EXIT
      ENDIF                                         && IF Scrn_name != scrname
   ENDDO                                         && DO WHILE .t.
RETURN(NIL)

*----------------------------
*         Author: Ed Phillips
*   Date Created: 03/19/91
*----------------------------
FUNCTION NextGet(scrname)
   DO WHILE .t.
      SKIP
      IF scrname != Trim(FIELD->Scrn_name) .OR. Eof()
         GO M->gtop
         EXIT
      ELSEIF FIELD->Gs_flag $ 'BG'
         EXIT
      ENDIF                                         && IF scrname != Trim(Scrn_name)
   ENDDO                                         && DO WHILE .t.
RETURN (NIL)                                      && FUNCTION NextGet

*----------------------------
*         Author: Ed Phillips
*   Date Created: 03/19/91
*   Invoke SAYs from SCRNGETS.DBF for 
*     specified screen
*----------------------------
FUNCTION Says(scrname)
   LOCAL oldcolor := Setcolor(), oldarea := Select(), dummy
   PRIVATE sexpr

   scrname := Upper(scrname)
   IF Select('Scrngets') = 0
      USE Scrngets INDEX Sgets NEW
   ENDIF

   SELECT Scrngets
   SEEK scrname

   DO WHILE scrname = Trim(FIELD->Scrn_name) .AND. ! Eof()

      *--------------
      * Issue one SAY
      *--------------
      IF FIELD->GS_flag $ 'BS'
         IF ! Empty(FIELD->Say_color)
            IF Upper(Left(Field->Say_color,2)) = 'C_'
               dummy := &(Trim(Field->Say_color))
               Setcolor(dummy)
            ELSE
               Setcolor(Trim(FIELD->Say_color))
            ENDIF

         ELSE
            Setcolor(M->c_say)
         ENDIF

         *-------------------------------------------------------------------
         * IF SAY_EXP is empty, say the get-var, otherwise evaluate the function
         *-------------------------------------------------------------------
         sexpr := If(Empty(FIELD->Say_exp), Trim(Right(FIELD->G_var,10)), Trim(FIELD->Say_exp))

         DO CASE
            CASE ! Empty(FIELD->Say_exp)
               dummy = &sexpr.                   && it's a function
            CASE Empty(FIELD->Say_pict)
               @ FIELD->G_row, FIELD->G_col SAY Eval(MemVarBlock(sexpr))    && it's a field
            OTHERWISE
               @ FIELD->G_row, FIELD->G_col SAY Eval(MemVarBlock(sexpr)) PICT Trim(FIELD->Say_pict)
         ENDCASE
      ENDIF                                      && IF Gs_flag
      SKIP
   ENDDO                                         && DO WHILE scrname = Trim(Scrn_name) .AND. ! Eof()
   SELECT (oldarea)
   Setcolor(oldcolor)
RETURN (NIL)

*----------------------------
*         Author: Ed Phillips
*   Date Created: 03/19/91
*----------------------------
PROCEDURE CtrlEnd
   GO M->gbottom
   KEYBOARD Chr(K_UP)+Chr(K_DOWN)
RETURN                                           && PROCEDURE CtrlEnd

*----------------------------
*         Author: Ed Phillips
*   Date Created: 03/19/91
*----------------------------
PROCEDURE CtrlHome
   GO M->gtop
   KEYBOARD Chr(K_UP)+Chr(K_DOWN)
RETURN                                           && PROCEDURE CtrlEnd
* EOF: Get_Say.prg
