*.............................................................................
*   Program Name: BOOMBOX.PRG       Copyright: Public Domain
*   Date Created: 06/03/91           Language: Clipper 5.0
*   Time Created: 09:30:06             Author: Ed Phillips
*           Desc: Exploding box routine. Box_types are 0 - no box
*                                                      1 - single line box
*                                                      2 - double line box
*.............................................................................

FUNCTION BoomBox(t,l,b,r,box_type)
   LOCAL booms, yinc, xinc, i, r1, r2, c1, c2, cr, cc

   box_type := If( ValType(box_type) = 'U', 0, box_type )

   booms = (b-t)/2
   yinc = 1
   xinc = ((r-l)/2)/booms
   cr = t+booms
   cc = l+((r-l)/2)

   FOR i = 1 TO booms
      r1 = cr - (i*yinc)
      c1 = cc - (i*xinc)
      r2 = cr + (i*yinc)
      c2 = cc + (i*xinc)

      Scroll(r1,c1,r2,c2,0)
      IF box_type = 1
         @ r1,c1 TO r2,c2
      ELSEIF box_type = 2
         @ r1,c1 TO r2,c2 DOUBLE
      ENDIF
      Inkey(0.05)
   NEXT                                          && FOR i = 1 TO booms
RETURN(NIL)
* EOF: BOOMBOX.PRG
