*********************************************************************
*  Function: RScreen.PRG
*  Writer: Kraig Krist/TBCS
*          PO Box 711
*          Annandale, VA 22003-0711
*  Date: August 22, 1993.
*  Description: Restore Screen.  Enhanced orginal version by
*               Rick Spense
*********************************************************************
*
*   ***** Function Specifications *****
*
*   Passed In: Screen to Restore
*              Example: RScreen(cOldScrn)
*
*   Returns: nothing
*
*********************************************************************
*             ---- Modification Log ----
*  When:
*   Why:
*********************************************************************
#Include "ScrnUtil.CH"
FUNCTION RScreen(cScrn)
********************************************************************
* Restores a saved screen area. Note that we don't need the
* coordinates as they were saved with the Screen.
********************************************************************
  RestScreen(nSTop(cScrn),nSLeft(cScrn),nSBottom(cScrn),;
             nSRight(cScrn),cScreen(cScrn))
RETURN(NIL)
*********************************************************************
*  Function: SScreen.PRG
*  Writer: Kraig Krist.
*          PO Box 711
*          Annandale, VA 22003-0711
*  Date: August 22, 1993.
*  Description: Save Screen.  Enhanced orginal version by Rick Spense
*********************************************************************
*
*   ***** Function Specifications *****
*
*   Passed In: Screen coordinates to save
*              Example: cOldScrn := SScreen(10,0,15,79)
*
*   Returns: Saved Screen with screen coordinates
*
*********************************************************************
*             ---- Modification Log ----
*  When:
*   Why:
*********************************************************************
FUNCTION SScreen(nTop,nLeft,nBottom,nRight)
*********************************************************************
*   Establish defaults if value was not passed.
*********************************************************************
  If nTop = NIL
    nTop := 0
  EndIf
  If nLeft = NIL
    nLeft := 0
  EndIf
  If nBottom = NIL
    nBottom := MaxRow()
  EndIf
  If nRight = NIL
    nRight := MaxCol()
  EndIf
*********************************************************************
*   Returned the saved corrdinates and screen.
*********************************************************************
RETURN(Chr(nTop) + Chr(nLeft) + Chr(nBottom) + Chr(nRight) +;
       SaveScreen(nTop,nLeft,nBottom,nRight))
