******************************************************************************
*  File:           SCROL0292.PRG
*  Author:         Jim Magnant (Txaggie on BORBBS)
*  Original date:  02-07-1992
*  Modified by:    
*  Last changed:   
*
*  Note: This program source code can be run as a stand-alone text file 
*        viewer from within dBASE IV or embedded within an application.
*        The sample program file SAMPLE.PRG can be used to select the
*        text file from all ".TXT" files on the drive.  For files with
*        other extensions, simply change the popup definition accordingly.
*
*  This code has evolved from many sources and conversations.  It will 
*  continue to evolve, probably until I have a somewhat sophisticated text
*  editor.  I'm in need of letter-writing and mail merge capabilities, but
*  have not found anything that could be distributed in runtime applications
*  without significantly affecting the price.  So, I'm sharing with others
*  while performing a necessary evil.  Enjoy, and feel free to modify to your
*  heart's content.  If you'd like to share ideas (or problems!), contact me
*  on the Borland International BBS (BORBBS via Compuserve, Txaggie ID) or 
*  on The Database Connection BBS in Houston (Jim Magnant, Conf. #3). I hope 
*  to have a Compuserve ID very soon, so look for me there (I'm vocal, so I
*  won't be hard to find).
*
******************************************************************************
*
*  FILES USED:
*
*              Database file:          Text.dbf          One field (View_text), 
*                                                           132 CHR'S wide
*              Index file:             None
*              External procedure:     None
*              Format file:            None
*              Sample calling program: Sample.prg
*              Sample text file:       &in_file.txt       Select from any in
*                                                            current subdirectory
*              Documentation:          README.DOC
*
******************************************************************************
*
*  BASIC ALGORITHM:
*
*  1     Save the environmental settings that will be modified.
*  2     Clear the screen and ask the user to be patient.
*  3     Define the view window coordinates and number of visible lines.
*  4     Use the Text database file.
*  5     Load the correct file to be viewed, including zapping of old file.
*  6     Give the user the help message and assign the current values for the
*           cursor location, and activate the window for viewing.
*  7     Start processing the keystrokes.
*  7.1   Decide whether the keystroke desired, combined with the current cursor
*          location, indicates a redraw of the screen (draw=.t.).
*  7.1.1 If so, save the record pointer and display the records in the window.
*  7.1.2 Return to the original record position.
*  8     Relocate the cursor to the "now" position.
*  9     Call the keystroke processor.
*  9.1   Initialize the memory variable and use INKEY(0) to wait for keypress.
*  9.2   Process the keypress with DO CASE statement.
*  9.2.1 If the wrong key was pressed, beep the user and loop for another key.
*  9.3   Exit the loop and return to the calling program.
*  10    Reset the environment and release the memory items.
*
******************************************************************************
*
*  MEMORY VARIABLES USED:
*
*  w_top       = Top row of the window used to view the file
*  w_left      = Left starting column of viewing window
*  w_bot       = Bottom row of the viewing window
*  w_right     = Right ending column of viewing window
*  w_skip      = Number of lines visible in the window
*  in_file     = Name of file to APPEND text from
*  col_now     = Current cursor column location in the viewing window
*  col_st      = Character from LEFT of field start to begin showing in window
*  col_end     = Last character from LEFT of field to show in window
*  row_now     = Current cursor row location
*  draw        = Indicates whether or not a screen redraw is required
*  exxit       = Controls exiting of the main program DO WHILE loop (quit)
*  bell_on     = Indicates whether user wants the bell to sound for wrong keys
*  rcd_old     = Used to store the record pointer to return to after drawing
*  countt      = Used to count the # of lines drawn (don't exceed w_skip)
*  keypress    = Used as a dummy variable to call the key handler
*  key_press   = Trapped keypress entered by the user (the one we'll process)
*
******************************************************************************


PROCEDURE Scrl0292

* Save the environmental settings that will be changed.
SAVE SCREEN TO sscreen              && Save the screen for restoring
ttalk   = SET('TALK')               && Save talk.
sstat   = SET('STATUS')             && Save status bar.
colour  = SET('ATTRIBUTES')         && Save colors.
nnear   = SET('NEAR')               && Save near setting (when searches fail)
eesc    = SET('ESCAPE')             && Save esc setting
ssafe   = SET('SAFETY')             && Save the safety setting

* Set the environment to the desired settings
*SET COLOR TO                       && Use this to reset colors as you wish
SET TALK OFF                        && Hide command results
SET EXACT OFF                       && Seek's partial match of 1st letters
SET NEAR ON                         && And we'll stop close to a match
SET ESCAPE OFF                      && This allows processing of left arrow!

* Set status bar off (NOTE: If left/turned ON, you MUST set w_bot < 22!
SET STATUS OFF                      && Turn on status bar

* Ask user to wait a sec.
CLEAR                               && Clear the screen
@ 10,16 TO 14,61                    && Draw box
@ 12,27 SAY 'One moment please . . . . '        
@ 24,0

* Define the window to be used for the browse.
*-- Window size determined here (can easily be passed as parameters)
w_top   = 0
w_left  = 0
w_bot   = 23
w_right = 79
w_skip  = w_bot - w_top - 2         && Number of lines to skip for pges

* NOTE: Use the following 1 line ONLY if you do NOT use the popup selection
*in_file = "REPORT.TXT"


* Define window with color attributes all the same to hide the active row.
DEFINE WINDOW Texter FROM w_top,w_left TO w_bot,w_right COLOR N/W,N/W,N/W

USE TEXT

* NOTE: Do the next 7 lines ONLY if you selected a file with a popup (see sample.prg)
in_file = PROMPT()                  && PROMPT() has the filename selected from the popup
IF RECNO() > 0                      && If the file already has data ....
   SET SAFETY OFF                   && Don't prompt user for OK to zap
   ZAP                              && Delete all the records
   SET SAFETY &ssafe.               && Reset safety to the initial condition.
ENDIF
APPEND FROM &in_file. SDF           && Append from the selected (or defined file)

* Start viewing at the top
GO TOP                              

* Set up help message at bottom of screen.
@ 24,29 SAY "  Press F1 for Help   " COLOR W+/B 

* Set the inital row/column values to 1, activate window & go to 0,0
col_now = 1                         && Current column location
col_st  = 1                         && Left-most column location in window
col_end = 78                        && Right-most column location in window
row_now = 1                         && Current row location
draw = .t.                          && When .t., draw the screen using SCAN
ACTIVATE WINDOW Texter
@ 0,0                               && Go to the upper-left window location

exxit = .F.                         && Initialize the loop control variable
bell_on = .t.
DO WHILE .NOT. exxit                && Start processing
	IF draw = .t.
		draw = .f.                    && Reset for no-redraw condition
		rcd_old = recno()
		@ 0,0 say ""                  && Go back to upper-left of the window
		countt = 1
		set cursor off                && Hide cursor while drawing
		DO WHILE countt <= w_skip
			?? SUBSTR(VIEW_TEXT,col_st,col_end-col_st)    && Don't exceed window!
			?
			IF .NOT. EOF()             && Make sure not to skip if EOF() = .t.
			   skip
			ENDIF
			countt = countt + 1
		ENDDO
		go rcd_old                    && Return to where user was looking
		set cursor on                 && Show user where he is
		*clear typeahead              && Scan takes awhile .... clear buffer
	ENDIF
	@ row_now-1, col_now-1 say ""    && Adjust -1 for dBASE coordinates 
	keypress = key_h(w_skip)         && Call the keystroke processor
ENDDO
ON KEY
SET MESSAGE TO
DEACTIVATE WINDOW Texter
@ 24,0 SAY REPLICATE(' ',80)        && Overwrite the help message at bottom
RELEASE WINDOW Texter               && Clearthe window from memory


* Reset the environment
USE                                 && Clear the work area of the dbf
SET TALK &ttalk.
SET STATUS &sstat.
SET COLOR TO &colour.
SET NEAR &nnear.
SET ESCAPE &eesc.
RESTORE SCREEN FROM Sscreen
RELEASE SCREEN Sscreen

* Do the next line ONLY if you are using SAMPLE.PRG to select a .TXT file
DEACTIVATE POPUP

RETURN
*-- EOP: TXTREAD2.PRG


FUNCTION key_h                && Keyhandler function
PARAMETERS skip_no

   key_press = 0        		&& Initialize variable geting value from INKEY(0)
  
   DO WHILE .T.               && Used to continue wait for "valid" keys
	key_press = INKEY(0)       && Wait for the keystroke indefinately

	* Process input
	DO CASE
	   CASE key_press = 24 .OR. key_press = 13     								&& Down Arrow or Return key
		   IF RECNO() > RECCOUNT()-skip_no .AND. row_now = 21      && At bottom
				IF bell_on 
				   ?? CHR(7)
				ENDIF
			ELSE
				IF row_now = 21   && At bottom of window, ....
					skip 
					draw = .t.     && Redraw screen (down one line)
				ELSE
					row_now = row_now + 1  && Not window bottom, move cursor down 1 line
				ENDIF
		   ENDIF
	   CASE key_press = 5      												&& Up Arrow
		   IF RECNO() = 1 .AND. row_now = 1          && Already at the top
		      IF bell_on   
		         ?? CHR(7)                           && Beep  only if bell is on
				ENDIF
		   ELSE
				IF row_now = 1                         && Top of window, not file
					SKIP -1
					draw = .t.                          && Redraw window
				ELSE
					row_now = row_now - 1               && Move up 1 line in window
				ENDIF
		   ENDIF
		CASE key_press = 19        						&& Left arrow
			IF col_now > 1
				col_now = col_now - 1                  && If not on left edge ...
			ELSE
				IF col_st # 1
					col_st  = col_st - 1                && Reset memvar indicating # cols from left
					col_end = col_end -1                && Reset memvar indicating window end location
					draw = .t.
				ELSE
				   IF bell_on = .t.
				      ?? CHR(7)                        && Beep user -> already at far left
				   ENDIF
				ENDIF
			ENDIF
		CASE key_press = -400 								&& Backtab (S-TAB)
			IF col_now > 5                            && If not within 5 from left
				col_now = col_now - 5
			ELSE
				IF col_now > 1                         && Location is btwn 2 & 4
					col_now = 1
				ELSE
					IF col_st > 5                       && If farther right, .....
						col_st  = col_st - 5
						col_end = col_end -5
						draw = .t.
					ELSE
						IF col_st > 1                    && Reset to far left 
							col_st = 1
							col_end = 78
						ELSE                             && You're at the far left!
						   IF bell_on = .t.
						      ?? CHR(7)                  && Beep user -> already at far left!
						   ENDIF
						ENDIF
					ENDIF
				ENDIF
			ENDIF
		CASE key_press = 26                          && Home key (similar to back-TAB)
			IF col_now > 1
				col_now = 1
			ELSE
				IF col_st > 1
					col_st  = 1
					col_end = 78
					draw = .t.
				ELSE
				   IF bell_on = .t.
				      ?? CHR(7)                        && Beep user -> aleady at far left
				   ENDIF
				ENDIF
			ENDIF
		CASE key_press = 29                          && Ctrl-Home key
			IF col_st > 1
				col_now = 1
				col_st  = 1
				col_end = 78
				draw = .t.
			ELSE
				IF col_now > 1
					col_now = 1
				ELSE
				   IF bell_on = .t.
				      ?? CHR(7)                        && Beep user -> already at far left!
				   ENDIF
				ENDIF
			ENDIF
		CASE key_press = 4   									&& Right arrow
			IF col_now < 78                           && Not at far right of window
				col_now = col_now + 1                  && Move right one column
			ELSE
				IF col_end < 132                       && Not at max right location
					col_st  = col_st + 1
					col_end = col_end + 1
					draw = .t.
				ELSE
				   IF bell_on = .t.
				      ?? CHR(7)                        && Beep user -> at far right!
				   ENDIF
				ENDIF
			ENDIF
		CASE key_press = 9											&& TAB key
			IF col_now < 73                           && Not within 5 spaces of right of window
				col_now = col_now + 5
			ELSE
				IF col_now < 78                        && Not at far right of window
					col_now = 78                        && Go to far right of window
				ELSE
					IF col_end < 127                    && If at far right of window but not far 
*                                                        right of field .....
						col_st  = col_st + 5
						col_end = col_end + 5
						draw = .t.
					ELSE
						IF col_end < 132                 && Almost all the way right 
							col_st  = 55
							col_end = 132
						ELSE
						   IF bell_on = .t.
						      ?? CHR(7)                  && Beep user -> already at far right!
						   ENDIF
						ENDIF
					ENDIF
				ENDIF
			ENDIF
		CASE key_press = 2 										&& End key (similar to TAB key)
			IF col_now < 78
				col_now = 78
			ELSE
				IF col_end < 132
					col_st  = 55
					col_end = 132
					draw = .t.
				ELSE
				   IF bell_on = .t.
				      ?? CHR(7)                        && Beep user -> already at far right!
				   ENDIF
				ENDIF
			ENDIF
		CASE key_press = 23  								&& Ctrl-End key (similar to TAB)
			IF col_end < 132
				col_now = 78
				col_st  = 55
				col_end = 132
				draw = .t.
			ELSE
				IF col_now < 78
					col_now = 78
				ELSE
				   IF bell_on = .t.
				      ?? CHR(7)                        && Beep user -> already at far right!
				   ENDIF
				ENDIF
			ENDIF
	   CASE key_press = 18 										&& PgUp (similar to Up Arrow)
			IF RECNO() = 1  .and. row_now = 1
				   IF bell_on = .t.
				      ?? CHR(7)                        && Beep user -> already at top of doc!
				   ENDIF
			ELSE
				IF row_now > 1
					row_now = 1
				ELSE
					IF RECNO() > skip_no
						SKIP -skip_no  
					ELSE
						GO TOP
					ENDIF
					draw = .t.
				ENDIF
			ENDIF
	   CASE key_press = 3									&& PgDn (similar to Down Arrow)
			IF .NOT. RECNO() > RECCOUNT()-skip_no .and. row_now = 21
			   SKIP  skip_no                                                
			   IF EOF()     .or. recno() > reccount() - skip_no  
			   GO BOTTOM                                            
					skip -skip_no+1
			   ENDIF
				draw = .t.
			ELSE
				IF row_now < 21
					row_now = 21
				ELSE
				   IF bell_on = .t.
				      ?? CHR(7)                        && Beep user -> aleady at bottom!
				   ENDIF
				ENDIF
			ENDIF
	   CASE key_press = 31 									&& Ctrl-PgUp (see PgUp key)
			IF .NOT. RECNO() = 1 
			   GO TOP
				row_now = 1
				draw = .t.
			ELSE
				IF row_now > 1
					row_now = 1
				ELSE
				   IF bell_on = .t.
				      ?? CHR(7)                       && Beep user -> already at top!
				   ENDIF
				ENDIF
			ENDIF
	   CASE key_press = 30 									&& Ctrl-PgDn (see PgDn key)
			IF .NOT. RECNO() > RECCOUNT() - skip_no 
			   GO BOTTOM
				skip -skip_no+1
				row_now = 21
				draw = .t.
			ELSE
				IF row_now < 21
					row_now = 21
				ELSE
				   IF bell_on = .t.
				      ?? CHR(7)                       && Beep user -> aleady at bottom!
				   ENDIF
				ENDIF
			ENDIF
	   CASE key_press = 27 								 && Esc
		   exxit = .T.                             && Upon return to main program, exit loop
		CASE key_press = 28                        && F1 (Help)
			DO Helper                                                               
	   CASE key_press = -9								 && F10 - Turn bell on or off
	      bell_on = IIF(bell_on = .t.,.f.,.t.)
			define window info from 10,25 to 15,55 COLOR w+/r,w+/r,W+/R
			activate window info
			if bell_on 
				@ 1,3 SAY "The bell is now on."
				?? chr(7)
			else
				@ 1,3 SAY "The bell is now off."
			endif
			bbb = inkey(5)                          && Wait 5 seconds for user to see
			release window info                     
		OTHERWISE                                  && Any other key
		   IF bell_on = .t.
		      ?? CHR(7)                            && Beep user -> wrong key!
		   ENDIF
		   LOOP                                    && Loop (wrong keypress, try again)
	ENDCASE
	rcd_no = recno()
	EXIT                                          && Leave processor, redraw window w/
	*                                             &&   browse unless exxit = .T.
   ENDDO
RETURN key_press

PROCEDURE Helper
	DEFINE WINDOW Helper FROM 1,5 TO 23,75 COLOR W+/R,W+/B,W+/R
	ACTIVATE SCREEN                               && Allow text draw outside window
	@ 24,29 SAY "Press any key to continue" COLOR W+/B
	ACTIVATE WINDOW Helper
		@ 0,3  SAY "================= TEXT VIEWER HELP SCREEN ===================="
		@ 2,4  SAY "    ACTIVE KEYS                        ACTIONS"
		@ 3,6 TO 3,23
		@ 3,36 TO 3,61
		@ 5,4  SAY "  Arrow Up or Down              Up or Down one (1) line"
		@ 6,4  SAY "  Arrow Left or Right           Left or Right one (1) space"
		@ 8,4  SAY "  Home or End                   Left or Right one (1) screen"
		@ 9,4  SAY "  PgUp or PgDn                  Up or Down one (1) screen"
		@ 11,4 SAY "  Ctrl-PgUp                     Top of document"
		@ 12,4 SAY "  Ctrl-PgDn                     Bottom of document"
		@ 14,4 SAY "  Ctrl-Home                     Far left of document"
		@ 15,4 SAY "  Ctrl-End                      Far right of document"
		@ 17,4 SAY "  TAB or Shift-TAB              Right or Left five (5) spaces"
		@ 18,4 SAY "  F10                           Toggle Bell On or Off"
		@ 20,4 SAY "  Esc                           Quit the viewer"
		clear typeahead
		set cursor off
		temp = inkey(0)                            && Wait for user to press any key.
		set cursor on
	DEACTIVATE WINDOW Helper
	RELEASE WINDOW Helper                         && Clear window from memory.
	ACTIVATE SCREEN                               && Allow text draw outside window.
	@ 24,27 SAY "  Press F1 for Help    " COLOR W+/B
	ACTIVATE WINDOW Texter                        && Reactivate the viewer window.
RETURN
