*
*  SCRDOCPS.PRG - by Scott F. Barnes
*                 PostScript Printer screen-shot for Clipper 5.0
*                 COMPUSERVE: 73577,3233 [Scott F. Barnes]
*                 April 1991
*
*  This program may be used and passed around freely.  SCRDOCPS is still
*  in the development stage, and as such cannot be expected to perform to
*  consumer grade product standards.  I will make no guarantee as to it's
*  performance or suitability to your needs.
*.
*  I would appreciate any suggestions or comments.
*
*  SCRDOCPS will create a shadow boxed screen shot file in .PS or .EPS
*  format to be sent to a PostScript printer.  Include the proper .ext for
*  the file type you want.  EPS files can be resized by popular D.T.P. products.
*  Unlike some bitmapped "graphics" screenshot pgms, the black areas will remain
*  more saturated, shaded areas will not form checkerboard patterns, and
*  alphabetic letters will be more readable when scaled.
*  I use the "GoScript Plus" (LaserGo, Inc.) PostScript interpreter to print to
*  H.P. LaserJet II and III printers.  This requires a print to disk of .PS
*  files so they may be further processed.  Remove or comment out this code if
*  you want to print directly to the printer.
*  If you want to resize the normal .PS files, simply change the 6 /pt...
*  line to whatever point size you want (x,y and start will have to change if
*  the origin. is to be moved).
*
*  This program is far from perfect.  I am just in the process of learning
*  PostScript, and the program has been changed many times.  So the
*  programming (Clipper and PostScript) can be greatly improved.
*  Some of the known limitations:
*
*       *** Works only with mono monitor codes
*       *** NOT ALL character codes are included
*       *** Round braces "()" are currently converted to "{}"
*       *** BOLD and normal chrs. are displayed the same
*
*  I will be adding more chr() codes, and improving on the programming in the
*  future, and if there is an interest, I will upload future versions.
*
*  In the calling program, insert these lines:
*      e.g. EXTERNAL scrdocps
*           SET KEY -7 scrdocps
*
*  I compile SCRDOCPS using the /n/a/w/m 5.0 flags
*  Be sure to link the SCRDOCPS.obj to your application, F8 will activate.
*
*
*   CHARACTER CODES SUPPORTED:                      ATTRIBUTES SUPPORTED:
*   ============================================    =========================
*                                                   Normal   - white on black
*   (^px)     024      196      191       180    Inverted - black on white
*   (^py)     025      217      192       195    Underline
*            179      218    176-8             Flashing - 1/2 Normal,
*   Double Line box characters are currently                   1/2 Inverted
*   converted to their single line equivalent.
*
*
PROCEDURE SCRDOCPS
LOCAL uSCR,X,Y,mCOLOUR,mSCRCH,mPRT,uT1,uT2,mSTR,mPREV,mTYPE
LOCAL mCNT,mCHR,mPRE,mNEW,mEPS,getlist:={},uALL:=""

LOCAL uNCH[25]    && Characters
LOCAL uOCH[25]    && Attributes

mPRT = SPACE(12)
SAVE SCREEN TO uSCR
mCOLOUR = SETCOLOR()
SET COLOR TO W+
@ 11,10,14,52 BOX "ͻȺ "
@ 12,12 SAY "Enter Filename:" GET mPRT
READ
SET COLOR TO W+*
@ 13,12 SAY "WORKING ..."
mPRT = UPPER(ALLTRIM(mPRT))
IF RIGHT(mPRT,3)=".PS"
    mEPS = .F.
ELSE
    mEPS = .T.
ENDIF

FOR X=0 TO 24
    uT1 = ""
    uT2 = ""
    FOR Y=1 TO 160 STEP 2
        uT1 = uT1 + SUBSTR(uSCR,Y+(X*160),1)
        uT2 = uT2 + SUBSTR(uSCR,Y+1+(X*160),1)
    NEXT Y
    uT1 = STRTRAN(uT1,"(","{")                             && Replace with
    uT1 = STRTRAN(uT1,")","}")                             && defined chrs.
    uT1 = STRTRAN(uT1,"","")                             && until they can
    uT1 = STRTRAN(uT1,"","")                             && be added.
    uT1 = STRTRAN(uT1,"","")
    uT1 = STRTRAN(uT1,"","")
    uT1 = STRTRAN(uT1,"","")
    uT1 = STRTRAN(uT1,"","")
    uT1 = STRTRAN(uT1,"","")
    uT1 = STRTRAN(uT1,"","")
    uNCH[X+1] = uT1
    uOCH[X+1] = uT2
    uALL = uALL+uT1
NEXT X

SET PRINT TO &(mPRT)
SET CONSOLE OFF
IF mEPS
TEXT TO PRINT
%!PS-Adobe-2.0 EPSF-1.2
%%BoundingBox: 96 399 406 614
ENDTEXT
ENDIF

TEXT TO PRINT
6 /pt exch def                         % point size (can be changed for .ps)
100 /x exch def
100 /start exch def
600 /y exch def
/q pt 4 div def
/swidth pt 12 div def
/h pt q add def
/halfh h 2 div def
/Courier-Bold findfont pt scalefont setfont
/chrl (a) stringwidth pop def

/nl{
    /y y pt sub q sub def
    start y moveto
}def
/norm{
    dup
    /s exch def
    currentpoint /y exch def /x exch def
    /sw s stringwidth pop def
    0 setgray
    x y q sub moveto
    sw 0 rlineto 0 h rlineto sw neg 0 rlineto
    closepath
    fill
    1 setgray
    x y moveto
}def
/invert{
    0 setgray
}def
/flash{
    dup dup
    /s exch def
    currentpoint /y exch def /x exch def
    /sw s stringwidth pop def
    0 setgray
    x y q sub moveto
    sw 0 rlineto 0 h rlineto sw neg 0 rlineto
    closepath
    fill
    1 setgray
    x y moveto
    show
    gsave
        x y q sub moveto
        sw 0 rlineto 0 q 2 mul rlineto sw neg 0 rlineto
        closepath clip fill
        x y moveto
        0 setgray
        x y moveto
        show
    grestore
}def
/underline{
    dup
    /s exch def
    currentpoint /y exch def /x exch def
    /sw s stringwidth pop def
    1 setgray
    x y moveto
    sw 0 rlineto
    swidth setlinewidth
    stroke
    x y moveto
}def
ENDTEXT

IF (AT(CHR(176),uALL)<>0)
TEXT TO PRINT
/chr176{
    dup
    /s exch def
    currentpoint /y exch def /x exch def
    /sw s stringwidth pop def
    .2 setgray
    x y q sub moveto
    sw 0 rlineto 0 h rlineto sw neg 0 rlineto
    closepath
    fill
    1 setgray
    x y moveto
}def
ENDTEXT
ENDIF
IF (AT(CHR(177),uALL)<>0)
TEXT TO PRINT
/chr177{
    dup
    /s exch def
    currentpoint /y exch def /x exch def
    /sw s stringwidth pop def
    .4 setgray
    x y q sub moveto
    sw 0 rlineto 0 h rlineto sw neg 0 rlineto
    closepath
    fill
    1 setgray
    x y moveto
}def
ENDTEXT
ENDIF
IF (AT(CHR(178),uALL)<>0)
TEXT TO PRINT
/chr178{
    dup
    /s exch def
    currentpoint /y exch def /x exch def
    /sw s stringwidth pop def
    .7 setgray
    x y q sub moveto
    sw 0 rlineto 0 h rlineto sw neg 0 rlineto
    closepath
    fill
    1 setgray
    x y moveto
}def
ENDTEXT
ENDIF
IF (AT(CHR(24),uALL)<>0)
TEXT TO PRINT
/chr24{
    dup
    /s exch def
    currentpoint /y exch def /x exch def
    /sw s stringwidth pop def
    /xmid sw 2 div def
    swidth setlinewidth
    x y moveto
    xmid 0 rmoveto
    0 h q sub q sub q sub rlineto
    stroke
    x y moveto
    xmid h q sub q sub rmoveto
    q neg q neg rlineto q q add 0 rlineto
    closepath
    fill
    x y moveto
}def
ENDTEXT
ENDIF
IF (AT(CHR(25),uALL)<>0)
TEXT TO PRINT
/chr25{
    dup
    /s exch def
    currentpoint /y exch def /x exch def
    /sw s stringwidth pop def
    /xmid sw 2 div def
    swidth setlinewidth
    x y moveto
    xmid 0 rmoveto
    0 h q sub q sub rlineto
    stroke
    x y moveto
    xmid 0 rmoveto
    q q rlineto q neg q neg add 0 rlineto
    closepath
    fill
    x y moveto
}def
ENDTEXT
ENDIF
IF (AT(CHR(179),uALL)<>0)
TEXT TO PRINT
/chr179{
    dup
    /s exch def
    currentpoint /y exch def /x exch def
    /sw s stringwidth pop def
    /xmid sw 2 div def
    swidth setlinewidth
    x y q sub moveto
    xmid 0 rmoveto
    0 h rlineto
    stroke
    x y moveto
}def
ENDTEXT
ENDIF
IF (AT(CHR(180),uALL)<>0)
TEXT TO PRINT
/chr180{
    dup
    /s exch def
    currentpoint /y exch def /x exch def
    /sw s stringwidth pop def
    /xmid sw 2 div def
    swidth setlinewidth
    x y q sub moveto
    xmid 0 rmoveto
    0 h rlineto
    stroke
    x y moveto
    xmid halfh q sub rmoveto
    xmid neg 0 rlineto
    stroke
    x y moveto
}def
ENDTEXT
ENDIF
IF (AT(CHR(191),uALL)<>0)
TEXT TO PRINT
/chr191{
    dup
    /s exch def
    currentpoint /y exch def /x exch def
    /sw s stringwidth pop def
    /xmid sw 2 div def
    swidth setlinewidth
    x y moveto
    0 halfh q sub rmoveto
    xmid 0 rlineto 0 halfh neg rlineto
    stroke
    x y moveto
}def
ENDTEXT
ENDIF
IF (AT(CHR(192),uALL)<>0)
TEXT TO PRINT
/chr192{
    dup
    /s exch def
    currentpoint /y exch def /x exch def
    /sw s stringwidth pop def
    /xmid sw 2 div def
    swidth setlinewidth
    x y moveto
    sw halfh q sub rmoveto
    xmid neg 0 rlineto 0 halfh rlineto
    stroke
    x y moveto
}def
ENDTEXT
ENDIF
IF (AT(CHR(195),uALL)<>0)
TEXT TO PRINT
/chr195{
    dup
    /s exch def
    currentpoint /y exch def /x exch def
    /sw s stringwidth pop def
    /xmid sw 2 div def
    swidth setlinewidth
    x y q sub moveto
    xmid 0 rmoveto
    0 h rlineto
    stroke
    x y moveto
    xmid halfh q sub rmoveto
    xmid 0 rlineto
    stroke
    x y moveto
}def
ENDTEXT
ENDIF
IF (AT(CHR(196),uALL)<>0)
TEXT TO PRINT
/chr196{
    dup
    /s exch def
    currentpoint /y exch def /x exch def
    /sw s stringwidth pop def
    swidth setlinewidth
    x y q sub moveto
    0 halfh rmoveto
    sw 0 rlineto
    stroke
    x y moveto
}def
ENDTEXT
ENDIF
IF (AT(CHR(217),uALL)<>0)
TEXT TO PRINT
/chr217{
    dup
    /s exch def
    currentpoint /y exch def /x exch def
    /sw s stringwidth pop def
    /xmid sw 2 div def
    swidth setlinewidth
    x y moveto
    0 halfh q sub rmoveto
    xmid 0 rlineto 0 halfh rlineto
    stroke
    x y moveto
}def
ENDTEXT
ENDIF
IF (AT(CHR(218),uALL)<>0)
TEXT TO PRINT
/chr218{
    dup
    /s exch def
    currentpoint /y exch def /x exch def
    /sw s stringwidth pop def
    /xmid sw 2 div def
    swidth setlinewidth
    x xmid add y q sub moveto
    0 halfh rlineto xmid 0 rlineto
    stroke
    x y moveto
}def
ENDTEXT
ENDIF
TEXT TO PRINT
x y moveto                              % Create Shadow Box
chrl 3 mul q rmoveto
.8 setgray
chrl 82 mul 0 rlineto
0 27 h mul neg rlineto
chrl 82 mul neg 0 rlineto
closepath fill

x y moveto                              % Create Black Box Around
chrl neg pt 2 mul q add rmoveto
0 setgray
chrl 82 mul 0 rlineto
0 27 h mul neg rlineto
chrl 82 mul neg 0 rlineto
closepath fill

x y moveto                              % Create Hollow
0 pt rmoveto
1 setgray
chrl 80 mul 0 rlineto
0 25 h mul neg rlineto
chrl 80 mul neg 0 rlineto
closepath fill

x y moveto
%.........................................................................
ENDTEXT

SET PRINT ON
FOR X=1 TO 25
    mPREV = LEFT(uOCH[X],1)
    mSTR  = ""
    Y=1
    DO WHILE Y<=80
        mCHR = SUBSTR(uNCH[X],Y,1)
        IF mCHR<CHR(32) .OR. mCHR>CHR(126)
            mTYPE = ATTYPE(mPREV)
            IF LEN(mSTR)>0
                ? "("+mSTR+") "+mTYPE+" show"
            ENDIF
            mPREV = SUBSTR(uOCH[X],Y,1)
            mTYPE = ATTYPE(mPREV)
            IF mCHR=CHR(176)
                mTYPE="chr176"
            ENDIF
            IF mCHR=CHR(177)
                mTYPE="chr177"
            ENDIF
            IF mCHR=CHR(178)
                mTYPE="chr178"
            ENDIF
            IF mCHR=CHR(179)
                ? "( ) "+mTYPE+" chr179 show"
            ELSEIF mCHR=CHR(196)
                mCNT = 1
                mNEW = SUBSTR(uNCH[X],Y+1,1)
                DO WHILE mNEW=CHR(196) .AND. Y<=81
                    mCNT = mCNT + 1
                    Y = Y + 1
                    mNEW = SUBSTR(uNCH[X],Y+1,1)
                ENDDO
                ? "("+SPACE(mCNT)+") "+mTYPE+" chr196 show"
            ELSEIF mCHR=CHR(24)
                ? "( ) "+mTYPE+" chr24 show"
            ELSEIF mCHR=CHR(25)
                ? "( ) "+mTYPE+" chr25 show"
            ELSEIF mCHR=CHR(217)
                ? "( ) "+mTYPE+" chr217 show"
            ELSEIF mCHR=CHR(192)
                ? "( ) "+mTYPE+" chr192 show"
            ELSEIF mCHR=CHR(218)
                ? "( ) "+mTYPE+" chr218 show"
            ELSEIF mCHR=CHR(191)
                ? "( ) "+mTYPE+" chr191 show"
            ELSEIF mCHR=CHR(180)
                ? "( ) "+mTYPE+" chr180 show"
            ELSEIF mCHR=CHR(195)
                ? "( ) "+mTYPE+" chr195 show"
            ELSE
                mCNT = 1
                mPRE = mCHR
                mNEW = SUBSTR(uNCH[X],Y+1,1)
                DO WHILE (mNEW=mPRE) .AND. Y<=79
                    mCNT = mCNT + 1
                    Y = Y + 1
                    mNEW = SUBSTR(uNCH[X],Y+1,1)
                ENDDO
                ? "("+SPACE(mCNT)+") "+mTYPE+" show"
            ENDIF
            IF Y<=80
                mSTR =  ""
                mPREV = SUBSTR(uOCH[X],Y+1,1)
            ENDIF
        ELSE
            IF SUBSTR(uOCH[X],Y,1)=mPREV
                mSTR = mSTR+mCHR
            ELSE
                mTYPE = ATTYPE(mPREV)
                IF LEN(mSTR)>0
                    ? "("+mSTR+") "+mTYPE
                    IF mTYPE<>" flash"
                        ?? " show"
                    ENDIF
                ENDIF
                mSTR =  SUBSTR(uNCH[X],Y,1)
                mPREV = SUBSTR(uOCH[X],Y,1)
            ENDIF
        ENDIF
        Y=Y+1
    ENDDO
    mTYPE = ATTYPE(mPREV)
    IF LEN(mSTR)>0
        ? "("+mSTR+") "+mTYPE+" show"
    ENDIF
    mSTR =  SUBSTR(uNCH[X],Y,1)
    mPREV = SUBSTR(uOCH[X],Y,1)
    ? "nl"
NEXT X
? "%........................................................................."
IF ! mEPS
    ? "showpage"
ENDIF
SET CONSOLE ON
SET PRINT OFF
SET DEVICE TO SCREEN
SET PRINT TO
RESTORE SCREEN FROM uSCR
SETCOLOR(mCOLOUR)
RETURN
**************************************************************************
*
*    11111111
*     undelined (2&3=0)
*     normal (1&2&3=1)
*     
*    Bright
*    Ŀ
*    Inverted
*    
*    Flash
*
FUNCTION ATTYPE
LOCAL m1,m2,m3,m4,m5,m6,m7,m8,mSETS
PARAMETERS mP
mSETS=""
m1:=m2:=m3:=m4:=m5:=m6:=m7:=m8:=.F.
mP = ASC(mP)
IF mP>=128
    m8 = .T.
    mP -= 128
    RETURN(" flash")
ENDIF
IF mP>=64
    m7 = .T.
    mP -= 64
    mSETS = mSETS+" invert"
ENDIF
IF mP>=32
    m6 = .T.
    mP -= 32
ENDIF
IF mP>=16
    m5 = .T.
    mP -= 16
ENDIF
IF mP>=8
    m4 = .T.
    mP -= 8
ENDIF
IF mP>=4
    m3 = .T.
    mP -= 4
ENDIF
IF mP>=2
    m2 = .T.
    mP -= 2
    mSETS = mSETS+" norm"
ENDIF
IF mP>=1 .AND. !m2 .AND. !m3
    m1 = .T.
    mP -= 1
    mSETS = mSETS+" norm underline"
ENDIF
RETURN(mSETS)
