//  S_DEMO.PRG
//
//  Demonstration program for StarClass (tm)
//
//  Copyright (c) 1991-1994 by Loesgen Software, Inc.
//  All Worldwide Rights Reserved.

//  Written by Brian Loesgen, Paul McWhinnie

//  Version 3.0 (Released: March 1994)


// Clipper header files
#include "inkey.ch"
#include "setcurs.ch"
#include "directry.ch"
#include "getexit.ch"
#include "fileio.ch"

// StarClass header files
#include "starclas.ch"
#include "scwindow.ch"
#include "scmenu.ch"

#define SC_BACKGROUND   "StarClass 3.0" + SPACE( 15 )

#define CLR_DEMO       "W/B, N/W,,,G+/B"
#define CLR_PROMPT     "R+/B"
#define CLR_ERROR      "W+/R"
#define CLR_WARNING    "W/R"

#define AD_DEFAULT     3
#define CHR_ENTER      ""

STATIC nDelaySecs

// The following provide faster access to certain class objects
STATIC soMouse
STATIC soAppDefs
STATIC soDeskTop
STATIC soEventMgr

// The following are used by dmoCheck1()
STATIC saTopping, scBeverage, scPayment, scName, scSpecial

// The following are used by dmoGauge3()
STATIC oGaugeWin, oPulse, oBloodPres, oAlpha, oTemp
STATIC oHeartBeat, oIdle, oIdleMarque
STATIC slHasSeenGauge := FALSE

// The following is used by dmoRead3()
STATIC saData

// The following are used by the color configuration module and
// also by cycleColors
STATIC saColors     := {}
STATIC snColorIndex := 1
#define CLR_DESKTOP   1
#define CLR_BACK      2
#define CLR_HELPBAR   3

***********************************************************************
* FUNCTION main(<cDataPath>, [<nDelay>]) --> NIL
*
* Parameters  :
* Description : Main routine for StarClass Demo program.
***********************************************************************
FUNCTION main( cDataPath, nDelay )

   LOCAL nStart       := SECONDS()
   LOCAL nWhich
   LOCAL GetList
   LOCAL lDone, i
   LOCAL oBarMenu

   INIT STARCLASS  // for Clipper 5.01

   SETCANCEL( FALSE )

   PushVideo()

   DEFAULT cDataPath TO AssertPath( cDataPath )


   // ALTD(0)

   SCROLL()

   SETCOLOR( "w/b" )
   SETBLINK( FALSE )

   // Ensure we always start the demo in 25 line mode
   IF MAXROW() <> 24
      SETMODE( 25, 80 )
   ENDIF

   soAppDefs := AppDefs()

   SET MOUSE ON AT ROW 14 COLUMN 34
   soMouse := GetMouse()

   #ifndef LSI_TEST
      IF scIsVGA() .AND. YNConf( { "Welcome to the StarClass 3.0 demo!", "",;
                   "Would you like to run the demo with font remapping?"  }, TRUE )

         soAppDefs:selectSet( AD_SET_REMAPPED )
      ELSE
         soAppDefs:selectSet( AD_SET_NONREMAPPED )
      ENDIF
   #else
      soAppDefs:selectSet( AD_SET_REMAPPED )
   #endif

   soMouse:hide()
   SayCenter("Loading... Please wait...")

   SETKEY( K_ALT_C, {|| ConfirmQuit() } )

   IF nDelay <> NIL
      nDelay     := VAL( nDelay )
      nDelaySecs := nDelay
   ELSE
      nDelaySecs := 0
   ENDIF

   SET CURSOR OFF
   SET DELETED ON

   // Initialize the DESKTOP class
   soDeskTop                := DeskTop()
   soDeskTop:title          := "StarClass 3.0 Demo"
   soDeskTop:backGroundChar := SC_BACKGROUND
   soDeskTop:backColor      := "n/n*"
   soDeskTop:outlineBarMenu := TRUE
   soDeskTop:outlineHelpBar := TRUE
   soDeskTop:helpBarJustify := SC_JUSTIFY_CENTER
   soDeskTop:clock          := Clock():new(,,,, TRUE )

   // Set a file-wide static reference to the EVENTMGR class
   soEventMgr := EventMgr()

   // Create the demo's main menu
   oBarMenu := MainMenu()

   soDeskTop:mainMenu := oBarMenu

   OpeningScreen()

   soMouse:display()

   IF soMouse:active

      #ifndef LSI_TEST
         MessageBox( { "A mouse has been detected and will be enabled in parts of this demo.",;
                       "",;
                       "Due to the nature of this demo, and the fact that it controls the",;
                       "execution flow to a great degree, mouse support is less visible than",;
                       "it could be in a real application developed using StarClass.","",ContMsg()})

      #endif

      #ifdef DEMO

      IF ! soAppDefs:fontRemap .AND. ;
         YNConf({"Would you like to use the Funcky II","graphical mouse cursor?"})

         // Install the Funcky II graphical mouse cursor
         MessageBox({"If you experience any difficulties running the demo, ",;
                     "please try it again with the normal mouse cursor.","",ContMsg()},,10)

         m_reset()
         m_install( 1 )
         soMouse:initialize()
         soMouse:hide()

      ENDIF

      #endif

   ELSE

      MessageBox( { "A mouse has NOT been detected and therefore", ;
                    "will not be used in this demo.",              ;
                    "",                                            ;
                    "We will, however, leave the mouse icons on",  ;
                    "the windows",                                 ;
                    "",                                            ;
                    ContMsg() },, 10 )

   ENDIF


   // Open all data files used by the demo
   OpenDBFs( cDataPath )

   // Display the DeskTop
   soDeskTop:display()

   oBarMenu:configure()
   oBarMenu:addKeyEvent( K_ALT_F4, {|| soEventMgr:endPoll := TRUE } )

   oBarMenu:read()

   #ifdef LSI_TEST
      QUIT
   #endif

   dmoFinale()
   dmoGoodbye()

   EXIT STARCLASS  // for Clipper 5.01

   CLEAR
   QUIT

   RETURN ( NIL )


**
*                               Startup screens
**

***********************************************************************
* FUNCTION OpeningScreen() --> NIL
*
* Description : Displays the opening screen by "dissolving" the DeskTop
*               onto the screen.
***********************************************************************
STATIC FUNCTION OpeningScreen()

   LOCAL oOverLay

   oOverlay := Window():new( 0, 0, MAXROW(), MAXCOL(), "n/n", "n/n", NOBORDER )

   oOverlay:explode := FALSE

   DispBegin()

   soDeskTop:display()
   oOverlay:display()

   DispEnd()

   oOverlay:implode( 8 )
   oOverlay:kill()

   RETURN ( NIL )


***********************************************************************
* FUNCTION dmoStart() --> NIL
*
* Description : The initial welcome screen
***********************************************************************
STATIC FUNCTION dmoStart

   LOCAL oWin1      := Window():new( 8, 14, 18, 65, "W+/BG" )
   LOCAL GetList    := {}
   LOCAL nStartTime := SECONDS()
   LOCAL lDone      := FALSE
   LOCAL nKey

   FLUSH KEYBOARD

   soMouse:hide()

   @ 1,0 SAY "     << Welcome to a demo of StarClass(tm) >>       " COLOR "W+/B" IN oWin1
   @ 3,0 SAY "   Copyright (c) 1991-1994 Loesgen Software, Inc.   " IN oWin1
   @ 5,0 SAY "           All Worldwide Rights Reserved.           " IN oWin1

   oWin1:addMarquee( 8, 0, "Press any key to start the demo...", .1 )
   oWin1:display()

   DO WHILE ((nKey := GetInput()) = 0) .AND. ! soMouse:changed
      Window():displayMarquee()
   ENDDO

   oWin1:kill()

   soMouse:display()

   RETURN ( NIL )


**
*                                    Windows
**

***********************************************************************
* FUNCTION dmoIntro()
*
* Parameters  :
* Description : Display the introductory screen
* Returns     :
***********************************************************************
FUNCTION DmoIntro

   LOCAL oWin1      := Window():new( 6, 10, 19, 69, "w+/bg" )

   oWin1:title      := " Introduction to the Window Class "
   oWin1:titleColor := "w+/r"
   oWin1:frameColor := "r/bg"

   @  1, 1 SAY "    StarClass is heavily window-oriented               " IN oWin1
   @  3, 1 SAY "    All user input/activities happen in windows        " IN oWin1
   @  5, 1 SAY "    The Windows Class has an extensive set of methods  " IN oWin1
   @  7, 1 SAY "    Several classes are descendants of the Window      " IN oWin1
   @  8, 1 SAY "     class, meaning they also inherit the methods       " IN oWin1
   @ 10, 1 SAY " We will now see a demonstration of some of the Window  " COLOR CLR_DEMO IN oWin1
   @ 11, 1 SAY " methods in action.                                     " COLOR CLR_DEMO IN oWin1
   @ 11,21 SAY ContMsg() COLOR CLR_PROMPT IN oWin1

   oWin1:display()

   FLUSH KEYBOARD
   GetInput( nDelaySecs )

   oWin1:kill()

   RETURN ( NIL )


***********************************************************************
* FUNCTION dmoTitle()
*
* Parameters  :
* Description :  Display various Window title styles
* Returns     :
***********************************************************************
FUNCTION dmoTitle

   LOCAL oText      := Window():new( 6,  10, 17, 67, "w+/bg" )
   LOCAL o1         := Window():new( 2,   3,  5, 28, "w+/b"  )
   LOCAL o2         := Window():new( 2,  45,  5, 76, "w+/b"  )
   LOCAL o3         := Window():new( 13,  3, 16, 28, "w+/b"  )
   LOCAL o4         := Window():new( 13, 45, 16, 76, "w+/b"  )
   LOCAL o5         := Window():new( 18, 18, 22, 62, "w+/b"  )
   LOCAL nIndex     := 1
   LOCAL lDone      := FALSE
   LOCAL nStartTime := SECONDS()
   LOCAL nKey
   LOCAL aTitles := { " Window 1 ", " Text Window ", " Client Record ", ;
                    "< Inventory File >", " Employees "}

   soMouse:hide()

   oText:title := " Window 1 "  // so it has a title for the initial ::display()
   oText:titleColor := "n/w*"
   oText:frameColor := "w+/bg"
   @ 1, 1 SAY "Windows can have optional titles, which, if present,  " IN oText
   @ 2, 1 SAY "will be displayed in a position determined by the     " IN oText
   @ 3, 1 SAY '"titleStyle" instance variable.                       ' IN oText
   @ 5, 1 SAY "The title can be changed at any time by assigning a   " IN oText
   @ 6, 1 SAY 'new string to the "title" instance variable, as we are' IN oText
   @ 7, 1 SAY "doing now.                                            " IN oText
   @ 9, 1 SAY PAD( ContMsg(), 54 ) COLOR CLR_PROMPT IN oText
   oText:display()

   FLUSH KEYBOARD
   DO WHILE ( nKey := GetInput(.3) ) == 0 .AND. ! soMouse:changed
      oText:title := aTitles[ nIndex ]
      nIndex := IF( nIndex+1 > LEN( aTitles ), 1, nIndex+1 )
      oText:display()
   ENDDO

   oText:implode( 8 )
   oText:resize( 7, 10, 11, 67 )
   oText:winSay( 1, 1, "These are the 5 different pre-defined titleStyles" )
   oText:winSay( 2, 1, "from which you can choose." )
   oText:title := "Window:title Demo"

   o1:winSay( 1, 1, "Left justified" )
   o1:frameColor := o1:titleColor := "bg/b"
   o1:title      := " Title Style 1 "
   o1:titleStyle := SC_TITLESTYLE_LEFTJUST
   o1:frameChars := SNGLBORD
   o1:display()

   o2:winSay( 1, 1, "Centered in a bar" )
   o2:titleColor := "w+/bg"
   o2:frameColor := "bg/b"
   o2:frameChars := SNGLBORD
   o2:title      := " Title Style 2 "
   o2:titleStyle := SC_TITLESTYLE_CENTERED
   o2:display()

   o3:winSay( 1, 1, "Right Justified" )
   o3:frameColor := "bg/b"
   o3:titleColor := "b/bg"
   o3:frameChars := SNGLBORD
   o3:title      := " Title Style 3 "
   o3:titleStyle := SC_TITLESTYLE_RIGHTJUST
   o3:display()

   o4:winSay( 1, 1, "Centered in the frame" )
   o4:frameColor := "bg/b"
   o4:titleColor := "w+/b"
   o4:frameChars := SNGLBORD
   o4:title      := " Title Style 4 "
   o4:titleStyle := SC_TITLESTYLE_CENTERED_INLINE
   o4:display()


   o5:winSay( 1, 1, "Centered in the frame, with window controls" )
   o5:setEventHandlers()
   o5:frameColor := "bg/b"
   o5:titleColor := "n/bg"
   o5:title      := "Title Style 5"
   o5:titleStyle := SC_TITLESTYLE_WINDOWS
   o5:display()

   oText:display()
   FLUSH KEYBOARD
   GetInput( nDelaySecs )

   oText:implode(8)
   oText:clear()
   oText:winSay( 1, 1, "The titleStyle can be set from the AppDefs class," )
   oText:winSay( 2, 1, "making global changes simple." )
   oText:display()

   FLUSH KEYBOARD
   GetInput( nDelaySecs )
   oText:implode( 8 )

   oText:kill()
   o1:kill() ; o2:kill() ; o3:kill() ; o4:kill() ; o5:kill()

   soMouse:display()

   RETURN ( NIL )



***********************************************************************
* FUNCTION dmoColor()
*
* Parameters  :
* Description :  Demonstrate Window colors
* Returns     :
***********************************************************************
FUNCTION dmoColor

   LOCAL oWin1       := Window():new(  6, 5, 12, 63 )
   LOCAL oWin2       := Window():new( 11, 7, 15, 61, CLR_DEMO )
   LOCAL aBackColors := { "B*", "G", "BG", "GR*", "BR", "W", "N*" }
   LOCAL aColors     := { "W+/B", "G+/B", "R+/B",  "B+/B", "N/B", "GR/B", "W/B", }
   LOCAL aForeColors := { "W+", "G+", "R+",  "B+", "N", "GR", "W" }
   LOCAL nForeIndex  := 1
   LOCAL nBackIndex  := 1
   LOCAL nStartTime  := SECONDS()
   LOCAL nKey, cThisColor

   soMouse:hide()

   @ 1, 1 SAY "Colors can be changed at any time simply by reassigning " IN oWin1
   @ 2, 1 SAY "the ::frameColor and ::paneColor instance variables.    " IN oWin1

   @ 0, 1 SAY "Notice that this window is NOT changing colors.   " IN oWin2
   @ 2, 1 SAY  PAD( ContMsg(), 54 ) COLOR CLR_PROMPT               IN oWin2
   oWin1:title := " Color Demonstration "
   Window():displayAll()
   FLUSH KEYBOARD
   DO WHILE (nKey := GetInput(.3)) == 0 .AND. ! soMouse:changed

      oWin1:paneColor := oWin1:frameColor := oWin1:titleColor ;
         ( cThisColor := aForeColors[ nForeIndex ] + "/" +   ;
                         aBackColors[ nBackIndex ] )

      // change the color of all text strings to match the ::paneColor
      AEVAL( oWin1:says, {|ele| ele:color := cThisColor} )
      oWin1:paneColor := oWin1:frameColor := oWin1:titleColor := cThisColor
      IF ++ nForeIndex > LEN( aForeColors )
        nForeIndex := 1
        nBackIndex := IF( nBackIndex + 1 > LEN( aBackColors ), 1, nBackIndex + 1 )
      ENDIF

      Window():refresh()

   ENDDO
   oWin2:kill()

   oWin1:resize( 6, 10, 12, 68 )
   oWin1:title        := " Selectable Text Colors "
   oWin1:titleColor   := "w+/b*"
   oWin1:frameColor   := "b+/b"
   oWin1:paneColor    := CLR_DEMO
   @ 1, 1 SAY "Note that text in a window can be in a color other than " ;
          COLOR CLR_DEMO IN oWin1
   @ 2, 1 SAY "the ::frameColor and ::paneColor.                       " ;
          COLOR CLR_DEMO IN oWin1
   @ 4, 1 SAY  PAD( ContMsg(), 54 )  COLOR CLR_PROMPT IN oWin1
   oWin1:display()

   nForeIndex := 1
   nStartTime := SECONDS()

   FLUSH KEYBOARD

   DO WHILE ( nKey := GetInput( .3 ) ) == 0 .AND. ! soMouse:changed

      oWin1:winSayAgain( 1, 40, "color",        aColors[ nForeIndex ] )
      oWin1:winSayAgain( 2,  5, "::frameColor", aColors[ nForeIndex ] )
      oWin1:winSayAgain( 2, 22, "::paneColor",  aColors[ nForeIndex ] )
      nForeIndex := IF( nForeIndex + 1 > LEN( aColors ), 1, nForeIndex + 1 )
      Window():refresh()

   ENDDO

   oWin1:kill()

   soMouse:display()

   RETURN ( NIL )


***********************************************************************
* FUNCTION dmoDepth()
*
* Parameters  :
* Description :  Demonstrate Window depth movement
* Returns     :
***********************************************************************
FUNCTION dmoDepth
   LOCAL oWin1, oWin2, oWin3, oWin4
   LOCAL nStartTime := SECONDS()
   LOCAL nKey
   LOCAL oCurrent

   FLUSH KEYBOARD

   soMouse:hide()

   // set a default titleStyle value for these windows
   soAppDefs:titleStyle := SC_TITLESTYLE_WINDOWS

   oWin1              := Window():new( 5, 10, 10, 45, "w/gr" )
   oWin1:title        := " Window 1 "
   oWin1:frameColor   := "w/gr"
   oWin1:frameFcColor := "w+/gr"
   @0,1 SAY "Just a window with some text..." in oWin1

   oWin2              := Window():new( 7, 20, 12, 55, "+/gr*" )
   oWin2:title        := " Window 2 "
   oWin2:titleColor   := "n/g"
   oWin2:titleFcColor := "r/g*"
   oWin2:frameColor   := "g/gr*"
   oWin2:frameFcColor := "g+/gr*"

   @0,1 SAY "Well HELLO World!"             IN oWin2
   @2,1 SAY "This is text in Window 2 "     IN oWin2
   @3,1 SAY "   ... and this is more text." IN oWin2

   oWin3              := Window():new( 9, 30, 13, 65, "w+/r" )
   oWin3:titleColor   := "n/w"
   oWin3:titleFcColor := "n/w*"
   oWin3:frameColor   := "w/r"
   oWin3:frameFcColor := "w+/r"
   oWin3:title        := " Window 3 "
   @1,1 SAY "More text in Window 3..." in oWin3

   oWin4              := Window():new(20, 2, 22, 77, CLR_DEMO)
   oWin4:frameFcChars := oWin4:frameFcChars
   oWin4:frameFcColor := oWin4:frameColor
   @0,1  SAY "Demo of Depth movement (.5 second delay)." IN oWin4
   @0,45 SAY ContMsg()  COLOR CLR_PROMPT IN oWin4

   oWin1:display() ; delay(30)
   oWin2:display() ; delay()
   oWin3:display() ; delay()
   oWin4:display() ; delay()

   FLUSH KEYBOARD

   oWin1:setFocus()
   DO WHILE GetInput( .5 ) == 0

      oCurrent := soEventMgr:currentEntity

      DO CASE
         CASE oCurrent == oWin1
              oWin2:setFocus()
         CASE oCurrent == oWin2
              oWin3:setFocus()
         CASE oCurrent == oWin3
              oWin1:setFocus()
      ENDCASE

   ENDDO

   Window():killAll()
   soMouse:display()

   RETURN ( NIL )


***********************************************************************
* FUNCTION dmoZoom()
*
* Parameters  :
* Description :  Demonstrate Window zooming
* Returns     :
***********************************************************************
FUNCTION dmoZoom
   LOCAL oWin1 := Window():new( 5, 5, 10, 60, CLR_DEMO )
   LOCAL r     := 4
   LOCAL cName
   LOCAL lDone := FALSE, nStartTime := SECONDS()
   LOCAL nKey

   @0,1 SAY "The ZOOM method toggles the window size between       " IN oWin1
   @1,1 SAY "the size it was created as and full-screen.           " IN oWin1
   @3,1 SAY "Press any key to ZOOM this window, <Esc> when done...." COLOR CLR_PROMPT IN oWin1

   oWin1:display()
   soMouse:hide()
   FLUSH KEYBOARD

   DO WHILE GetInput( nDelaySecs/3 ) <> K_ESC .AND. ! lDone

      IF ! soMouse:changed  // ignore the mouse for this part of the demo
         oWin1:zoom()
      ENDIF

      lDone := ( LASTKEY() == K_ESC )
   ENDDO

   oWin1:kill()

   // zoom part 2
   lDone := FALSE ; nStartTime := SECONDS()
   oWin1 := Window():new( 5, 5,7,60,CLR_DEMO)
   cName := "John Smith    "

   @0,1 SAY "Press any key to Zoom..." COLOR "bg/b" IN oWin1

   @ 3,1 SAY "You can also write text to coordinates outside of the current window" IN oWin1
   @ 4,1 SAY "boundaries. That text will then become visible when the window is zoomed" IN oWin1
   @ 5,1 SAY "or the window is resized to include it." IN oWin1
   @ 7,1 SAY "One possible application of this is to include help in your read windows," IN oWin1
   @ 8,1 SAY "but write the text outside of the normally displayed area. Pressing a ZOOM" IN oWin1
   @ 9,1 SAY "hotkey would bring the text into view without affecting the READ." IN oWin1
   @11,1 SAY "Another application would be to avoid screen clutter in a READ window. Just" IN oWin1
   @12,1 SAY "show something unique in the ZOOMed down window, say ITEM #. If the user" IN oWin1
   @13,1 SAY "wants more information they can ZOOM into it." IN oWin1
   @15,1 SAY "Press any key to toggle ZOOM state, <Esc> to continue..." COLOR CLR_PROMPT IN oWin1
   oWin1:zoom()
   oWin1:display()

   nStartTime := SECONDS()
   DO WHILE GetInput( nDelaySecs/3 ) <> K_ESC .AND. !lDone
      IF ! soMouse:changed
         oWin1:zoom()
      ENDIF
      lDone := ( LASTKEY() == K_ESC )
   ENDDO

   oWin1:kill()
   soMouse:display()

   RETURN ( NIL )


***********************************************************************
* FUNCTION dmoHide()
*
* Parameters  :
* Description :  Demonstrate Window hiding effects
* Returns     :
***********************************************************************
FUNCTION dmoHide
   LOCAL oText := Window():new( 16,  2, 23, 56, CLR_DEMO )
   LOCAL oWin2 := Window():new( 10, 30, 13, 60, "w+/g"   )
   LOCAL oWin3 := Window():new(  8, 12, 15, 49, "n/bg"   )
   LOCAL v1    := "Dave      "
   LOCAL v2    := "Smith         "
   LOCAL v3    := "17 - 32nd Street       "
   LOCAL v4    := "Smalltown, USA         "
   LOCAL v5    := "12345-1234"

   LOCAL nMode

   soMouse:hide()

   oWin2:title := " Window 2 " ; oWin3:title := " Window 3 "

   oWin2:titleColor := oWin2:titleFcColor := "n/w*"

   @ 1,1 SAY "Just another window" CENTERED IN oWin2

   @ 1,  1  SAY "Name: "                                IN oWin3
   @ 1, 10  GET v1                                      IN oWin3
   @ 1, 21  GET v2                                      IN oWin3
   @ 2,  1  SAY ""  IN oWin3
   @ 3,  1  SAY "Address: " GET v3                      IN oWin3
   @ 4, 10  GET v4                                      IN oWin3
   @ 5, 10  GET v5                                      IN oWin3
   oWin3:frameFcColor :=  oWin3:frameColor := "w+/bg"
   oWin3:titleFcColor :=  oWin3:titleColor := "n/w*"

   @ 0, 1 SAY "There are several different ways to hide a window." IN oText
   @ 2, 1 SAY "The simplest is the HIDE method which simply makes" IN oText
   @ 3, 1 SAY "it invisible (as well as any SAYs and GETs)."       IN oText
   @ 5, 1 SAY ContMsg() COLOR CLR_PROMPT IN oText

   oText:display()
   oWin2:display()
   oWin3:display()

   FLUSH KEYBOARD
   GetInput( nDelaySecs )
   oWin3:hide()
   oWin2:hide()
   oText:clear()

   oWin2:explode := FALSE
   oWin3:explode := FALSE

   oText:resize( 18,, 22, 72 )

   @ 0,1 SAY "But who wants to just make a window disappear when we have effects?" IN oText

   FOR nMode = 1 TO 8
       oText:WinSayAgain( 2, 15, " << Now doing implode mode "+LTRIM(STR(nMode))+" >>","GR+/B")

       DispBegin()
       oText:display()
       oWin2:display()
       oWin3:display()
       DispEnd()

       GetInput( 1 )

       Window():topmost:implode(nMode)
       Window():topmost:implode(nMode)

   NEXT

   soMouse:display()

   oText:kill()
   oWin2:kill()
   oWin3:kill()

   RETURN ( NIL )


***********************************************************************
* FUNCTION dmoSend()
*
* Description :  Demonstrate the Window send method
* Returns     :
***********************************************************************
FUNCTION dmoSend()
   // demo the SEND method
   LOCAL box1, box2, oText
   LOCAL cntr       := 1
   LOCAL nStartTime := SECONDS()

   FLUSH KEYBOARD

   soMouse:hide()

   box1  := Window():new( 5, 5, 15, 38, "W+/BG" )
   box2  := Window():new( 5, 42, 15, 75, "n/BG" )
   oText := Window():new( 17, 5, 22, 75, CLR_DEMO )

   oText:winSay(0,1, "The SEND method allows you to easily create status type windows")
   oText:winSay(1,1, "which can be used to inform your users of activities being done")
   oText:winSay(3,1, ContMsg() , CLR_PROMPT)
   oText:display()

   DO WHILE GetInput(.7) == 0 .AND. ! soMouse:changed
      DO CASE
         CASE cntr = 1
              box1:send(time()+" -- Indexing...")
              box2:send("Satellite link complete")
         CASE cntr = 2
              box1:send(time()+" -- Backing up...")
              box2:send(time()+" -- Indexing over here...")
         CASE cntr = 3
              box1:send(time()+" -- Reporting...")
         CASE cntr = 4
              box1:send(time()+" -- Taking a break...")
              box2:send(time()+" -- Erasing myself...","r+/b")
         CASE cntr = 5
              box2:send(time()+" -- Recovering myself...")
      ENDCASE
      cntr++
      cntr := IF( cntr > 5, 1, cntr )
   ENDDO

   Window():killAll()
   soMouse:display()

   RETURN ( NIL )


***********************************************************************
* FUNCTION dmoMarquee()
*
* Parameters  :
* Description :  Demonstrate Window marquees
* Returns     :
***********************************************************************
FUNCTION dmoMarquee
   // Marquee demo
   LOCAL oWin1 := Window():new(  7,  7, 11, 42, "w/b"    )
   LOCAL oWin2 := Window():new( 10, 30, 13, 60, "w+/r"   )
   LOCAL oWin3 := Window():new(  9, 16, 19, 46, "g/bg", "g+/bg" )
   LOCAL oWin4 := Window():new( 15, 20, 18, 54, "w+/*", "r/*"   )
   LOCAL factor, cString, cString2, cString3, nKey
   LOCAL nStartTime := SECONDS()

   FLUSH KEYBOARD

   oWin1:title := " Window 1 " ; oWin2:title := " Window 2 "
   oWin3:title := " Window 3 " ; oWin4:title := " Window 4 "

   oWin1:titleColor := "n/w"
   oWin2:titleColor := "n/w+"
   oWin3:titleColor := "n/g"
   oWin4:titleColor := "w+/r"

   cString := "This is the Marquee class...  Each window can contain Marquee objects, _at least_ one per line... They scroll through....  FOREVER...."
   cString2 := "Each MARQUEE object can has an ::INTERVAL exported instance variable, which allows you to set a minimum period between updates.... "
   cString3 := " Look at this effect! "
   oWin1:addMarquee( 0, 0, " " + cString )
   oWin1:addMarquee( 1, 0, "  " + cString )
   oWin1:addMarquee( 2, 0, "   " + cString )
   oWin2:addMarquee( ,,cString )
   factor := (oWin3:right - oWin3:left) / 2

   oWin3:addMarquee( 0,      0, cString3, 0, factor+1, "W+/BG")
   oWin3:addMarquee( 0, factor, cString3, 0, factor+1, "GR+/BG")

   oWin4:addMarquee( ,,cString )
   @3,0 SAY " Press any key to continue...     " COLOR "*"+CLR_PROMPT IN oWin3

   Window():displayAll()
   soMouse:hide()

   DO WHILE (nKey := GetInput()) == 0 .AND. !soMouse:changed
      Window():displayMarquee()
   ENDDO

   Window():killAll()
   soMouse:display()

   RETURN ( NIL )

**
*  Reads
**

***********************************************************************
* FUNCTION dmoRead()
*
* Parameters  :
* Description :  Demonstrate Window forms
* Returns     :
***********************************************************************
FUNCTION dmoRead

   LOCAL oWin1 := Window():new(4, 10, 19, 66, "w+/r")
   LOCAL memvar1, memvar2, r, offset, nStartTime := SECONDS()

   FLUSH KEYBOARD

   oWin1:frameFcColor := "w+/r"

   oWin1:title := "This is a Read Window"
   oWin1:frameFcColor := "w+/r"
   @ 0,1 SAY "As well as text, which is added to a Window with     " in oWin1
   @ 2,1 SAY "    @ <row>, <col> SAY <text> IN <window>            " in oWin1
   @ 4,1 SAY "We can also have GETs:                               " in oWin1
   @ 6,1 SAY "    @ <row>, <col> GET <text> IN <window>            " in oWin1
   @ 8,1 SAY "... which also support all the clauses that you're   " in oWin1
   @ 9,1 SAY "used to (VALID, COLOR, WHEN, etc...).                " in oWin1
   @11,1 SAY "We are now doing a READ inside this window....       " in oWin1
   memvar1 := "think  " ; memvar2 := "am     "
   @13, 6 SAY "I "             GET memvar1 IN oWin1
   @13,14 SAY ", therefore I " GET memvar2 IN oWin1

   @13,36 say "(in Living Color!)" IN oWin1
   r := 13 ; offset := 46
   oWin1:winSayAgain(r, offset+1, "C", "gr+/r")
   oWin1:winSayAgain(r, offset+2, "o", "bg+/r")
   oWin1:winSayAgain(r, offset+3, "l", "n+/r")
   oWin1:winSayAgain(r, offset+4, "o", "b+/r")
   oWin1:winSayAgain(r, offset+5, "r", "g+/r")
   oWin1:read()

   oWin1:kill()

   RETURN ( NIL )


***********************************************************************
* FUNCTION dmoRead2()
*
* Parameters  :
* Description :  Demonstrate Window forms - Part 2
* Returns     :
***********************************************************************
FUNCTION dmoRead2

   // put a browse window on the screen, when <enter> is pressed, bring up
   // a READ window

   LOCAL oRead   := CreateRead( 1 )
   LOCAL oBrowse := CreateTB( 1 )
   LOCAL oText   := Window():new( 14, 5, 17, 45, CLR_DEMO )

   FLUSH KEYBOARD

   oRead:title        := " Edit Customer "
   oRead:explode      := FALSE

   oBrowse:title := " Browse Customer "
   oBrowse:allowDelete := oBrowse:allowAppend := oBrowse:autoseek := FALSE
   oBrowse:showVBar := TRUE
   oBrowse:showHBar := TRUE

   @ 0,1 SAY "Press <enter> to bring up Read window"  IN oText
   @ 1,1 SAY "or press <Esc> to continue...        "  IN oText

   // ta daa.....
   ON ENTER IN oBrowse oRead:read():hide()
   oText:display()

   people->( dbGotop() )
   oBrowse:browse()

   DispBegin()
   oText:resize( oText:top+1,, 20, 65 )
   oText:clear()
   oText:winSay( 0, 1, "The association of the read window to the browse window" )
   oText:winSay( 1, 1, "that you just saw was installed by the following UDC:" )
   oText:winSay( 3, 2, "  ON ENTER IN oBrowse oRead:read():hide()  ", "n/bg")
   oText:winSay( 5, 1, ContMsg(), CLR_PROMPT)
   oText:display()
   DispEnd()

   FLUSH KEYBOARD
   GetInput( nDelaySecs * 2 )
   Window():killAll()

   RETURN ( NIL )


***********************************************************************
* FUNCTION dmoRead3() --> NIL
*
* Parameters  :
* Description :
***********************************************************************
STATIC FUNCTION dmoRead3()

   LOCAL oWin
   LOCAL lStartExplode      := soAppDefs:explode
   LOCAL cStartBtnColorSpec := soAppDefs:btnColorSpec
   LOCAL cStartColor        := SETCOLOR()

   soAppDefs:explode      := FALSE
   soAppDefs:btnColorSpec := "n/bg,w+/rb,n+/w,r+/bg,g+/rb"

   oWin := Window():stdWin( 3, 2, 17, 76 )

   oWin:title := " People "
   oWin:modal := TRUE

   // Set colors for GETs
   SETCOLOR( "w/n,w+/rb,,,n/bg" )

   @  2, 2 SAY "First name : " GET saData[ people->( FIELDPOS( "first_name" ) ) ] IN oWin
   @  4, 2 SAY "Last name  : " GET saData[ people->( FIELDPOS( "last_name"  ) ) ] IN oWin

   @  6, 2 SAY "Address    : " GET saData[ people->( FIELDPOS( "address_1"  ) ) ] IN oWin
   @  7, 15                    GET saData[ people->( FIELDPOS( "address_2"  ) ) ] IN oWin

   @  2,52 BUTTON "    ~Edit    "                                         ;
           ACTION oWin:read()                                             ;
           WHEN ! oWin:active()                                           ;
           HELPMESSAGE "Edit the current record"                          ;
           IN oWin

   @  4,52 BUTTON "    ~Save    "                                         ;
           ACTION {|| GetActive():exitState := GE_WRITE,                  ;
                    Message():new( {|| Gather( saData ) } ):post() }      ;
           WHEN oWin:active                                               ;
           HELPMESSAGE "Save changes"                                     ;
           NOREAD  IN oWin

   @  6,52 BUTTON "   ~Abort    "                                         ;
           ACTION ( saData := Scatter(), oWin:abort() )                   ;
           WHEN oWin:active                                               ;
           HELPMESSAGE "Abort changes"                                    ;
           NOREAD IN oWin

   @  8,52 BUTTON "  ~Previous  "                                         ;
           ACTION PrevRecord()                                            ;
           WHEN ! oWin:active                                             ;
           HELPMESSAGE "Move to the <previous> record"                    ;
           NOREAD IN oWin

   @ 10,52 BUTTON "    ~Next    "                                         ;
           ACTION NextRecord()                                            ;
           WHEN ! oWin:active                                             ;
           HELPMESSAGE "Move to the <next> record"                        ;
           NOREAD IN oWin

   GO TOP
   saData := Scatter()

   oWin:setFocus()
   oWin:display()

   oWin:addKeyEvent( K_ESC, {|| oWin:kill() } )

   soAppDefs:explode      := lStartExplode
   soAppDefs:btnColorSpec := cStartBtnColorSpec

   SETCOLOR( cStartColor )

   RETURN ( NIL )


***********************************************************************
* FUNCTION PrevRecord() --> NIL
*
* Description :
***********************************************************************
STATIC FUNCTION PrevRecord()

   LOCAL oGet

   IF ! BOF()
      SKIP -1
      saData := Scatter()
   ELSE
      TONE( 350, 1 )
      DeskTop():setMessage( "START OF FILE", "w+/r" )
      SKIP
   ENDIF

   RETURN ( NIL )


***********************************************************************
* FUNCTION NextRecord() --> NIL
*
* Description :
***********************************************************************
STATIC FUNCTION NextRecord()

   LOCAL oGet

   IF ! EOF()
      SKIP 1
      IF ! EOF()
         saData := Scatter()
      ELSE
         TONE( 350, 1 )
         DeskTop():setMessage( "END OF FILE", "w+/r" )
         SKIP -1
      ENDIF
   ENDIF

   RETURN ( NIL )


***********************************************************************
* FUNCTION dmoCheck1() --> NIL
*
* Description :
***********************************************************************
FUNCTION dmoCheck1()

   #define TXT_COKE           "Coke"
   #define TXT_DIETCOKE       "Diet Coke"
   #define TXT_ORANGE         "Root Beer"
   #define TXT_ROOTBEER       "Orange"
   #define TXT_MILK           "Milk"

   #define TXT_CASH           "Cash"
   #define TXT_VISA           "Visa"
   #define TXT_AMEX           "American Express"
   #define TXT_MC             "M/C"

   #define T_ONIONS     1
   #define T_KETCHUP    2
   #define T_PICKLES    3
   #define T_TOMATOES   4
   #define T_RELISH     5
   #define T_SAUCE      6
   #define T_CHEESE     7
   #define TOPPING_ARRAY_LEN  7

   LOCAL oWin1
   LOCAL aPayment  := { TXT_CASH, TXT_VISA, TXT_AMEX, TXT_MC }
   LOCAL aBeverage := { TXT_COKE, TXT_DIETCOKE, TXT_ROOTBEER, TXT_ORANGE, TXT_MILK }

   ResetVars()

   oWin1 := Window():new( 3, 8, 23, 70 )

   oWin1:title        := " StarClass Burger Manifest "
   oWin1:titleStyle   := SC_TITLESTYLE_WINDOWS
   oWin1:titleFcColor := "N/W*"
   oWin1:name         := "BURGER_WIN"
   oWin1:modal        := TRUE

   @ 01, 04 SAY "Enter your name : " GET scName COLOR "N/W,N/W" IN oWin1

   BEGIN TAB GROUP IN oWin1

   // Add some CheckBox objects to the window
   @  5, 6 GET saTopping[ T_ONIONS   ] CHECKBOX "~Onions        " IN oWin1
   @  6, 6 GET saTopping[ T_KETCHUP  ] CHECKBOX "~Ketchup       " IN oWin1
   @  7, 6 GET saTopping[ T_PICKLES  ] CHECKBOX "~Pickles       " IN oWin1
   @  8, 6 GET saTopping[ T_TOMATOES ] CHECKBOX "~Tomatoes      " IN oWin1
   @  9, 6 GET saTopping[ T_RELISH   ] CHECKBOX "Re~lish        " IN oWin1
   @ 10, 6 GET saTopping[ T_SAUCE    ] CHECKBOX "Special ~Sauce " IN oWin1
   @ 11, 6 GET saTopping[ T_CHEESE   ] CHECKBOX "Ch~eese        " IN oWin1

   END TAB GROUP IN oWin1

   AEVAL( oWin1:gets, {|g| g:toggleAction := {|| CheckTopping( oWin1, oWin1:frames[1] ) } }, ;
       LEN(oWin1:gets) - 6, 7 )

   @ 05, 40 GET scBeverage RADIO aBeverage COLOR "W/B,W+/RB" IN oWin1

   @ 15, 8  GET scPayment RADIO aPayment COLOR "N/BG,W+/BG" ;
             HORIZONTAL IN oWin1

   // Radio button and Check box frames
   @  3, 3, 12, 32 FRAME COLOR "BG/B" ;
                   TITLE " Toppings " ;
                   TITLECOLOR "W+/R"  ;
                   IN oWin1

   @  3,37, 10, 58 FRAME TITLE " Beverage " ;
                   TITLESTYLE 2             ;
                   IN oWin1

   @ 13, 3, 16, 58 FRAME SNGLBORD           ;
                   COLOR "N/BG"             ;
                   TITLE " Payment Type "   ;
                   TITLESTYLE 3             ;
                   IN oWin1

   @ 18, 4 SAY "Special Instructions : " GET scSpecial COLOR "N/W,N/W" IN oWin1

   @  1,48 BUTTON "   ~Read   "  ;
           ACTION oWin1:read()   ;
           WHEN   ! oWin1:active ;
           NOREAD                ;
           IN oWin1

   @ 11,37 BUTTON "     Clear ~Form      "  ;
           ACTION ResetVars( oWin1 )        ;
           WHEN   oWin1:active              ;
           NOREAD                           ;
           IN oWin1

   oWin1:setFocus()
   oWin1:display()

   oWin1:addKeyEvent( K_ESC, {|| oWin1:kill(), soEventMgr:endPoll := TRUE } )

   soDeskTop:setMessage( 'Click on "Read" or press Alt+R, press <Esc> when done' )

   //Invoke a secondary event loop
   Run()

   soDeskTop:setMessage( "" )

   IF EMPTY( scPayment )
      MessageBox("If you're not going to pay, you won't get your burger!", "w+/r")
   ENDIF

   RETURN ( NIL )


***********************************************************************
* FUNCTION CheckTopping() --> TRUE
*
* Description :
***********************************************************************
STATIC FUNCTION CheckTopping( oWin, oFrame )

   LOCAL i, nToppings := 0

   FLUSH KEYBOARD

   FOR i := 1 TO TOPPING_ARRAY_LEN
      IF saTopping[ i ]
         nToppings ++
      ENDIF
   NEXT

   IF nToppings == TOPPING_ARRAY_LEN
      oFrame:title      := " Toppings: The WORKS! "
      oFrame:frameColor := "bg+/b"
   ELSE
      oFrame:title := " Toppings "
      oFrame:frameColor := "bg/b"
   ENDIF
   DispBegin()
   oFrame:display( oWin:top, oWin:left )
   DispEnd()

   RETURN ( TRUE )


***********************************************************************
* FUNCTION ResetVars(<oWin>) --> NIL
*
* Parameters  :
* Description : Reset STATIC vars.
***********************************************************************
STATIC FUNCTION ResetVars( oWin )

   saTopping := ARRAY( TOPPING_ARRAY_LEN )
   AFILL( saTopping, FALSE )

   scPayment  := ""
   scBeverage := ""

   scName     := SPACE( 20 )
   scSpecial  := SPACE( 32 )

   IF oWin <> NIL
      AEVAL( oWin:activeGets, ;
         {|g| IF( g:class == BaseGet(), g:updateBuffer, NIL ) } )

      CheckTopping( oWin, oWin:frames[1] )
   ENDIF


   RETURN ( NIL )


***********************************************************************
* FUNCTION dmoCheck2
*
* Parameters  :
* Description :
*
* Returns     : NIL
***********************************************************************
FUNCTION dmoCheck2()

   #define CHOICES_TEXT                1
   #define CHOICES_FLAG                2
   #define CHOICES_PATH                3
   #define CHOICES_RESULT              4
   #define CHOICES_BLOCK               5
   #define CHOICES_SELECTABLE_COLOR    "/w, n/g"
   #define CHOICES_UNSELECTABLE_COLOR  "n+/w,n+/w"

   #define CHOICES_TXT_ALL              "All Entries"
   #define CHOICES_TXT_A_TO_M           "A to M"
   #define CHOICES_TXT_N_TO_Z           "N to Z"


   LOCAL oWin         := Window():new( 5, 5, 7, 50 )
   LOCAL oText        := Window():new( 17, 3, 22, 77 )
   LOCAL nListType    := 0
   LOCAL cntr         := 0
   LOCAL oEventMgr    := EventMgr()
   LOCAL aChoices     := {}
   LOCAL x, xVal
   LOCAL nHandle
   LOCAL oWhich, lThisOne
   LOCAL oStatus

   oText:winSay( 0, 1, "This is an example of associating a toggleAction with a checkBox GET.")
   oText:winSay( 2, 1, "If you check off an export list, the preBlock of the associated GET  ")
   oText:winSay( 3, 1, "for the file name becomes TRUE, allowing you to edit the file name.  ")

   // create the status window
   oStatus := Window():new( 5, 25, 22, 65, "w+/g" )
   oStatus:title := "Export Status"
   oStatus:titleColor := "n/w*"

   // Define the export options. Note that if you want to add more
   // options, all the windows will resize to accomodate them
   AADD( aChoices, { CHOICES_TXT_ALL,     TRUE,  "all.txt             ", 0, ;
                     {|| TRUE }                     })

   AADD( aChoices, { CHOICES_TXT_A_TO_M,  FALSE,  "a_to_m.txt          ", 0, ;
                     {|| people->last_name <= "M"}  })

   AADD( aChoices, { CHOICES_TXT_N_TO_Z,  TRUE,  "n_to_z.txt          ", 0, ;
                     {|| people->last_name >= "N"}  })


   oWhich       := Window():new( 5, 13, 9 + LEN( aChoices ), 59 )
   oWhich:title := "Export List Selection"

   @ 1, 20, LEN( aChoices ) + 2, 43 FRAME SNGLBORD                    ;
                                    COLOR "n/bg"                      ;
                                    TITLE " Export File Name "        ;
                                    TITLESTYLE SC_TITLESTYLE_CENTERED ;
                                    TITLECOLOR "b/bg"                 ;
                                    IN oWhich

   FOR x := 1 TO LEN( aChoices )
       MakeGets( oWhich, aChoices, x )
   NEXT

   oText:display()

   oWhich:read():hide()

   oText:implode(3)

   soMouse:hide()

   x := 1
   WHILE x <= LEN( aChoices )

      // Process this one?
      IF ! aChoices[ x ][ CHOICES_FLAG ]
         // No, skip it.
         oStatus:send( " Skipped " + TRIM( aChoices[ x ][ CHOICES_PATH ] ) + "...", "n/bg")
         x++
         LOOP
      ENDIF

      oStatus:send( " Exporting " + TRIM( aChoices[ x ][ CHOICES_PATH ] ) + "...", "w+/r")

      FCREATE( aChoices[ x ][ CHOICES_PATH ] )
      nHandle := FOPEN( aChoices[ x ][ CHOICES_PATH ], FO_WRITE )

      people->( dbGotop() )
      DO WHILE ! people->(EOF())

         IF aChoices[ x ][ CHOICES_BLOCK ]:eval()
            FWRITE( nHandle, TRIM( people->first_name) + " " +   ;
                             TRIM( people->last_name )  +  CRLF  )

            oStatus:send( TRAN(++cntr,"9,999") + ". " +          ;
                          TRIM( people->last_name ) + ", " +     ;
                          people->first_name )

            INKEY( .1 ) // delay a bit

         ENDIF

         people->( dbSkip() )

      ENDDO

      // save the count
      aChoices[ x ][ CHOICES_RESULT ] := cntr

      cntr := 0
      x++ // increment the array index

   ENDDO

   oWhich:resize(, 10,, 70)
   oWhich:setFocus()

   @ 1, 47, LEN( aChoices ) + 2, 57 FRAME SNGLBORD              ;
                                    COLOR "bg+/b"               ;
                                    TITLE " Results "           ;
                                    TITLECOLOR "w+/b"           ;
                                    IN oWhich


   FOR x := 1 TO LEN( aChoices )

       @ x + 1, 51 SAY IF( aChoices[ x ][ CHOICES_RESULT ] <> 0, ;
                            TRANSFORM( aChoices[ x ][ CHOICES_RESULT ], "9,999" ),;
                             "" )                                                 ;
                   COLOR "w+/b" IN oWhich

   NEXT

   soMouse:display()

   oStatus:implode(7)
   oWhich:display()

   soDeskTop:SetMessage("Export complete. Press any key to continue...")

   GetInput(0)

   soDeskTop:SetMessage("")

   oWhich:implode(7)
   oWhich:kill()

   oText:kill()

   oStatus:kill()

   RETURN ( NIL )


***********************************************************************
* FUNCTION MakeGets( oWin, aChoices,  nIndex )
*
* Parameters  :
* Description : Create a series of detached LOCAL gets and
*               and add them to window oWin
*
* Returns     : NIL
***********************************************************************
STATIC FUNCTION MakeGets( oWin, aChoices, nIndex )

   LOCAL xVal := aChoices[ nIndex ]
   LOCAL oCheckGet
   LOCAL oPathGet

   @ nIndex + 1, 1 GET xVal[ CHOICES_FLAG ]                    ;
                   CHECKBOX aChoices[ nIndex ][ CHOICES_TEXT ] ;
                   IN oWin

   oCheckGet := ATAIL( oWin:gets )

   @ nIndex + 1, 22 GET xVal[ CHOICES_PATH ]                ;
                    COLOR IF( xVal[ CHOICES_FLAG ],        ;
                               CHOICES_SELECTABLE_COLOR,    ;
                               CHOICES_UNSELECTABLE_COLOR ) ;
                    IN oWin

   oPathGet := ATAIL( oWin:gets )

   oPathGet:preBlock := {|| xVal[ CHOICES_FLAG ] }

   oCheckGet:toggleAction := {|| oPathGet:colorSpec :=                ;
                                    IF( xVal[ CHOICES_FLAG ],         ;
                                    CHOICES_SELECTABLE_COLOR,         ;
                                    CHOICES_UNSELECTABLE_COLOR ),     ;
                                 oPathGet:display(),                  ;
                                 xVal[ CHOICES_FLAG ] }


   RETURN ( NIL )


**
* TBWin Family
**

***********************************************************************
* FUNCTION dmoTBIntro()
*
* Parameters  :
* Description :  Introduction to the TB____ family
* Returns     :
***********************************************************************
FUNCTION dmoTBIntro
   LOCAL oTB
   LOCAL oTextWin := Window():new( 13, 10, 18, 78, CLR_DEMO )
   LOCAL oTextWin2 := Window():new( 12, 7, 22, 73, CLR_DEMO )
   FLUSH KEYBOARD
   GO TOP

   oTextWin:frameFcColor  := oTextWin:frameColor  := "bg+/b"
   oTextWin2:frameFcColor := oTextWin2:frameColor := "bg+/b"

   @0, 1 SAY "This is the TBWin class. It is descended from the Windows      " ;
         IN oTextWin
   @1, 1 SAY "Class, and contains a TBrowse object in instance variable ::tb." ;
         IN oTextWin
   @3, 1 SAY "Go ahead....                                                   " ;
         IN oTextWin
   @3,14 SAY "cursor around!"  COLOR CLR_PROMPT                                ;
         IN oTextWin

   @0,1 SAY "This is the syntax (more or less) used to create and browse"      ;
        IN oTextWin2
   @1,1 SAY "that TBWin object:"                                               ;
        IN oTextWin2
   @8,3 SAY ContMsg() COLOR CLR_PROMPT IN oTextWin2
   @3,3 SAY '  LOCAL oTB := TBWin():new(  2, 2, 12, 30, "w/b")          '      ;
        COLOR "w+/bg" IN oTextWin2
   @4,3 SAY '  oTB:title := " Customers "                               '      ;
        COLOR "w+/bg" IN oTextWin2
   @5,3 SAY '  oTB:addField("last_name")                                '      ;
        COLOR "w+/bg" IN oTextWin2
   @6,3 SAY '  oTB:browse()                                             '      ;
        COLOR "w+/bg" IN oTextWin2

   oTB := CreateTB(1)
   oTB:autoSeek := FALSE
   oTB:tb:getColumn(1):editColor := "w+/g, w+/g"

   // You can delete a "Mouse Event" by sending its name to the
   // delMouseEvent method.
   oTB:delMouseEvent("SIZE")

   //  These are examples of how to use the TBCol:preblock and TBCol:postblock
   //  instance variables
   //
   //  oTB:tb:getColumn(1):postBlock ;
   //       := { |oGet| IF(EMPTY(oGet:buffer),;
   //                      (TONE(1500,2), MessageBox("Field cannot be blank","w+/r",2),FALSE),;
   //                      TRUE) }
   //
   //  oTB:tb:getColumn(1):preBlock ;
   //       := { |oGet| IF( TRIM(UPPER(last_name)) = "SMITH",;
   //                      (TONE(1500,2), MessageBox("Can't edit records for a Smith!","w+/r",2),FALSE),;
   //                      TRUE) }

   oTextWin:display()
   oTB:display()

   SET COLOR TO

   oTB:browse()

   oTextWin:implode(7)
   oTextWin2:display()

   GetInput( nDelaySecs )
   oTextWin2:implode(8)
   oTB:implode(8)
   oTextWin:kill()
   oTextWin2:kill()
   oTB:kill()

   RETURN ( NIL )


***********************************************************************
* FUNCTION dmoTBSeek()
*
* Parameters  :
* Description :  Demonstrate Incremental Seeking
* Returns     :
***********************************************************************
FUNCTION dmoTBSeek

   LOCAL oWin2 := Window():new( 14, 10, 22, 70, CLR_DEMO )
   LOCAL oTB

   FLUSH KEYBOARD

   GO TOP

   @ 0, 1 SAY "Each TBWin object has an incremental search feature for   " IN oWin2
   @ 1, 1 SAY "doing indexed seeks. All you need to do is start typing,  " IN oWin2
   @ 2, 1 SAY "the TBWin object will attempt to find what you are typing." IN oWin2
   @ 4, 1 SAY "Pressing <backspace> deletes a character from the seek    " IN oWin2
   @ 5, 1 SAY "string and takes you back to the last match, a tone means " IN oWin2
   @ 6, 1 SAY "that no match was found.                                  " IN oWin2
   @ 6,26 SAY "Press <Esc> when done..." COLOR CLR_PROMPT IN oWin2

   oTB := CreateTB( 1 )
   SET COLOR TO
   oWin2:display()
   oTB:browse()

   oWin2:clear()
   oWin2:resize( 15, 10, 21, 72 )
   @ 0,1 SAY "All of that was handled by the browse method. The box " IN oWin2
   @ 1,1 SAY "containing the seek string was a window object contained in" IN oWin2
   @ 2,1 SAY "the TBWin object.                                          " IN oWin2
   @ 4,1 SAY ContMsg() COLOR CLR_PROMPT IN oWin2

   oWin2:display()
   GetInput( nDelaySecs )
   Window():killAll()

   RETURN ( NIL )


***********************************************************************
* FUNCTION dmoTBZoom()
*
* Parameters  :
* Description :  Demonstrate TB____ zooming
* Returns     :
***********************************************************************
FUNCTION dmoTBZoom

   LOCAL oTB   := CreateTB(1)
   LOCAL oText := Window():new( 13, 7, 23, 71, CLR_DEMO )

   FLUSH KEYBOARD

   GO TOP

   @ 0,1 SAY "Remember the ZOOM method we looked at in the Window class?   " IN oText
   @ 2,1 SAY "Well.... the TBGen family is descended from the Window class," IN oText
   @ 3,1 SAY "so we can invoke that method (with some additions) from here." IN oText
   @ 5,1 SAY "Note what the horizontal scroll indicator does when you Zoom." COLOR "G/B" IN oText
   @ 7,1 SAY "Press F2 or click on the top right window corner to ZOOM, or " COLOR CLR_PROMPT IN oText
   @ 8,1 SAY "press <Esc> when done..." COLOR CLR_PROMPT IN oText

   oText:display()

   oTB:showHBar := TRUE
   oTB:showVBar := TRUE
   oTB:explode  := FALSE
   oTB:addField( "address_1" )
   oTB:addField( "telephone", "@R 999-999-9999" )
   oTB:browse()

   Window():killAll()

   RETURN ( NIL )


***********************************************************************
* FUNCTION dmoTBPrnt()
*
* Parameters  :
* Description :  Demonstrate TBWin parent/child relations
* Returns     :
***********************************************************************
FUNCTION dmoTBPrnt()

   LOCAL oText   := Window():new( 14, 4, 23, 75, CLR_DEMO )
   LOCAL oParent := CreateTB( 1 )
   LOCAL oChild  := CreateTB( 2 )

   FLUSH KEYBOARD

   people->( dbGoTop() )

   @  0, 1 SAY "You are now looking at 2 TBWin objects, CUSTOMERS and ORDERS, "   IN oText
   @  1, 1 SAY "which have been related by the PARENT...CHILD UDC:"                       IN oText
   @  3, 1 SAY "    PARENT oParent CHILD oChild KEY upper(people->last_name)  "   IN oText
   @  5, 1 SAY "As you would expect, any movement through the PARENT window will" IN oText
   @  6, 1 SAY "cause the CHILD window to be updated, with a lookup done on the"  IN oText
   @  7, 1 SAY "KEY clause. Go ahead, try it, "                                   IN oText
   @  7,31 SAY "cursor around. Press <Esc> when done..." COLOR CLR_PROMPT IN oText

   oText:preBlock := {|| FALSE }

   PARENT oParent CHILD oChild KEY UPPER( people->last_name ) ;
      KEYFIELD last_name

   oText:display()

   oParent:modal    := TRUE
   oParent:showVBar := TRUE

   oChild:move( oChild:top - 1, oChild:left )


   oParent:browse()

   Window():killAll()

   RETURN ( NIL )


***********************************************************************
* FUNCTION dmoTBPrnt2()
*
* Parameters  :
* Description :  Demonstrate TBWin parent/child relations - Part 2
* Returns     :
***********************************************************************
FUNCTION dmoTBPrnt2

   LOCAL oText   := Window():new( 13, 2, 19, 77, CLR_DEMO )
   LOCAL oParent := CreateTB(1)
   LOCAL oChild1 := CreateTB(2)
   LOCAL oChild2 := CreateTB(3)

   FLUSH KEYBOARD

   @0,1  SAY "Each PARENT can have multiple CHILD TBWin objects, and a CHILD can"   IN oText
   @1,1  SAY "in turn be a PARENT. Displaying a PARENT will automatically display"  IN oText
   @2,1  SAY "the children. You are about to see one parent (Customer) with 2 children." IN oText
   @4,1  SAY ContMsg()  COLOR CLR_PROMPT IN oText

   PARENT oParent CHILD oChild1 KEY upper(people->last_name) KEYFIELD last_name
   PARENT oParent CHILD oChild2 KEY upper(people->last_name) KEYFIELD last_name
   oText:display()
   GetInput( nDelaySecs * 2 )
   oText:implode(7)

   oText:clear()
   oText:resize( 13, 0, 20, 30 )
   @0,1 SAY "Press TAB to move between" IN oText
   @1,1 SAY "TBWin objects (if they   " IN oText
   @2,1 SAY "           have any data)" IN oText
   @4,1 SAY "Press <Esc> when done..."  COLOR CLR_PROMPT IN oText
   oText:display()
   people->( dbGotop() )
   oParent:modal    := TRUE
   oParent:showVBar := TRUE
   soMouse:hide()

   // Display all the windows
   oParent:display()
   oChild1:display()
   oChild2:display()

   // Browse the parent
   oParent:browse()

   Window():killAll()

   soMouse:display()

   RETURN ( NIL )


***********************************************************************
* FUNCTION dmoMult() --> NIL
*
* Description : The piece de resistance...putting it all together.
***********************************************************************
FUNCTION dmoMult

   LOCAL oReadPeople := CreateRead( 1 )
   LOCAL oReadOrders := CreateRead( 2 )
   LOCAL oBrPeople   := CreateTB( 1 )
   LOCAL oBrOrders   := CreateTB( 2 )
   LOCAL oText       := Window():new( 5, 10, 17, 70, CLR_DEMO )

   FLUSH KEYBOARD

   oBrPeople:addField( "address_1" )

   @  0,1 SAY "And now we come to the pice de rsistance. It's time to" IN oText
   @  1,1 SAY "put some of these objects together and see what we come"  IN oText
   @  2,1 SAY "up with. Make sure you look at the source code for what"  IN oText
   @  3,1 SAY "you're about to see.                                   "  IN oText

   @  5,1 SAY "You'll be looking at 2 browse windows (TBWin objects), "  IN oText
   @  6,1 SAY 'which have been related using the "PARENT" command.    '  IN oText

   @  8,1 SAY "Pressing <enter> in either one will bring up a READ    "  IN oText
   @  9,1 SAY "window, which was associated with the browse window    "  IN oText
   @ 10,1 SAY 'by the "ON ENTER" command.                             '  IN oText

   oText:display()

   GetInput( nDelaySecs )

   oText:implode( 7 )
   oText:clear()
   oText:resize( 17, 5, 21, 44 )

   @ 0, 1 SAY "<Enter> to bring up Read window     "  IN oText
   @ 1, 1 SAY "<Tab> to move between browse windows"  IN oText
   @ 2, 1 SAY "<Esc> when done                     "  IN oText

   // Ta daa...amazing what these few lines do, eh?
   PARENT oBrPeople CHILD oBrOrders KEY UPPER(people->last_name) ;
      KEYFIELD last_name

   ON ENTER IN oBrPeople oReadPeople:read():hide()
   ON ENTER IN oBrOrders oReadOrders:read():hide()

   ON ADD IN oBrPeople WinAppend( oReadPeople, oBrPeople )
   ON ADD IN oBrOrders WinAppend( oReadOrders, oBrOrders )

   oText:display()

   oBrPeople:modal := TRUE
   oBrPeople:display()

   oBrOrders:display()

   oBrPeople:browse()

   Window():killAll()

   RETURN ( NIL )


**
* Timer
**

***********************************************************************
* FUNCTION dmoTimer()
*
* Parameters  :
* Description :  Demonstrate Timer class
* Returns     :
***********************************************************************
FUNCTION dmoTimer1

   LOCAL oTimer := Timer():new( 5, 5,, "n/bg" )
   LOCAL oText  := Window():new( 17, 10, 22, 70, CLR_DEMO )

   FLUSH KEYBOARD

   oTimer:flipSize()
   oTimer:displaySeconds( TRUE )
   @ 0,1 SAY "This is a TIMER object, which contains the current time." IN oText
   @ 1,1 SAY "We could have created it with a start time which would  " IN oText
   @ 2,1 SAY "have made it an elapsed time counter.                   " IN oText
   @ 3,1 SAY ContMsg() COLOR CLR_PROMPT IN oText
   Window():displayAll()
   GetInput( nDelaySecs )

   oTimer:displaySeconds( FALSE )
   oText:clear()
   @ 0,1 SAY "The TIMER object is now no longer displaying seconds. " IN oText
   @ 3,1 SAY ContMsg() COLOR CLR_PROMPT IN oText
   Window():displayAll()
   GetInput( nDelaySecs )

   oTimer:flipsize()
   oText:clear()
   @0,1 SAY "WHOAAAA...... Will ya look at that!!!!                 " IN oText
   @3,1 SAY ContMsg() COLOR CLR_PROMPT IN oText
   Window():displayAll()
   GetInput( nDelaySecs )

   oTimer:displaySeconds(TRUE)
   oText:clear()
   @0,1 SAY "Now we're showing seconds again in large mode.         " IN oText
   @3,1 SAY ContMsg() COLOR CLR_PROMPT IN oText
   Window():displayAll()
   GetInput( nDelaySecs )
   Timer():killAll() ; Window():killAll()

   RETURN ( NIL )


***********************************************************************
* FUNCTION dmoTimer2()
*
* Parameters  :
* Description :  Demonstrate Timer class - Part 2
* Returns     :
***********************************************************************
FUNCTION dmoTimer2

   LOCAL oWin1 := Window():new( 16, 5, 22, 75, CLR_DEMO)
   LOCAL oWin2 := timer():new( 2, 5,, "w+/bg" )
   LOCAL oWin3 := timer():new( 6, 2, SECONDS()-300, "n/g+" )
   LOCAL oWin4 := timer():new( 7, 30, SECONDS()-200, "n/gr" )
   LOCAL oWin5 := timer():new( 7, 60, SECONDS()-100, "w+/r" )

   FLUSH KEYBOARD

   oWin2:title := " Timer Window 2 " ; oWin4:flipsize() ; oWin5:flipsize()
   @0,1 SAY "The timer class is descended from Windows, so we can apply most of "  IN oWin1
   @1,1 SAY "the Window methods (some get redefined). This whole screen, by the "  IN oWin1
   @2,1 SAY "way, took about 12 lines of code (INCLUDING 4 lines for this text) "  IN oWin1
   @4,1 SAY ContMsg() COLOR CLR_PROMPT IN oWin1
   oWin2:display() ; oWin3:display() ; oWin4:display() ; oWin5:display() ;oWin1:display()
   GetInput( nDelaySecs )

   Window():topmost():implode(8) ; Window():refresh() // The refresh method calls to update the timers
   Window():topmost():implode(1) ; Window():refresh() // is to update the timers
   Window():topmost():implode(3) ; Window():refresh()
   Window():topmost():implode(7) ; Window():refresh()
   Window():topmost():implode(7)

   Window():killAll()

   RETURN ( NIL )


**
*  Scroll Bars
**

***********************************************************************
* FUNCTION dmoScrollBar()
*
* Parameters  :
* Description :  Demonstrate the ScrollBars
* Returns     :
***********************************************************************
FUNCTION dmoScrollBar

   LOCAL oTB     := CreateTB( 2 )
   LOCAL oText   := Window():new( 11, 5, 23, 75, CLR_DEMO )
   LOCAL oHotKey
   LOCAL lRemapped := soAppDefs:fontRemap

   FLUSH KEYBOARD

   oTB:addfield("ship_date")

   // set up hot keys for this part of the demo
   oHotKey := HotKey()
   oHotKey:addKey( "SCROLL", K_F2, {|| oTB:zoom()} )
   oHotKey:addKey( "SCROLL", K_F4, {|| scrollSwap( oTB ), oTB:display() } )
   oHotKey:activate("SCROLL")

   oTB:title        := " This is a TBWin Object "
   oTB:titleStyle   := SC_TITLESTYLE_WINDOWS
   oTB:titleFcColor := "n/g"
   oTB:move(1,25)
   oTB:showHBar := TRUE
   oTB:showVBar := TRUE
   oText:winSay(  0, 1, "A TBWin object can contain vertical and horizontal scroll bars."  )
   oText:winSay(  2, 1, "The horizontal scroll bar will be added to the window if all the" )
   oText:winSay(  3, 1, "fields (columns) you've added will not fit into the window."      )
   oText:winSay(  5, 1, "The vertical scroll bar, by default, shows the pointer position"  )
   oText:winSay(  6, 1, "in a DBF based on the RECNO()."                                   )
   oText:winSay(  8, 1, "Both scroll bars are instances of the SCROLLBAR class."           )
   oText:winSay( 10, 1, "Cursor around, or press <Esc> when done...", CLR_PROMPT           )
   oText:display()

   oTB:modal := TRUE

   oTB:browse()
   oTB:implode(3) ; oText:hide(1) ; oText:clear()

   ScrollSwap( oTB )

   oText:resize( oText:top, oText:left, oText:bottom-1, oText:right )
   oText:winSay( 0, 1, "You have complete control over the visual appearance of the")
   oText:winSay( 1, 1, "scroll bars. You can define:")
   oText:winSay( 3, 1, "                       Bar character (non-remapped mode)","BG+/B")
   oText:winSay( 4, 1, "                       Bar color","BG+/B")
   oText:winSay( 5, 1, "                       Pointer character (non-remapped mode)","BG+/B")
   oText:winSay( 6, 1, "                       Pointer color","BG+/B")
   IF soAppDefs:fontRemap
      oText:winSay( 8, 1, "Cursor around, <F2> to zoom, or press <Esc> when done... ", CLR_PROMPT)
   ELSE
      oText:winSay( 8, 1, "Cursor around, <F2> to zoom, <F4> to swap scroll bar characters and", CLR_PROMPT)
      oText:winSay( 9, 1, "colors, or press <Esc> when done...", CLR_PROMPT)
   ENDIF

   oText:display()

   oTB:browse()
   oTB:implode(2) ; oText:implode(4) ; oText:clear()

   Window():killAll()
   oHotKey:deactivate( "SCROLL" )

   SET ORDER TO 1

   RETURN ( NIL )


***********************************************************************
* FUNCTION ScrollSwap( oTB, nChoice )
*
* Parameters  :
* Description :  Support function for the ScrollBar class demo
* Returns     :
***********************************************************************
STATIC FUNCTION ScrollSwap( oTB, nChoice )

   STATIC nSet := 0

   nSet := IF( nChoice <> NIL, nChoice, nSet )

   DO CASE
   CASE nSet = 0
      IF ! soAppDefs:fontRemap
         oTB:hbar:fillcharacter := ""     ; oTB:hbar:pointerCharacter := ""
         oTB:vbar:fillcharacter := ""     ; oTB:vbar:pointerCharacter := ""
      ENDIF
      oTB:hbar:fillColor     := "bg/b"  ; oTB:hbar:pointerColor     := "g+/r"
      oTB:vbar:fillColor     := "bg/b"  ; oTB:vbar:pointerColor     := "g+/r"

   CASE nSet = 1
      IF ! soAppDefs:fontRemap
         oTB:hBar:fillCharacter  := ""            ; oTB:hBar:pointerCharacter := ""
         oTB:vBar:fillCharacter  := ""         ; oTB:vBar:pointerCharacter := ""
      ENDIF
      oTB:hBar:fillColor      := "n/bg+, n/bg+" ; oTB:hBar:pointerColor := "r+/n+"
      oTB:vbar:fillColor      := "n/bg+"     ; oTB:vbar:pointerColor     := "r+/n+"

   CASE nSet = 2
      IF ! soAppDefs:fontRemap
         oTB:hbar:fillcharacter := ""     ; oTB:hbar:pointerCharacter := ""
         oTB:vbar:fillcharacter := ""     ; oTB:vbar:pointerCharacter := ""
      ENDIF
      oTB:hbar:fillColor     := "bg/b+"  ; oTB:hbar:pointerColor     := "g+/b+"
      oTB:vbar:fillColor     := "bg/b+"  ; oTB:vbar:pointerColor     := "g+/b+"

   ENDCASE

   nSet ++
   nSet := IF( nSet > 2, 0, nSet )

   RETURN ( NIL )


**
* Order Info
**

***********************************************************************
* FUNCTION OrderInfo() --> NIL
*
* Parameters  :
* Description :  Display and optionnaly print an order form
***********************************************************************
FUNCTION OrderInfo

   LOCAL oWin, nHandle
   LOCAL nStartArea := SELECT()

   SETCOLOR( CLR_DEMO )

   SELECT demotext
   IF dbSeek( "ORDER" )

      oWin := DBTWin():new( 2, 0, DeskTop():nBottom, MAXCOL(), "text", "demotext" )
      oWin:allowEdit    := FALSE
      oWin:frameFcColor := "bg/b"
      oWin:leftMargin   := oWin:rightMargin := 0
      oWin:lineLength   := 80
      oWin:read( FALSE )

      IF YNConf( "Print order form on LPT1?", , "W+/B" )

         IF ( nHandle := FOPEN( "LPT1", FO_WRITE ) ) > 0
            FWRITE( nHandle, oWin:data )
            FCLOSE( nHandle )
            EJECT
         ELSE
            MessageBox( "StarClass demo: Error opening device LPT1", "w+/r" )
         ENDIF

      ENDIF

      oWin:kill()

   ENDIF

   SELECT( nStartArea )
   RETURN ( NIL )


**
* Closing Screens
**

***********************************************************************
* FUNCTION dmoFinale()
*
* Parameters  :
* Description :  The extremely impressive Grand Finale <g>
* Returns     :
***********************************************************************
FUNCTION dmoFinale

   LOCAL oWin1, oWin2, oWin3, oWin4, oWin5, oWin6

   LOCAL i

   soAppDefs:frameFcColor := NIL


   oWin1 := Window():new(  5, 20,  7, 60, "b+/r"   )
   oWin1:frameFcColor := "w+/r"

   oWin2 := Window():new(  7,  5,  9, 57, "w/br"  )
   oWin2:frameFcColor := "w+/br"

   oWin3 := Window():new(  9, 35, 11, 75, "gr+/b*" )
   oWin3:frameFcColor := "r+/b*"

   oWin4 := Window():new( 11,  6, 13, 44, "n/bg"   )
   oWin4:frameFcColor := "w+/bg"

   oWin5 := Window():new( 13, 26, 16, 77, "gr/w*" )
   oWin5:frameFcColor := "w+/w*"

   oWin6 := Window():new( 16, 13, 18, 52, "n/gr*" )
   oWin6:frameFcColor := "w+/gr*"

   FLUSH KEYBOARD

   @ 0,1 SAY "Well, it may be pining for the fjords." COLOR "W/R" IN oWin1
   @ 0,1 SAY "We don't have any more parrots. I have a slug." IN oWin2
   @ 0,1 SAY "Exceptional bird, the Norwegian Blue.  Beautiful plumage, isn't it?" IN oWin3
   @ 0,1 SAY "He's not dead, he's merely resting."     IN oWin4

   @ 0, 1 SAY "If you hadn't nailed it to the perch it would be" IN oWin5
   @ 1, 1 SAY "pushing up the daisies."                          IN oWin5

   @ 0,1 SAY "POLLY, POLLY, POLLY!  [thump, thump]" IN oWin6


   SET MOUSE OFF

   Window():displayAll()

   FOR i := 1 TO 700

      Window():next()

      IF GetInput() <> 0
         EXIT
      ENDIF

   NEXT

   Window():killAll()

   RETURN ( NIL )


***********************************************************************
* FUNCTION dmoGoodBye() --> NIL
*
* Parameters  :
* Description :  The "Thank You" screen
***********************************************************************
FUNCTION dmoGoodbye

   LOCAL oWindow := Window()
   LOCAL oText   := oWindow:new( 5, 4, 21, 76, CLR_DEMO )
   LOCAL GetList := {}
   LOCAL nKey

   soMouse:hide()

   CLEAR TYPEAHEAD
   SET COLOR TO W/BG
   CLEAR

   oText:winSay(  0,0, "           This concludes the StarClass(tm) demonstration.             ", "G+/BG")
   oText:winSay(  2,1, "This is very much a user-driven product. We're open to any comments")
   oText:winSay(  3,1, "or suggestions that you may have.  Please contact us at:")
   oText:winSay(  4,1, "")
   oText:winSay(  6,1, "                  Loesgen Software, Inc.")
   oText:winSay(  7,1, "                  1712 Avenue Rd, Box 54605")
   oText:winSay(  8,1, "                  Toronto, ON")
   oText:winSay(  9,1, "                  Canada M5M 4N5")
   oText:winSay( 11,1, "         Fax: (416) 784-3768          Voice: (416) 784-3618     " )
   oText:winSay( 12,1, "         CIS: 73063,1012              BBS:   (416) 784-9712     " )
   oText:addMarquee(,,"Don't miss the Introductory Special!   See ORDERING INFO for information on how to order your copy of StarClass...", .2 )
   oText:display()

   DO WHILE ( nKey := GetInput() ) == 0 .AND. ! soMouse:changed
      oWindow:displayMarquee()
   ENDDO

   oText:hide( 8 )
   oText:kill()

   SET COLOR TO
   SET CURSOR ON
   CLS

   RETURN ( NIL )


**
*                          Demo support functions
**

***********************************************************************
* FUNCTION OpenDBFs( [<cDataPath>] )
*
* Parameters  : - none -
* Description : Open all data tables needed during demo.
* Returns     : NIL
***********************************************************************
FUNCTION OpenDBFs( cDataPath )

   FIELD last_name, key

   SET( _SET_DEFAULT, cDataPath )

   BEGIN SEQUENCE

   IF ! FILE( cDataPath + "people.dbf" )
      MessageBox( "StarClass Demo Error: Can't find PEOPLE.DBF", CLR_ERROR )
      BREAK
   ENDIF

   IF ! FILE( cDataPath + "orders.dbf" )
      MessageBox( "StarClass Demo Error: Can't find ORDERS.DBF", CLR_ERROR )
      BREAK
   ENDIF

   IF ! FILE( cDataPath + "history.dbf" )
      MessageBox( "StarClass Demo Error: Can't find HISTORY.DBF", CLR_ERROR )
      BREAK
   ENDIF

   IF ! FILE( cDataPath + "demotext.dbf" )
      MessageBox( "StarClass Demo Error: Can't find DEMOTEXT.DBF", CLR_ERROR )
      BREAK
   ENDIF

   USE people NEW
   INDEX ON UPPER(last_name) TO ( cDataPath + "people" )

   USE orders NEW
   INDEX ON UPPER(last_name) TO ( cDataPath + "orders" )

   USE history NEW
   INDEX ON UPPER(last_name) TO ( cDataPath + "history" )

   USE demotext NEW
   INDEX ON key TO ( cDataPath + "demotext" )

   RECOVER

      MessageBox({"StarClass Demo Fatal Error: One or more of the data files", ;
                                              "this demo could not be found."},;
                                              CLR_ERROR )

      SCROLL()

      ?"StarClass demo aborted: unable to find required files."
      ?
      ?"Please unpack the self-extracting demo SCDEMO.EXE, and run"
      ?"DEMO again in the directory it was unpacked in."
      ?

      QUIT

   END SEQUENCE

   RETURN ( NIL )


***********************************************************************
* FUNCTION CreateTB()
*
* Parameters  :
* Description :  Create the browsers
* Returns     :
***********************************************************************
STATIC FUNCTION CreateTB( nWhich )
   // We got tired of duplicating the same TBWin object all over the place....
   LOCAL oTB
   DO CASE

     CASE nWhich = 1
          SELECT people
          oTB := TBWin():new(  3, 4, 11, 30 )
          oTB:editColor := "w+/gr"
          oTB:title := " Customers "
          oTB:addField("last_name", "@!")
          oTB:titleColor   := "n/bg"
          oTB:titleFcColor := "n/bg*"
          oTB:paneColor    := oTB:frameColor   := "w/b" // unfocussed pane and fram colors
          oTB:paneFcColor  := "w/b"  // pane color when this window has focus
          oTB:frameFcColor := "w+/b" // frame color when this window has focus


     CASE nWhich = 2
          SELECT orders
          oTB := TBWin():new( 5, 40, 13, 74 )
          oTB:editColor := "bg+/g"
          oTB:title := " Orders "
          oTB:addField("quantity","99.99","Qty")
          oTB:addField("item",,"Item")
          oTB:addField("price","99.99","Price")
          oTB:titleStyle   := SC_TITLESTYLE_WINDOWS
          oTB:titleColor   := "n/bg"
          oTB:titleFcColor := "n/bg*"
          oTB:paneColor    := oTB:frameColor   := "w/b" // unfocussed pane and fram colors
          oTB:paneFcColor  := "w/b"  // pane color when this window has focus
          oTB:frameFcColor := "w+/b" // frame color when this window has focus


     CASE nWhich = 3
          SELECT history
          oTB := TBWin():new(  15, 40, 23, 74, "w+/g")
          oTB:editColor    := "w+/rb"
          oTB:title        := " History "
          oTB:titleStyle   := SC_TITLESTYLE_WINDOWS
          oTB:titleColor   := "n/bg"
          oTB:titleFcColor := "n/bg*"
          oTB:frameFcColor  := "w+/g"
          oTB:addField("quantity",,"Qty")
          oTB:addField("item",,"Item")
          oTB:addField("price",,"Price")
          oTB:allowAppend := oTB:allowDelete := FALSE
          oTB:blocks[ BLOCK_ENTER ]:= {|| Tone(2000,1), Tone(1000,2),Tone(500,3), ;
                                          MessageBox("Unable to edit history!","w+/r") }

   ENDCASE
   oTB:setEventHandlers()
   RETURN ( oTB )


***********************************************************************
* FUNCTION CreateRead(<nWhich>)
*
* Parameters  :
* Description : For the demo only: create some read objects on demand.
* Returns     : oRead
***********************************************************************
STATIC FUNCTION CreateRead( nWhich )

   LOCAL oRead

   FIELD item, quantity, price

   DO CASE
   CASE ( nWhich == 1 )

      oRead := Window():new( 12, 10, 21, 55, "w/b" )
      oRead:title        := " Edit Customers "
      oRead:titleFcColor := "n/w*"

      @ 1,1 SAY "Last Name: " GET people->last_name PICTURE "@!" IN oRead
      @ 3,1 SAY "Address:   " GET people->address_1              IN oRead
      @ 4,1 SAY "           " GET people->address_2              IN oRead
      @ 5,1 SAY "Postal:    " GET people->postal                 IN oRead
      @ 7,1 SAY "Telephone: " GET people->telephone                     ;
                              PICTURE "@R 999-999-9999"          IN oRead

   CASE ( nWhich == 2 )


      oRead              := Window():new( 12, 30, 17, 50, "w/g+" )
      oRead:title        := " Edit Orders "
      oRead:frameFcColor := "w/g+"

      @ 1,1 SAY "Item:     "  GET orders->item     IN oRead
      @ 2,1 SAY "Quantity: "  GET orders->quantity IN oRead
      @ 3,1 SAY "Price:    "  GET orders->price    IN oRead

   ENDCASE

   RETURN ( oRead )




***********************************************************************
* FUNCTION ContMsg() --> lContinue
*
* Parameters  :
* Description :  Use to display the continuation message, which varies
*                depending on the mode this demo is running in
***********************************************************************
STATIC FUNCTION ContMsg
   // This returns the appropriate continuation string shown in all the
   // windows during the demo.
   RETURN ( "Press any key to continue..." )


***********************************************************************
* FUNCTION ConfirmQuit() --> NIL
*
* Description : Confirm user want to quit the demo
***********************************************************************
STATIC FUNCTION ConfirmQuit

   LOCAL cStartColor := SETCOLOR( "w+/r" )
   LOCAL altcsave    := SETKEY( K_ALT_C, NIL )

   #ifndef LSI_TEST

   IF YNConf( "Are you sure you want to abort the demo?" )

      IF ! slHasSeenGauge .AND.                                   ;
         ! YNConf({"But you haven't seen the Gauge demo yet.","", ;
                   "It really is quite impressive!","",           ;
                   "Are you SURE you want to quit?"}, TRUE )

         RETURN ( NIL ) //note!
      ENDIF


      // Kill all objects, as something may exist if we got here
      // by a SetKey()

      Timer():killAll() ; Window():killAll() ; Idle():killAll()
      soDeskTop:display()

      dmoFinale()

      dmoGoodbye()

      EXIT STARCLASS
      QUIT

   ENDIF
   #else
     QUIT
   #endif

   SETCOLOR( cStartColor )
   SETKEY( K_ALT_C, altcsave )

   RETURN ( NIL )


***********************************************************************
* FUNCTION dmoMemoText()
*
* Parameters  :
* Description :  Demonstrate the MemoText family
* Returns     :
***********************************************************************
FUNCTION dmoMemoText

   LOCAL oText := Window():new( 2, 1, 9, 65, "w+/bg" )
   LOCAL oWin, oTB, oCol, oNotes

   @ 0, 1 SAY 'The MemoText family is a group of text editing        ' IN oText
   @ 1, 1 SAY "classes which use different data sources:             " IN oText
   @ 3, 1 SAY "     DBTWin:   Standard DBT memo fields              " IN oText
   @ 4, 1 SAY "     FFWin:    FlexFile DBV fields                   " IN oText
   @ 5, 1 SAY "     TextWin:  ASCII files                           " IN oText

   oText:display()

   SET SCOREBOARD OFF
   SET DELETED ON
   FLUSH KEYBOARD

   // Create a DBTWin object.
   oWin := DBTWin():new( 11, 2, MAXROW() - 2, MAXCOL() - 2, "text", "demotext" )
   demotext->( dbSeek("ORDER") )

   // Disable editing of oWin:data
   oWin:allowEdit := FALSE

   oWin:titleFcColor := "n/g"
   oWin:paneColor    := oWin:paneFcColor  := "w/b"
   oWin:frameColor   := oWin:frameFcColor := "w/b"
   oWin:title        := "This is a DBTWin object, reading data from a DBT (memo) file"

   // Set the line length
   oWin:lineLength := 80

   oWin:read()

   // Hide the window
   oWin:implode(7)

   oText:hide()
   oText:clear()
   oText:resize( MAXROW() - 6, 12, MAXROW() - 3, 68 )
   oText:winSay( 0, 1, "Press <enter> on the Notes field to edit the notes" )
   oText:winSay( 1, 1, "using a DBTWin object. Press <Esc> when done..." )
   oText:display()

   // create a TBWin object to do the browse
   SELECT people
   GO TOP
   oTB := TBWin():new( 5, 25, 15, 55 )
   oTB:addfield("last_name",,"Last Name")
   oTB:frameColor    := "bg/b"
   oTB:frameFcColor  := "bg+/b"

   // Now add a calculated field to this TBWin, which will
   // display the string "<memo>" if there is something in
   // the memo field for the current record.
   oCol := oTB:addfield({|| IF( EMPTY(people->notes), SPACE(6), "<memo>" ) },,"Notes")

   // This sample program also demostrates usage of the <oCol>:editAction
   // instance variable. If you press <enter> while on the "name" field,
   // you'll invoke the default edit behavior. Pressing <enter> on the
   // "pointer" (aka MEMO) field edits the DBTWin object.

   oCol:editAction := {|| SETCURSOR( SC_NORMAL ), ;
                          editMemo(oNotes, otb,  ;
                          " Notes for "+TRIM(people->first_name)+" "+TRIM(people->last_name)+" -- Press Ctrl-W to Save "),;
                          SETCURSOR( SC_NONE ) }

   // create the DBTWin MEMOWIN descendant
   oNotes := DBTWin():new( 10, 5, 22, 75, "notes" )
   oNotes:frameColor    := "bg/b" ; oNotes:frameFcColor  := "bg+/b"
   oNotes:titleFcColor  := "n/bg*"

   // just pop it up, none of this growing stuff
   oNotes:explode := FALSE

   // browse it
   oTB:browse()

   // hide the window
   oTB:implode(1)

   // kill the windows
   oTB:kill()  ; oNotes:kill()
   oWin:kill() ; oText:kill()

   RETURN ( NIL )


***********************************************************************
* FUNCTION editDBT()
*
* Parameters  :
* Description : Stub function to edit notes
* Returns     :
***********************************************************************
FUNCTION editDBT( oFile, oTB )
   // first, ensure that the TB object is stable, otherwise we
   // may not be on the right record.
   STABILIZE BROWSE  oTB:tb
   oFile:title := "< Edit Notes for "+TRIM(people->first_name)+" "+TRIM(people->last_name)+" >" // nice touch huh?
   oFile:readData()
   oFile:read()
   oFile:hide()
   oTB:tb:refreshCurrent()
   RETURN ( NIL )


***********************************************************************
* FUNCTION dispText(<cKey>, <cTitle>  ) --> NIL
*
* Parameters  : cKey
* Description :
***********************************************************************
STATIC FUNCTION dispText( cKey, cTitle )

   LOCAL oWin
   LOCAL nSaveCursor := SETCURSOR( SC_NONE )

   IF demotext->( dbSeek( cKey ) )

      SETCOLOR( CLR_DEMO )

      oWin := DBTWin():new( 2, 0, soDeskTop:nBottom, MAXCOL(), ;
                              "text", "demotext" )

      oWin:explode      := FALSE
      oWin:allowEdit    := FALSE
      oWin:frameFcColor := "bg/b"
      oWin:topMargin    := 1
      oWin:leftMargin   := oWin:rightMargin := 2
      oWin:lineLength   := 80
      oWin:frameFcColor := "bg+/b"
      oWin:titleFcColor := "n/bg*"

      IF cTitle <> NIL
         oWin:title := cTitle
      ENDIF

      soDeskTop:setMessage( "<Esc> = return" )

      oWin:read( FALSE )

      soDeskTop:setMessage( "" )

      oWin:kill()

      SETCURSOR( nSaveCursor )

   ENDIF

   RETURN ( NIL )


***********************************************************************
* FUNCTION dmoEventMgr() --> NIL
*
* Parameters  :
* Description :
***********************************************************************
FUNCTION dmoEventMgr()

   LOCAL oTB
   LOCAL oIdle
   LOCAL cMsg
   LOCAL oText

   dispText( "EVENT DRIVEN", "An Overview of the StarClass Event System" )

   oText := Window():new( 5, 3, 10, 77, "n/bg" )

   oText:winSay( 0, 1,"This is an example of using the Idle class (background processing) to")
   oText:winSay( 1, 1,"post Messages on the event queue. It is a timed out browse: While in")
   oText:winSay( 2, 1,"browse mode, if you don't press a key or click the mouse, the browse")
   oText:winSay( 3, 1,"will time out and a message will be displayed.")

   oText:display()

   DeskTop():setMessage( "Press any key to continue..." )
   GetInput( 10 )
   SayCenter()


   SELECT people

   // Create a TBWin object
   oTB := TBWin():new( 10, 5, 20, 40 )

   oTB:addField( "last_name","@!","Last Name" )
   oTB:addField( "first_name",,"First Name" )
   oTB:setFocus()
   oTB:allowEdit  := oTB:allowDelete := oTB:allowAppend := FALSE

   // Override the ESC-to-loose-focus
   oTB:addKeyEvent( K_ESC, {|| TRUE } )

   // Set up an Idle event
   cMsg  := "Keyboard inactivity period exceeded!"

   oIdle := Idle():new( {|| oIdle:elapsed > 4 }, ;
               {|| Message():new( {|| oTB:exitRequested := TRUE } ):post(), ;
                   Message():new( {|| Tone(1000,2), Tone(500,1) } ):post(), ;
                   Message():new( {|| oTB:implode(8) }            ):post(), ;
                   Message():new( {|| SayCenter() }               ):post(), ;
                   Message():new( {|| oText:implode(8) }          ):post(), ;
                   Message():new( {|| MessageBox(cMsg,"w+/r",5)}  ):post() })

   oIdle:oneTime := TRUE

   // Display the TBWin
   oTB:browse()

   SayCenter( "If you don't press any keys (or click the mouse), the browse will time out." )

   oTB:kill()
   oIdle:kill()

   oText:kill()

   RETURN ( NIL )


***********************************************************************
* FUNCTION dmoChild()
*
* Parameters  :
* Description :  Relating a browse to a form window
* Returns     :
***********************************************************************
FUNCTION dmoChild

   LOCAL oParent
   LOCAL oChild
   LOCAL nStartArea := SELECT()

   SELECT people
   oParent := TBWin():new( 3, 5, 20, 30 )
   oParent:frameColor := "w/b"

   // add a couple of columns to the parent
   oParent:addField("last_name")

   // specify what happens when the browse is stable and the system is
   // just about to look for input activity
   oParent:Blocks[ BLOCK_PREINPUT ] := {|| oChild:display() }

   // specify that we want editing to occur in the child window
   ON ENTER IN oParent oChild:read()

   // create the child object
   oChild := Window():new( 9, 34, 18, 77, "w/b" )
   oChild:paneFcColor := oChild:frameFcColor := "g+/b"
   @ 0,1  SAY "First:   " GET people->first_name   IN  oChild
   @ 1,1  SAY "Last:    " GET people->last_name    IN  oChild
   @ 3,1  SAY "Address: " GET people->address_1    IN  oChild
   @ 4,1  SAY "         " GET people->address_2    IN  oChild
   @ 5,1  SAY "Postal:  " GET people->postal       IN  oChild
   @ 7,1  SAY "Phone:   " GET people->telephone    IN  oChild

   oChild:blocks[ BLOCK_PREREAD ]  := {|| Scatter() }
   oChild:blocks[ BLOCK_POSTREAD ] := {|| IF( LASTKEY() == K_ESC, Gather(), NIL ) }

   oParent:modal := TRUE

   oParent:helpMessage := "<Esc> when done            " + CHR_ENTER + " = Edit"
   oChild:helpMessage  := "<Esc> = Abort            PgDn = Save"


   oParent:browse()

   oParent:kill()
   oChild:kill()

   SELECT( nStartArea )

   RETURN ( NIL )


***********************************************************************
* FUNCTION AboutBox() --> NIL
*
* Description : Displays the "About" window
***********************************************************************
STATIC FUNCTION AboutBox()

   LOCAL oAbout := Window():new( 9, 14, 18 )

   oAbout:paneFcColor  := oAbout:paneColor  := "w+/g"
   oAbout:frameFcColor := oAbout:frameColor := "bg+/g"

   oAbout:winSay( 1, 0, "   << StarClass 3.0 Demo >>   ", "n/bg", TRUE )
   oAbout:winSay( 3, 0, "Copyright (c) 1993,1994 Loesgen Software, Inc.",, TRUE )
   oAbout:winSay( 4, 0, "All Worldwide Rights Reserved",, TRUE )

   @ 6, INT( ( ( oAbout:right - oAbout:left ) / 2 ) - 5 ) ;
        BUTTON "   ~OK   "                                ;
        ACTION oAbout:abort()                             ;
        IN oAbout

   oAbout:modal := TRUE
   oAbout:read()

   oAbout:implode( 8 )
   oAbout:kill()

   RETURN ( NIL )


***********************************************************************
* FUNCTION dmoGauge1()
*
* Description :
* Returns     :
***********************************************************************
FUNCTION dmoGauge1()

   LOCAL oGauge1
   LOCAL oGauge2
   LOCAL oGauge3
   LOCAL x
   LOCAL oInfo
   LOCAL cSaveIconColor := soAppDefs:iconColor

   soMouse:hide()

   // gauge 1 -- Fancy
   soAppDefs:iconColor := "g+/b"
   oGauge1 := GaugeWin():new(  5, 10, 12, 65, 100 )
   oGauge1:resizeGauge( 3, 4, 4, 50 )
   oGauge1:title        := "Example of a GaugeWin Object with Text"
   oGauge1:titleStyle   := SC_TITLESTYLE_WINDOWS
   oGauge1:titleColor   := oGauge1:titleFcColor := "n/g*"
   oGauge1:frameColor   := oGauge1:frameFcColor := "g+/b"
   oGauge1:paneColor    := oGauge1:paneFcColor  := "w/b"
   oGauge1:setEventHandlers()
   oGauge1:gauges[1]:notDoneColor := "w+/r*"
   oGauge1:gauges[1]:doneColor    := "g+/gr*"

   @ 2, 3, 5, 51 FRAME SNGLBORD+" " COLOR "BG/B"                         ;
                                TITLE " Percentage Complete "            ;
                                TITLECOLOR "BG+/B"                       ;
                                TITLESTYLE SC_TITLESTYLE_CENTERED        ;
                                IN oGauge1

   // gauge 2 -- Simple
   oGauge2 := GaugeWin():new( 15, 10, 18, 40, 100,, "bg+/g", "r/g", CHR(178), CHR(176) )
   oGauge2:resizeGauge( 1, 1, 1, 27 )
   oGauge2:title        := "A Simple GaugeWin Object"
   oGauge2:titleStyle   := SC_TITLESTYLE_WINDOWS
   oGauge2:titleColor   := oGauge2:titleFcColor := "g+/n"
   oGauge2:frameColor   := oGauge2:frameFcColor := "n/g"
   oGauge2:paneColor    := oGauge2:paneFcColor  := "n/g"

   // gauge 3 -- Vertical
   oGauge3 := GaugeWin():new( 10, 47, 20, 58, 100,, "bg/n", "/r",,, FALSE )
   oGauge3:titleColor   := oGauge3:titleFcColor := "n/bg*"
   oGauge3:title        := "Vertical"
   oGauge3:frameColor   := oGauge3:frameFcColor := "bg+/n*"
   oGauge3:paneColor    := oGauge3:paneFcColor  := "bg+/n*"
   oGauge3:resizeGauge( 3, 2, 8, 7 )

   oInfo := Window():new( 7, 3 )

   oInfo:winSay(  0, 1, "The GaugeWin class is used to display progress gauges.                 ")

   oInfo:winSay(  2, 1, "This class is a composite class: it contains Gauge objects which it      ")
   oInfo:winSay(  3, 1, "uses as progress indicators (the StarClass OOP tutorial includes a       ")
   oInfo:winSay(  4, 1, "description of what a composite class is).                               ")

   oInfo:winSay(  6, 1, "The design of GaugeWin is very open, the gauges are contained in an     ")
   oInfo:winSay(  7, 1, "array in the GaugeWin object. This allows you to have multiple gauges   ")
   oInfo:winSay(  8, 1, "in a window, possibly of different types.                               ")

   oInfo:display()
   GetInput(0)
   oInfo:implode(3)
   oInfo:kill()

   FLUSH KEYBOARD

   FOR x := 1 TO 100

       IF INKEY() <> 0
          EXIT
       ENDIF

       // gauge 1
       oGauge1:says := {}
       oGauge1:winSay( 1,, LTRIM( TRANSFORM( x , "99,999,999") ) + ;
                           " out of 100", "w+/b", TRUE )


       oGauge1:display( x )

       // gauge 2
       oGauge2:display( x )

       // gauge 3
       oGauge3:display( x )

       IF x = 100
          x := 1
       ENDIF

   NEXT

   BaseWin():implodeAll(5)
   oGauge1:kill()
   oGauge2:kill()
   oGauge3:kill()

   soAppDefs:iconColor := cSaveIconColor
   soMouse:display()

   RETURN ( NIL )


***********************************************************************
* FUNCTION dmoGauge2()
*
* Description :
* Returns     :
***********************************************************************
FUNCTION dmoGauge2()

   LOCAL oGaugeWin
   LOCAL x, y, z
   LOCAL aFiles   := {}
   LOCAL aProcess := { "Open    <Esc> to quit", ;
                       "Read    <Esc> to quit", ;
                       "Write   <Esc> to quit", ;
                       "Close   <Esc> to quit"  }
   LOCAL oFileGauge, oProcessGauge, oByteGauge, oVertByteGauge

   LOCAL nNumFiles     := 5
   LOCAL nNumProcess   := LEN( aProcess )
   LOCAL nNumBytes     := 30
   LOCAL bUpdateString
   LOCAL nSaveJustify  := soDeskTop:helpBarJustify
   LOCAL oInfo

   soMouse:hide()

   // Create a GaugeWin
   oGaugeWin := scGaugeWin():new(  5, 10, 18, 72, 100 )

   // Resize the default gauge which is added by the constructor
   oGaugeWin:resizeGauge( 2, 3, 2, 49 )

   // Do some aesthetics...
   oGaugeWin:title        := "Example of a Complex GaugeWin Object"
   oGaugeWin:titleStyle   := SC_TITLESTYLE_WINDOWS
   oGaugeWin:titleColor   := oGaugeWin:titleFcColor := "n/g*"
   oGaugeWin:frameColor   := oGaugeWin:frameFcColor := "g+/b"

   @ 1, 2, 3, 50 FRAME SNGLBORD+" " COLOR "BG/B"            ;
                 TITLE " Files "                            ;
                 TITLECOLOR "BG+/B"                         ;
                 TITLESTYLE SC_TITLESTYLE_CENTERED_INLINE   ;
                 IN oGaugeWin

   // Get a reference to the default gauge
   oFileGauge := oGaugeWin:gauges[ 1 ]
   oFileGauge:maxValue := nNumFiles
   oFileGauge:doneColor    := "r+/gr*"
   oFileGauge:notDoneColor := "w+/*"

   // Add a second gauge
   oProcessGauge := oGaugeWin:addGauge( 5, 3, 5, 49 )
   oProcessGauge:maxValue     := LEN( aProcess )
   oProcessGauge:doneColor    := "g+/b*"
   oProcessGauge:notDoneColor := "w+/*"

   @ 4, 2, 6, 50 FRAME SNGLBORD+" " COLOR "BG/B"            ;
                 TITLE " Processes "                        ;
                 TITLECOLOR "BG+/B"                         ;
                 TITLESTYLE SC_TITLESTYLE_CENTERED_INLINE   ;
                 IN oGaugeWin


   // Add a third gauge
   oByteGauge := oGaugeWin:addGauge( 8, 3, 8, 49 )
   oByteGauge:maxValue     := nNumBytes
   oByteGauge:doneColor    := "b+/w*"
   oByteGauge:notDoneColor := "w+/*"

   @ 7, 2, 9, 50 FRAME SNGLBORD+" " COLOR "BG/B"            ;
                 TITLE " Bytes Processed "                  ;
                 TITLECOLOR "BG+/B"                         ;
                 TITLESTYLE SC_TITLESTYLE_CENTERED_INLINE   ;
                 IN oGaugeWin


   // Add a fourth gauge (the vertical one)
   oVertByteGauge := oGaugeWin:addGauge( 2, 54, 8, 57, nNumBytes,,"b+/w*","w+/r*",,,FALSE )

   @ 1, 53, 9, 58 FRAME SNGLBORD+" " COLOR "BG/B"            ;
                  IN oGaugeWin


   soDeskTop:setMessage("Multiple Gauge Demo")

   bUpdateString := {|v| " Processing File " +                            ;
                         LTRIM( TRANSFORM( v , "99,999,999") ) +           ;
                         " of " + LTRIM( TRANSFORM( nNumFiles, "99,999" )) +" "}

   oInfo := Window():new( 9, 9 )

   oInfo:winSay(  0, 1, "You're about to see an example of a more complex GaugeWin.  ")

   oInfo:winSay(  2, 1, "This GaugeWin contains multiple gauges, all of which are    ")
   oInfo:winSay(  3, 1, "being updated under program control (inside a FOR...NEXT    ")
   oInfo:winSay(  4, 1, "loop).                                          ")

   oInfo:display()
   GetInput(0)
   oInfo:implode(5)
   oInfo:kill()

   FLUSH KEYBOARD

   FOR x := 1 TO nNumFiles

       // Check for an attempt to end this demo and add a bit of
       // a delay.

       // Clear the SAYS array. This is needed because the text will be
       // centered, and hence will not be at an absolute column position
       // where it would automatically replace another text string.
       oGaugeWin:says := {}

       // Add the text message to the GaugeWin
       oGaugeWin:winSay( 11,,bUpdateString:eval(x), "r+/b", TRUE )

       // Set the current value of the first gauge
       oFileGauge:value := x

       FOR y := 1 TO nNumProcess

           // Set the current value of the second gauge
           oProcessGauge:value := y


           soDeskTop:setMessage( aProcess[ y ] )

           FOR z := 1 TO nNumBytes

               IF INKEY() == K_ESC .OR. LASTKEY() == K_ESC
                  EXIT
               ENDIF

               // Set the current value of the third gauge
               oByteGauge:value     := z

               // Set the current value of the vertical (fourth) gauge
               oVertByteGauge:value := z

               // After all that, finally, display the GaugeWin
               oGaugeWin:display()

           NEXT

       NEXT

   NEXT

   oGaugeWin:kill()

   soDeskTop:helpBarJustify := nSaveJustify
   soDeskTop:setMessage("")

   soMouse:display()

   RETURN ( NIL )


***********************************************************************
* FUNCTION dmoGauge3()
*
* Description : The "Patient Monitor"
* Returns     :
***********************************************************************
FUNCTION dmoGauge3()

   #define _NAME         1
   #define _ADDRESS1     2
   #define _ADDRESS2     3
   #define _SEX          4
   #define _AGE          5
   #define _INSURED      6

   LOCAL oDeskTop := DeskTop()
   LOCAL lMute    := FALSE
   LOCAL oMarquee
   LOCAL oInfo
   LOCAL aData    := { "John Doe                ", ;
                       "1701 Sumach Street,     ", ;
                       "St. Stephen, NB.        ", ;
                       "Male"                    , ;
                       29                        , ;
                       TRUE }

   PushVideo()

   soMouse:hide()

   SETCOLOR( "bg+/n*" )

   // Create a GaugeWin
   oGaugeWin := scGaugeWin():new(  1, 5, 22, 74 )

   // Do some aesthetics...
   oGaugeWin:title       := "Patient Monitor"
   oGaugeWin:titleStyle  := SC_TITLESTYLE_WINDOWS
   oGaugeWin:titleColor  := oGaugeWin:titleFcColor := "n/g*"
   oGaugeWin:frameColor  := oGaugeWin:frameFcColor := "g+/b"

   oPulse := oGaugeWin:addGauge( 2, 3, 11, 7, 100,          ;
                                 {|| 50 + Random(49)},      ;
                                 "r+/gr*", "w+/*",          ;
                                 ,, FALSE )

   @ 1, 2, 12, 8 FRAME SNGLBORD+" " COLOR "BG/B"            ;
                 IN oGaugeWin

   oBloodPres  := oGaugeWin:addGauge( 2, 10, 11, 13, 100,   ;
                                 {|| 50 + Random(49)},      ;
                                 "r+/gr*", "w+/*",          ;
                                 ,, FALSE )

   @ 1, 9, 12, 14 FRAME SNGLBORD+" " COLOR "BG/B"           ;
                   IN oGaugeWin


   oTemp     := oGaugeWin:addGauge( 2, 16, 11, 19, 100,     ;
                                 {|| 50 + Random(49)},      ;
                                 "r+/gr*", "w+/*", ;
                                 ,, FALSE )

   @ 1, 15, 12, 20 FRAME SNGLBORD+" " COLOR "BG/B"          ;
                   IN oGaugeWin


   oAlpha     := oGaugeWin:addGauge( 2, 22, 11, 25, 100,    ;
                                 {|| 20 + Random(79)},      ;
                                 "r+/gr*", "w+/*",          ;
                                 ,, FALSE )

   @ 1, 21, 12, 26 FRAME SNGLBORD+" " COLOR "BG/B"          ;
                   IN oGaugeWin


   @14, 33 BUTTON "  ~Quit   "                              ;
          ACTION {|| KillPatient() }                        ;
          IN oGaugeWin

   @14,44 BUTTON "  ~Mute  "                                ;
          ACTION {|| lMute := TRUE }                        ;
          WHEN ! lMute                                      ;
          IN oGaugeWin

   @14,54 BUTTON "  ~Noise  "                               ;
          ACTION {|| lMute := FALSE }                       ;
          WHEN lMute                                        ;
          IN oGaugeWin

   oInfo := Window():new( 4, 3 )

   oInfo:winSay(  0, 1, "This example uses another technique to update the gauges.             ")

   oInfo:winSay(  2, 1, "Each gauge (and remember that a GaugeWin can contain many gauges) has ")
   oInfo:winSay(  3, 1, "a positionBlock, a code block which can be used to determine the      ")
   oInfo:winSay(  4, 1, "current position of the gauge.                                        ")

   oInfo:winSay(  6, 1, "This example uses the positionBlocks, in conjunction with the Idle()  ")
   oInfo:winSay(  7, 1, "class, to update the gauges                  . To make it a little    ")
   oInfo:winSay(  7, 29,                            "in the background", "r+/b" )
   oInfo:winSay(  8, 1, "more complex, the sounds you'll hear are also generated by Idle()     ")
   oInfo:winSay(  9, 1, "objects.                                                              ")

   oInfo:winSay( 11, 1, "This is by no means a standard application of the GaugeWin class, but ")
   oInfo:winSay( 12, 1, 'it serves to give you a glimpse at the power available "under the     ')
   oInfo:winSay( 13, 1, 'hood". What this example shows is very sophisticated, yet it is       ')
   oInfo:winSay( 14, 1, "elegantly simple from the client code standpoint.                     ")

   oInfo:display()
   GetInput(0)
   oInfo:implode(5)
   oInfo:kill()

   // Set up the background tasks

   oIdle := Idle():new( {|| oIdle:elapsed > .2 }, ;
                        {|| oGaugeWin:display( TRUE ) })


   oHeartBeat := Idle():new( {|| oHeartBeat:elapsed > .7 }, ;
                             {|| IF( ! lMute, TONE(200,1), NIL )} )

   oMarquee := oGaugeWin:addMarquee( ,, "No significant change in patient status",,, "g+/b" )

   oIdleMarquee   := Idle():new( {|| oIdleMarquee:elapsed > .2 }, ;
                             {|| Window():displayMarquees() } )


   @ 1, 29, 12, 66 FRAME SNGLBORD+" " COLOR "G+/B" ;
                   IN oGaugeWin


   @ 3, 31 SAY "Name:     "   GET aData[ _NAME ]      IN oGaugeWin
   @ 5, 31 SAY "Address:  "   GET aData[ _ADDRESS1 ]  IN oGaugeWin
   @ 6, 31 SAY "          "   GET aData[ _ADDRESS2 ]  IN oGaugeWin

   @ 8, 31 SAY "Sex:"  IN oGaugeWin

   @ 8, 41 GET aData[ _SEX ]                    ;
           RADIOBUTTON {"Male", "Female"}       ;
           HORIZONTAL                           ;
           COLOR "w/b, /w"                      ;
           IN oGaugeWin

   @10, 31 SAY "Age:      "                     ;
           GET aData[ _AGE ]                    ;
           PICTURE "999"                        ;
           IN oGaugeWin

   @10, 54 GET aData[ _INSURED ]                ;
           CHECKBOX "Insured"                   ;
           COLOR "w/b, /w"                      ;
           IN oGaugeWin

   @13,1 SAY "    P     P     T     A "  IN oGaugeWin
   @14,1 SAY "    U     R     E     L "  IN oGaugeWin
   @15,1 SAY "    L     E     M     P "  IN oGaugeWin
   @16,1 SAY "    S     S     P     H "  IN oGaugeWin
   @17,1 SAY "    E                 A "  IN oGaugeWin


   soDeskTop:setMessage( "               Alt+Q = Quit          Alt+N / Alt+M = Toggle sound      " )

   oGaugeWin:setFocus()
   oGaugeWin:display()

   oGaugeWin:modal := TRUE

   Run()

   PopVideo()

   soDeskTop:setMessage()

   oGaugeWin:implode(8)
   oGaugeWin:kill()

   oHeartBeat:kill()
   oIdle:kill()
   oIdleMarquee:kill()

   soMouse:display()

   slHasSeenGauge := TRUE

   RETURN( NIL )


***********************************************************************
* FUNCTION KillPatient() --> NIL
*
* Description : Errr.... "terminate" this part of the demo? <g>
***********************************************************************
FUNCTION KillPatient()
   LOCAL lDone      := FALSE
   LOCAL oIdleClass := Idle()
   LOCAL nLifeSigns

   soDeskTop:setMessage("")

   oPulse:positionBlock     := NIL
   oTemp:positionBlock      := NIL
   oBloodPres:positionBlock := NIL
   oAlpha:positionBlock     := NIL

   // make sure pulse and alpha start high
   oPulse:value     := MAX( oPulse:value, 80 )
   oAlpha:value     := MAX( oAlpha:value, 70 )

   oGaugeWin:deleteMarquees()

   @ oGaugeWin:bottom - oGaugeWin:top - 2, 1 ;
     SAY "   We may have a problem here!   " ;
     CENTERED COLOR "n/r*" IN oGaugeWin

   oIdle:kill()

   WHILE ! lDone

      oGaugeWin:display()

      nLifeSigns :=  ( oPulse:value     := MAX( 0, oPulse:value - 1 ) )     + ;
                     ( oTemp:value      := MAX( 0, oTemp:value - 1 ) )      + ;
                     ( oAlpha:value     := MAX( 0, oAlpha:value - 1 ) )     + ;
                     ( oBloodPres:value := MAX( 0, oBloodPres:value - 1 ) )

      lDone := ( nLifeSigns = 0 )

      DO CASE
         CASE nLifeSigns < 20
              oHeartBeat:trigger := {|| oHeartBeat:elapsed > 1 }
              oHeartBeat:action  := {|| TONE(170,2) }
         CASE nLifeSigns < 60
              oHeartBeat:trigger := {|| oHeartBeat:elapsed > .9 }
              oHeartBeat:action  := {|| TONE(180,1) }
         CASE nLifeSigns < 90
              oHeartBeat:trigger := {|| oHeartBeat:elapsed > .8 }
              oHeartBeat:action  := {|| TONE(190,1) }
      ENDCASE

      oIdleClass:check()

   END
   TONE( 1000, 20 )

   EventMgr():endPoll := TRUE

   RETURN ( NIL )


***********************************************************************
* FUNCTION MainMenu() --> oBarMenu
*
* Description : Create the main menu for the demo.
***********************************************************************
STATIC FUNCTION MainMenu()

   LOCAL oBarMenu
   LOCAL oFileMenu, oWindowMenu
   LOCAL oTBMenu, oGaugeMenu
   LOCAL oColorsMenu, oConfigMenu, oHelpBarMenu, oHelpMenu, oDescriptions

   CREATE BARMENU oBarMenu

   CREATE MENU oFileMenu

      ADD MENUITEM "What is ~StarClass?"                               ;
          ACTION dispText( "DESCRIPTION", "What is StarClass 3.0? " )  ;
          HELPMESSAGE "General description of StarClass"               ;
          TO oFileMenu

      ADD SEPARATOR TO oFileMenu

      CREATE MENU oDescriptions

         ADD MENUITEM "~Event Manager"                                         ;
             ACTION dispText( "EVENT DRIVEN", "An Overview of the StarClass Event System"  )                                 ;
             HELPMESSAGE "An overview of the StarClass event handling system"  ;
             TO oDescriptions

         ADD MENUITEM "~Menu System"                                           ;
             ACTION dispText( "CUAMENU", "StarClass CUA Compliant Menuing System" )                                      ;
             HELPMESSAGE "An overview of the StarClass CUA compliant menu system"  ;
             TO oDescriptions

         ADD MENUITEM "~DeskTop"                                               ;
             ACTION dispText( "DESKTOP", "Overview of the StarClass DeskTop" ) ;
             HELPMESSAGE "An overview of the StarClass DeskTop"                ;
             TO oDescriptions

         ADD MENUITEM "~Overviews"                                             ;
             POPUP oDescriptions                                               ;
             HELPMESSAGE "Overviews of various parts of the StarClass architecture" ;
             TO oFileMenu

      ADD MENUITEM "~Quotes"                                                   ;
          ACTION   dispText( "QUOTES" )                                        ;
          HELPMESSAGE "Quotes by Famous People and current users"             ;
          TO oFileMenu

      ADD MENUITEM "Other ~Third Party Products"                               ;
          ACTION   dispText( "OTHER ISV", "Compatibility with other third party products") ;
          HELPMESSAGE "Compatibility with other third party products"          ;
          TO oFileMenu

      ADD SEPARATOR TO oFileMenu

      ADD MENUITEM "Ordering ~Info"                                            ;
          ACTION   OrderInfo()                                                 ;
          HELPMESSAGE "View, and optionaly print, an order form"               ;
          TO oFileMenu

      ADD SEPARATOR TO oFileMenu

      ADD MENUITEM "E~xit"                                                     ;
          ACTION ConfirmQuit()                                                 ;
          HELPMESSAGE "Quit this demo and return to DOS"                       ;
          TO oFileMenu


   CREATE MENU oWindowMenu

      ADD MENUITEM "~Introduction"                                             ;
          ACTION ( dmoIntro(), dmoTitle(), dmoColor(), dmoDepth() )            ;
          HELPMESSAGE "An introduction to the Windowing system"                ;
          TO oWindowMenu

      ADD SEPARATOR TO oWindowMenu

      ADD MENUITEM "~Effects"                                                  ;
          ACTION   ( dmoZoom(), dmoHide(), dmoSend(), dmoMarquee() )           ;
          HELPMESSAGE "Some of the visual special effects in StarClass 3"      ;
          TO oWindowMenu

      ADD MENUITEM "~Forms"                                                    ;
          ACTION   ( dmoRead(), dmoRead2(), dmoRead3() )                       ;
          HELPMESSAGE "Displaying and editing data in Windows"                 ;
          TO oWindowMenu

      ADD MENUITEM "~Radio Buttons & Check Boxes"                              ;
          ACTION   ( dmoCheck1(), dmoCheck2() )                                ;
          HELPMESSAGE "Demonstration of the Radio Buttons and Check Boxes"     ;
          TO oWindowMenu

      ADD MENUITEM "~MemoText Family"                                          ;
          ACTION   dmoMemoText()                                               ;
          HELPMESSAGE "An introduction to the MemoText text editing classes"   ;
          TO oWindowMenu

      ADD MENUITEM "E~vent Manager"                                            ;
          ACTION dmoEventMgr()                                                 ;
          HELPMESSAGE "An example of the StarClass EventMgr class"             ;
          TO oWindowMenu

      IF ! soAppDefs:fontRemap
         ADD MENUITEM "~Timer Class"                                           ;
             ACTION   ( dmoTimer1(), dmoTimer2() )                             ;
             HELPMESSAGE "A demonstration of the timer class"                  ;
             TO oWindowMenu
      ENDIF


   CREATE MENU oTBMenu

      ADD MENUITEM "~Introduction"                                             ;
          ACTION   ( dmoTBIntro(), dmoTBZoom() )                               ;
          HELPMESSAGE "Introduction to the TB___ family of data browsers"      ;
          TO oTBMenu

      ADD SEPARATOR TO oTBMenu

      ADD MENUITEM "I~ncremental seeking"                                      ;
          ACTION   dmoTBSeek()                                                 ;
          HELPMESSAGE "A demonstration of the incremental seeking abilities"   ;
          TO oTBMenu

      ADD MENUITEM "~Parent/child browses"                                     ;
          ACTION   ( dmoTBPrnt(), dmoTBPrnt2() )                               ;
          HELPMESSAGE "A demonstration of related data browsers"               ;
          TO oTBMenu

      ADD MENUITEM "~Code insertion points"                                    ;
          ACTION   ( dispText("BLOCKS","Extending StarClass with Code Insertion Points"), dmoChild() )                          ;
          HELPMESSAGE "Extending StarClass: code insertion points make it easy!" ;
          TO oTBMenu

      ADD MENUITEM "Related browses with ~forms"                               ;
          ACTION   dmoMult()                                                   ;
          HELPMESSAGE "Form windows can be related to browsers"                ;
          TO oTBMenu

      ADD MENUITEM "~Navigating a browse with Buttons"                         ;
          ACTION   TBButtons()                                                 ;
          HELPMESSAGE "Buttons can be incorporated in browsers"                ;
          TO oTBMenu


   CREATE MENU oGaugeMenu

      ADD MENUITEM "~Progress Gauges"                                          ;
          ACTION ( dmoGauge1(), dmoGauge2(), dmoGauge3() )                     ;
          HELPMESSAGE "Progress Gauges -- Don't miss this one!!!"              ;
          TO oGaugeMenu

      ADD MENUITEM "~Scroll Bars"                                              ;
          ACTION dmoScrollBar()                                                ;
          HELPMESSAGE "Vertical and horizontal scroll bars"                    ;
          TO oGaugeMenu


   CREATE MENU oConfigMenu

      CREATE MENU oColorsMenu

         ADD MENUITEM "~Cycle through colors"                                  ;
             ACTION {|| AEVAL( oColorsMenu:menuItems, {|e| e:checked := FALSE } ),;
                        CycleColors(),                                         ;
                        oColorsMenu:menuItems[ snColorIndex + 2 ]:checked := TRUE }  ;
             HELPMESSAGE "Iterate throught the array of colors"                ;
             TO oColorsMenu

         ADD SEPARATOR TO oColorsMenu


         AADD( saColors, { soDeskTop:backColor, soDeskTop:titleColor,          ;
                           soDeskTop:helpBarColor } )

         ADD MENUITEM PADR( UPPER( soDeskTop:backColor ), 5 ) +                ;
             " DeskTop background ~1"                                          ;
             ACTION {|o| SetDTColors( oColorsMenu, 1, o ) }                     ;
             COLOR ",n/n*,,,n+/n*"                                             ;
             CHECKED                                                           ;
             TO oColorsMenu

         AADD( saColors, { "g/n", "n/bg", "n/bg" } )
         ADD MENUITEM "G/N   DeskTop background ~2"                            ;
             ACTION {|o| SetDTColors( oColorsMenu, 2, o ) }                     ;
             COLOR ",g/n,,,g+/n"                                               ;
             TO oColorsMenu


         AADD( saColors, { "gr/n*", "n/bg", "n/bg" } )
         ADD MENUITEM "GR/N* DeskTop background ~3"                            ;
             ACTION {|o| SetDTColors( oColorsMenu, 3, o ) }                     ;
             COLOR ",gr/n*,,,gr+/n*"                                           ;
             TO oColorsMenu

         AADD( saColors, { "n/bg", "w/rb", "w/rb" } )
         ADD MENUITEM "N/BG  DeskTop background ~4"                            ;
             ACTION {|o| SetDTColors( oColorsMenu, 4, o ) }                     ;
             COLOR ",n/bg,,,n+/bg"                                             ;
             TO oColorsMenu

         ADD MENUITEM "~DeskTop colors"                                        ;
             POPUP oColorsMenu                                                 ;
             HELPMESSAGE "Select Colors"                                       ;
             TO oConfigMenu

      CREATE MENU oHelpBarMenu

         ADD MENUITEM "~Display help bar"                                      ;
             ACTION ( soDeskTop:dispHelpBar := ! soDeskTop:dispHelpBar,        ;
                      SetHelpBarMenu( oHelpBarMenu ) )                         ;
             HELPMESSAGE "Toggle display of this DeskTop help bar"             ;
             CHECKED TO oHelpBarMenu

         ADD SEPARATOR TO oHelpBarMenu

         ADD MENUITEM "~Left justified"                                        ;
             ACTION ( soDeskTop:helpBarJustify := SC_JUSTIFY_LEFT,             ;
                      SetHelpBarMenu( oHelpBarMenu ) )                         ;
             SELECTABLE WHEN soDeskTop:dispHelpBar                             ;
             HELPMESSAGE "Left justify help messages"                          ;
             TO oHelpBarMenu

         ADD MENUITEM "~Centered"                                              ;
             ACTION ( soDeskTop:helpBarJustify := SC_JUSTIFY_CENTER,           ;
                      SetHelpBarMenu( oHelpBarMenu ) )                         ;
             SELECTABLE WHEN soDeskTop:dispHelpBar                             ;
             HELPMESSAGE "Center help messages"                                ;
             CHECKED                                                           ;
             TO oHelpBarMenu

         ADD MENUITEM "~Right justified"                                       ;
             ACTION ( soDeskTop:helpBarJustify := SC_JUSTIFY_RIGHT,            ;
                      SetHelpBarMenu( oHelpBarMenu ) )                         ;
             SELECTABLE WHEN soDeskTop:dispHelpBar                             ;
             HELPMESSAGE "Right justify help messages"                         ;
             TO oHelpBarMenu

         ADD MENUITEM "~Help Bar"                                              ;
             POPUP oHelpBarMenu                                                ;
             HELPMESSAGE "Configuration options for the help bar"              ;
             TO oConfigMenu

         ADD MENUITEM "~Retain menu positions"                                 ;
             ACTION {|o| Menu():savePos := ! Menu():savePos,                   ;
                     o:checked := ! o:checked }                                ;
             HELPMESSAGE "Remember the last menu item in each pulldown menu"   ;
             CHECKED                                                           ;
             TO oConfigMenu

         // To lessen the chance of missing anything while the user goes
         // through the menus, turn on the savePos-ition option, which
         // will retain the last position in a pulldown
         Menu():savePos := TRUE

         ADD MENUITEM "~Shade windows" ;
             ACTION {|o| soAppDefs:shadowWindows := ! soAppDefs:shadowWindows(), ;
                         o:checked := ! o:checked }                            ;
             HELPMESSAGE "Toggle window shading"                               ;
             CHECKED                                                           ;
             TO oConfigMenu

         ADD MENUITEM "Set DeskTop ~background character"                      ;
             ACTION SetDTChar()                                                ;
             HELPMESSAGE "Pick the DeskTop's background character from a PopMenu" ;
             TO oConfigMenu

         ADD SEPARATOR TO oConfigMenu

         ADD MENUITEM "Set video mode to ~25 x 80"                             ;
             ACTION soDeskTop:setVideoMode( 25, 80 )                           ;
             SELECTABLE WHEN MAXROW() <> 24                                    ;
             TO oConfigMenu

         ADD MENUITEM "Set video mode to ~50 x 80"                             ;
             ACTION soDeskTop:setVideoMode( 50, 80 )                           ;
             SELECTABLE WHEN MAXROW() <> 49                                    ;
             TO oConfigMenu

   CREATE MENU oHelpMenu

      ADD MENUITEM "~About"                                                    ;
          ACTION AboutBox()                                                    ;
          HELPMESSAGE "See version information for this demo"                  ;
          TO oHelpMenu

   /* --- Add pulldown menus to the barmenu ---*/

   ADD MENUITEM " ~File "                                                      ;
       PULLDOWN oFileMenu                                                      ;
       HELPMESSAGE "General Information"                                       ;
       TO BARMENU oBarMenu

   ADD MENUITEM " ~Windows "                                                   ;
       PULLDOWN oWindowMenu                                                    ;
       HELPMESSAGE "The Windowing System"                                      ;
       TO BARMENU oBarMenu

   ADD MENUITEM " ~Browsers "                                                  ;
       PULLDOWN oTBMenu                                                        ;
       HELPMESSAGE "The TB___ Family"                                          ;
       TO BARMENU oBarMenu

   ADD MENUITEM " ~Gauges "                                                    ;
       PULLDOWN oGaugeMenu                                                     ;
       HELPMESSAGE "Scroll bars and Progress Gauges"                           ;
       TO BARMENU oBarMenu

   ADD MENUITEM " ~Options "                                                   ;
       PULLDOWN oConfigMenu                                                    ;
       HELPMESSAGE "Change the configuration of this demo"                     ;
       TO BARMENU oBarMenu

   ADD MENUITEM " ~Help "                                                      ;
       PULLDOWN oHelpMenu                                                      ;
       HELPMESSAGE "Help options"                                              ;
       TO BARMENU oBarMenu

   RETURN ( oBarMenu )


***********************************************************************
* FUNCTION SetHelpBarMenu() --> NIL
*
* Parameters  :
* Description :
***********************************************************************
FUNCTION SetHelpBarMenu( oMenu )

   LOCAL nJustify

   AEVAL( oMenu:menuItems, {|e| e:checked := FALSE } )

   IF soDeskTop:dispHelpBar

      oMenu:menuItems[ 1 ]:checked := TRUE

      nJustify := soDeskTop:helpBarJustify

      DO CASE
      CASE nJustify == SC_JUSTIFY_LEFT
         oMenu:menuItems[ 3 ]:checked := TRUE

      CASE nJustify == SC_JUSTIFY_CENTER
         oMenu:menuItems[ 4 ]:checked := TRUE

      CASE nJustify == SC_JUSTIFY_RIGHT
         oMenu:menuItems[ 5 ]:checked := TRUE

      ENDCASE

   ENDIF

   RETURN ( NIL )


***********************************************************************
* FUNCTION SetDTColor(<oMenu>, <>, <>) --> NIL
*
* Parameters  :
* Description :
***********************************************************************
FUNCTION SetDTColors( oMenu, nColorIndex, oMenuItem )

   AEVAL( oMenu:menuItems, {|o| o:checked := FALSE }, 2 )

   soDeskTop:backColor    := saColors[ nColorIndex ][ CLR_DESKTOP ]
   soDeskTop:titleColor   := saColors[ nColorIndex ][ CLR_BACK    ]
   soDeskTop:helpBarColor := saColors[ nColorIndex ][ CLR_HELPBAR ]
   soDeskTop:clock:color  := saColors[ nColorIndex ][ CLR_BACK    ]

   oMenuItem:checked := TRUE
   soDeskTop:display()

   RETURN ( NIL )


***********************************************************************
* FUNCTION CycleColors() --> NIL
*
* Parameters  :
* Description :
***********************************************************************
FUNCTION CycleColors()

   LOCAL nDelay := .5
   LOCAL oWin   := Window():new( 11, 8 )

   @ 0, 1 SAY "How long a delay would you like between color changes? " ;
          GET nDelay                                                    ;
          PICTURE "999.9"                                               ;
          IN oWin

   oWin:read()
   oWin:implode( 8 )
   oWin:kill()

   WHILE INKEY( nDelay ) == 0

      IF ++snColorIndex > LEN( saColors )
         snColorIndex := 1
      ENDIF

      soDeskTop:backColor    := saColors[ snColorIndex ][ CLR_DESKTOP ]
      soDeskTop:titleColor   := saColors[ snColorIndex ][ CLR_BACK    ]
      soDeskTop:helpBarColor := saColors[ snColorIndex ][ CLR_HELPBAR ]
      soDeskTop:clock:color  := saColors[ snColorIndex ][ CLR_BACK    ]
      soDeskTop:display()
      soDeskTop:setMessage( "Cycling through some sample DeskTop colors, now displaying set " + LTRIM( XToC( snColorIndex ) ) )

   ENDDO

   RETURN ( NIL )


***********************************************************************
* FUNCTION SetDTChar()
*
* Parameters  :
* Description :
* Returns     :
***********************************************************************
FUNCTION SetDTChar()

   STATIC oMenu

   IF oMenu = NIL

      CREATE POPMENU oMenu ROW 7 COLUMN 20 ;
            TITLE " Pick Character "      ;
            TITLECOLOR "w+/r"

         // Add a dummy menu item
         ADD MENUITEM "" ACTION  NIL SELECTABLE WHEN FALSE TO oMenu

         ADD MENUITEM "~StarClass"                              ;
            ACTION ( soDeskTop:backGroundChar := SC_BACKGROUND, ;
                     soDeskTop:display() )                      ;
            TO oMenu

         ADD MENUITEM "~None"                                   ;
            ACTION ( soDeskTop:backGroundChar := " ",           ;
                     soDeskTop:display() )                      ;
            TO oMenu

         ADD MENUITEM REPL( "", LEN( SC_BACKGROUND ) )         ;
            ACTION ( soDeskTop:backGroundChar := "",           ;
                     soDeskTop:display() )                      ;
            TO oMenu

   ENDIF

   oMenu:display()

   RETURN ( NIL )


***********************************************************************
* FUNCTION
*
* Parameters  :
* Description :
***********************************************************************
FUNCTION TBButtons()

   LOCAL oTBWin
   LOCAL oTB

   oTBWin := TBwin():new( 2, 2, 22, 76,, "people" )

   oTBWin:addField( "last_name",, "Last Name"  )
   oTBWin:addField( "first_name",, "First Name" )
   oTBWin:addField( "address_1",, "Address 1"  )
   oTBWin:addField( "address_2",, "Address 2"  )

   oTBWin:title   := " People "
   oTBWin:explode := FALSE

   // Get a reference to the TBrowse object
   oTB := oTBWin:tb

   oTB:headSep   := ""
   oTB:colSep    := "  "
   oTB:footSep   := ""

   oTBWin:setOffsets( ,, 6 )

   @ 13,  3 BUTTON " ~Up     " ACTION oTB:up()       NOREAD IN oTBWin
   @ 15,  3 BUTTON " ~Down   " ACTION oTB:down()     NOREAD IN oTBwin
   @ 13, 17 BUTTON " ~Top    " ACTION oTB:goTop()    NOREAD IN oTBWin
   @ 15, 17 BUTTON " ~Bottom " ACTION oTB:goBottom() NOREAD IN oTBWin
   @ 13, 31 BUTTON " Page u~p   " ACTION oTB:pageUp()   NOREAD IN oTBWin
   @ 15, 31 BUTTON " Page do~wn " ACTION oTB:pageDown() NOREAD IN oTBWin

   @ 13, 48 BUTTON " ~Left   " ACTION oTB:left()     NOREAD IN oTBWin
   @ 13, 62 BUTTON " ~Right  " ACTION oTB:right()    NOREAD IN oTBWin

   @ 15, 62 BUTTON " ~End    " ACTION oTB:end()      NOREAD IN oTBWin
   @ 15, 48 BUTTON " ~Home   " ACTION oTB:home()     NOREAD IN oTBWin

   @ 17,  5 BUTTON " P~an home  " ACTION oTB:panHome()  NOREAD IN oTBWin
   @ 17, 22 BUTTON " Pa~n end   " ACTION oTB:panEnd()   NOREAD IN oTBWin

   @ 17, 40 BUTTON " Pan le~ft  " ACTION oTB:panLeft()  NOREAD IN oTBWin
   @ 17, 58 BUTTON " Pan ri~ght " ACTION oTB:panRight() NOREAD IN oTBWin

   oTBWin:modal := TRUE
   oTBWin:addKeyEvent( K_ESC, {|| oTBWin:kill() } )

   oTBWin:browse()

   RETURN ( NIL )

// eof: S_DEMO.PRG
