/*
 This code is functionally identical to Neil Wiechers great
 Scatter(), Gather(), UnGather() save for one deviation.

 The default is to use HUNG type prefixing for variables.
 For example...

 lActive   == FIELD->ACTIVE
 dDate     == FIELD->DATE
 cFName    == FIELD->FNAME
 nNumber   == FIELD->NUMBER

 For a thorough discussion of HUNG programming notation standards,
 Download HUNG14.ZIP.

 The calls to the ScatGath() engine can easily be turned
 in to pseudo-functions with the #translate directive.
 Just delete the three functions Scatter/Gather/UnGather
 and replace them with this

 #translate Scatter( <cPreFix>, <nFldMin>, <nFldMax> );
            =>;
            ScatGath( <cPreFix>, <nFldMin>, <nFldMax>, 1 )

 #translate Gather( <cPreFix>, <nFldMin>, <nFldMax> );
            =>;
            ScatGath( <cPreFix>, <nFldMin>, <nFldMax>, 2 )

 #translate UnGather( <cPreFix>, <nFldMin>, <nFldMax> );
            =>;
            ScatGath( <cPreFix>, <nFldMin>, <nFldMax>, 3 )


 Add this to one of your include files and you have just cut out
 the overhead of three more functions.

 Robert DiFalco 71610,1705
 Fresh Technologies

 Syntax.....: Scatter( [<cPreFix>, [<nFldMin>, [<nFldMax>]]] )
              Gather( [<cPreFix>, [<nFldMin>, [<nFldMax>]]] )
              UnGather( [<cPreFix>, [<nFldMin>, [<nFldMax>]]] )

 Parameters.: [<cPreFix>] == Prefix to assign to each variable.
                             Default is to use HUNG notation
                             standards.
              [<nFldMin>] == Starting Field number. Default is one.
              [<nFldMax>] == Last Field to Scatter. Default is Last.

 Example....: use ACCOUNT new
              use HISTORY new

              select ACCOUNT
              Scatter()          // Gather Field data for recno 1

              select HISTORY
              Gather()           // Transfer Field data to HISTORY

              UnGather()         // Release Public MemVars

 Source.....: Clipper 5.0

 */


FUNCTION Scatter( cPreFix, nFldMin, nFldMax )
RETURN ScatGath( cPreFix, nFldMin, nFldMax, 1 )

FUNCTION Gather( cPreFix, nFldMin, nFldMax )
RETURN ScatGath( cPreFix, nFldMin, nFldMax, 2 )

FUNCTION UnGather( cPreFix, nFldMin, nFldMax )
RETURN ScatGath( cPreFix, nFldMin, nFldMax, 3 )

FUNCTION ScatGath( cPreFix, nFldMin, nFldMax, nMode )
   local n

   nFldMax := if( nFldMax == NIL, fcount(), nFldMax )
   nFldMin := if( nFldMin == NIL, 1, nFldMin )

   for n := nFldMin to nFldMax
      cVar := if( cPreFix == NIL, type( field(n) ), cPreFix )+;
              field(n)

      if nMode == 1
         public &cVar.
         &cVar. := FieldGet( n )
      elseif nMode == 2
         FieldPut( n, &cVar. )
      elseif nMode == 3
         release &cVar.
      endif

   next

RETURN NIL

