#include <nandef.h>
#include <extend.h>

/*
*****************************************************************************
 Author: John F. Kaster
   Date: 02/05/90
 Syntax: scancode()
Returns: a 2-character string matching the keyboard scan code

Purpose: Provide recognition of a larger number of keys on the keyboard than
         Clipper does on its own.

Example: xkey = scancode() -- [grey-] returns:  chr(45)+chr(74)
                           -- [-]     returns:  chr(45)+chr(12)
                           -- [grey+] returns:  chr(43)+chr(78)
                           -- [+]     returns:  chr(43)+chr(13)

Notes:   This routine waits for a key to be pressed, and is independent of
         Clipper's keyboard input routine.  Therefore, lastkey() will not be
         updated by it.

         Compiled with Turbo C 2.0

         Unfortunately, I don't have a complete table of the scancodes
         immediately available in electronic format, but most DOS books and
         programming manuals for DOS contain the table.

*****************************************************************************
*/

CLIPPER scancode ( void )
{
   unsigned char  key[3];

   asm mov     ah, 00h;
   asm int     16h;

   *key         = _AL;
   *( key + 1 ) = _AH;
   *( key + 2 ) = 0;

   _retclen( key, 3 );

}
