;       Saveres4 -- *experimental* saverest with 4 screens -- adapted
;                   from SAVEREST by H.M. Van Tassell

;    To generate .BIN file for for dBaseIII LOAD/CALL
;       1. MASM saveres4;
;       2. LINK saveres4;
;       3. EXE2BIN saveres4
;    Use the file saveres4.BIN with your dBaseIII+ program
;       Syntax: CALL SaveRest WITH "Sx" or "Rx"  where "x" is between
;               0 and 3 ONLY!! (other values will do nothing).

;    NOTE: I can't see what good this thing is until it can save and restore
;          from files, that's next.  Also on the agenda:compression of data,
;          load from UI/SAYWHAT!? files, etc.
;
;    R. Russell Freeland
;    Synergy Corp.
;    (voice) 305/792-1866
;    CIS:76146,371
;    8/8/1986

code_seg segment byte public 'code'
      assume      cs:code_seg   ;,ds:code_seg,es:code_seg,ss:code_seg

saverest proc far
org 0
main: jmp begin

save_which      db      ?
screen_mode     db      0FFh    ; screen mode, 7 = mono
screen_page     db      0       ; current page here
cursor_pos      dw      0       ; store cursor position here
screen_buffer   dw  2000*4 DUP(?); local screen buffer storage area

begin:
        push ds
        push es
        cld
        mov al,Byte Ptr[bx+1]   ;save the second char in "save_which"
        mov Byte Ptr CS:save_which,al ;thru AL register
        cmp al,'0'              ;is it
        jb  nogood              ;within
        cmp al,'3'              ;bounds?
        ja  nogood              ;if not, we're done
        mov al,Byte Ptr[bx]     ; get passed dBASEIII first parameter char
        and al,05Fh             ; make sure it is upper case
        cmp al,'S'              ; if Save screen
        je save_screen          ;    jump to save screen routine
        cmp al,'R'              ; if Restore screen
        je restore_screen       ;    jump to restore screen routine
nogood:
        jmp finish              ; else return back to dBASEIII
;
save_screen:
        xor al,al               ; first get screen mode and page
        mov ah,15               ; function 15 return mode in AL
        int 10h                 ; and page in BH
        mov Byte Ptr CS:screen_mode,al  ; store em
        mov Byte Ptr CS:screen_page,bh  ; for future use
        xor al,al               ; now get the current cursor position
        mov ah,3                ; function 3 reads cursor position
        int 10h                 ; returns DH,DL=cursor row,col
        mov Word Ptr CS:cursor_pos,dx   ; store it
        mov ax,0B000h           ; preload mono buffer segment
        cmp Byte Ptr CS:screen_mode,07h ; is 7 if mono mode
        je save_mono
        mov ax,0B800h           ; it is not mono mode
save_mono:
        mov ds,ax               ; DS:SI must point start of screen memory
        mov si,0
        push cs
        pop es                  ; ES:DI must point to screen buffer
        mov di,offset CS:screen_buffer
        xor ax,ax               ; clear AX
        mov al,Byte Ptr CS:save_which   ; get second dBASE parameter character
        xor ax,0030h            ; convert to a number
        mov  cx,4000d
        mul cx                  ; multiply ax*4000
        add di,ax               ; and offset that far into the buffer
        mov cx,2000             ; number of words to save
        rep movsw               ; move the screen memory to the buffer
        jmp finish              ; and return back to dBASEIII
;
restore_screen:
        ;
        cmp Byte Ptr CS:screen_mode,0FFh; if the screen mode byte hasn't
        jne saved               ; changed, we havn't first saved
        jmp finish              ; a screen, so return to dBASEIII
saved:  mov bh,Byte Ptr CS:screen_page  ; BH = current display page
        mov dx,Word Ptr CS:cursor_pos   ; DH,DL = row,col of current position
        xor al,al               ; first restore prior cursor position
        mov ah,2                ; function 2 sets cursor position with
        int 10h                 ; DH,DL=cursor row,col and BH = page
        mov ax,0B000h           ; preload mono buffer segment
        cmp Byte Ptr CS:screen_mode,07h ; is 7 if mono mode
        je restore_mono
        mov ax,0B800h           ; it is not mono mode
restore_mono:
        mov ES,ax               ; ES:DI must point start of screen memory
        mov di,0
        xor ax,ax
        mov al,Byte Ptr CS:save_which  ; get dBASE second parameter character
        xor ax,0030h            ; convert to a number
        mov  cx,4000d           ; multiply ax*4000
        mul  cx
        mov si,offset CS:screen_buffer
        add  si,ax              ; and offset that far into the buffer
        push cs
        pop ds                  ; DS:SI must point to screen buffer
        mov cx,2000             ; number of words to restore
        rep movsw               ; move the buffer to the screen memory
finish:
        pop es
        pop ds
        ret                     ; return back to dBASEIII+

saverest endp
code_seg ends
      END main
