    * SAVE_GETS.PRG
    *
    * Program file to save and restore gets

    * Must compile this with /n because of the following external
    * static ...

    STATIC _get_stack := {}    // The get stack. Initialized once,
                               // conceptually at compile time

    #define ASHRINK(ar) ASIZE(ar, len(ar) - 1)


    * VOID _push_gets()
    *
    * Push Clipper's current get list onto the stack and clear it

    FUNCTION _push_gets

        * Push the get list by appending the current get list to the
        * stack array
        aadd(_get_stack, getlist)

        * Clear the get list
        getlist = {}

    RETURN NIL


    * VOID _pop_gets()
    *
    * Pop the current get list stack, restoring Clipper's get list

    FUNCTION _pop_gets

        * Pop the gets by assigning getlist to the last element of
        * the stack array
        getlist = _get_stack[len(_get_stack)]

        * Pop the stack by removing the last element
        ASHRINK(getlist)

    RETURN NIL
